/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.dom.marshal.MarshalException;

public class SAMLSecurityTokenReference
extends SecurityTokenReferenceImpl {
    private static final boolean verbose = Verbose.isVerbose(SAMLSecurityTokenReference.class);
    private static final boolean debug = false;
    private boolean isDirectReference = false;
    private String tokenType;

    public SAMLSecurityTokenReference() {
    }

    public SAMLSecurityTokenReference(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        super(qName, string, securityToken);
        SAMLToken sAMLToken = (SAMLToken)securityToken;
        if (sAMLToken.isSaml2()) {
            this.tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(string)) {
            this.tokenType = string;
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(string)) {
            this.tokenType = string;
            this.setValueType(string);
        } else {
            this.tokenType = "http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID";
            this.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID");
        }
        if (WSSConstants.REFERENCE_QNAME.equals(qName)) {
            this.setDirectReference(true);
            this.setReferenceURI("#" + securityToken.getId());
        } else {
            KeyIdentifierImpl keyIdentifierImpl = new KeyIdentifierImpl(sAMLToken.getAssertionID().getBytes());
            this.setKeyIdentifier(keyIdentifierImpl);
        }
    }

    private boolean isDirectReference() {
        return this.isDirectReference;
    }

    private void setDirectReference(boolean bl) {
        this.isDirectReference = bl;
    }

    public String getValueType() {
        String string = super.getValueType();
        if (this.isDirectReference()) {
            string = this.tokenType;
        }
        return string;
    }

    public Node marshalDirectRef(Element element, Node node, Map map, String string) {
        Element element2 = this.marshalInternal(element, node, map);
        Element element3 = (Element)element2.getParentNode();
        DOMUtils.addAttribute(element3, WSS11Constants.TOKEN_TYPE_QNAME, map, this.tokenType);
        DOMUtils.addAttribute(element2, WSSConstants.URI_QNAME, map, string);
        return element3;
    }

    public void unmarshalDirectRef(Element element) {
        this.setReferenceURI(DOMUtils.getAttributeValue(element, WSSConstants.URI_QNAME));
        this.setValueType(DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME));
        Element element2 = (Element)element.getParentNode();
        this.tokenType = DOMUtils.getAttributeValue(element2, WSS11Constants.TOKEN_TYPE_QNAME);
        if (this.getValueType() == null && this.tokenType != null && "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(this.tokenType)) {
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        }
        this.setDirectReference(true);
    }

    public Node marshalKeyIdRef(Element element, Node node, Map map, KeyIdentifier keyIdentifier) throws MarshalException {
        Element element2 = this.marshalInternal(element, node, map);
        Element element3 = (Element)element2.getParentNode();
        DOMUtils.addAttribute(element2, WSSConstants.VALUE_TYPE_QNAME, map, this.getValueType());
        DOMUtils.addText(element2, new String(keyIdentifier.getIdentifier()));
        return element3;
    }

    public void unmarshalKeyIdRef(Element element) throws MarshalException {
        this.tokenType = DOMUtils.getAttributeValue((Element)element.getParentNode(), WSS11Constants.TOKEN_TYPE_QNAME);
        String string = DOMUtils.getAttributeValue(element, WSSConstants.ENCODING_TYPE_QNAME);
        this.setValueType(DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME));
        this.setKeyIdentifier(new KeyIdentifierImpl(DOMUtils.getText(element).trim().getBytes(), string));
    }
}

