/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAMLCredentialImpl;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.xml.crypto.wss.SecurityTokenImpl;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.dom.marshal.MarshalException;

public class SAMLTokenImpl
extends SecurityTokenImpl
implements SAMLToken {
    private static final long serialVersionUID = 5452212188047058232L;
    private SAMLCredentialImpl samlCredential;
    private Subject subject;

    public SAMLTokenImpl() {
    }

    public SAMLTokenImpl(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Can not create SAML token with null credential. Please check the configuration.");
        }
        this.samlCredential = (SAMLCredentialImpl)object;
    }

    public SAMLTokenImpl(String string, Object object) {
        this(object);
        this.samlCredential.setTokenType(string);
    }

    public Object getCredential() {
        return this.samlCredential;
    }

    public String getValueType() {
        return this.samlCredential.getTokenType();
    }

    public String getId() {
        return this.getAssertionID();
    }

    public boolean isSaml2() {
        return this.samlCredential.isSaml2();
    }

    public void setId(String string) {
        throw new UnsupportedOperationException("Can't set ID on SAML Assertion");
    }

    public PrivateKey getPrivateKey() {
        return this.samlCredential.getPrivateKey();
    }

    public PublicKey getPublicKey() {
        Key key = this.samlCredential.getHolderOfKey();
        if (key instanceof PublicKey) {
            return (PublicKey)key;
        }
        return null;
    }

    public Key getSecretKey() {
        if (null == this.samlCredential.getSymmetircKey() && null == this.samlCredential.getHolderOfKey()) {
            return null;
        }
        if (null != this.samlCredential.getSymmetircKey()) {
            return this.samlCredential.getSymmetircKey();
        }
        Key key = this.samlCredential.getHolderOfKey();
        if (key instanceof PublicKey || key instanceof PrivateKey) {
            return null;
        }
        return key;
    }

    public X509Certificate getHolderOfCert() {
        return this.samlCredential.getX509Cert();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void marshal(Element element, Node node, Map map) throws MarshalException {
        Node node2;
        block8: {
            Object object = this.samlCredential.getCredential();
            if (object instanceof String) {
                DocumentBuilder documentBuilder = null;
                try {
                    try {
                        documentBuilder = CSSUtils.getParser();
                        Document document = documentBuilder.parse(new ByteArrayInputStream(((String)object).getBytes()));
                        node2 = element.getOwnerDocument().importNode(document.getFirstChild(), true);
                    }
                    catch (SAXException sAXException) {
                        throw new MarshalException(sAXException);
                    }
                    catch (IOException iOException) {
                        throw new MarshalException(iOException);
                    }
                    Object var9_11 = null;
                    if (documentBuilder == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (documentBuilder == null) throw throwable;
                    CSSUtils.returnParser(documentBuilder);
                    throw throwable;
                }
                CSSUtils.returnParser(documentBuilder);
            } else {
                if (!(object instanceof Element)) throw new MarshalException("do not know how to marshal: " + object);
                Element element2 = (Element)object;
                node2 = element.getOwnerDocument().importNode(element2, true);
            }
        }
        if (node != null) {
            element.insertBefore(node2, node);
            return;
        }
        element.appendChild(node2);
    }

    public void unmarshal(Node node) throws MarshalException {
        try {
            this.samlCredential = new SAMLCredentialImpl(node);
        }
        catch (WSSecurityException wSSecurityException) {
            this.samlCredential = null;
            throw new MarshalException(wSSecurityException);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public String getAssertionID() {
        return this.samlCredential.getAssertionID();
    }

    public boolean isHolderOfKey() {
        return this.samlCredential.isHolderOfKey();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SAMLToken)) {
            return false;
        }
        return ((SAMLToken)object).getAssertionID().equals(this.getAssertionID());
    }
}

