/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.UsernameAndPassword;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.security.saml.AbstractSAMLCredentialProvider;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAML2TokenHandler;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.security.saml.SAMLIssuedTokenHelper;
import weblogic.wsee.security.saml.SAMLSTSHelper;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.security.saml.SAMLTokenHandler;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.util.BSTCredentialProviderUtil;
import weblogic.wsee.security.wst.binding.BinarySecret;
import weblogic.wsee.security.wst.binding.KeySize;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponseCollection;
import weblogic.wsee.security.wst.binding.RequestedProofToken;
import weblogic.wsee.security.wst.binding.RequestedSecurityToken;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.InvalidScopeException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustSoapClient;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.framework.WSTCredentialProviderHelper;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.UsernameTokenImpl;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.dom.DOMUtils;

public class SAMLTrustCredentialProvider
extends AbstractSAMLCredentialProvider {
    private static boolean verbose = Verbose.isVerbose(SAMLTrustCredentialProvider.class);
    protected static final ContextHandler EMPTY_CONTEXT = new SecurityTokenContextHandler();
    private SAMLCredential samlCredential = null;
    protected static final String[] SAML_VALUE_TYPES = new String[]{"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"};

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (null != this.samlCredential) {
            if (verbose) {
                Verbose.log("return with saved SAML Credential");
            }
            return this.samlCredential;
        }
        this.samlCredential = this.getCredentialSTSCSS(string, contextHandler);
        return this.samlCredential;
    }

    private Object getCredentialLocalCSS(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (purpose.equals(Purpose.IDENTITY) || purpose.equals(Purpose.SIGN)) {
            if (!(contextHandler instanceof SecurityTokenContextHandler)) {
                return null;
            }
            SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
            Object object = contextHandler.getValue("com.bea.contextelement.saml.CachingRequested");
            if (object != null) {
                securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.CachingRequested", object);
            }
            Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
            CSSUtils.processSAMLClaims(false, securityTokenContextHandler, node);
            CSSUtils.setupSAMLContextElements(false, securityTokenContextHandler, contextHandler);
            Object object2 = null;
            if (CSSUtils.isHolderOfKey(false, securityTokenContextHandler)) {
                object2 = this.getKeyInfoCredential(string, string2, (SecurityTokenContextHandler)contextHandler, purpose);
            }
            try {
                return CSSUtils.getSAMLCredential(false, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", securityTokenContextHandler, object2);
            }
            catch (WSSecurityException wSSecurityException) {
                if (verbose) {
                    Verbose.log((Object)"Exception while acquiring SAML credential", wSSecurityException);
                }
                return null;
            }
        }
        return null;
    }

    private SAMLCredential getCredentialSTSCSS(String string, ContextHandler contextHandler) {
        SecurityTokenContextHandler securityTokenContextHandler = SAMLTrustCredentialProvider.getSecurityCtxHandler(contextHandler);
        if (securityTokenContextHandler == null) {
            return null;
        }
        MessageContext messageContext = SAMLTrustCredentialProvider.getMessageContext(securityTokenContextHandler);
        if (messageContext == null) {
            return null;
        }
        Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        boolean bl = string.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        CSSUtils.processSAMLClaims(bl, securityTokenContextHandler, node);
        SAMLTokenHandler sAMLTokenHandler = new SAMLTokenHandler();
        SAML2TokenHandler sAML2TokenHandler = new SAML2TokenHandler();
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        if (wSSecurityContext != null) {
            wSSecurityContext.setTokenHandler(sAMLTokenHandler);
            wSSecurityContext.setTokenHandler(sAML2TokenHandler);
        }
        Element element = DOMUtils.getFirstElement(node, SAMLIssuedTokenHelper.ISSUED_TK_POLICY_QNAME);
        WSTContext wSTContext = WSTContext.getWSTContext(messageContext);
        try {
            if (null == element) {
                this.intWSTContext(string, wSTContext, messageContext, securityTokenContextHandler);
            } else {
                this.intWSTContext(string, wSTContext, messageContext, securityTokenContextHandler, element);
            }
        }
        catch (PolicyException policyException) {
            LogUtils.logWss("Could not load policy for SAML STS: " + policyException.getMessage());
            return null;
        }
        catch (WSSecurityException wSSecurityException) {
            LogUtils.logWss("Could not create OnBehalfOf token: " + wSSecurityException.getMessage());
            return null;
        }
        TrustSoapClient trustSoapClient = null;
        try {
            trustSoapClient = new TrustSoapClient(wSTContext);
            return SAMLTrustCredentialProvider.createCredential(trustSoapClient, wSTContext, sAMLTokenHandler, string);
        }
        catch (InvalidRequestException invalidRequestException) {
            LogUtils.logWss("Could not retrieve SAML token through WS-Trust, request was invalid." + invalidRequestException.getMessage());
        }
        catch (WSTFaultException wSTFaultException) {
            wSTFaultException.printStackTrace();
            LogUtils.logWss("Could not retrieve SAML token through WS-Trust, WS-Trust fault: " + wSTFaultException.getMessage());
        }
        return null;
    }

    private void intWSTContext(String string, WSTContext wSTContext, MessageContext messageContext, SecurityTokenContextHandler securityTokenContextHandler) throws PolicyException, WSSecurityException {
        String string2;
        String string3;
        String string4 = (String)securityTokenContextHandler.getValue("weblogic.wsee.security.trust_version");
        if (string4 == null) {
            string4 = (String)messageContext.getProperty("weblogic.wsee.security.trust_version");
        }
        if (string4 == null) {
            string4 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        if ((string3 = (String)messageContext.getProperty("weblogic.wsee.security.trust_soap_version")) != null) {
            wSTContext.setSoapVersion(string3);
        }
        wSTContext.setAction(SAMLSTSHelper.getAction(string4));
        wSTContext.setTokenType(string);
        wSTContext.setTrustVersion(string4);
        wSTContext.initEndpoints(messageContext);
        String string5 = wSTContext.getStsUri();
        if (string5 == null || string5.equals(wSTContext.getEndpointUri())) {
            string5 = WSTCredentialProviderHelper.getSTSURIFromConfig(securityTokenContextHandler, messageContext, this.getClass().getName());
            if (string5 == null) {
                string5 = wSTContext.getEndpointUri();
            }
            wSTContext.setStsUri(string5);
        }
        this.initPolicy(securityTokenContextHandler, wSTContext, messageContext);
        String string6 = (String)securityTokenContextHandler.getValue("com.bea.contextelement.saml.subject.ConfirmationMethod");
        if (string6 != null) {
            if (string6.contains("bearer")) {
                wSTContext.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
            } else if ("sender-vouches".equals(string6) || "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(string6)) {
                if ("metro".equals(messageContext.getProperty("weblogic.wsee.policy.compat.preference"))) {
                    if (verbose) {
                        Verbose.log("Setting keytype to \"http://schemas.oracle.com/ws/2010/03/securitypolicy/ws-sx/ws-trust/SenderVouches\" ");
                    }
                    wSTContext.setKeyType("http://schemas.oracle.com/ws/2010/03/securitypolicy/ws-sx/ws-trust/SenderVouches");
                }
            } else if (string6.contains("holder-of-key")) {
                wSTContext.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
            }
        }
        if ((string2 = (String)messageContext.getProperty("weblogic.wsee.security.trust_key_type")) != null) {
            wSTContext.setKeyType(string2);
        }
        wSTContext.setLifetimePeriod(-1L);
        wSTContext.setKeySize(-1);
        wSTContext.setBinarySecretType("none");
        String string7 = (String)messageContext.getProperty("weblogic.wsee.security.wst_onbehalfof_user");
        if (string7 != null) {
            UsernameAndPassword usernameAndPassword = new UsernameAndPassword();
            usernameAndPassword.setUsername(string7);
            UsernameTokenImpl usernameTokenImpl = new UsernameTokenImpl(usernameAndPassword, EMPTY_CONTEXT);
            wSTContext.setOnBehalfOfToken(usernameTokenImpl);
        }
    }

    private void intWSTContext(String string, WSTContext wSTContext, MessageContext messageContext, SecurityTokenContextHandler securityTokenContextHandler, Element element) throws PolicyException, WSSecurityException {
        String string2;
        String string3;
        String string4;
        if (null == element) {
            this.intWSTContext(string, wSTContext, messageContext, securityTokenContextHandler);
            return;
        }
        wSTContext.setIssuedTokenClaims(element);
        messageContext.setProperty("weblogic.wsee.security.trust_claim", (Object)element);
        SAMLIssuedTokenHelper sAMLIssuedTokenHelper = new SAMLIssuedTokenHelper(element);
        String string5 = sAMLIssuedTokenHelper.getTrustVersion();
        if (string5 == null) {
            string5 = (String)securityTokenContextHandler.getValue("weblogic.wsee.security.trust_version");
        }
        if (string5 == null) {
            string5 = (String)messageContext.getProperty("weblogic.wsee.security.trust_version");
        }
        if (string5 == null) {
            string5 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        if ((string4 = (String)messageContext.getProperty("weblogic.wsee.security.trust_soap_version")) != null) {
            wSTContext.setSoapVersion(string4);
        }
        wSTContext.setAction(SAMLSTSHelper.getAction(string5));
        wSTContext.setTokenType(string);
        wSTContext.setTrustVersion(string5);
        wSTContext.initEndpoints(messageContext);
        if (StringUtil.isEmpty((String)messageContext.getProperty("weblogic.wsee.wst.saml.sts_endpoint_uri"))) {
            string3 = sAMLIssuedTokenHelper.getIssuerAddressUri();
            if (string3 != null) {
                wSTContext.setStsUri(string3);
            } else {
                string2 = wSTContext.getStsUri();
                if (string2 == null || string2.equals(wSTContext.getEndpointUri())) {
                    string2 = WSTCredentialProviderHelper.getSTSURIFromConfig(securityTokenContextHandler, messageContext, this.getClass().getName());
                    if (string2 == null) {
                        string2 = wSTContext.getEndpointUri();
                    }
                    wSTContext.setStsUri(string2);
                }
            }
        }
        this.initPolicy(securityTokenContextHandler, wSTContext, messageContext);
        string3 = sAMLIssuedTokenHelper.getKeyType();
        if (null == string3) {
            string3 = (String)messageContext.getProperty("weblogic.wsee.security.trust_key_type");
        }
        if (string3 != null) {
            wSTContext.setKeyType(string3);
        } else {
            string2 = (String)securityTokenContextHandler.getValue("com.bea.contextelement.saml.subject.ConfirmationMethod");
            if (string2 != null) {
                if (string2.contains("bearer")) {
                    wSTContext.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
                } else if ("sender-vouches".equals(string2) || "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(string2)) {
                    if ("metro".equals(messageContext.getProperty("weblogic.wsee.policy.compat.preference"))) {
                        if (verbose) {
                            Verbose.log("Setting keytype to \"http://schemas.oracle.com/ws/2010/03/securitypolicy/ws-sx/ws-trust/SenderVouches\" ");
                        }
                        wSTContext.setKeyType("http://schemas.oracle.com/ws/2010/03/securitypolicy/ws-sx/ws-trust/SenderVouches");
                    }
                } else if (string2.contains("holder-of-key")) {
                    wSTContext.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
                }
            }
        }
        wSTContext.setLifetimePeriod(-1L);
        wSTContext.setKeySize(sAMLIssuedTokenHelper.getKeySize());
        if (string3 == null || !string3.endsWith("/SymmetricKey")) {
            wSTContext.setBinarySecretType("none");
        }
        if ((string2 = (String)messageContext.getProperty("weblogic.wsee.security.wst_onbehalfof_user")) != null) {
            UsernameAndPassword usernameAndPassword = new UsernameAndPassword();
            usernameAndPassword.setUsername(string2);
            UsernameTokenImpl usernameTokenImpl = new UsernameTokenImpl(usernameAndPassword, EMPTY_CONTEXT);
            wSTContext.setOnBehalfOfToken(usernameTokenImpl);
        }
    }

    private void initPolicy(SecurityTokenContextHandler securityTokenContextHandler, WSTContext wSTContext, MessageContext messageContext) throws PolicyException {
        NormalizedExpression normalizedExpression = WSTCredentialProviderHelper.getSTSPolicyFromConfig(securityTokenContextHandler, messageContext, this.getClass().getName());
        if (messageContext.getProperty("weblogic.wsee.security.wst_bootstrap_policy") != null) {
            Object object = messageContext.getProperty("weblogic.wsee.security.wst_bootstrap_policy");
            if (object instanceof NormalizedExpression) {
                normalizedExpression = (NormalizedExpression)object;
            } else if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)messageContext.getProperty("weblogic.wsee.security.wst_bootstrap_policy");
                normalizedExpression = PolicyFinder.readPolicyFromStream(null, "SAMLSTSPolicy.xml", inputStream, true).normalize();
            }
        }
        if (normalizedExpression == null) {
            normalizedExpression = SAMLSTSHelper.getTrustBootStrapPolicy(wSTContext.getStsUri().toLowerCase(Locale.ENGLISH).startsWith("https"));
            wSTContext.setWssp(false);
        } else {
            wSTContext.setWssp(true);
        }
        wSTContext.setBootstrapPolicy(normalizedExpression);
    }

    public static SAMLCredential createCredential(TrustSoapClient trustSoapClient, WSTContext wSTContext, SecurityTokenHandler securityTokenHandler, String string) throws WSTFaultException {
        SOAPMessage sOAPMessage = trustSoapClient.requestTrustToken();
        Node node = SOAPHelper.getRSTBaseNode(sOAPMessage);
        RequestSecurityTokenResponse requestSecurityTokenResponse = null;
        if ("RequestSecurityTokenResponseCollection".equals(node.getLocalName())) {
            RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection = BindingHelper.unmarshalRSTRCNode(node, securityTokenHandler);
            List<RequestSecurityTokenResponse> list = requestSecurityTokenResponseCollection.getRequestSecurityTokenResponseCollection();
            if (list == null || list.isEmpty()) {
                throw new WSTFaultException("Empty RequestSecurityTokenResponseCollection.");
            }
            requestSecurityTokenResponse = list.get(0);
        } else {
            requestSecurityTokenResponse = BindingHelper.unmarshalRSTRNode(node, securityTokenHandler);
        }
        return SAMLTrustCredentialProvider.getCredentialFromRSTR(wSTContext, requestSecurityTokenResponse, string);
    }

    protected static SecurityTokenContextHandler getSecurityCtxHandler(ContextHandler contextHandler) {
        if (!(contextHandler instanceof SecurityTokenContextHandler)) {
            return null;
        }
        return (SecurityTokenContextHandler)contextHandler;
    }

    protected static MessageContext getMessageContext(SecurityTokenContextHandler securityTokenContextHandler) {
        WSSecurityContext wSSecurityContext = (WSSecurityContext)securityTokenContextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        if (wSSecurityContext == null) {
            return null;
        }
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        return messageContext;
    }

    private String getIssueAction(String string) {
        return string + "/Issue";
    }

    static SAMLCredential getFromContext(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        return (SAMLCredential)messageContext.getProperty("weblogic.wsee.saml.credential");
    }

    static void setToContext(MessageContext messageContext, SAMLCredential sAMLCredential) {
        if (messageContext != null) {
            messageContext.setProperty("weblogic.wsee.saml.credential", (Object)sAMLCredential);
            Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            if (map != null) {
                map.put("weblogic.wsee.saml.credential", sAMLCredential);
            }
        }
    }

    private static SAMLCredential getCredentialFromRSTR(WSTContext wSTContext, RequestSecurityTokenResponse requestSecurityTokenResponse, String string) throws WSTFaultException {
        TokenType tokenType = requestSecurityTokenResponse.getTokenType();
        if (tokenType != null && !tokenType.getTokenType().equals(string)) {
            throw new RequestFailedException("Unexpected token type in RSTR: " + tokenType.getTokenType());
        }
        RequestedSecurityToken requestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken();
        if (requestedSecurityToken == null) {
            throw new RequestFailedException("RequestedSecurityToken must be specified");
        }
        SecurityToken securityToken = requestedSecurityToken.getSecurityToken();
        if (!(securityToken instanceof SAMLToken)) {
            throw new RequestFailedException(securityToken.getValueType() + " is not a SAML token.");
        }
        LogUtils.logWss("From  RequestedSecurityToken, got SAML Token = " + securityToken.toString() + " id =" + securityToken.getId());
        SAMLToken sAMLToken = (SAMLToken)securityToken;
        SAMLCredential sAMLCredential = (SAMLCredential)sAMLToken.getCredential();
        if (sAMLCredential.isHolderOfKey()) {
            String string2 = wSTContext.getKeyType();
            if (SAMLUtils.isSymmetricKeyType(string2)) {
                if (null != wSTContext.getSymmetricKey()) {
                    if (verbose) {
                        Verbose.log("Setting Symmetric Key from Entropy");
                    }
                    sAMLCredential.setSymmetircKey(wSTContext.getSymmetricKey());
                } else {
                    if (verbose) {
                        Verbose.log("Getting Symmetric Key from RSTR");
                    }
                    sAMLCredential.setSymmetircKey(SAMLTrustCredentialProvider.getSymmetricKeyFromRstr(requestSecurityTokenResponse, wSTContext));
                }
            } else if (sAMLCredential.getPrivateKey() == null) {
                X509Certificate x509Certificate = sAMLCredential.getX509Cert();
                if (verbose) {
                    Verbose.log("setting key for SAML HofK for cert =" + x509Certificate.toString());
                }
                X509Credential x509Credential = BSTCredentialProviderUtil.findX509Credential(wSTContext.getMessageContext(), x509Certificate);
                sAMLCredential.setPrivateKey(x509Credential.getPrivateKey());
            }
        }
        return sAMLCredential;
    }

    private static Key getSymmetricKeyFromRstr(RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext) throws RequestFailedException, InvalidScopeException {
        Key key;
        block11: {
            RequestedProofToken requestedProofToken = requestSecurityTokenResponse.getRequestedProofToken();
            if (requestedProofToken == null) {
                throw new RequestFailedException("RequestedProofToken must be specified");
            }
            key = null;
            try {
                try {
                    BinarySecret binarySecret = SAMLTrustCredentialProvider.getBinarySecret(requestSecurityTokenResponse);
                    String string = binarySecret.getType();
                    if (string != null && string.endsWith("/Nonce")) {
                        String string2 = wSTContext.getSymmetricKeyAlgorithm();
                        if (string2 == null) {
                            string2 = "AES";
                        }
                        int n = wSTContext.getKeySize();
                        KeySize keySize = requestSecurityTokenResponse.getKeySize();
                        if (keySize != null) {
                            n = keySize.getSize();
                        }
                        key = KeyUtils.generateKey(wSTContext.getRstNonce(), binarySecret.getValue(), string2, n);
                        break block11;
                    }
                    if (string != null && string.endsWith("/SymmetricKey")) {
                        String string3 = wSTContext.getSymmetricKeyAlgorithm();
                        if (string3 == null) {
                            string3 = "AES";
                        }
                        key = new SecretKeySpec(binarySecret.getValue(), string3);
                        break block11;
                    }
                    throw new RequestFailedException("Not yet supported BinarySecret type: " + string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RequestFailedException("Unable to compute key from entropies");
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new RequestFailedException("Unable to compute key from entropies");
                }
            }
            catch (Exception exception) {
                throw new InvalidScopeException(exception.getMessage());
            }
        }
        EncryptedKeyInfoBuilder.debugKey(key, "Key got from RSTR BinarySecret");
        return key;
    }

    private static BinarySecret getBinarySecret(RequestSecurityTokenResponse requestSecurityTokenResponse) throws RequestFailedException {
        if (null != requestSecurityTokenResponse.getEntropy()) {
            if (verbose) {
                Verbose.log("Getting BinarySecret from Entropy");
            }
            return requestSecurityTokenResponse.getEntropy().getBinarySecret();
        }
        if (null != requestSecurityTokenResponse.getRequestedProofToken()) {
            if (verbose) {
                Verbose.log("Getting BinarySecret from RequestedProofToken");
            }
            return requestSecurityTokenResponse.getRequestedProofToken().getBinarySecret();
        }
        if (verbose) {
            Verbose.log("BinarySecret not found from either Entropy or  RequestedProofToken");
        }
        throw new RequestFailedException("BinarySecret is expected in Entropy or RequestedProofToken");
    }

    public String[] getValueTypes() {
        return SAML_VALUE_TYPES;
    }
}

