/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.security.AccessController;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.security.saml.SAMLTrustCredential;
import weblogic.wsee.security.saml.SAMLTrustToken;
import weblogic.wsee.security.util.CertUtils;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.UsernameToken;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public abstract class SAMLTrustTokenProvider
implements TrustTokenProvider {
    private static boolean verbose = Verbose.isVerbose(SAMLTrustTokenProvider.class);

    public TrustToken issueTrustToken(WSTContext wSTContext) throws WSTFaultException {
        SAMLCredential sAMLCredential;
        String string = this.getConfirmationMethod(wSTContext.getTokenType(), wSTContext.getKeyType());
        if (verbose) {
            Verbose.log("Token Type =[" + wSTContext.getTokenType() + "]  and KeyType =[" + wSTContext.getKeyType() + "] and the Confirmation Method =[" + string + "]");
        }
        if ((sAMLCredential = this.getCredential(wSTContext.getTokenType(), wSTContext.getAppliesTo(), this.getSubject(wSTContext), string, (WSSecurityContext)wSTContext.getMessageContext().getProperty("weblogic.xml.crypto.wss.WSSecurityContext"), wSTContext)) == null) {
            throw new RequestFailedException("Could not obtain SAML token.");
        }
        SAMLTrustCredential sAMLTrustCredential = new SAMLTrustCredential(sAMLCredential);
        this.intiTrustCredential(sAMLTrustCredential, wSTContext);
        SAMLTrustToken sAMLTrustToken = new SAMLTrustToken(sAMLTrustCredential);
        return sAMLTrustToken;
    }

    protected String getConfirmationMethod(String string, String string2) {
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer".equals(string2)) {
            return "bearer";
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(string2) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(string2)) {
            return "holder-of-key";
        }
        return "sender-vouches";
    }

    private AuthenticatedSubject getSubject(WSTContext wSTContext) throws WSTFaultException {
        AuthenticatedSubject authenticatedSubject = null;
        try {
            authenticatedSubject = this.getOnBehalfOfSubject(wSTContext);
            if (authenticatedSubject == null) {
                authenticatedSubject = (AuthenticatedSubject)wSTContext.getMessageContext().getProperty("weblogic.wsee.wss.subject");
            }
        }
        catch (LoginException loginException) {
            throw new WSTFaultException("Could not get SAML token for OnBehalfOf token.");
        }
        return authenticatedSubject;
    }

    private AuthenticatedSubject getOnBehalfOfSubject(WSTContext wSTContext) throws LoginException {
        String string;
        SecurityToken securityToken = wSTContext.getOnBehalfOfToken();
        if (securityToken != null && securityToken instanceof UsernameToken && (string = ((UsernameToken)securityToken).getUsername()) != null && string.length() != 0) {
            String string2 = "weblogicDEFAULT";
            PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)SAMLTrustTokenProvider.getKernelID(), (String)string2);
            if (principalAuthenticator == null) {
                throw new RuntimeException("PrincipalAuthenticator Unavailable");
            }
            return principalAuthenticator.impersonateIdentity(string);
        }
        return null;
    }

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private SAMLCredential getCredential(String string, String string2, AuthenticatedSubject authenticatedSubject, String string3, WSSecurityContext wSSecurityContext, WSTContext wSTContext) {
        SAMLAttributeStatementData sAMLAttributeStatementData;
        boolean bl = false;
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
        securityTokenContextHandler.addContextElement("com.bea.contextelement.xml.EndpointURL", string2);
        securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.TargetResource", string2);
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(string)) {
            bl = true;
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.subject.ConfirmationMethod", CSSUtils.mapSAML2ConfMethod(string3));
        } else {
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.subject.ConfirmationMethod", CSSUtils.mapSAMLConfMethod(string3));
        }
        Subject subject = null;
        if (null != authenticatedSubject) {
            subject = authenticatedSubject.getSubject();
        }
        if ((sAMLAttributeStatementData = this.getSAMLAttributeData(bl, string2, subject, wSSecurityContext)) != null) {
            CSSUtils.setupSAMLAttributesContextElements(bl, securityTokenContextHandler, sAMLAttributeStatementData.isAttributeOnlyRequest(), sAMLAttributeStatementData);
        }
        Object object = null;
        try {
            if (CSSUtils.isHolderOfKey(string3)) {
                if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(wSTContext.getKeyType())) {
                    if (verbose) {
                        Verbose.log("setting Symmetric Holder of Key ...");
                    }
                    CredentialProvider credentialProvider = this.getEncryptionCredentialProvider(bl, string2, wSSecurityContext);
                    object = this.getKeyInfoFromSymmetricKey(wSTContext, wSSecurityContext, credentialProvider);
                } else {
                    object = this.getKeyInfoCredential(authenticatedSubject, wSSecurityContext);
                }
            }
            return (SAMLCredential)CSSUtils.getSAMLCredential(string.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"), string, securityTokenContextHandler, object, authenticatedSubject);
        }
        catch (WSSecurityException wSSecurityException) {
            if (verbose) {
                Verbose.log((Object)"Exception while acquiring SAML credential", wSSecurityException);
            }
            return null;
        }
    }

    public SAMLAttributeStatementData getSAMLAttributeData(boolean bl, String string, Subject subject, WSSecurityContext wSSecurityContext) {
        if (verbose) {
            Verbose.log("No override on getSAMLAttributeData(), and no SAML Attribute data to be generated for target url =" + string);
        }
        return null;
    }

    private CredentialProvider getEncryptionCredentialProvider(boolean bl, String string, WSSecurityContext wSSecurityContext) {
        try {
            X509Certificate x509Certificate = this.getServerEncryptionCert(bl, string, wSSecurityContext);
            if (null == x509Certificate) {
                if (verbose) {
                    Verbose.log("Geeting no X509 for EncryptedKey token in SAML assertion");
                }
                return null;
            }
            return new StubPropertyBSTCredProv(x509Certificate, null);
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.log((Object)"Got exception when getting EncryptionCredentialProvider for for encrypting EncryptedKey token in SAML assertion", exception);
            }
            return null;
        }
    }

    public X509Certificate getServerEncryptionCert(boolean bl, String string, WSSecurityContext wSSecurityContext) throws Exception {
        if (verbose) {
            Verbose.log("No override on getServerEncryptionCert(), and no encryption cert to be used for encrypting EncryptedKey token in SAML assertion for target url =" + string);
        }
        return null;
    }

    private void intiTrustCredential(SAMLTrustCredential sAMLTrustCredential, WSTContext wSTContext) {
        sAMLTrustCredential.setAppliesTo(wSTContext.getAppliesTo());
        sAMLTrustCredential.setCreated(wSTContext.getCreated());
        sAMLTrustCredential.setExpires(wSTContext.getExpires());
    }

    public TrustToken renewTrustToken(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
        return null;
    }

    public void cancelTrustToken(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
    }

    public SecurityTokenReference createSecurityTokenReference(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
        return null;
    }

    public TrustToken resolveTrustToken(WSTContext wSTContext, SecurityTokenReference securityTokenReference) throws WSTFaultException {
        return null;
    }

    public Object getKeyInfoCredential(AuthenticatedSubject authenticatedSubject, WSSecurityContext wSSecurityContext) {
        if (null != authenticatedSubject) {
            List<BinarySecurityToken> list;
            Object object = wSSecurityContext.getProperty("BinarySecurityTokenHandler.AuthenticatedSubject.Cert");
            if (object != null && object instanceof X509Certificate) {
                if (verbose) {
                    Verbose.log("Found X509 credential of " + (X509Certificate)object);
                }
                return new X509Credential((X509Certificate)object, null);
            }
            if (verbose) {
                Verbose.log("looking BST from WSSecurityContext ...");
            }
            if (null == (list = wSSecurityContext.getBinarySecurityTokens()) || list.isEmpty()) {
                return null;
            }
            Set<Principal> set = authenticatedSubject.getSubject().getPrincipals();
            Object[] objectArray = set.toArray();
            String[] stringArray = new String[set.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Principal)objectArray[i]).getName();
            }
            if (verbose) {
                Verbose.log("Checking BST size = " + list.size());
            }
            for (BinarySecurityToken binarySecurityToken : list) {
                X509Certificate x509Certificate = binarySecurityToken.getCertificate();
                String string = CertUtils.getSubjectCN(x509Certificate);
                if (null == string) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    if (verbose) {
                        Verbose.log("Found X509 credential for " + string + " cert SubjectDN name is " + x509Certificate.getSubjectDN().getName());
                    }
                    return new X509Credential(x509Certificate, null);
                }
            }
            if (verbose) {
                Verbose.log("No KeyInfo Credentail found on all BST");
            }
        } else if (verbose) {
            Verbose.log("No KeyInfo Credentail due to null AuthenticatedSubject");
        }
        return null;
    }

    private Object getKeyInfoFromSymmetricKey(WSTContext wSTContext, WSSecurityContext wSSecurityContext, CredentialProvider credentialProvider) throws WSSecurityException {
        EncryptedKeyInfoBuilder encryptedKeyInfoBuilder = new EncryptedKeyInfoBuilder(wSSecurityContext, credentialProvider);
        return encryptedKeyInfoBuilder.getEncryptedKeyNode(wSTContext);
    }
}

