/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.security.SimplePrincipal;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;

public class SAMLUtils {
    private static final boolean verbose = Verbose.isVerbose(SAMLUtils.class);
    private static final String SAML_ASSERTION_TAG = "Assertion";
    private static final String SAML11_ID_ATTR = "AssertionID";
    private static final String SAML11_MAJOR_VERSION_ATTR = "MajorVersion";
    private static final String SAML11_MINOR_VERSION_ATTR = "MinorVersion";
    private static final String SAML11_VERSION = "1.1";
    private static final String SAML20_ID_ATTR = "ID";
    private static final String SAML20_VERSION_ATTR = "Version";
    private static final String SAML20_VERSION = "2.0";
    private static final String SAML_ISSUER_ATTR = "Issuer";
    private static final String SAML_CONDITIONS_TAG = "Conditions";
    private static final String SAML_NOTBEFORE_ATTR = "NotBefore";
    private static final String SAML_NOTONORAFTER_ATTR = "NotOnOrAfter";
    public static final String SAML_SUBJECT_TAG = "Subject";
    public static final String SAML_ATN_STATEMENT_TAG = "AuthenticationStatement";
    public static final String SAML_ATTRIBUTE_STATEMENT_TAG = "AttributeStatement";
    private static final String SAML11_NAMEID_TAG = "NameIdentifier";
    private static final String SAML20_NAMEID_TAG = "NameID";
    public static final String SAML_SUBJCONF_TAG = "SubjectConfirmation";
    private static final String SAML20_SUBJCONF_METHOD_ATTR = "Method";
    private static final String SAML11_SUBJCONF_METHOD_TAG = "ConfirmationMethod";
    private static final String SAML_KEYINFO_TAG = "KeyInfo";
    private static final String SAML_SUBJCONF_DATA_TAG = "SubjectConfirmationData";
    private static final String FORMAT = "Format";
    private static final String X509_SUBJECT_NAME = "X509SubjectName";
    private static final String AUTHN_INSTANT = "AuthenticationInstant";
    private static final String AUTHN_METHOD = "AuthenticationMethod";
    private static final String AUTHN_METHOD_PASSWORD = "urn:oasis:names:tc:SAML:1.0:am:password";
    private static Set saml11TokenSet = null;

    public static String getTokenTypeFromAssertionElement(Element element) {
        if (element != null && SAML_ASSERTION_TAG.equals(element.getLocalName())) {
            String string = element.getAttribute(SAML20_VERSION_ATTR);
            if (SAML20_VERSION.equals(string)) {
                return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
            }
            string = element.getAttribute(SAML11_MAJOR_VERSION_ATTR) + "." + element.getAttribute(SAML11_MINOR_VERSION_ATTR);
            if (SAML11_VERSION.equals(string)) {
                return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            }
        }
        return null;
    }

    public static boolean isEquivalentSamlTokenType(String string, String string2) {
        if (string != null && string.equals(string2) && string.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
            return true;
        }
        return saml11TokenSet.contains(string) && saml11TokenSet.contains(string2);
    }

    public static boolean isSamlTokenType(String string) {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(string) || saml11TokenSet.contains(string);
    }

    public static boolean isSymmetricKeyType(String string) {
        if (null == string) {
            return false;
        }
        return string.endsWith("/SymmetricKey");
    }

    public static Element getFirstMatchingChildElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Node getReplaceAttributeStmtToAuthenticateStmtSAMLNode(Element element) {
        if (null == SAMLUtils.getFirstMatchingChildElement(element, SAML_ATTRIBUTE_STATEMENT_TAG)) {
            return element;
        }
        Node node = element.cloneNode(true);
        QName qName = new QName(element.getNamespaceURI(), SAML_ATN_STATEMENT_TAG, element.getPrefix());
        Element element2 = DOMUtils.createElement((Element)node, qName, element.getPrefix());
        Element element3 = SAMLUtils.getFirstMatchingChildElement(element, SAML_CONDITIONS_TAG);
        String string = "2008-12-02T20:08:42.359Z";
        if (null != element3) {
            string = DOMUtils.getAttributeValue(element3, new QName(SAML_NOTBEFORE_ATTR), string);
        }
        element2.setAttribute(AUTHN_INSTANT, string);
        element2.setAttribute(AUTHN_METHOD, AUTHN_METHOD_PASSWORD);
        Element element4 = SAMLUtils.getFirstMatchingChildElement((Element)node, SAML_ATTRIBUTE_STATEMENT_TAG);
        Element element5 = SAMLUtils.getFirstMatchingChildElement(element4, SAML_SUBJECT_TAG);
        element2.appendChild(element5);
        node.replaceChild(element2, element4);
        return node;
    }

    public static boolean hasAttributeNoAuthenticateStmt(Element element) {
        if (null == element) {
            return false;
        }
        if (null != SAMLUtils.getFirstMatchingChildElement(element, SAML_ATN_STATEMENT_TAG)) {
            return false;
        }
        Element element2 = SAMLUtils.getFirstMatchingChildElement(element, SAML_ATTRIBUTE_STATEMENT_TAG);
        if (null == element2) {
            return false;
        }
        return null != SAMLUtils.getFirstMatchingChildElement(element2, SAML_SUBJECT_TAG);
    }

    public static Element getSubjectElementFromSamlAssertion(Element element) {
        Element element2 = SAMLUtils.getFirstMatchingChildElement(element, SAML_ATN_STATEMENT_TAG);
        if (element2 != null) {
            return SAMLUtils.getFirstMatchingChildElement(element2, SAML_SUBJECT_TAG);
        }
        element2 = SAMLUtils.getFirstMatchingChildElement(element, SAML_ATTRIBUTE_STATEMENT_TAG);
        if (element2 != null) {
            return SAMLUtils.getFirstMatchingChildElement(element2, SAML_SUBJECT_TAG);
        }
        return SAMLUtils.getFirstMatchingChildElement(element, SAML_SUBJECT_TAG);
    }

    public static Element getNameIdentifierElm(Element element) {
        if (null == element) {
            return null;
        }
        Element element2 = SAMLUtils.getFirstMatchingChildElement(element, SAML11_NAMEID_TAG);
        if (null != element2) {
            return element2;
        }
        return SAMLUtils.getFirstMatchingChildElement(element, SAML20_NAMEID_TAG);
    }

    public static boolean hasX509SubjectName(Element element) {
        if (null == element) {
            return false;
        }
        String string = DOMUtils.getAttributeValue(element, new QName(FORMAT));
        if (null == string) {
            string = DOMUtils.getAttributeValue(element, new QName(element.getNamespaceURI(), FORMAT));
        }
        if (null != string) {
            return string.indexOf(X509_SUBJECT_NAME) != -1;
        }
        String string2 = DOMUtils.getText(element);
        if (null == string2) {
            return false;
        }
        return string2.startsWith("CN=");
    }

    public static Subject getJavaSubjectFromSamlElement(Node node) {
        Element element = (Element)node;
        Element element2 = SAMLUtils.getSubjectElementFromSamlAssertion(element);
        Element element3 = SAMLUtils.getNameIdentifierElm(element2);
        if (null == element3) {
            return null;
        }
        String string = DOMUtils.getText(element3);
        Subject subject = new Subject();
        if (null == string) {
            return subject;
        }
        if (SAMLUtils.hasX509SubjectName(element3)) {
            if (verbose) {
                Verbose.log("X509 Subject name =" + string);
            }
            X500Principal x500Principal = new X500Principal(string);
            subject.getPrincipals().add(x500Principal);
        } else {
            if (verbose) {
                Verbose.log("Simple principla name =" + string);
            }
            SimplePrincipal simplePrincipal = new SimplePrincipal(string);
            subject.getPrincipals().add((Principal)simplePrincipal);
        }
        return subject;
    }

    static {
        saml11TokenSet = new HashSet();
        saml11TokenSet.add("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        saml11TokenSet.add("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        saml11TokenSet.add("http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID");
    }
}

