/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.serviceref;

import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.security.KeyPairCredential;
import weblogic.security.PublicCertCredential;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.security.bst.BSTCredentialProvider;
import weblogic.wsee.security.serviceref.ServiceRefUtils;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;

public class ServiceRefBSTCredProv
extends BSTCredentialProvider {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        Object object = null;
        if (ServiceRefBSTCredProv.isForVerification(purpose) || ServiceRefBSTCredProv.isForEncryption(purpose)) {
            object = ServiceRefUtils.getCredential(kernelID, "weblogic.pki.TrustedCertificate", string2, contextHandler);
            if (object != null) {
                PublicCertCredential publicCertCredential = (PublicCertCredential)object;
                return new X509Credential((X509Certificate)publicCertCredential.getCertificate());
            }
        } else if ((purpose == null || ServiceRefBSTCredProv.isForIdentity(purpose) || ServiceRefBSTCredProv.isForSigning(purpose) || ServiceRefBSTCredProv.isForResponseEncryption(purpose) || ServiceRefBSTCredProv.isForDecryption(purpose)) && (object = ServiceRefUtils.getCredential(kernelID, "weblogic.pki.Keypair", string2, contextHandler)) != null) {
            KeyPairCredential keyPairCredential = (KeyPairCredential)object;
            return new X509Credential((X509Certificate)keyPairCredential.getCertificate(), (PrivateKey)keyPairCredential.getKey());
        }
        return null;
    }
}

