/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.serviceref;

import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import weblogic.security.SSL.TrustManager;
import weblogic.xml.crypto.utils.CertUtils;

public class ServiceRefTrustManager
implements TrustManager,
Serializable {
    static final long serialVersionUID = 4818528773669203889L;
    private static ServiceRefTrustManager tm = new ServiceRefTrustManager();

    private ServiceRefTrustManager() {
    }

    public static TrustManager getInstance() {
        return tm;
    }

    public boolean certificateCallback(X509Certificate[] x509CertificateArray, int n) {
        try {
            return CertUtils.validateCertPath(this.getCertPath(x509CertificateArray));
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private CertPath getCertPath(X509Certificate[] x509CertificateArray) throws CertificateException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate = x509CertificateArray[i];
            arrayList.add(x509Certificate);
        }
        return CertificateFactory.getInstance("X509").generateCertPath(arrayList);
    }
}

