/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.serviceref;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.RemoteResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.security.spi.WLSUser;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.WSSecurityContext;

public class ServiceRefUtils {
    private static boolean VERBOSE = SecurityImpl.VERBOSE;
    public static final String END_POINT_ADDRESS = "weblogic.wsee.connection.end_point_address";

    public static Object getCredential(AuthenticatedSubject authenticatedSubject, String string, String string2, ContextHandler contextHandler) {
        AuthenticatedSubject authenticatedSubject2;
        String string3 = ServiceRefUtils.getPrincipalName(authenticatedSubject, contextHandler, string);
        if (string3 == null) {
            return null;
        }
        Resource resource = ServiceRefUtils.getResource(contextHandler);
        if (resource == null) {
            return null;
        }
        CredentialManager credentialManager = ServiceRefUtils.getCredentialManager(authenticatedSubject);
        Object[] objectArray = credentialManager.getCredentials(authenticatedSubject, string3, resource, null, string);
        if (objectArray.length < 1 && (objectArray = credentialManager.getCredentials(authenticatedSubject, authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)authenticatedSubject), resource, null, string)).length < 1) {
            LogUtils.logWss("No credentials found for principal name " + string3 + " and remote resource " + resource);
            return null;
        }
        LogUtils.logWss("Got credentials for principal name " + string3 + " and remote resource " + resource);
        return objectArray[0];
    }

    private static CredentialManager getCredentialManager(AuthenticatedSubject authenticatedSubject) {
        SecurityService.ServiceType serviceType = SecurityService.ServiceType.CREDENTIALMANAGER;
        String string = SecurityServiceManager.getDefaultRealmName();
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)authenticatedSubject, (String)string, (SecurityService.ServiceType)serviceType);
        return credentialManager;
    }

    private static String getPrincipal(AuthenticatedSubject authenticatedSubject) {
        AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)authenticatedSubject);
        return ServiceRefUtils.getName(authenticatedSubject2);
    }

    private static String getName(AuthenticatedSubject authenticatedSubject) {
        String string;
        block0: {
            Set set = authenticatedSubject.getPrincipals(WLSUser.class);
            string = null;
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) break block0;
            Principal principal = (Principal)iterator.next();
            string = principal.getName();
        }
        return string;
    }

    private static Resource getResource(ContextHandler contextHandler) {
        WSSecurityContext wSSecurityContext = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        String string = (String)messageContext.getProperty("weblogic.wsee.security.wss.end_point_url");
        if (string != null) {
            LogUtils.logWss("Endpoint address from message context property weblogic.wsee.security.wss.end_point_url : " + string);
        }
        if (string == null && (string = (String)messageContext.getProperty(END_POINT_ADDRESS)) != null) {
            LogUtils.logWss("Endpoint address from message context property weblogic.wsee.connection.end_point_address : " + string);
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LogUtils.logWss("Could not create RemoteResource, endpoint address: " + string + ", " + malformedURLException);
            return null;
        }
        return new RemoteResource(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getPort()), uRL.getPath(), null);
    }

    private static String getPrincipalName(AuthenticatedSubject authenticatedSubject, ContextHandler contextHandler, String string) {
        String string2 = null;
        if ("weblogic.pki.Keypair".equals(string) || "weblogic.pki.TrustedCertificate".equals(string)) {
            string2 = (String)contextHandler.getValue("weblogic.xml.crypto.wss.PKI_Initiator");
        }
        LogUtils.logWss("Principal name from context handler: " + string2);
        if (string2 == null) {
            string2 = ServiceRefUtils.getPrincipal(authenticatedSubject);
            LogUtils.logWss("Principal name from subject on thread:" + string2);
        }
        if (string2 == null) {
            AuthenticatedSubject authenticatedSubject2 = (AuthenticatedSubject)contextHandler.getValue("weblogic.wsee.wss.subject");
            if (authenticatedSubject2 != null) {
                string2 = ServiceRefUtils.getName(authenticatedSubject2);
            }
            LogUtils.logWss("Principal name from security context:" + string2);
        }
        return string2;
    }
}

