/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.util;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.security.bst.ClientBSTCredentialProvider;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.security.utils.Utils;

public class BSTCredentialProviderUtil {
    private static final boolean verbose = Verbose.isVerbose(BSTCredentialProviderUtil.class);
    private static final String X509V3_VALUE_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";

    public static void dumpBST(String string, MessageContext messageContext) {
        try {
            Verbose.banner("BST --" + string);
            Map map = WSSecurityContext.getCredentialProviders(messageContext);
            if (null == map) {
                if (verbose) {
                    Verbose.log("No crdential provider found");
                }
                return;
            }
            CredentialProvider credentialProvider = (CredentialProvider)map.get(X509V3_VALUE_TYPE);
            if (null == credentialProvider) {
                if (verbose) {
                    Verbose.log("No X509V3 crdential provider found");
                }
                return;
            }
            if (credentialProvider instanceof ClientBSTCredentialProvider) {
                Verbose.log("ClientBSTCredentialProvider CP =" + credentialProvider.toString() + "\n");
            } else {
                Verbose.log("CredentialProvider CP =" + credentialProvider.toString() + "\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static X509Credential findX509Credential(MessageContext messageContext, X509Certificate x509Certificate) {
        WSSecurityContext wSSecurityContext;
        if (verbose) {
            Verbose.log("Finding ClientBSTCredentialProvider that has X509 cert =" + BSTCredentialProviderUtil.dumpX509CertInfo(x509Certificate));
        }
        if (null == (wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext))) {
            if (verbose) {
                Verbose.log("No securityContext found");
            }
            return null;
        }
        try {
            CredentialProvider credentialProvider = wSSecurityContext.getRequiredCredentialProvider(X509V3_VALUE_TYPE);
            Object object = credentialProvider.getCredential(X509V3_VALUE_TYPE, null, new SecurityTokenContextHandler(wSSecurityContext), Purpose.SIGN);
            if (object == null || !(object instanceof X509Credential)) {
                Verbose.log("Unable to find the X509 credentail for valueType = http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3 credential is " + object);
                return null;
            }
            X509Credential x509Credential = (X509Credential)object;
            if (x509Certificate.equals(x509Credential.getCertificate())) {
                if (verbose) {
                    Verbose.log("Found the credendtial for the given X509 cert");
                }
                return (X509Credential)object;
            }
            if (verbose) {
                Verbose.log("Unable to find the matched X509 credentail for valueType = http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3 credential found was " + x509Credential);
            }
            return null;
        }
        catch (WSSecurityException wSSecurityException) {
            wSSecurityException.printStackTrace();
            Verbose.logException(wSSecurityException);
            return null;
        }
    }

    public static String dumpX509CertInfo(X509Certificate x509Certificate) {
        if (null == x509Certificate) {
            return "Null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Principal principal = x509Certificate.getSubjectDN();
            stringBuffer.append(x509Certificate.getSubjectDN());
            stringBuffer.append(" SKI=");
            byte[] byArray = Utils.getSubjectKeyIdentifier(x509Certificate);
            if (null == byArray || byArray.length == 0) {
                stringBuffer.append("Null");
            } else {
                stringBuffer.append(Utils.toBase64(byArray));
            }
            stringBuffer.append(" TP=");
            byte[] byArray2 = CertUtils.getThumbprint(x509Certificate);
            stringBuffer.append(Utils.toBase64(byArray2));
        }
        catch (Exception exception) {
            stringBuffer.append("? exception=" + exception.getMessage());
        }
        return stringBuffer.toString();
    }
}

