/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import weblogic.utils.encoders.BASE64Encoder;

public class CertUtils {
    public static void dumpCert(String string, String string2, String string3, String string4, OutputStream outputStream) throws Exception {
        List list = CertUtils.getCertificate(string, string2, string3, "JKS");
        String string5 = CertUtils.getBase64EncodedCert((X509Certificate)list.get(0));
        outputStream.write("-----BEGIN CERTIFICATE-----".getBytes());
        outputStream.write(string5.getBytes());
        outputStream.write("-----END CERTIFICATE-----".getBytes());
    }

    public static void dumpPrivateKey(String string, String string2, String string3, String string4, OutputStream outputStream) throws Exception {
        List list = CertUtils.getCertificate(string, string2, string3, "JKS");
        String string5 = CertUtils.getBase64EncodedCert((X509Certificate)list.get(0));
        outputStream.write("-----BEGIN PRIVATE KEY-----".getBytes());
        outputStream.write(string5.getBytes());
        outputStream.write("-----END PRIVATE KEY-----".getBytes());
    }

    public static List getCertificate(String string, String string2, String string3, String string4) {
        if (string == null || string.equals("")) {
            throw new SecurityException("keyStoreFilename is either null or empty string");
        }
        if (string4 == null || string4.equals("")) {
            throw new SecurityException("keyStoreType is either null or empty");
        }
        if (string3 == null || string3.equals("")) {
            throw new SecurityException("certAlias is either null or empty");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(string4);
            FileInputStream fileInputStream = new FileInputStream(string);
            if (string2 == null) {
                keyStore.load(fileInputStream, null);
            } else {
                keyStore.load(fileInputStream, string2.toCharArray());
            }
            Certificate[] certificateArray = keyStore.getCertificateChain(string3);
            if (certificateArray == null) {
                throw new SecurityException("Can not find public key for alias: \"" + string3 + "\"");
            }
            return Arrays.asList(certificateArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SecurityException(fileNotFoundException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException);
        }
        catch (CertificateException certificateException) {
            throw new SecurityException(certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecurityException(keyStoreException);
        }
    }

    public static Enumeration getAliases(String string, String string2, String string3) {
        if (string == null || string.equals("")) {
            throw new SecurityException("keyStoreFilename is either null or empty string");
        }
        if (string3 == null || string3.equals("")) {
            throw new SecurityException("keyStoreType is either null or empty");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(string3);
            FileInputStream fileInputStream = new FileInputStream(string);
            if (string2 == null) {
                keyStore.load(fileInputStream, null);
            } else {
                keyStore.load(fileInputStream, string2.toCharArray());
            }
            return keyStore.aliases();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SecurityException(fileNotFoundException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException);
        }
        catch (CertificateException certificateException) {
            throw new SecurityException(certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecurityException(keyStoreException);
        }
    }

    public static String getBase64EncodedCert(Certificate certificate) throws CertificateEncodingException {
        return new BASE64Encoder().encodeBuffer(certificate.getEncoded());
    }

    public static PrivateKey getPrivateKey(String string, String string2, String string3, String string4, String string5) throws KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(string4);
        keyStore.load(new FileInputStream(string3), string5.toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, string2.toCharArray());
        return privateKey;
    }

    public static PrivateKey getPKCS8PrivateKey(String string) throws Exception {
        if (string == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        return CertUtils.getPKCS8PrivateKey(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPKCS8PrivateKey(InputStream inputStream) throws Exception {
        if (null == inputStream) {
            throw new IllegalArgumentException("Null inputstream");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            PrivateKey privateKey;
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey2 = privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey2;
        }
        finally {
            dataInputStream.close();
        }
    }

    public static X509Certificate getCertificate(String string) throws Exception {
        if (string == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        return CertUtils.getCertificate(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getCertificate(InputStream inputStream) throws Exception {
        if (null == inputStream) {
            throw new IllegalArgumentException("Null inputstream");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(byteArrayInputStream);
            return x509Certificate;
        }
        finally {
            dataInputStream.close();
        }
    }

    public static String getSubjectCN(X509Certificate x509Certificate) {
        if (null == x509Certificate) {
            return null;
        }
        String string = x509Certificate.getSubjectDN().getName();
        int n = string.indexOf("CN=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 3);
        if ((n = string2.indexOf(",")) == -1) {
            return string2.trim();
        }
        return string2.substring(0, n).trim();
    }
}

