/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.util;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.xml.crypto.wss.WSSecurityException;

public class FaultUtils {
    private static final String DEBUG_PROPERTY = "weblogic.wsee.security.debug";
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.wsee.security.debug");
    private static final QName SENDER = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender", "env");
    private static final QName RECEIVER = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver", "env");
    private static final QName SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server", "env");

    public static boolean isDebug() {
        return DEBUG;
    }

    public static void setSOAPFault(Throwable throwable, SoapMessageContext soapMessageContext) throws SOAPException {
        soapMessageContext.setFault(throwable);
        MessageFactory messageFactory = soapMessageContext.getMessageFactory();
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        SOAPFault sOAPFault = sOAPMessage.getSOAPBody().addFault();
        soapMessageContext.setMessage(sOAPMessage);
        QName qName = FaultUtils.getSubcode(throwable);
        if (FaultUtils.isSOAP12(soapMessageContext)) {
            FaultUtils.setSOAP12Code(qName, sOAPFault);
        } else {
            FaultUtils.setSOAP11Code(qName, sOAPFault);
        }
        sOAPFault.setFaultString(FaultUtils.getMessage(throwable));
        if (DEBUG) {
            Detail detail = sOAPFault.addDetail();
            SOAPFaultUtil.fillDetail(throwable, detail, true);
        }
    }

    private static String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getCause().getMessage();
        }
        return string;
    }

    private static void setSOAP11Code(QName qName, SOAPFault sOAPFault) throws SOAPException {
        SOAPFactory sOAPFactory = WLSOAPFactory.createSOAPFactory("SOAP 1.1 Protocol");
        if (qName != null) {
            sOAPFault.setFaultCode(FaultUtils.getName(qName, sOAPFactory));
        } else {
            sOAPFault.setFaultCode(FaultUtils.getName(SERVER, sOAPFactory));
        }
    }

    private static void setSOAP12Code(QName qName, SOAPFault sOAPFault) throws SOAPException {
        SOAPFactory sOAPFactory = WLSOAPFactory.createSOAPFactory("SOAP 1.2 Protocol");
        if (qName != null) {
            sOAPFault.setFaultCode(FaultUtils.getName(SENDER, sOAPFactory));
            sOAPFault.appendFaultSubcode(qName);
        } else {
            sOAPFault.setFaultCode(FaultUtils.getName(RECEIVER, sOAPFactory));
        }
    }

    private static Name getName(QName qName, SOAPFactory sOAPFactory) throws SOAPException {
        return sOAPFactory.createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    private static QName getSubcode(Throwable throwable) {
        QName qName = null;
        if (throwable instanceof WSSecurityException) {
            qName = ((WSSecurityException)throwable).getFaultCode();
        }
        return qName;
    }

    private static boolean isSOAP12(SoapMessageContext soapMessageContext) throws SOAPException {
        Dispatcher dispatcher = soapMessageContext.getDispatcher();
        if (dispatcher != null) {
            return dispatcher.isSOAP12();
        }
        return "http://www.w3.org/2003/05/soap-envelope".equals(soapMessageContext.getMessage().getSOAPPart().getEnvelope().getNamespaceURI());
    }
}

