/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.wss.SecurityPolicyConductor;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.plan.SecurityMessageArchitect;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.sps.SmartPolicySelector;
import weblogic.wsee.security.wss.sps.SmartSecurityPolicyBlueprint;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class SecurityPolicyArchitect
extends SecurityPolicyConductor {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyArchitect.class);
    private static final boolean debug = false;

    public SecurityPolicyArchitect(SecurityBuilder securityBuilder, WSS11Context wSS11Context) {
        super(securityBuilder, wSS11Context);
    }

    public SecurityPolicyArchitect(SecurityBuilder securityBuilder, SecurityValidator securityValidator, WSS11Context wSS11Context) {
        super(securityBuilder, securityValidator, wSS11Context);
    }

    protected void processMessagePolicy(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, SOAPMessageContext sOAPMessageContext, boolean bl) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        SmartPolicySelector smartPolicySelector;
        Map<String, Object> map = SecurityPolicyArchitect.initBlueprintPropertiesFromContext(sOAPMessageContext);
        if (verbose) {
            if (normalizedExpression == null) {
                Verbose.say("Request policy is null");
            } else {
                Verbose.say("Request policy:" + normalizedExpression.toString());
            }
            if (normalizedExpression2 == null) {
                Verbose.say("No Normalized Response Policy");
            } else {
                Verbose.say("Response policy:" + normalizedExpression2.toString());
            }
        }
        if (bl) {
            smartPolicySelector = new SmartPolicySelector(this.sbuilder, normalizedExpression, normalizedExpression2, map, bl, this.securityCtx);
        } else {
            if (this.securityCtx.hasDerivedKey()) {
                map.put("DerivedKeysToken", "DerivedKeysToken");
            }
            smartPolicySelector = new SmartPolicySelector(this.sbuilder, normalizedExpression2, normalizedExpression, map, bl, this.securityCtx);
        }
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = smartPolicySelector.getSmartPolicyBlueprint();
        if (null == smartSecurityPolicyBlueprintArray || 0 == smartSecurityPolicyBlueprintArray.length) {
            if (0 != smartPolicySelector.getReasonCode()) {
                throw new SecurityPolicyException(smartPolicySelector.tellMeWhy());
            }
            if (verbose) {
                Verbose.log("No policy aletrnative has been selected");
            }
            throw new SecurityPolicyException("No good policy aletrnative found");
        }
        if (1 == smartSecurityPolicyBlueprintArray.length) {
            this.processOutbound(smartSecurityPolicyBlueprintArray[0].getSecurityPolicyBlueprint(), sOAPMessageContext);
            this.securityCtx.setRequestPolicyIdx(0);
            return;
        }
        SecurityPolicyException securityPolicyException = null;
        if (bl) {
            int[] nArray = smartPolicySelector.getPolicyPriorityIndex();
            for (int i = 0; i < smartSecurityPolicyBlueprintArray.length; ++i) {
                try {
                    this.processOutbound(smartSecurityPolicyBlueprintArray[nArray[i]].getSecurityPolicyBlueprint(), sOAPMessageContext);
                    this.securityCtx.setRequestPolicyIdx(nArray[i]);
                    return;
                }
                catch (SecurityPolicyException securityPolicyException2) {
                    Verbose.log("Policy alternative [" + nArray[i] + "] got problems, error =" + securityPolicyException2.getMessage());
                    if (null != securityPolicyException) continue;
                    securityPolicyException = securityPolicyException2;
                    continue;
                }
            }
        } else {
            int n;
            int n2 = this.securityCtx.getRequestPolicyIdx();
            Verbose.log("Use the privous selected one for response idx=" + n2);
            try {
                boolean bl2 = false;
                for (n = 0; n < smartSecurityPolicyBlueprintArray.length; ++n) {
                    if (smartSecurityPolicyBlueprintArray[n].getPolicyLocationIdx() != n2) continue;
                    this.processOutbound(smartSecurityPolicyBlueprintArray[n].getSecurityPolicyBlueprint(), sOAPMessageContext);
                    return;
                }
            }
            catch (SecurityPolicyException securityPolicyException3) {
                Verbose.log("Policy alternative [" + n2 + "] got problems, error =" + securityPolicyException3.getMessage());
                securityPolicyException = securityPolicyException3;
            }
            int[] nArray = smartPolicySelector.getPolicyPriorityIndex();
            for (n = 0; n < smartSecurityPolicyBlueprintArray.length; ++n) {
                int n3 = nArray[n];
                if (n2 == n3) continue;
                try {
                    this.processOutbound(smartSecurityPolicyBlueprintArray[n3].getSecurityPolicyBlueprint(), sOAPMessageContext);
                    return;
                }
                catch (SecurityPolicyException securityPolicyException4) {
                    Verbose.log("Policy alternative [" + n3 + "] got problems, error =" + securityPolicyException4.getMessage());
                }
            }
        }
        throw securityPolicyException;
    }

    protected void processOutbound(SecurityPolicyBlueprint securityPolicyBlueprint, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyArchitectureException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        this.securityCtx.setPolicyOutline(securityPolicyBlueprint);
        SecurityMessageArchitect securityMessageArchitect = new SecurityMessageArchitect(this.securityCtx);
        securityMessageArchitect.buildWssMessage(sOAPMessageContext, securityPolicyBlueprint);
    }
}

