/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityPolicyConductor {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyConductor.class);
    private static final boolean debug = false;
    protected SecurityBuilder sbuilder = null;
    protected SecurityValidator sValidator = null;
    protected WSS11Context securityCtx;

    public SecurityPolicyConductor(SecurityBuilder securityBuilder, WSS11Context wSS11Context) {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.sbuilder = securityBuilder;
        this.securityCtx = wSS11Context;
    }

    public SecurityPolicyConductor(SecurityBuilder securityBuilder, SecurityValidator securityValidator, WSS11Context wSS11Context) {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.sbuilder = securityBuilder;
        this.sValidator = securityValidator;
        this.securityCtx = wSS11Context;
    }

    public SecurityPolicyConductor(SecurityValidator securityValidator, WSS11Context wSS11Context) {
        if (null == securityValidator) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.sValidator = securityValidator;
        this.securityCtx = wSS11Context;
    }

    public void processRequestOutbound(NormalizedExpression normalizedExpression, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        if (SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression)) {
            this.processRequestOutbound(normalizedExpression, null, sOAPMessageContext);
        }
    }

    public void processRequestOutbound(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        this.processMessagePolicy(normalizedExpression, normalizedExpression2, sOAPMessageContext, true);
    }

    public void processResponseOutbound(NormalizedExpression normalizedExpression, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        if (SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression)) {
            this.processResponseOutbound(null, normalizedExpression, sOAPMessageContext);
        }
    }

    public void processResponseOutbound(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        this.processMessagePolicy(normalizedExpression, normalizedExpression2, sOAPMessageContext, false);
    }

    protected abstract void processMessagePolicy(NormalizedExpression var1, NormalizedExpression var2, SOAPMessageContext var3, boolean var4) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException;

    protected static Map<String, Object> initBlueprintPropertiesFromContext(SOAPMessageContext sOAPMessageContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.security.message_age", sOAPMessageContext.getProperty("weblogic.wsee.security.message_age"));
        PolicySelectionPreference policySelectionPreference = PolicySelectionPreference.getPolicySelectionPreference((MessageContext)sOAPMessageContext);
        hashMap.put("weblogic.wsee.policy.selection.preference", policySelectionPreference);
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.policy.compat.preference");
        hashMap.put("weblogic.wsee.policy.compat.preference", string);
        hashMap.put("oracle.contextelement.saml2.AttributeOnly", sOAPMessageContext.getProperty("oracle.contextelement.saml2.AttributeOnly"));
        hashMap.put("weblogic.wsee.security.saml.attributies", sOAPMessageContext.getProperty("weblogic.wsee.security.saml.attributies"));
        return hashMap;
    }
}

