/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.EncryptionPolicy;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.IdentityPolicy;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.SigningPolicy;
import weblogic.wsee.security.policy.SigningReferencesFactory;
import weblogic.wsee.security.policy.TimestampPolicy;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.MessageAgeAssertion;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.SecurityBuilder;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.Purpose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyDriver {
    private SecurityBuilder sbuilder;
    private SecurityTokenContextHandler ctxHandler;
    private SecurityToken policyIdToken;
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyDriver.class);

    public SecurityPolicyDriver(SecurityBuilder securityBuilder, WSSecurityContext wSSecurityContext) {
        this.sbuilder = securityBuilder;
        this.ctxHandler = new SecurityTokenContextHandler(wSSecurityContext);
    }

    public void processOutbound(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        this.processOutbound(policyAlternative, null, sOAPMessageContext);
    }

    public void processOutbound(PolicyAlternative policyAlternative, PolicyAlternative policyAlternative2, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        if (policyAlternative2 != null) {
            this.processConfidentialityTokens(policyAlternative2, sOAPMessageContext);
        }
        if (policyAlternative != null) {
            this.processMessageAge(policyAlternative);
            this.processIdentity(policyAlternative);
            this.processIntegrity(policyAlternative, sOAPMessageContext);
            this.processConfidentiality(policyAlternative, sOAPMessageContext);
        }
    }

    private void processConfidentialityTokens(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, MarshalException {
        Set set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        if (set == null || set.size() == 0) {
            return;
        }
        this.doConfidentialityTokens(set, sOAPMessageContext);
    }

    private void doConfidentialityTokens(Set<ConfidentialityAssertion> set, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, MarshalException {
        XMLEncryptionFactory xMLEncryptionFactory = this.sbuilder.getXMLEncryptionFactory();
        block0: for (ConfidentialityAssertion confidentialityAssertion : set) {
            EncryptionPolicy encryptionPolicy = new EncryptionPolicy(xMLEncryptionFactory, sOAPMessageContext, confidentialityAssertion, false);
            List list = encryptionPolicy.getValidEncryptionTokens();
            boolean bl = false;
            for (SecurityToken securityToken : list) {
                this.ctxHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", securityToken.getClaims());
                bl = this.sbuilder.addSecurityToken(securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), Purpose.ENCRYPT_RESPONSE, this.ctxHandler) != null;
                if (!bl) continue;
                continue block0;
            }
        }
    }

    private void processMessageAge(PolicyAlternative policyAlternative) throws WSSecurityException, MarshalException, PolicyException {
        Set set = policyAlternative.getAssertions(MessageAgeAssertion.class);
        if (set.size() > 0) {
            this.doMessageAge(set);
        }
    }

    private void doMessageAge(Set<MessageAgeAssertion> set) throws WSSecurityException, MarshalException, PolicyException {
        if (set.size() > 1) {
            throw new PolicyException("Only one MessageAge specification is supported in a policy alternative");
        }
        TimestampPolicy timestampPolicy = new TimestampPolicy(set.iterator().next());
        short s = timestampPolicy.getMessageAgeSeconds();
        if (!this.sbuilder.addTimestamp(s, this.ctxHandler)) {
            throw new WSSecurityException("Unable to add a Timestamp to the message");
        }
        if (verbose) {
            Verbose.log("Added timestamp(maxAgesSecs=" + s + ")...");
        }
    }

    private void processIdentity(PolicyAlternative policyAlternative) throws WSSecurityException, MarshalException {
        this.doIdentity(policyAlternative);
    }

    private void doIdentity(PolicyAlternative policyAlternative) throws WSSecurityException, MarshalException {
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        for (IdentityAssertion identityAssertion : set) {
            IdentityPolicy identityPolicy = new IdentityPolicy(identityAssertion);
            List list = identityPolicy.getValidIdentityTokens();
            boolean bl = false;
            for (SecurityToken securityToken : list) {
                this.addClaimsToContextHandler(securityToken.getClaims());
                if (this.sbuilder.addSecurityToken(securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), Purpose.IDENTITY, this.ctxHandler) == null) {
                    if (!verbose) continue;
                    Verbose.log("Failed to add token: " + securityToken);
                    continue;
                }
                if (verbose) {
                    Verbose.log("Added " + securityToken);
                }
                bl = true;
                this.policyIdToken = securityToken;
                break;
            }
            if (bl) continue;
            throw new WSSecurityException("Unable to add security token for identity");
        }
    }

    private void processIntegrity(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyException, WSSecurityException, MarshalException, PolicyException {
        Set set = policyAlternative.getAssertions(IntegrityAssertion.class);
        if (set == null || set.size() == 0) {
            return;
        }
        this.doIntegrity(set, sOAPMessageContext);
    }

    private void doIntegrity(Set<IntegrityAssertion> set, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyException, WSSecurityException, MarshalException, PolicyException {
        SigningReferencesFactory signingReferencesFactory;
        XMLSignatureFactory xMLSignatureFactory = this.sbuilder.getXMLSignatureFactory();
        SigningPolicy signingPolicy = new SigningPolicy(xMLSignatureFactory, signingReferencesFactory = new SigningReferencesFactory(this.sbuilder), sOAPMessageContext, set);
        if (signingPolicy.isX509AuthConditional() && (this.policyIdToken == null || !BSTUtils.isX509Type(this.policyIdToken.getTokenTypeUri()))) {
            return;
        }
        SignedInfo signedInfo = signingPolicy.getSignedInfo();
        List list = signingPolicy.getValidSignatureTokens();
        Node node = null;
        boolean bl = signingPolicy.signedSecurityTokens();
        for (SecurityToken securityToken : list) {
            this.addClaimsToContextHandler(securityToken.getClaims());
            this.addDerivedFromToken(securityToken);
            if (bl) {
                Reference reference = signingReferencesFactory.newSigningTokenReference(securityToken, this.ctxHandler, signingPolicy.getDigestAlgorithm());
                if (reference == null) continue;
                node = this.sbuilder.addSignature(signingPolicy.newSignedInfo(xMLSignatureFactory, reference), reference, this.ctxHandler);
            } else {
                node = this.sbuilder.addSignature(signedInfo, securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.isIncludeInMessage(), this.ctxHandler);
            }
            if (node == null) continue;
            if (!verbose) break;
            Verbose.log("Added Signature using " + securityToken);
            break;
        }
        if (node == null) {
            throw new WSSecurityException("Failed to add Signature.");
        }
    }

    private void processConfidentiality(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, MarshalException, XMLEncryptionException, PolicyException {
        Set set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        if (set == null || set.size() == 0) {
            return;
        }
        this.doConfidentiality(set, sOAPMessageContext);
    }

    private void doConfidentiality(Set<ConfidentialityAssertion> set, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, MarshalException, XMLEncryptionException, PolicyException {
        XMLEncryptionFactory xMLEncryptionFactory = this.sbuilder.getXMLEncryptionFactory();
        for (ConfidentialityAssertion confidentialityAssertion : set) {
            EncryptionPolicy encryptionPolicy = new EncryptionPolicy(xMLEncryptionFactory, sOAPMessageContext, confidentialityAssertion);
            List list = encryptionPolicy.getValidEncryptionTokens();
            List list2 = encryptionPolicy.getEncryptionTargets();
            EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
            for (EncryptionTarget encryptionTarget : list2) {
                boolean bl = false;
                for (SecurityToken securityToken : list) {
                    this.addClaimsToContextHandler(securityToken.getClaims());
                    this.addDerivedFromToken(securityToken);
                    bl = this.sbuilder.addEncryption(encryptionTarget.getTBEs(), encryptionMethod, encryptionTarget.getEncryptionMethod(), securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.isIncludeInMessage(), this.ctxHandler);
                    if (!bl) continue;
                    break;
                }
                if (bl) continue;
                throw new WSSecurityException("Failed to add Encryption.");
            }
        }
    }

    private void addClaimsToContextHandler(Node node) {
        this.ctxHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", node);
    }

    private void addDerivedFromToken(SecurityToken securityToken) throws MarshalException, WSSecurityException {
        Object object;
        String string = securityToken.getDerivedFromTokenType();
        if (string != null && (object = this.ctxHandler.getValue("weblogic.wsee.wsc.derived_from_token")) == null) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.move_node_to_top", "true");
            this.ctxHandler.addContextElement("weblogic.wsee.wsc.derived_from_token", this.sbuilder.addSecurityToken(string, null, Purpose.SIGN, this.ctxHandler));
            this.ctxHandler.addContextElement("weblogic.wsee.security.move_node_to_top", "false");
        }
    }
}

