/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.wss.SecurityPolicyConductor;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.plan.SecurityMessageInspector;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutline;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.security.wss.sps.SmartPolicySelector;
import weblogic.wsee.security.wss.sps.SmartSecurityPolicyBlueprint;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyInspector
extends SecurityPolicyConductor {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyInspector.class);
    private static final boolean debug = false;

    public SecurityPolicyInspector(SecurityValidator securityValidator, WSS11Context wSS11Context) {
        super(new SecurityBuilderImpl(wSS11Context), securityValidator, wSS11Context);
    }

    protected static Map<String, Object> initBlueprintPropertiesFromContext(SOAPMessageContext sOAPMessageContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.security.message_age", sOAPMessageContext.getProperty("weblogic.wsee.security.message_age"));
        if (null != sOAPMessageContext.getProperty("weblogic.wsee.policy.compat.preference")) {
            hashMap.put("weblogic.wsee.policy.compat.preference", sOAPMessageContext.getProperty("weblogic.wsee.policy.compat.preference"));
        }
        hashMap.put("weblogic.wsee.policy.selection.preference", new PolicySelectionPreference("ValidationOnly"));
        hashMap.put("oracle.contextelement.saml2.AttributeOnly", sOAPMessageContext.getProperty("oracle.contextelement.saml2.AttributeOnly"));
        hashMap.put("weblogic.wsee.security.saml.attributies", sOAPMessageContext.getProperty("weblogic.wsee.security.saml.attributies"));
        return hashMap;
    }

    @Override
    protected void processMessagePolicy(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, SOAPMessageContext sOAPMessageContext, boolean bl) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray;
        Map<String, Object> map = SecurityPolicyInspector.initBlueprintPropertiesFromContext(sOAPMessageContext);
        SmartPolicySelector smartPolicySelector = bl ? new SmartPolicySelector(this.sValidator, this.sbuilder, normalizedExpression, normalizedExpression2, map, bl, null) : new SmartPolicySelector(this.sValidator, this.sbuilder, normalizedExpression2, normalizedExpression, map, bl, null);
        SecurityPolicyOutline securityPolicyOutline = null;
        Object object = this.securityCtx.getPolicyOutline();
        if (object != null && object instanceof SecurityPolicyOutline) {
            securityPolicyOutline = (SecurityPolicyOutline)object;
        }
        if (null == (smartSecurityPolicyBlueprintArray = smartPolicySelector.getSmartPolicyBlueprint(securityPolicyOutline))) {
            if (0 != smartPolicySelector.getReasonCode()) {
                String string = smartPolicySelector.tellMeWhy();
                throw new SecurityPolicyException(string);
            }
            if (verbose) {
                Verbose.log("No policy aletrnative has been selected");
            }
            throw new SecurityPolicyException("No security policy found!");
        }
        SecurityPolicyInspectionException securityPolicyInspectionException = null;
        for (int i = 0; i < smartSecurityPolicyBlueprintArray.length; ++i) {
            try {
                this.inspectMessageByPolicy(smartSecurityPolicyBlueprintArray[i], sOAPMessageContext);
                this.securityCtx.setRequestPolicyIdx(smartSecurityPolicyBlueprintArray[i].getPolicyLocationIdx());
                this.securityCtx.setPolicyOutline(smartSecurityPolicyBlueprintArray[i].getSecurityPolicyBlueprint());
                return;
            }
            catch (SecurityPolicyInspectionException securityPolicyInspectionException2) {
                securityPolicyInspectionException = securityPolicyInspectionException2;
                continue;
            }
        }
        if (null == securityPolicyInspectionException) {
            throw new SecurityPolicyInspectionException("Unknown error???");
        }
        throw securityPolicyInspectionException;
    }

    private void inspectMessageByPolicy(SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyInspectionException, SecurityPolicyArchitectureException, WSSecurityException {
        SecurityMessageInspector securityMessageInspector = new SecurityMessageInspector(sOAPMessageContext, this.securityCtx);
        boolean bl = "true".equalsIgnoreCase((String)sOAPMessageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"));
        securityMessageInspector.inspectWssMessage(smartSecurityPolicyBlueprint, bl);
    }
}

