/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.sps.SmartPolicySelector;
import weblogic.wsee.security.wss.sps.SmartSecurityPolicyBlueprint;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicySelectionHelper {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicySelectionHelper.class);
    private static final boolean debug = false;
    private SmartPolicySelector sps = null;
    private SmartSecurityPolicyBlueprint[] blueprints = null;
    private PolicySelectionPreference preference = null;
    private NormalizedExpression normalizedPolicy = null;
    public static final int NONE = 0;
    public static final int OPTIONAL = 1;
    public static final int MUST = 2;
    public static final int ERROR = -1;

    public SecurityPolicySelectionHelper(NormalizedExpression normalizedExpression, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        this(normalizedExpression, null, bl, null);
    }

    public SecurityPolicySelectionHelper(NormalizedExpression normalizedExpression, MessageContext messageContext, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.policy.selection.preference", PolicySelectionPreference.getPolicySelectionPreference(messageContext));
        this.init(normalizedExpression, hashMap, bl, null);
    }

    public SecurityPolicySelectionHelper(NormalizedExpression normalizedExpression, PolicySelectionPreference policySelectionPreference, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("weblogic.wsee.policy.selection.preference", policySelectionPreference);
        this.init(normalizedExpression, hashMap, bl, null);
    }

    public SecurityPolicySelectionHelper(NormalizedExpression normalizedExpression, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        this.init(normalizedExpression, map, bl, wSS11Context);
    }

    private void init(NormalizedExpression normalizedExpression, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == normalizedExpression) {
            return;
        }
        if (null == wSS11Context) {
            SoapMessageContext soapMessageContext = new SoapMessageContext(true);
            try {
                wSS11Context = new WSS11Context(soapMessageContext.getMessage().getSOAPBody().getParentNode());
            }
            catch (SOAPException sOAPException) {
                throw new WSSecurityException((Exception)((Object)sOAPException));
            }
        }
        this.normalizedPolicy = normalizedExpression;
        this.sps = new SmartPolicySelector(normalizedExpression, map, bl, wSS11Context);
        if (null != this.sps) {
            this.blueprints = this.sps.getSmartPolicyBlueprint();
        }
    }

    public PolicyAlternative getFirstPolicyAlternative(PolicySelectionPreference policySelectionPreference) {
        PolicyAlternative policyAlternative = this.sps.getFirstPolicyAlternative(policySelectionPreference);
        return policyAlternative;
    }

    public NormalizedExpression generateSortedecurityNormalizedExpression(PolicySelectionPreference policySelectionPreference) {
        if (!this.sps.hasSecurityPolicyAlternative()) {
            return null;
        }
        if (this.sps.getPolicyAlternativeCount() == 1 || this.getAlternatives() == 1) {
            return this.normalizedPolicy;
        }
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = this.sps.getSmartPolicyBlueprint();
        int[] nArray = this.sps.getPolicyPriorityIndex(policySelectionPreference);
        NormalizedExpression normalizedExpression = new NormalizedExpression();
        for (int i = 0; i < nArray.length; ++i) {
            normalizedExpression.addAlternative(smartSecurityPolicyBlueprintArray[nArray[i]].getPolicyAlternative());
        }
        return normalizedExpression;
    }

    public NormalizedExpression generateSortedecurityNormalizedExpression() {
        if (!this.sps.hasSecurityPolicyAlternative()) {
            return null;
        }
        if (this.sps.getPolicyAlternativeCount() == 1 || this.getAlternatives() == 1) {
            return this.normalizedPolicy;
        }
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = this.sps.getSmartPolicyBlueprint();
        int[] nArray = this.sps.getPolicyPriorityIndex();
        NormalizedExpression normalizedExpression = new NormalizedExpression();
        for (int i = 0; i < nArray.length; ++i) {
            normalizedExpression.addAlternative(smartSecurityPolicyBlueprintArray[nArray[i]].getPolicyAlternative());
        }
        return normalizedExpression;
    }

    public PolicySelectionPreference getPolicySelectionPreference() {
        return this.preference;
    }

    public void setPolicySelectionPreference(PolicySelectionPreference policySelectionPreference) {
        this.preference = null == policySelectionPreference ? new PolicySelectionPreference() : policySelectionPreference;
    }

    public int getAlternatives() {
        if (this.blueprints == null) {
            return 0;
        }
        return this.blueprints.length;
    }

    private boolean noPolicy() {
        return this.blueprints == null || this.blueprints.length == 0;
    }

    public int digitalSignatureKeyPairRequirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isSignatureRequired()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }

    public int encryptionKeyPairRequirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isEncryptionRequired()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }

    public int samlTokenRequirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isSamlTokenAuth()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }

    public int usernameTokenRequirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isUsernameTokenAuth()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }

    public int secureConversationRequirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isSecureConversation()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }

    public int secureConversation13Requirement() {
        if (this.noPolicy()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.blueprints.length; ++i) {
            if (!this.blueprints[i].isSecureConversation() || !this.blueprints[i].isWssc13()) continue;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        if (n == this.blueprints.length) {
            return 2;
        }
        return 1;
    }
}

