/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.policy.EncryptionPolicy;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.IdentityPolicy;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.SigningPolicy;
import weblogic.wsee.security.policy.SigningReferencesFactory;
import weblogic.wsee.security.policy.TimestampPolicy;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.MessageAgeAssertion;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityValidator;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyValidator {
    private static boolean VERBOSE = SecurityImpl.VERBOSE;
    private SecurityValidator svalidator;
    private TimestampConfiguration timestampConfig;

    public SecurityPolicyValidator(SecurityValidator securityValidator) {
        this.svalidator = securityValidator;
    }

    public SecurityPolicyValidator(SecurityValidator securityValidator, TimestampConfiguration timestampConfiguration) {
        this.svalidator = securityValidator;
        this.timestampConfig = timestampConfiguration;
    }

    public void processInbound(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, MarshalException, XMLEncryptionException {
        if (!this.svalidator.hasSecurity() && SecurityPolicyAssertionFactory.hasSecurityPolicy(policyAlternative)) {
            throw new WSSecurityException("No Security header in message but required by policy.");
        }
        this.processConfidentiality(policyAlternative, sOAPMessageContext);
        this.processIntegrity(policyAlternative, sOAPMessageContext);
        this.processIdentity(policyAlternative);
        this.processMessageAge(policyAlternative);
    }

    private void processMessageAge(PolicyAlternative policyAlternative) throws WSSecurityException, PolicyException {
        Set set = policyAlternative.getAssertions(MessageAgeAssertion.class);
        if (set.size() > 0) {
            this.doMessageAge(set);
        }
    }

    private void doMessageAge(Set<MessageAgeAssertion> set) throws WSSecurityException, PolicyException {
        if (set.size() > 1) {
            throw new PolicyException("Only one MessageAge specification is supported in a policy alternative");
        }
        TimestampPolicy timestampPolicy = new TimestampPolicy(set.iterator().next());
        short s = timestampPolicy.getMessageAgeSeconds();
        if (!this.svalidator.validateTimestamp(s)) {
            throw new WSSecurityException("Timestamp validation failed.", WSSConstants.FAILURE_INVALID);
        }
    }

    private void processIdentity(PolicyAlternative policyAlternative) throws WSSecurityException {
        this.doIdentity(policyAlternative);
    }

    private void doIdentity(PolicyAlternative policyAlternative) throws WSSecurityException {
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            IdentityAssertion identityAssertion = (IdentityAssertion)iterator.next();
            IdentityPolicy identityPolicy = new IdentityPolicy(identityAssertion);
            List list = identityPolicy.getValidIdentityTokens();
            for (SecurityToken securityToken : list) {
                LogUtils.logWss("Trying to validate identity assertion token " + securityToken.getTokenTypeUri());
                if (!this.svalidator.validateSecurityToken(securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.getClaims())) continue;
                bl = true;
                LogUtils.logWss("Validated identity assertion token " + securityToken.getTokenTypeUri());
            }
            if (bl) continue;
            throw new WSSecurityException("Unable to validate identity assertions.", WSSConstants.FAILURE_INVALID);
        }
    }

    private void processIntegrity(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyException, WSSecurityException, PolicyException {
        Set set = policyAlternative.getAssertions(IntegrityAssertion.class);
        if (set == null || set.size() == 0) {
            return;
        }
        this.doIntegrity(set, sOAPMessageContext);
    }

    private void doIntegrity(Set<IntegrityAssertion> set, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyException, WSSecurityException, PolicyException {
        XMLSignatureFactory xMLSignatureFactory = this.svalidator.getXMLSignatureFactory();
        SigningReferencesFactory signingReferencesFactory = new SigningReferencesFactory(this.svalidator);
        SigningPolicy signingPolicy = new SigningPolicy(xMLSignatureFactory, signingReferencesFactory, sOAPMessageContext, set);
        SignedInfo signedInfo = signingPolicy.getSignedInfo();
        List list = signingPolicy.getValidSignatureTokens();
        boolean bl = false;
        boolean bl2 = signingPolicy.signedSecurityTokens();
        for (SecurityToken securityToken : list) {
            if (bl2) {
                SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
                securityTokenContextHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", securityToken.getClaims());
                Reference reference = signingReferencesFactory.newSigningTokenReference(securityToken, securityTokenContextHandler, signingPolicy.getDigestAlgorithm());
                bl = this.svalidator.validateSignature(signingPolicy.newSignedInfo(xMLSignatureFactory, reference), securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.getClaims());
            } else {
                bl = this.svalidator.validateSignature(signedInfo, securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.getClaims());
            }
            if (!bl) continue;
            break;
        }
        if (!bl) {
            throw new WSSecurityException("Could not validate signature using any of the supported token types", WSSConstants.FAILURE_INVALID);
        }
    }

    private void processConfidentiality(PolicyAlternative policyAlternative, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, PolicyException, XMLEncryptionException {
        Set set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        if (set == null || set.size() == 0) {
            return;
        }
        this.doConfidentiality(set, sOAPMessageContext);
    }

    private void doConfidentiality(Set<ConfidentialityAssertion> set, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, PolicyException, XMLEncryptionException {
        XMLEncryptionFactory xMLEncryptionFactory = this.svalidator.getXMLEncryptionFactory();
        for (ConfidentialityAssertion confidentialityAssertion : set) {
            EncryptionPolicy encryptionPolicy = new EncryptionPolicy(xMLEncryptionFactory, sOAPMessageContext, confidentialityAssertion);
            List list = encryptionPolicy.getValidEncryptionTokens();
            List list2 = encryptionPolicy.getEncryptionTargets();
            EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
            for (EncryptionTarget encryptionTarget : list2) {
                boolean bl = false;
                for (SecurityToken securityToken : list) {
                    bl = this.svalidator.validateEncryption(encryptionTarget.getTBEs(), encryptionMethod, encryptionTarget.getEncryptionMethod(), securityToken.getTokenTypeUri(), securityToken.getTokenIssuer(), securityToken.getClaims());
                    if (!bl) continue;
                    break;
                }
                if (bl) continue;
                throw new WSSecurityException("Could not validate encryption against any of the supported token types", WSSConstants.FAILURE_INVALID);
            }
        }
    }
}

