/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.saml.SAML2Constants;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.plan.helper.TokenTypeHelper;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wss.policy.IdentityPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.TimestampPolicy;
import weblogic.wsee.security.wssc.v200502.WSCConstants;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.SecurityImpl;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.security.wsu.WSUConstants;

public class SecurityMessageArchitect {
    private static final boolean verbose = Verbose.isVerbose(SecurityMessageArchitect.class);
    private static final boolean debug = false;
    private static final String XMLNS_TRUST_13 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private static final String XMLNS_TRUST_DEFAULT = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private SecurityTokenContextHandler ctxHandler;
    private SecurityPolicyBlueprint blueprint;
    private SOAPMessageContext soapMessageCtx;
    private WSS11Context securityCtx;
    private SecurityBuilder secBuilder;

    public SecurityMessageArchitect(WSS11Context wSS11Context) {
        this.securityCtx = wSS11Context;
    }

    public SecurityMessageArchitect(SOAPMessageContext sOAPMessageContext, WSS11Context wSS11Context) {
        if (null == sOAPMessageContext || sOAPMessageContext.getMessage() == null) {
            throw new IllegalArgumentException("Null Soap message context");
        }
        this.soapMessageCtx = sOAPMessageContext;
        this.securityCtx = wSS11Context;
        this.ctxHandler = new SecurityTokenContextHandler(wSS11Context);
    }

    public void buildWssMessage(SOAPMessageContext sOAPMessageContext, SecurityPolicyBlueprint securityPolicyBlueprint) throws PolicyException, WSSecurityException, SecurityPolicyException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        if (null == sOAPMessageContext || sOAPMessageContext.getMessage() == null) {
            throw new IllegalArgumentException("Null Soap message context");
        }
        this.soapMessageCtx = sOAPMessageContext;
        this.ctxHandler = new SecurityTokenContextHandler(this.securityCtx);
        this.buildWssMessage(securityPolicyBlueprint);
    }

    private void buildWssMessage(SecurityPolicyBlueprint securityPolicyBlueprint) throws PolicyException, WSSecurityException, SecurityPolicyException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        this.blueprint = securityPolicyBlueprint;
        this.secBuilder = this.blueprint.getSecurityBuilder();
        this.init();
        this.constructMessage();
        if (verbose) {
            Verbose.log("SOAP Security Message is constructed");
        }
    }

    private void constructMessage() throws PolicyException, WSSecurityException, SecurityPolicyException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        boolean bl = this.blueprint.isRequest();
        boolean bl2 = false;
        SignatureConfirmation[] signatureConfirmationArray = null;
        if (verbose) {
            if (this.blueprint.getPolicyAlternative() != null) {
                NormalizedExpression normalizedExpression = NormalizedExpression.createEmptyExpression();
                normalizedExpression.addAlternative(this.blueprint.getPolicyAlternative());
                if (null == normalizedExpression) {
                    Verbose.log("Policy NormalizedExpression is null");
                } else {
                    System.out.println(normalizedExpression.toString());
                }
            } else {
                Verbose.log("Policy Alternative is null");
            }
        }
        boolean bl3 = "LaxTimestampFirst".equals(this.blueprint.getGeneralPolicy().getLayout());
        if (this.doAction(2) && !bl3) {
            if (verbose) {
                Verbose.log("Constructing message age (1)...");
            }
            this.processMessageAge(this.blueprint.getTimestampPolicy(), bl3);
        }
        if (this.doAction(1)) {
            if (verbose) {
                Verbose.log("Constructing message authentication identity ...");
            }
            this.processIdentity(this.blueprint.getIdentityPolicy());
        }
        if (this.doAction(128)) {
            if (this.blueprint.getGeneralPolicy().isRequireSignatureConfirmation()) {
                if (verbose) {
                    Verbose.log("Constructing signature confirmation ...");
                }
                signatureConfirmationArray = this.processSignatureConfirmation(this.blueprint.getGeneralPolicy());
            } else {
                throw new IllegalStateException("Check why");
            }
        }
        if (this.doAction(2) && bl3) {
            if (verbose) {
                Verbose.log("Constructing message age (2)...");
            }
            this.processMessageAge(this.blueprint.getTimestampPolicy(), bl3);
        }
        if (this.doAction(4)) {
            if (verbose) {
                Verbose.log("Adding toekns to the message ...");
            }
            this.addEndorseToken(this.blueprint.getEndorsingPolicy(), this.blueprint.getSigningPolicy());
        }
        if (this.doAction(256)) {
            this.resolveSignatureList(signatureConfirmationArray);
            this.resolveEncryptionList(signatureConfirmationArray);
        }
        if (this.doAction(8448)) {
            if (verbose) {
                Verbose.log("Constructing signature and encryption with Endorsing togther for the Encrypt Signature case ..., request =" + bl);
            }
            if (this.doAction(1024)) {
                this.resolveSignatureElementSignatureList(signatureConfirmationArray);
            }
            this.processIntegrityAndConfidentialityAndEndorsing(this.blueprint.getSigningPolicy(), this.blueprint.getEncryptionPolicy(), this.blueprint.getEndorsingPolicy(), this.blueprint.getBuildingPlan(), bl);
            return;
        }
        if (this.doAction(256)) {
            if (verbose) {
                Verbose.log("Constructing signature and encryption ..., request =" + bl);
            }
            if (!this.isEncryptBeforeSigning() || this.isEncryptBeforeSigning() && (!this.blueprint.getEncryptionPolicy().isEncryptionRequired() || !this.blueprint.getSigningPolicy().isSignatureRequired())) {
                this.processIntegrityAndConfidentiality(this.blueprint.getSigningPolicy(), this.blueprint.getEncryptionPolicy(), bl);
            } else {
                SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, true);
                this.processIntegrityAndConfidentiality(this.blueprint.getSigningPolicy(), this.blueprint.getEncryptionPolicy(), bl);
                SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, false);
            }
        } else if (this.isEncryptBeforeSigning()) {
            SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, true);
            if (this.doAction(8)) {
                if (verbose) {
                    Verbose.log("Constructing encryption  (1)...");
                }
                this.resolveEncryptionList(signatureConfirmationArray);
                this.processConfidentiality(this.blueprint.getEncryptionPolicy(), bl);
            }
            if (this.doAction(16)) {
                if (verbose) {
                    Verbose.log("Constructing signature (1)...");
                }
                this.resolveSignatureList(signatureConfirmationArray);
                if (this.blueprint.isX509AuthConditional()) {
                    // empty if block
                }
                this.processIntegrity(this.blueprint.getSigningPolicy(), bl);
            }
            SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, false);
        } else {
            if (this.doAction(16)) {
                if (verbose) {
                    Verbose.log("Constructing signature (2) ...");
                }
                this.resolveSignatureList(signatureConfirmationArray);
                if (this.blueprint.isX509AuthConditional()) {
                    // empty if block
                }
                this.processIntegrity(this.blueprint.getSigningPolicy(), bl);
                if (this.doAction(1024)) {
                    if (verbose) {
                        Verbose.log("Endorsing support token (1) ...");
                    }
                    this.resolveSignatureElementSignatureList(signatureConfirmationArray);
                    this.ctxHandler.addContextElement("weblogic.wsee.security.need_to_move_timestamp", new Boolean(true));
                    this.processIntegrity(this.blueprint.getEndorsingPolicy(), bl);
                    bl2 = true;
                }
            }
            if (this.doAction(8)) {
                if (verbose) {
                    Verbose.log("Constructing encryption (2) ...");
                }
                this.resolveEncryptionList(signatureConfirmationArray);
                this.processConfidentiality(this.blueprint.getEncryptionPolicy(), bl);
            }
        }
        if (!bl2 && this.doAction(1024)) {
            if (verbose) {
                Verbose.log("Endorsing support token (2) ...");
            }
            if (this.isEncryptBeforeSigning()) {
                this.ctxHandler.addContextElement("weblogic.wsee.security.need_to_move_timestamp", new Boolean(true));
            }
            this.resolveSignatureElementSignatureList(signatureConfirmationArray);
            this.processIntegrity(this.blueprint.getEndorsingPolicy(), bl);
        }
    }

    private boolean doAction(int n) {
        int n2 = this.blueprint.getBuildingPlan();
        return (n2 & n) == n;
    }

    private boolean isEncryptBeforeSigning() {
        return this.blueprint.getGeneralPolicy().isEncryptBeforeSigning();
    }

    private void init() throws SecurityPolicyArchitectureException {
        Map map;
        Map map2;
        this.blueprint.verifyPolicy(this.soapMessageCtx);
        this.secBuilder.setLayout(this.blueprint.getGeneralPolicy().getLayout());
        if (this.blueprint.getGeneralPolicy().isWss11()) {
            this.secBuilder.setWSSVersion("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        } else {
            this.secBuilder.setWSSVersion("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        }
        if (this.blueprint.getGeneralPolicy().isRequireSignatureConfirmation()) {
            this.blueprint.getGeneralPolicy().setSignatureValues(this.securityCtx.getPreviousMessageSignatureValues().get(0));
        }
        if (this.blueprint.getGeneralPolicy().hasTrustOptions()) {
            if (this.blueprint.getGeneralPolicy().getTrustOptions().isWst13()) {
                this.ctxHandler.addContextElement("weblogic.wsee.security.trust_version", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            } else if (this.blueprint.getGeneralPolicy().getTrustOptions().isWst10()) {
                this.ctxHandler.addContextElement("weblogic.wsee.security.trust_version", "http://schemas.xmlsoap.org/ws/2005/02/trust");
            } else {
                if (verbose) {
                    Verbose.log("Unsupported Trust version found, set to default Trust version with NS=http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                }
                this.ctxHandler.addContextElement("weblogic.wsee.security.trust_version", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            }
        }
        if ((map2 = this.blueprint.encryptionPolicy.getNodeMap()).containsKey("EncryptSignature") && null != this.blueprint.getEndorsingPolicy() && (map = this.blueprint.getEndorsingPolicy().getSigningNodeMap()) != null && map.containsKey("EndoseSignature")) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.endorse_signature_encrypt_signature", new Boolean(true));
        }
    }

    private void resolveSignatureList(SignatureConfirmation[] signatureConfirmationArray) throws SecurityPolicyException, WSSecurityException {
        SignaturePolicy signaturePolicy = this.blueprint.getSigningPolicy();
        this.resolveSignatureList(signaturePolicy, signatureConfirmationArray);
    }

    private void resolveSignatureList(SignaturePolicy signaturePolicy, SignatureConfirmation[] signatureConfirmationArray) throws SecurityPolicyException, WSSecurityException {
        Map map = signaturePolicy.getSigningNodeMap();
        SOAPMessage sOAPMessage = this.soapMessageCtx.getMessage();
        try {
            Object object;
            Object object2;
            Object object3;
            SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(this.soapMessageCtx);
            if (map.containsKey("Body")) {
                signaturePolicy.addSignatureNode("Body", (Node)sOAPMessage.getSOAPBody());
            }
            if (map.containsKey("UserNameToken")) {
                object3 = sOAPSecurityHeaderHelper.getUsernameTokenElement();
                if (object3 != null) {
                    signaturePolicy.addSignatureNode("UserNameToken", (Node)object3);
                } else if (SecurityImpl.isEncryptBeforeSign(this.ctxHandler) && null != (object2 = (Map)this.ctxHandler.getValue("weblogic.wsee.security.encrypted_element.map")) && (object3 = (Element)object2.get(WSSConstants.UNT_QNAME)) != null) {
                    signaturePolicy.addSignatureNode("UserNameToken", (Node)object3);
                }
            }
            if (map.containsKey("SamlToken")) {
                object3 = sOAPSecurityHeaderHelper.getSaml11Or20TokenElement();
                if (object3 != null) {
                    if (this.blueprint.getGeneralPolicy().isCompatMSFT()) {
                        signaturePolicy.addSignatureNode("SamlToken", (Node)object3);
                    } else {
                        object2 = (SAMLToken)this.securityCtx.getToken((Element)object3);
                        object = this.secBuilder.createSTRReference((weblogic.xml.crypto.wss.provider.SecurityToken)object2, signaturePolicy.getDigestMethod(), null, true);
                        String string = object.getURI();
                        if (string.startsWith("#")) {
                            string = string.substring(1);
                        }
                        SecurityTokenReference securityTokenReference = this.securityCtx.getSTR(string);
                        securityTokenReference.marshal((Element)object3.getParentNode(), object3.getNextSibling(), this.securityCtx.getNamespaces());
                        signaturePolicy.addSignatureReference("SamlToken", (Reference)object);
                    }
                } else if (SecurityImpl.isEncryptBeforeSign(this.ctxHandler) && null != (object2 = (Map)this.ctxHandler.getValue("weblogic.wsee.security.encrypted_element.map"))) {
                    object3 = (Element)object2.get(SAML2Constants.SAML2_ASST_QNAME);
                    if (object3 == null) {
                        object3 = (Element)object2.get(SAMLConstants.SAML_ASST_QNAME);
                    }
                    if (object3 != null) {
                        signaturePolicy.addSignatureNode("SamlToken", (Node)object3);
                    }
                }
            }
            if (map.containsKey("SecureConversationTokenToken")) {
                object2 = sOAPSecurityHeaderHelper.getScToken13Element();
                if (object2 == null) {
                    object2 = sOAPSecurityHeaderHelper.getScTokenElement();
                    object3 = WSCConstants.SCT_QNAME;
                } else {
                    object3 = weblogic.wsee.security.wssc.v13.WSCConstants.SCT_QNAME;
                }
                if (object2 != null) {
                    signaturePolicy.addSignatureNode("SecureConversationTokenToken", (Node)object2);
                } else if (SecurityImpl.isEncryptBeforeSign(this.ctxHandler) && null != (object = (Map)this.ctxHandler.getValue("weblogic.wsee.security.encrypted_element.map")) && (object2 = (Element)object.get(object3)) != null) {
                    signaturePolicy.addSignatureNode("SecureConversationTokenToken", (Node)object2);
                }
            }
            if (map.containsKey("Header") && null == map.get("Header") && null != (object2 = SOAPSecurityHeaderHelper.getNonSecurityElements(sOAPMessage, null)) && object2.size() > 0) {
                signaturePolicy.addSignatureNodeListToReference((List)object2);
            }
            if ((signaturePolicy.isSignatureRequired() || map.containsKey("TimeStamp")) && null != (object2 = sOAPSecurityHeaderHelper.getTimestampElement())) {
                signaturePolicy.addSignatureNode("TimeStamp", (Node)object2);
            }
            if (signaturePolicy.isSignatureRequired() && signatureConfirmationArray != null && signatureConfirmationArray.length > 0) {
                for (int i = 0; i < signatureConfirmationArray.length; ++i) {
                    signaturePolicy.addSignatureNode("Signature" + i, signatureConfirmationArray[i].getSignatureConfirmationNode());
                }
            }
            signaturePolicy.addSignatureNodeListToReference(this.soapMessageCtx);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
        catch (MarshalException marshalException) {
            Verbose.logException(marshalException);
            throw new WSSecurityException(marshalException.getMessage(), marshalException);
        }
    }

    private void resolveEncryptionList(SignatureConfirmation[] signatureConfirmationArray) throws SecurityPolicyException, WSSecurityException {
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        Map map = encryptionPolicy.getNodeMap();
        SOAPMessage sOAPMessage = this.soapMessageCtx.getMessage();
        try {
            Object object;
            SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(this.soapMessageCtx);
            if (map.containsKey("Body")) {
                if (sOAPMessage.getSOAPBody().hasChildNodes()) {
                    encryptionPolicy.addNode("Body", (Node)sOAPMessage.getSOAPBody());
                } else if (verbose) {
                    Verbose.log("No body encryption due to body is empty");
                }
            }
            if (map.containsKey("EncryptSignature")) {
                if ((this.blueprint.getBuildingPlan() & 0x2100) != 8448) {
                    object = sOAPSecurityHeaderHelper.getSignatrueElements();
                    if (null == object || object.size() == 0) {
                        if (this.blueprint.isRequest()) {
                            throw new SecurityPolicyException("Missing signature element for encryption");
                        }
                        if (verbose) {
                            Verbose.log("No no signature requirement on response, no encrypt signature ...");
                        }
                    } else {
                        for (int i = 0; i < object.size(); ++i) {
                            encryptionPolicy.addNode("EncryptSignature" + i, (Node)object.get(i));
                        }
                    }
                }
                if (signatureConfirmationArray != null && signatureConfirmationArray.length > 0) {
                    for (int i = 0; i < signatureConfirmationArray.length; ++i) {
                        Element element = (Element)signatureConfirmationArray[i].getSignatureConfirmationNode();
                        encryptionPolicy.addNode("Signature" + i, element);
                    }
                }
            }
            if (map.containsKey("UserNameToken")) {
                encryptionPolicy.addNode("UserNameToken", sOAPSecurityHeaderHelper.getUsernameTokenElement());
            }
            if (map.containsKey("SamlToken")) {
                object = sOAPSecurityHeaderHelper.getSaml11Or20TokenElement();
                if (null != object) {
                    encryptionPolicy.addNode("SamlToken", (Node)object);
                } else {
                    Verbose.log("Unable to find SAML Token to Encrypt!");
                }
            }
            if (map.containsKey("Header")) {
                // empty if block
            }
            encryptionPolicy.addEncryptionNodeList(this.soapMessageCtx);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
    }

    private void resolveSignatureElementSignatureList(SignatureConfirmation[] signatureConfirmationArray) throws WSSecurityException, SecurityPolicyException {
        SignaturePolicy signaturePolicy = this.blueprint.getEndorsingPolicy();
        if (this.blueprint.hasTransportSecuirity()) {
            if (verbose) {
                Verbose.log("Endorsing supporting token + transport security caes....");
            }
            this.resolveSignatureList(signaturePolicy, signatureConfirmationArray);
        } else {
            Map map = signaturePolicy.getSigningNodeMap();
            try {
                if (map.containsKey("EndoseSignature")) {
                    Serializable serializable;
                    SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(this.soapMessageCtx);
                    Element element = sOAPSecurityHeaderHelper.getSignatrueElement();
                    boolean bl = false;
                    if (element == null && this.isEndosingEncryptSignature()) {
                        element = sOAPSecurityHeaderHelper.getDummyElement("weblogic.wsee.security.signature_node");
                        serializable = new QName(WSUConstants.WSU_URI, "Id", "wsu");
                        DOMUtils.addAttribute(element, serializable, "weblogic.wsee.security.signature_node");
                        bl = true;
                    }
                    if (element == null) {
                        throw new WSSecurityException("Missing signature element for Endorsing");
                    }
                    serializable = new ArrayList<Element>();
                    serializable.add(element);
                    signaturePolicy.setNewSignatureNodeListToReference((List)((Object)serializable));
                    if (bl) {
                        sOAPSecurityHeaderHelper.removeDummyElement(element);
                    }
                }
            }
            catch (Exception exception) {
                Verbose.logException(exception);
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        signaturePolicy.setIncludeSigningTokens(signaturePolicy.signedSecurityTokens());
    }

    private void processMessageAge(TimestampPolicy timestampPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (timestampPolicy.isIncludeTimestamp()) {
            this.doProcessMessageAge(timestampPolicy, bl);
        } else if (verbose) {
            Verbose.log("Timestamp is not required.");
        }
    }

    private void doProcessMessageAge(TimestampPolicy timestampPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        short s = timestampPolicy.getMessageAgeSeconds();
        if (bl) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.timestamp_first", new Boolean(bl).toString());
        }
        if (!this.secBuilder.addTimestamp(s, this.ctxHandler)) {
            throw new WSSecurityException("Unable to add a Timestamp to the message");
        }
        if (verbose) {
            Verbose.log("Added timestamp(maxAgesSecs=" + s + ")...");
        }
    }

    private void addEndorseToken(SignaturePolicy signaturePolicy, SignaturePolicy signaturePolicy2) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (!signaturePolicy.isSignatureRequired()) {
            if (verbose) {
                Verbose.log("No need to add support token reference.");
            }
            return;
        }
        this.doAddEndorseToken(signaturePolicy, signaturePolicy2);
    }

    private void doAddEndorseToken(SignaturePolicy signaturePolicy, SignaturePolicy signaturePolicy2) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        List list = signaturePolicy.getValidSignatureTokens();
        boolean bl = false;
        for (SecurityToken securityToken : list) {
            XMLStructure xMLStructure;
            this.setTokenIssuer(securityToken);
            if (securityToken.getDerivedFromTokenType() != null) {
                this.addDerivedFromToken(securityToken, true);
                xMLStructure = (weblogic.xml.crypto.wss.provider.SecurityToken)this.ctxHandler.getValue("weblogic.wsee.wsc.derived_from_token");
            }
            if (null != (xMLStructure = this.newSigningTokenReference(securityToken, this.ctxHandler, signaturePolicy2.getDigestMethod().getAlgorithm()))) {
                ArrayList<Reference> arrayList = new ArrayList<Reference>();
                arrayList.add((Reference)xMLStructure);
                signaturePolicy2.addReferences(arrayList);
                continue;
            }
            throw new WSSecurityException("Unable to add token " + securityToken.getTokenTypeUri() + " DK token type " + securityToken.getDerivedFromTokenType());
        }
    }

    private void processIdentity(IdentityPolicy identityPolicy) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (!identityPolicy.isAuthenticationRequired()) {
            if (verbose) {
                Verbose.log("Identity is not required.");
            }
            return;
        }
        this.doProcessIdentity(identityPolicy);
    }

    private void doProcessIdentity(IdentityPolicy identityPolicy) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        String string = null;
        List list = identityPolicy.getValidIdentityTokens();
        if (verbose) {
            Verbose.log("There are " + list.size() + " valid identity tokens");
        }
        boolean bl = false;
        for (SecurityToken securityToken : list) {
            if (securityToken.isOptional() && !this.secBuilder.isCredentialAvailable(securityToken.getTokenTypeUri())) {
                Verbose.log("Skip the optional token due to its availability, token = " + securityToken + " type =" + securityToken.getTokenTypeUri());
                bl = true;
                continue;
            }
            this.setTokenIssuer(securityToken);
            this.addClaimsToContextHandler(securityToken.getClaims());
            string = securityToken.getTokenTypeUri();
            if ("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(string) || "http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(string)) {
                string = securityToken.getDerivedFromTokenType();
            }
            if (TokenTypeHelper.isSamlValueType(string) && this.isSamlAttributeOnly()) {
                if (verbose) {
                    Verbose.log("Requesting a SAML Token with SAML Attributes only");
                }
                this.ctxHandler.addContextElement("oracle.contextelement.saml2.AttributeOnly", "True");
            }
            if (this.secBuilder.addSecurityToken(string, securityToken.getIssuerName(), Purpose.IDENTITY, this.ctxHandler) == null) {
                if (verbose) {
                    Verbose.log("Failed to add token: " + securityToken + " TokenUri =" + string);
                }
                if (!string.endsWith("/sc/sct")) continue;
                string = string + " SCT for authentication is not supported";
                break;
            }
            if (verbose) {
                Verbose.log("Added " + securityToken + " for identity");
            }
            bl = true;
            this.blueprint.setPolicyIdToken(securityToken);
            break;
        }
        if (!bl) {
            throw new WSSecurityException("Unable to add security token for identity, token uri =" + string);
        }
    }

    private void processIntegrity(SignaturePolicy signaturePolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (!signaturePolicy.isSignatureRequired()) {
            if (verbose) {
                Verbose.log("Signature is not required.");
            }
            return;
        }
        this.doProcessIntegrity(signaturePolicy, bl);
    }

    private void doProcessIntegrity(SignaturePolicy signaturePolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        SignedInfo signedInfo = signaturePolicy.getSignedInfo();
        List list = signaturePolicy.getValidSignatureTokens();
        if (verbose) {
            Verbose.log("There are " + list.size() + " signing tokens");
        }
        if (verbose) {
            Verbose.log("SignedInfo is: " + signedInfo);
        }
        Node node = null;
        boolean bl2 = signaturePolicy.signedSecurityTokens();
        for (SecurityToken securityToken : list) {
            if (verbose) {
                Verbose.log("SecurityToken: " + securityToken.toString());
            }
            this.setTokenIssuer(securityToken);
            this.addClaimsToContextHandler(securityToken.getClaims());
            this.addDerivedFromToken(securityToken, bl);
            if (bl2) {
                Reference reference = this.newSigningTokenReference(securityToken, this.ctxHandler, signaturePolicy.getDigestMethod().getAlgorithm());
                if (reference == null) continue;
                if (verbose) {
                    Verbose.log("Attempting signature on token");
                }
                node = this.secBuilder.addSignature(signaturePolicy.newSignedInfo(reference), reference, securityToken.getStrTypes(), this.ctxHandler);
            } else {
                if (verbose) {
                    Verbose.log("Attempting signature on message");
                }
                node = this.secBuilder.addSignature(signedInfo, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.isIncludeInMessage(), (ContextHandler)this.ctxHandler);
            }
            if (node == null) continue;
            if (!verbose) break;
            Verbose.log("Added Signature using " + securityToken);
            break;
        }
        if (node == null) {
            throw new WSSecurityException("Failed to add Signature.");
        }
    }

    private Reference newSigningTokenReference(SecurityToken securityToken, ContextHandler contextHandler, String string) throws WSSecurityException {
        Reference reference = null;
        XMLSignatureFactory xMLSignatureFactory = this.secBuilder.getXMLSignatureFactory();
        try {
            this.setTokenIssuer(securityToken);
            reference = this.secBuilder.createReference(securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), xMLSignatureFactory.newDigestMethod(string, null), new ArrayList(), securityToken.isIncludeInMessage(), contextHandler);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WSSecurityException(noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new WSSecurityException(invalidAlgorithmParameterException);
        }
        return reference;
    }

    private void processIntegrityAndConfidentiality(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        if (!encryptionPolicy.isEncryptionRequired() && !signaturePolicy.isSignatureRequired() && verbose) {
            Verbose.log("Neither Encryption nor Signature is required.");
        }
        this.doProcessIntegrityAndConfidentiality(signaturePolicy, encryptionPolicy, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doProcessIntegrityAndConfidentiality(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        Object object;
        List list = null;
        SignedInfo signedInfo = null;
        ArrayList arrayList = null;
        EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
        EncryptionMethod encryptionMethod2 = encryptionPolicy.getEncryptionMethod();
        List<EncryptionTarget> list2 = encryptionPolicy.getEncryptionTargets();
        if (!encryptionPolicy.isEncryptionRequired()) {
            signedInfo = signaturePolicy.getSignedInfo();
            list = signaturePolicy.getValidSignatureTokens();
            if (bl) {
                SecurityToken securityToken = (SecurityToken)list.get(0);
                this.setTokenIssuer(securityToken);
                this.secBuilder.addSignature(signedInfo, encryptionMethod, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.isIncludeInMessage(), this.ctxHandler);
                return;
            } else {
                this.secBuilder.addSignature(signedInfo, this.ctxHandler);
            }
            return;
        }
        list2 = encryptionPolicy.getEncryptionTargets();
        list = encryptionPolicy.getValidEncryptionTokens();
        if (null == list2) {
            if (verbose) {
                Verbose.log("There is no encryption target.");
            }
        } else {
            arrayList = new ArrayList();
            for (EncryptionTarget encryptionTarget : list2) {
                arrayList.addAll(encryptionTarget.getTBEs());
            }
        }
        if (signaturePolicy.isSignatureRequired()) {
            signedInfo = signaturePolicy.getSignedInfo();
            if (null == list) {
                list = signaturePolicy.getValidSignatureTokens();
            }
        } else {
            if (bl) {
                object = (SecurityToken)list.get(0);
                this.setTokenIssuer((SecurityToken)object);
                boolean bl2 = this.secBuilder.addEncryption(arrayList, encryptionMethod, encryptionMethod2, ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), this.ctxHandler);
                if (!bl2) throw new WSSecurityException("Failed to add Encryption.");
                if (!verbose) return;
                Verbose.log("Encryption is done.");
                return;
            } else {
                this.secBuilder.addEncryption(arrayList, encryptionMethod2, this.ctxHandler);
            }
            return;
        }
        if (bl) {
            object = (SecurityToken)list.get(0);
            this.setTokenIssuer((SecurityToken)object);
            this.secBuilder.addSignatureAndEncryption(signedInfo, arrayList, encryptionMethod, encryptionMethod2, ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), this.ctxHandler);
        } else {
            this.secBuilder.addSignatureAndEncryption(signedInfo, arrayList, encryptionMethod2, this.ctxHandler);
        }
        if (!verbose) return;
        Verbose.log("Signature and Encryption is done.");
    }

    private void processConfidentiality(EncryptionPolicy encryptionPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        if (!encryptionPolicy.isEncryptionRequired()) {
            if (verbose) {
                Verbose.log("Encryption is not required.");
            }
            return;
        }
        this.doProcessConfidentiality(encryptionPolicy, bl);
    }

    private void doProcessConfidentiality(EncryptionPolicy encryptionPolicy, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        List list = encryptionPolicy.getValidEncryptionTokens();
        List<EncryptionTarget> list2 = encryptionPolicy.getEncryptionTargets();
        EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
        for (EncryptionTarget encryptionTarget : list2) {
            EncryptionMethod encryptionMethod2 = null != encryptionTarget.getEncryptionMethod() ? encryptionTarget.getEncryptionMethod() : encryptionPolicy.getEncryptionMethod();
            boolean bl2 = false;
            for (SecurityToken securityToken : list) {
                this.setTokenIssuer(securityToken);
                this.addClaimsToContextHandler(securityToken.getClaims());
                this.addDerivedFromToken(securityToken, bl);
                bl2 = this.secBuilder.addEncryption(encryptionTarget.getTBEs(), encryptionMethod, encryptionMethod2, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.isIncludeInMessage(), this.ctxHandler);
                if (!bl2) continue;
                if (!verbose) break;
                Verbose.log("Encryption is done.");
                break;
            }
            if (bl2) continue;
            throw new WSSecurityException("Failed to add Encryption.");
        }
    }

    private SignatureConfirmation[] processSignatureConfirmation(GeneralPolicy generalPolicy) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        return this.doProcessSignatureConfirmation(generalPolicy);
    }

    private SignatureConfirmation[] doProcessSignatureConfirmation(GeneralPolicy generalPolicy) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        return this.secBuilder.addSignatureConfirmation(generalPolicy.getSignatureValues(), this.ctxHandler);
    }

    private void addClaimsToContextHandler(Node node) {
        if (verbose) {
            Verbose.log("Adding claims map to context: " + (node == null ? null : node.getLocalName()));
        }
        this.ctxHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", node);
    }

    private void addDerivedFromToken(SecurityToken securityToken, boolean bl) throws weblogic.xml.crypto.api.MarshalException, WSSecurityException {
        this.doAddDerivedFromToken(securityToken, bl);
    }

    private void doAddDerivedFromToken(SecurityToken securityToken, boolean bl) throws weblogic.xml.crypto.api.MarshalException, WSSecurityException {
        String string = securityToken.getDerivedFromTokenType();
        if (verbose) {
            Verbose.log("TokenTypeUri is: " + securityToken.getTokenTypeUri());
        }
        if (verbose) {
            Verbose.log("DerivedFrom token type is: " + string);
        }
        this.setTokenIssuer(securityToken);
        this.setBootstrapPolicy(securityToken);
        if (string != null) {
            weblogic.xml.crypto.wss.provider.SecurityToken securityToken2;
            EncryptionMethod encryptionMethod;
            EncryptionMethod encryptionMethod2;
            Object object = this.ctxHandler.getValue("weblogic.wsee.wsc.derived_from_token");
            if (object != null) {
                if (!SAMLUtils.isSamlTokenType(string) && object instanceof SAMLToken) {
                    if (verbose) {
                        Verbose.log("Wrong DerivedFromToken for derivedFromTokenType =" + string + " reset the token");
                    }
                    object = null;
                } else if (SAMLUtils.isSamlTokenType(string) && object instanceof EncryptedKeyToken && bl) {
                    if (verbose) {
                        Verbose.log("Building DerivedFromToken for derivedFromTokenType =" + string);
                    }
                    encryptionMethod2 = securityToken.getEncryptionMethod();
                    if (verbose) {
                        Verbose.log("EncryptionMethod is: " + encryptionMethod2);
                    }
                    if (encryptionMethod2 != null) {
                        this.ctxHandler.addContextElement("weblogic.wsee.ek.encrypt_method", encryptionMethod2);
                    }
                    if ((encryptionMethod = securityToken.getKeyWrapMethod()) != null) {
                        this.ctxHandler.addContextElement("weblogic.wsee.ek.keywrap_method", encryptionMethod);
                    }
                    if (null == (securityToken2 = this.getDkBaseToken(securityToken, string))) {
                        throw new WSSecurityException("Unable to create DK base token of type =" + string + " For Sign");
                    }
                    this.ctxHandler.addContextElement("weblogic.wsee.wsc.derived_from_token", securityToken2);
                }
            }
            if (object == null) {
                if (verbose) {
                    Verbose.log("DerivedFromToken is: " + object);
                }
                encryptionMethod2 = securityToken.getEncryptionMethod();
                if (verbose) {
                    Verbose.log("EncryptionMethod is: " + encryptionMethod2);
                }
                if (encryptionMethod2 != null) {
                    if (!bl) {
                        this.ctxHandler.addContextElement("weblogic.wsee.wsc.derived_from_token", SecurityTokenHelper.findSecurityTokenInContext(this.ctxHandler, securityToken.getDerivedFromTokenType()));
                        this.ctxHandler.addContextElement("weblogic.wsee.dk.referece_type", WSSConstants.KEY_IDENTIFIER_QNAME);
                        return;
                    }
                    this.ctxHandler.addContextElement("weblogic.wsee.ek.encrypt_method", encryptionMethod2);
                }
                if ((encryptionMethod = securityToken.getKeyWrapMethod()) != null) {
                    this.ctxHandler.addContextElement("weblogic.wsee.ek.keywrap_method", encryptionMethod);
                }
                if (null == (securityToken2 = this.getDkBaseToken(securityToken, string))) {
                    throw new WSSecurityException("Unable to create DK base token of type =" + string + " For Sign");
                }
                this.ctxHandler.addContextElement("weblogic.wsee.wsc.derived_from_token", securityToken2);
            }
        }
    }

    private weblogic.xml.crypto.wss.provider.SecurityToken getDkBaseToken(SecurityToken securityToken, String string) throws weblogic.xml.crypto.api.MarshalException, WSSecurityException {
        weblogic.xml.crypto.wss.provider.SecurityToken securityToken2 = null;
        if (securityToken.isIncludeDerivedFromInMessage()) {
            if (verbose) {
                Verbose.log("------ per Policy including Derived From SC Token in message  ----");
            }
            this.ctxHandler.addContextElement("weblogic.wsee.security.move_node_to_top", "true");
            if (securityToken.getStrTypesForDKBaseToken() != null && securityToken.getStrTypesForDKBaseToken().size() > 0) {
                this.ctxHandler.addContextElement("weblogic.wsee.dk.base_token_referece_type", securityToken.getStrTypesForDKBaseToken().get(0));
            }
            securityToken2 = this.secBuilder.addSecurityToken(string, null, Purpose.SIGN, this.ctxHandler);
            this.ctxHandler.addContextElement("weblogic.wsee.dk.base_token_referece_type", null);
            this.ctxHandler.addContextElement("weblogic.wsee.security.move_node_to_top", "false");
        } else {
            if (verbose) {
                Verbose.log("----- per Policy NOT including Derived From SC Token in message -----");
            }
            securityToken2 = this.secBuilder.createSecurityToken(string, null, Purpose.SIGN, this.ctxHandler);
        }
        return securityToken2;
    }

    private void setBootstrapPolicy(SecurityToken securityToken) {
        NormalizedExpression normalizedExpression = securityToken.getBootstrapPolicy();
        if (normalizedExpression != null) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.wst_bootstrap_policy", normalizedExpression);
        }
        HashSet<PolicyAlternative> hashSet = new HashSet<PolicyAlternative>();
        hashSet.add(this.blueprint.getPolicyAlternative());
        NormalizedExpression normalizedExpression2 = NormalizedExpression.createFromPolicyAlternatives(hashSet);
        this.ctxHandler.addContextElement("weblogic.wsee.security.wst_outer_policy", normalizedExpression2);
    }

    private void setTokenIssuer(SecurityToken securityToken) {
        if (verbose) {
            Verbose.log("Setting token issuer for token " + securityToken.toString() + " to " + securityToken.getTokenIssuer());
        }
        if (securityToken.getTokenIssuer() == null) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.issuer_endpoint_ref", null);
        } else {
            this.ctxHandler.addContextElement("weblogic.wsee.security.issuer_endpoint_ref", securityToken.getTokenIssuer());
        }
    }

    private boolean isWssc13() {
        return this.blueprint.getGeneralPolicy().isWssc13();
    }

    private boolean isEndosingEncryptSignature() {
        Boolean bl = (Boolean)this.ctxHandler.getValue("weblogic.wsee.security.endorse_signature_encrypt_signature");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private void processIntegrityAndConfidentialityAndEndorsing(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, SignaturePolicy signaturePolicy2, int n, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        if (!encryptionPolicy.isEncryptionRequired() && !signaturePolicy.isSignatureRequired() && verbose) {
            Verbose.log("Neither Encryption nor Signature is required.");
        }
        this.doProcessIntegrityAndConfidentialityAndEndorsing(signaturePolicy, encryptionPolicy, signaturePolicy2, n, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doProcessIntegrityAndConfidentialityAndEndorsing(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, SignaturePolicy signaturePolicy2, int n, boolean bl) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        Object object;
        boolean bl2;
        boolean bl3 = (n & 0x400) == 1024;
        boolean bl4 = (n & 0x200) == 512;
        boolean bl5 = (n & 0x2000) == 8192;
        boolean bl6 = bl2 = (n & 0x1000) == 4096;
        if (bl && bl3 && (signaturePolicy2.getValidSignatureTokens() == null || signaturePolicy2.getValidSignatureTokens().size() == 0)) {
            throw new IllegalArgumentException("No endorsing token");
        }
        List list = null;
        SignedInfo signedInfo = null;
        ArrayList arrayList = null;
        EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
        EncryptionMethod encryptionMethod2 = encryptionPolicy.getEncryptionMethod();
        List<EncryptionTarget> list2 = encryptionPolicy.getEncryptionTargets();
        if (!encryptionPolicy.isEncryptionRequired()) {
            signedInfo = signaturePolicy.getSignedInfo();
            list = signaturePolicy.getValidSignatureTokens();
            if (bl) {
                SecurityToken securityToken = (SecurityToken)list.get(0);
                this.setTokenIssuer(securityToken);
                this.secBuilder.addSignature(signedInfo, encryptionMethod, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.isIncludeInMessage(), this.ctxHandler);
                return;
            } else {
                this.secBuilder.addSignature(signedInfo, this.ctxHandler);
            }
            return;
        }
        list2 = encryptionPolicy.getEncryptionTargets();
        list = encryptionPolicy.getValidEncryptionTokens();
        if (null == list2) {
            if (verbose) {
                Verbose.log("There is no encryption target.");
            }
        } else {
            arrayList = new ArrayList();
            for (EncryptionTarget encryptionTarget : list2) {
                arrayList.addAll(encryptionTarget.getTBEs());
            }
        }
        if (signaturePolicy.isSignatureRequired()) {
            signedInfo = signaturePolicy.getSignedInfo();
            if (null == list) {
                list = signaturePolicy.getValidSignatureTokens();
            }
        } else {
            if (bl) {
                object = (SecurityToken)list.get(0);
                this.setTokenIssuer((SecurityToken)object);
                boolean bl7 = this.secBuilder.addEncryption(arrayList, encryptionMethod, encryptionMethod2, ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), this.ctxHandler);
                if (!bl7) throw new WSSecurityException("Failed to add Encryption.");
                if (!verbose) return;
                Verbose.log("Encryption is done.");
                return;
            } else {
                this.secBuilder.addEncryption(arrayList, encryptionMethod2, this.ctxHandler);
            }
            return;
        }
        if (bl) {
            object = (SecurityToken)list.get(0);
            if (bl4) {
                this.addClaimsToContextHandler(((SecurityToken)object).getClaims());
                this.addDerivedFromToken((SecurityToken)object, bl);
            }
            this.setTokenIssuer((SecurityToken)object);
            if (bl3) {
                SecurityToken securityToken = (SecurityToken)signaturePolicy2.getValidSignatureTokens().get(0);
                this.secBuilder.addSignatureAndEncryptionAndEndorsing(signedInfo, arrayList, encryptionMethod, encryptionMethod2, ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), n, signaturePolicy2.getSignedInfo(), securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.isIncludeInMessage(), this.ctxHandler);
            } else {
                this.secBuilder.addSignatureAndEncryptionAndEndorsing(signedInfo, arrayList, encryptionMethod, encryptionMethod2, ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), n, null, null, null, null, false, this.ctxHandler);
            }
        } else if (bl3 && signaturePolicy2.getValidSignatureTokens() != null && signaturePolicy2.getValidSignatureTokens().size() > 0) {
            object = (SecurityToken)signaturePolicy2.getValidSignatureTokens().get(0);
            this.secBuilder.addSignatureAndEncryptionAndEndorsing(signedInfo, arrayList, encryptionMethod2, n, signaturePolicy2.getSignedInfo(), ((SecurityToken)object).getTokenTypeUri(), ((SecurityToken)object).getStrTypes(), ((SecurityToken)object).getIssuerName(), ((SecurityToken)object).isIncludeInMessage(), this.ctxHandler);
        } else {
            this.secBuilder.addSignatureAndEncryptionAndEndorsing(signedInfo, arrayList, encryptionMethod2, n, null, null, null, null, false, this.ctxHandler);
        }
        if (!verbose) return;
        Verbose.log("Signature and Encryption is done.");
    }

    protected boolean isSamlAttributeOnly() {
        Object object = this.soapMessageCtx.getProperty("oracle.contextelement.saml2.AttributeOnly");
        if (null == object) {
            return false;
        }
        if (verbose) {
            Verbose.log("Property oracle.contextelement.saml2.AttributeOnly = " + object.toString());
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        return false;
    }
}

