/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutlineSketcher;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.IdentityPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.TimestampPolicy;
import weblogic.wsee.security.wss.sps.SmartSecurityPolicyBlueprint;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.XMLSignatureImpl;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.SecurityValidatorFactory;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class SecurityMessageInspector {
    private static final boolean verbose = Verbose.isVerbose(SecurityMessageInspector.class);
    private static final boolean debug = false;
    private static final boolean WS_POLICY_INTEROP = true;
    private static final boolean DEBUG_DUMP_SOAP = false;
    private SecurityTokenContextHandler ctxHandler;
    private SecurityPolicyBlueprint blueprint;
    private SOAPMessageContext soapMessageCtx;
    private WSS11Context securityCtx;
    private SecurityValidator svalidator;
    private Map<String, SecurityToken> validatedTokenMap = new HashMap<String, SecurityToken>();
    private static final String COMPAT_FLAG_3006 = "Bypass.3006.error";

    public SecurityMessageInspector(SOAPMessageContext sOAPMessageContext, WSS11Context wSS11Context) {
        this.soapMessageCtx = sOAPMessageContext;
        this.securityCtx = wSS11Context;
        this.ctxHandler = new SecurityTokenContextHandler(wSS11Context);
        new SecurityValidatorFactory();
        this.svalidator = SecurityValidatorFactory.getSecurityValidator(wSS11Context);
    }

    public void inspectWssMessage(SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint, boolean bl) throws SecurityPolicyInspectionException, SecurityPolicyArchitectureException, WSSecurityException {
        this.blueprint = smartSecurityPolicyBlueprint.getSecurityPolicyBlueprint();
        this.init();
        this.checkMessage(bl);
        if (verbose) {
            Verbose.log("SOAP Security Message has been verified");
        }
    }

    private static boolean isTransportSecure(SOAPMessageContext sOAPMessageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        boolean bl = true;
        if (null != wlMessageContext) {
            Object object = wlMessageContext.getProperty("weblogic.wsee.transport.servlet.request.secure");
            if (object != null) {
                bl = (Boolean)object;
                if (verbose) {
                    Verbose.say("The massage protected by HTTPS is " + bl);
                }
            }
        } else {
            Verbose.say("Unable to determine it is from HTTPS or not");
        }
        return bl;
    }

    private static boolean hasClientCert(SOAPMessageContext sOAPMessageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        boolean bl = true;
        if (null != wlMessageContext) {
            Object object = wlMessageContext.getProperty("weblogic.wsee.transport.client.cert.required");
            if (object != null) {
                bl = (Boolean)object;
                if (verbose) {
                    Verbose.say("The client cert present " + bl);
                }
            }
        } else {
            Verbose.say("Unable to determine it has client cert or not");
        }
        return bl;
    }

    private void checkMessage(boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException, SecurityPolicyInspectionException {
        Map map;
        boolean bl2 = this.blueprint.isRequest();
        if (this.blueprint.hasTransportSecuirity() && bl2) {
            if (!SecurityMessageInspector.isTransportSecure(this.soapMessageCtx)) {
                Verbose.banner("*** Security Warning ***");
                Verbose.say("The policy requires transport security, but the message does not come from HTTPs");
                System.err.println("*** Security Warning ***\n The message is NOT protected by HTTPS");
                throw new SecurityPolicyInspectionException(2681);
            }
            if (this.blueprint.getGenrealPolicy().isClientCertificateRequired() && !SecurityMessageInspector.hasClientCert(this.soapMessageCtx)) {
                Verbose.banner("*** Security Warning ***");
                Verbose.say("The policy requires client cert on two-way SSL, but the message does not come from two-way SSL");
                System.err.println("*** Security Warning ***\n The message is NOT protected by TWO-WAY SSL");
                throw new SecurityPolicyInspectionException(2641);
            }
        }
        SignatureConfirmation[] signatureConfirmationArray = null;
        if (this.doAction(2)) {
            if (verbose) {
                Verbose.log("Inspecting message age ...");
            }
            if (bl) {
                this.inspectMessageAge(this.blueprint.getTimestampPolicy());
            }
        }
        if (this.doAction(1)) {
            if (verbose) {
                Verbose.log("Inspecting message authentication identity ...");
            }
            this.inspectIdentity(this.blueprint.getIdentityPolicy());
        }
        if (this.doAction(128)) {
            if (verbose) {
                Verbose.log("Inspecting signature confirmation ...");
            }
            signatureConfirmationArray = this.inspectSignatureConfirmation(this.blueprint.getGeneralPolicy().isRequireSignatureConfirmation(), this.blueprint.getGeneralPolicy().isOptionalSignatureConfirmation());
        } else {
            signatureConfirmationArray = this.inspectSignatureConfirmation(false, this.blueprint.getGeneralPolicy().isOptionalSignatureConfirmation());
        }
        if (this.doAction(4)) {
            if (verbose) {
                Verbose.log("Adding toekns to the message ...");
            }
            this.inspectEndorseToken(this.blueprint.getEndorsingPolicy(), this.blueprint.getSigningPolicy());
        }
        if (this.doAction(8192) && (map = this.blueprint.getEncryptionPolicy().getNodeMap()).size() == 1 && map.containsKey("EncryptSignature")) {
            map.remove("EncryptSignature");
        }
        if (this.doAction(256)) {
            boolean bl3 = false;
            if (this.doAction(288)) {
                bl3 = true;
            }
            if (verbose) {
                Verbose.log("Inspecting signature and encryption ..., request =" + bl2);
            }
            this.resolveSignatureList(false);
            this.resolveEncryptionList(signatureConfirmationArray);
            this.inspectIntegrityAndConfidentiality(this.blueprint.getSigningPolicy(), this.blueprint.getEncryptionPolicy(), bl3, this.blueprint.getGeneralPolicy().isEncryptBeforeSigning());
        } else if (this.blueprint.getGeneralPolicy().isEncryptBeforeSigning()) {
            SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, true);
            if (this.doAction(8)) {
                if (verbose) {
                    Verbose.log("Inspecting encryption  ...");
                }
                this.resolveEncryptionList(signatureConfirmationArray);
                this.inspectConfidentiality(this.blueprint.getEncryptionPolicy(), bl2, true);
            }
            if (this.doAction(16)) {
                if (verbose) {
                    Verbose.log("Inspecting signature ...");
                }
                this.resolveSignatureList(true);
                if (this.blueprint.isX509AuthConditional()) {
                    // empty if block
                }
                this.inspectIntegrity(this.blueprint.getSigningPolicy(), bl2);
            }
            SecurityBuilderImpl.setEncryptBeforeSign(this.ctxHandler, false);
        } else {
            if (this.doAction(16)) {
                if (verbose) {
                    Verbose.log("Inspecting signature ...");
                }
                this.resolveSignatureList(false);
                if (this.blueprint.isX509AuthConditional()) {
                    // empty if block
                }
                this.inspectIntegrity(this.blueprint.getSigningPolicy(), bl2);
            }
            if (this.doAction(8)) {
                if (verbose) {
                    Verbose.log("Inspecting encryption  ...");
                }
                if (this.blueprint.getEncryptionPolicy().getNodeMap().containsKey("EncryptSignature") && !this.blueprint.getSigningPolicy().isSignatureRequired()) {
                    this.blueprint.getEncryptionPolicy().getNodeMap().remove("EncryptSignature");
                }
                this.resolveEncryptionList(signatureConfirmationArray);
                this.inspectConfidentiality(this.blueprint.getEncryptionPolicy(), bl2, false);
            }
        }
        if (this.doAction(1024)) {
            Iterator iterator;
            if (verbose) {
                Verbose.log("Endorsing support token  ...");
            }
            this.resolveSignatureElementSignatureList();
            if ((this.blueprint.getGeneralPolicy().hasTrustOptions() || this.blueprint.getGeneralPolicy().isCompatMSFT()) && this.blueprint.getEndorsingPolicy().getValidSignatureTokens() != null && (iterator = this.blueprint.getEndorsingPolicy().getValidSignatureTokens().iterator()) != null && iterator.hasNext()) {
                SecurityToken securityToken = (SecurityToken)iterator.next();
                List list = securityToken.getStrTypes();
                list.add(new STRType(WSSConstants.REFERENCE_QNAME));
            }
            this.inspectIntegrity(this.blueprint.getEndorsingPolicy(), bl2);
        }
    }

    private boolean doAction(int n) {
        int n2 = this.blueprint.getBuildingPlan();
        return (n2 & n) == n;
    }

    private void init() throws SecurityPolicyArchitectureException {
        this.blueprint.verifyPolicy(this.soapMessageCtx);
    }

    private void resolveSignatureList(boolean bl) throws SecurityPolicyInspectionException, WSSecurityException {
        SignaturePolicy signaturePolicy = this.blueprint.getSigningPolicy();
        Map map = signaturePolicy.getSigningNodeMap();
        SOAPMessage sOAPMessage = this.soapMessageCtx.getMessage();
        try {
            Object object;
            SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(this.soapMessageCtx);
            if (map.containsKey("Body")) {
                signaturePolicy.addSignatureNode("Body", (Node)sOAPMessage.getSOAPBody());
            }
            if (map.containsKey("UserNameToken")) {
                this.addReferenceByTokenValueType(signaturePolicy, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", bl);
            }
            if (map.containsKey("SamlToken")) {
                object = this.blueprint.getIdentityPolicy().getValidIdentityTokens();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SecurityToken securityToken = (SecurityToken)iterator.next();
                    String string = securityToken.getTokenTypeUri();
                    boolean bl2 = this.isSamlTokenType(string);
                    if (!bl2) continue;
                    this.addReferenceByTokenValueType(signaturePolicy, string, bl);
                    break;
                }
            }
            if (map.containsKey("SamlToken")) {
                object = null;
            }
            if (!map.containsKey("Header") || null == map.get("Header")) {
                // empty if block
            }
            if (signaturePolicy.isSignatureRequired() && null != (object = sOAPSecurityHeaderHelper.getTimestampElement())) {
                signaturePolicy.addSignatureNode("TimeStamp", (Node)object);
            }
            signaturePolicy.addSignatureNodeListToReference(this.soapMessageCtx);
        }
        catch (SecurityPolicyArchitectureException securityPolicyArchitectureException) {
            Verbose.logException(securityPolicyArchitectureException);
            throw new WSSecurityException(securityPolicyArchitectureException.getMessage(), securityPolicyArchitectureException);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
    }

    private void addReferenceByTokenValueType(SignaturePolicy signaturePolicy, String string, boolean bl) throws WSSecurityException {
        SecurityToken securityToken = this.validatedTokenMap.get(string);
        if (null == securityToken) {
            throw new SecurityPolicyInspectionException(1601);
        }
        this.addReferenceByTokenValueType(signaturePolicy, string, securityToken, bl);
    }

    private boolean isSamlTokenType(String string) {
        if (null == string) {
            return false;
        }
        return string.startsWith("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile") || string.startsWith("http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile");
    }

    private void addReferenceByTokenValueType(SignaturePolicy signaturePolicy, String string, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        Object object;
        boolean bl2;
        weblogic.xml.crypto.wss.provider.SecurityToken securityToken2 = null;
        List list = this.securityCtx.getSecurityTokens(string);
        if ((null == list || list.size() == 0) && (bl2 = this.isSamlTokenType(string))) {
            object = string;
            if (!string.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
                object = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            }
            list = this.securityCtx.getSecurityTokens((String)object);
        }
        if (null == list || list.size() == 0) {
            throw new SecurityPolicyInspectionException(3601);
        }
        Object object2 = list.iterator();
        while (object2.hasNext() && null == (object = this.securityCtx.getNode(securityToken2 = (weblogic.xml.crypto.wss.provider.SecurityToken)object2.next()))) {
        }
        if (null == securityToken2) {
            throw new SecurityPolicyInspectionException(3601);
        }
        try {
            Object object3;
            object2 = null;
            object = null;
            if (bl && null != (object3 = (Map)this.ctxHandler.getValue("weblogic.wsee.security.encrypted_element.map"))) {
                QName qName = null;
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(string)) {
                    qName = WSSConstants.UNT_QNAME;
                }
                object = (String)object3.get(qName);
            }
            object2 = object != null ? this.svalidator.getReference((String)object, this.blueprint.getXmlSignatureFactory().newDigestMethod(signaturePolicy.getDigestMethod().getAlgorithm(), null), new ArrayList(), securityToken.isIncludeInMessage()) : this.svalidator.getReference(securityToken2, this.blueprint.getXmlSignatureFactory().newDigestMethod(signaturePolicy.getDigestMethod().getAlgorithm(), null), new ArrayList(), securityToken.isIncludeInMessage());
            object3 = new ArrayList(1);
            object3.add(object2);
            signaturePolicy.addReferences((List)object3);
        }
        catch (Exception exception) {
            throw new SecurityPolicyInspectionException(3603);
        }
    }

    private void resolveEncryptionList(SignatureConfirmation[] signatureConfirmationArray) throws SecurityPolicyInspectionException, SecurityPolicyArchitectureException, WSSecurityException {
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        Map map = encryptionPolicy.getNodeMap();
        SOAPMessage sOAPMessage = this.soapMessageCtx.getMessage();
        try {
            Object object;
            Object object2;
            Object object3;
            SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(this.soapMessageCtx);
            if (map.containsKey("Body")) {
                if (sOAPMessage.getSOAPBody().hasChildNodes()) {
                    encryptionPolicy.addNode("Body", (Node)sOAPMessage.getSOAPBody());
                } else if (verbose) {
                    Verbose.log("No body encryption due to body is empty");
                }
            }
            if (map.containsKey("EncryptSignature")) {
                object3 = this.securityCtx.getSignatures();
                if (null == object3 || object3.size() == 0) {
                    throw new SecurityPolicyInspectionException(3001);
                }
                object2 = (XMLSignatureImpl)object3.get(0);
                object = ((XMLSignatureImpl)object2).getSignatureNode();
                encryptionPolicy.addNode("EncryptSignature", (Node)object);
                if (signatureConfirmationArray != null && signatureConfirmationArray.length > 0) {
                    for (int i = 0; i < signatureConfirmationArray.length; ++i) {
                        Element element = (Element)signatureConfirmationArray[i].getSignatureConfirmationNode();
                        encryptionPolicy.addNode("Signature" + i, element);
                    }
                }
            }
            if (map.containsKey("UserNameToken")) {
                object3 = this.getNodeByTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                if (null == object3) {
                    throw new SecurityPolicyInspectionException(4621);
                }
                encryptionPolicy.addNode("UserNameToken", (Node)object3);
            }
            if (map.containsKey("SamlToken")) {
                object3 = this.getValidatedSamlTokenTypeUri();
                if (null == object3) {
                    throw new SecurityPolicyInspectionException(4661);
                }
                object2 = this.getNodeByTokenValueType((String)object3);
                if (null == object2) {
                    object = object3;
                    if (!((String)object3).equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
                        object = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
                    }
                    object2 = this.getNodeByTokenValueType((String)object);
                }
                if (null == object2) {
                    throw new SecurityPolicyInspectionException(4661);
                }
                encryptionPolicy.addNode("SamlToken", (Node)object2);
            }
            if (map.containsKey("Header")) {
                // empty if block
            }
            encryptionPolicy.addEncryptionNodeList(this.soapMessageCtx);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
    }

    private String getValidatedSamlTokenTypeUri() {
        if (this.validatedTokenMap.isEmpty()) {
            Verbose.log("No validated SAML Token");
            return null;
        }
        List list = this.blueprint.getIdentityPolicy().getValidIdentityTokens();
        for (SecurityToken securityToken : list) {
            SecurityToken securityToken2;
            String string = securityToken.getTokenTypeUri();
            boolean bl = this.isSamlTokenType(string);
            if (!bl) continue;
            if (verbose) {
                Verbose.log("Found the SAML Token Type URI from IdentityPolicy =[" + string + "]");
            }
            if (null == (securityToken2 = this.validatedTokenMap.get(string))) {
                Verbose.log("No validated SAML Token for token type =[" + string + "]");
                return null;
            }
            return string;
        }
        Verbose.log("Unable to find any SAML Token Type URI from IdentityPolicy");
        return null;
    }

    private Node getNodeByTokenValueType(String string) {
        List list = this.securityCtx.getSecurityTokens(string);
        if (null == list || list.size() == 0) {
            return null;
        }
        for (weblogic.xml.crypto.wss.provider.SecurityToken securityToken : list) {
            Node node = this.securityCtx.getNode(securityToken);
            if (null == node) continue;
            return node;
        }
        return null;
    }

    private void resolveSignatureElementSignatureList() throws SecurityPolicyInspectionException, WSSecurityException {
        SignaturePolicy signaturePolicy = this.blueprint.getEndorsingPolicy();
        Map map = signaturePolicy.getSigningNodeMap();
        try {
            if (map.containsKey("EndoseSignature")) {
                List list = this.securityCtx.getSignatures();
                XMLSignatureImpl xMLSignatureImpl = null;
                if (this.blueprint.hasTransportSecuirity()) {
                    if (verbose) {
                        Verbose.log("Endorsing supporting token + transport security caes....");
                    }
                    if (null == list || list.size() == 0) {
                        throw new SecurityPolicyInspectionException(7501);
                    }
                    if (list.size() == 1) {
                        return;
                    }
                } else if (null == list || list.size() != 2) {
                    throw new SecurityPolicyInspectionException(7501);
                }
                xMLSignatureImpl = (XMLSignatureImpl)list.get(1);
                Element element = xMLSignatureImpl.getSignatureNode();
                ArrayList<Element> arrayList = new ArrayList<Element>();
                if (!SecurityPolicyOutlineSketcher.isSignatureElement(element)) {
                    XMLSignatureImpl xMLSignatureImpl2 = (XMLSignatureImpl)list.get(0);
                    element = xMLSignatureImpl2.getSignatureNode();
                }
                arrayList.add(element);
                signaturePolicy.setNewSignatureNodeListToReference(arrayList);
            }
        }
        catch (Exception exception) {
            Verbose.logException(exception);
            if (exception instanceof WSSecurityException) {
                throw (WSSecurityException)exception;
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private void inspectMessageAge(TimestampPolicy timestampPolicy) throws WSSecurityException {
        if (timestampPolicy.isIncludeTimestamp()) {
            this.doMessageAge(timestampPolicy);
        } else if (verbose) {
            Verbose.log("Timestamp is not required.");
        }
    }

    private void doMessageAge(TimestampPolicy timestampPolicy) throws WSSecurityException {
        short s = timestampPolicy.getMessageAgeSeconds();
        if (s == 0) {
            s = -1;
        }
        if (!this.svalidator.validateTimestamp(s)) {
            throw new WSSecurityException("Timestamp validation failed.", WSSConstants.FAILURE_INVALID);
        }
        if (verbose) {
            Verbose.log(" timestamp(maxAgesSecs=" + s + ") verified");
        }
    }

    private void inspectEndorseToken(SignaturePolicy signaturePolicy, SignaturePolicy signaturePolicy2) throws SecurityPolicyInspectionException, WSSecurityException {
        if (!signaturePolicy.isSignatureRequired()) {
            if (verbose) {
                Verbose.log("No need to verify support token endorsing.");
            }
            return;
        }
        this.doEndorseToken(signaturePolicy, signaturePolicy2);
    }

    private void doEndorseToken(SignaturePolicy signaturePolicy, SignaturePolicy signaturePolicy2) throws SecurityPolicyInspectionException, WSSecurityException {
        List list = signaturePolicy.getValidSignatureTokens();
        for (SecurityToken securityToken : list) {
            this.addReferenceByTokenValueType(signaturePolicy2, securityToken.getTokenTypeUri(), securityToken, false);
        }
    }

    private void inspectIdentity(IdentityPolicy identityPolicy) throws WSSecurityException {
        if (!identityPolicy.isAuthenticationRequired()) {
            if (verbose) {
                Verbose.log("Identity is not required.");
            }
            return;
        }
        this.doIdentity(identityPolicy);
    }

    private void doIdentity(IdentityPolicy identityPolicy) throws WSSecurityException {
        List list = identityPolicy.getValidIdentityTokens();
        boolean bl = false;
        for (SecurityToken securityToken : list) {
            this.setTokenIssuer(securityToken);
            this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", securityToken.isIncludeInMessage());
            String string = securityToken.getTokenTypeUri();
            if (string.endsWith("/dk") && SAMLUtils.isSamlTokenType(securityToken.getDerivedFromTokenType())) {
                string = securityToken.getDerivedFromTokenType();
            }
            if (verbose) {
                Verbose.log("Trying to validate identity assertion token type =" + securityToken.getTokenTypeUri() + " DerivedFromTokenType =" + securityToken.getDerivedFromTokenType() + " use Token Type for validation =" + string);
            }
            if (!this.svalidator.validateSecurityToken(string, securityToken.getIssuerName(), securityToken.getClaims())) continue;
            bl = true;
            if (verbose) {
                Verbose.log("Validated identity assertion token " + securityToken.getTokenTypeUri());
            }
            this.validatedTokenMap.put(securityToken.getTokenTypeUri(), securityToken);
        }
        this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
        if (!bl) {
            throw new SecurityPolicyInspectionException(1000);
        }
    }

    private void inspectIntegrity(SignaturePolicy signaturePolicy, boolean bl) throws SecurityPolicyInspectionException, WSSecurityException {
        if (!signaturePolicy.isSignatureRequired()) {
            if (verbose) {
                Verbose.log("Signature is not required.");
            }
            return;
        }
        this.doIntegrity(signaturePolicy, bl);
    }

    private void doIntegrity(SignaturePolicy signaturePolicy, boolean bl) throws SecurityPolicyInspectionException, WSSecurityException {
        SignedInfo signedInfo = signaturePolicy.getSignedInfo();
        List list = signaturePolicy.getValidSignatureTokens();
        boolean bl2 = false;
        boolean bl3 = signaturePolicy.signedSecurityTokens();
        for (SecurityToken securityToken : list) {
            this.setTokenIssuer(securityToken);
            this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", securityToken.isIncludeInMessage());
            if (bl3) {
                SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
                securityTokenContextHandler.addContextElement("weblogic.xml.crypto.wss.policy.Claims", securityToken.getClaims());
                Reference reference = this.blueprint.getSigningReferencesFactory().newSigningTokenReference(securityToken, securityTokenContextHandler, signaturePolicy.getDigestMethod().getAlgorithm());
                if (null == reference) {
                    throw new SecurityPolicyInspectionException(3701);
                }
                bl2 = this.svalidator.validateSignature(signaturePolicy.newSignedInfo(this.blueprint.getXmlSignatureFactory(), reference), securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.getClaims());
            } else {
                bl2 = this.svalidator.validateSignature(signedInfo, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.getClaims());
            }
            if (!bl2) continue;
            if (!verbose) break;
            Verbose.log("Signature has been validated successfully");
            break;
        }
        this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
        if (!bl2) {
            if (bl) {
                throw new SecurityPolicyInspectionException(3000);
            }
            try {
                String string = (String)this.soapMessageCtx.getProperty("weblogic.wsee.policy.compat.preference");
                if (null != string && COMPAT_FLAG_3006.equals(string)) {
                    Verbose.banner("Policy Enforcement Problem Dectected");
                    Verbose.log("By pass Policy Error 3006 due to the property weblogic.wsee.policy.compat.preference is set to Bypass.3006.error");
                    return;
                }
            }
            catch (Exception exception) {
                Verbose.log("ERROR ON on getting compact property during processing of policy enforcement Error code 3006 for the response message");
                Verbose.logException(exception);
            }
            throw new SecurityPolicyInspectionException(3006);
        }
    }

    private void inspectIntegrityAndConfidentiality(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, boolean bl, boolean bl2) throws SecurityPolicyInspectionException, WSSecurityException {
        if (!encryptionPolicy.isEncryptionRequired() && !signaturePolicy.isSignatureRequired() && verbose) {
            Verbose.log("Neither Encryption nor Signature is required.");
        }
        this.doIntegrityAndConfidentiality(signaturePolicy, encryptionPolicy, bl, bl2);
    }

    private void doIntegrityAndConfidentiality(SignaturePolicy signaturePolicy, EncryptionPolicy encryptionPolicy, boolean bl, boolean bl2) throws SecurityPolicyInspectionException, WSSecurityException {
        boolean bl3;
        block16: {
            List list = null;
            SignedInfo signedInfo = null;
            ArrayList arrayList = null;
            EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
            EncryptionMethod encryptionMethod2 = encryptionPolicy.getEncryptionMethod();
            List<EncryptionTarget> list2 = encryptionPolicy.getEncryptionTargets();
            if (signaturePolicy.isSignatureRequired()) {
                signedInfo = signaturePolicy.getSignedInfo();
                list = signaturePolicy.getValidSignatureTokens();
            }
            if (encryptionPolicy.isEncryptionRequired()) {
                list2 = encryptionPolicy.getEncryptionTargets();
                if (null == list) {
                    list = encryptionPolicy.getValidEncryptionTokens();
                }
            }
            if (null == list2) {
                if (verbose) {
                    Verbose.log("There is no encryption target.");
                }
            } else {
                arrayList = new ArrayList();
                for (EncryptionTarget object : list2) {
                    arrayList.addAll(object.getTBEs());
                }
            }
            bl3 = false;
            try {
                if (bl) {
                    SecurityToken exception = (SecurityToken)list.get(0);
                    this.setTokenIssuer(exception);
                    this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", exception.isIncludeInMessage());
                    bl3 = bl2 ? this.svalidator.validateEncryptionAndSignatureRequest(signedInfo, arrayList, encryptionMethod, encryptionMethod2, exception.getTokenTypeUri(), exception.getStrTypes(), exception.getIssuerName(), exception.isIncludeInMessage(), this.ctxHandler) : this.svalidator.validateSignatureAndEncryptionRequest(signedInfo, arrayList, encryptionMethod, encryptionMethod2, exception.getTokenTypeUri(), exception.getStrTypes(), exception.getIssuerName(), exception.isIncludeInMessage(), this.ctxHandler);
                    break block16;
                }
                try {
                    bl3 = this.svalidator.validateSignatureAndEncryptionResponse(signedInfo, arrayList, encryptionMethod2, this.ctxHandler);
                }
                catch (Exception xMLEncryptionException) {
                    throw new SecurityPolicyInspectionException(5006, (Throwable)xMLEncryptionException);
                }
            }
            catch (XMLEncryptionException xMLEncryptionException) {
                this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
                throw new SecurityPolicyInspectionException(4003, (Throwable)xMLEncryptionException);
            }
        }
        this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
        if (bl3) {
            if (verbose) {
                Verbose.log("Signature and Encryption has been validated successfully.");
            }
        } else {
            if (bl) {
                throw new SecurityPolicyInspectionException(5000);
            }
            throw new SecurityPolicyInspectionException(5006);
        }
    }

    private void inspectConfidentiality(EncryptionPolicy encryptionPolicy, boolean bl, boolean bl2) throws SecurityPolicyInspectionException, WSSecurityException {
        if (!encryptionPolicy.isEncryptionRequired()) {
            if (verbose) {
                Verbose.log("Encryption is not required.");
            }
            return;
        }
        this.doConfidentiality(encryptionPolicy, bl, bl2);
    }

    private void doConfidentiality(EncryptionPolicy encryptionPolicy, boolean bl, boolean bl2) throws SecurityPolicyInspectionException, WSSecurityException {
        List list = encryptionPolicy.getValidEncryptionTokens();
        List<EncryptionTarget> list2 = encryptionPolicy.getEncryptionTargets();
        EncryptionMethod encryptionMethod = encryptionPolicy.getKeyWrapMethod();
        for (EncryptionTarget encryptionTarget : list2) {
            EncryptionMethod encryptionMethod2 = null != encryptionTarget.getEncryptionMethod() ? encryptionTarget.getEncryptionMethod() : encryptionPolicy.getEncryptionMethod();
            boolean bl3 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    SecurityToken securityToken = (SecurityToken)iterator.next();
                    this.setTokenIssuer(securityToken);
                    this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", securityToken.isIncludeInMessage());
                    if (bl2) {
                        HashMap hashMap = new HashMap();
                        bl3 = this.svalidator.validateEncryptionforEncryptFirst(encryptionTarget.getTBEs(), encryptionMethod, encryptionMethod2, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.getClaims(), hashMap);
                        if (!hashMap.isEmpty()) {
                            this.ctxHandler.addContextElement("weblogic.wsee.security.encrypted_element.map", hashMap);
                        }
                    } else {
                        bl3 = this.svalidator.validateEncryption(encryptionTarget.getTBEs(), encryptionMethod, encryptionMethod2, securityToken.getTokenTypeUri(), securityToken.getStrTypes(), securityToken.getIssuerName(), securityToken.getClaims());
                    }
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
                    throw new SecurityPolicyInspectionException(4003, (Throwable)xMLEncryptionException);
                }
                if (!bl3) continue;
                if (!verbose) break;
                Verbose.log("Encryption has been validated successfull.");
                break;
            }
            this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
            if (bl3) continue;
            if (bl) {
                throw new SecurityPolicyInspectionException(4000);
            }
            throw new SecurityPolicyInspectionException(4006);
        }
    }

    private SignatureConfirmation[] inspectSignatureConfirmation(boolean bl, boolean bl2) throws SecurityPolicyInspectionException {
        return this.doSignatureConfirmation(bl, bl2);
    }

    private SignatureConfirmation[] doSignatureConfirmation(boolean bl, boolean bl2) throws SecurityPolicyInspectionException {
        SignatureConfirmation[] signatureConfirmationArray = null;
        List list = this.securityCtx.getSignatureConfirmations();
        if (bl) {
            if (null == list || list.size() == 0) {
                throw new SecurityPolicyInspectionException(6301);
            }
            boolean bl3 = this.svalidator.validateSignatureConfirmation();
            if (!bl3) {
                throw new SecurityPolicyInspectionException(6300);
            }
            signatureConfirmationArray = new SignatureConfirmation[list.size()];
            for (int i = 0; i < signatureConfirmationArray.length; ++i) {
                signatureConfirmationArray[i] = (SignatureConfirmation)list.get(i);
            }
        } else if (!bl2 && list != null && list.size() > 0) {
            throw new SecurityPolicyInspectionException(6308);
        }
        return signatureConfirmationArray;
    }

    private void setTokenIssuer(SecurityToken securityToken) {
        if (securityToken.getTokenIssuer() == null) {
            this.ctxHandler.addContextElement("weblogic.wsee.security.issuer_endpoint_ref", null);
        } else {
            this.ctxHandler.addContextElement("weblogic.wsee.security.issuer_endpoint_ref", securityToken.getTokenIssuer());
        }
    }
}

