/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.security.policy.SigningReferencesFactory;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlanImpl;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.plan.helper.XpathNodesHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.wssp.EncryptionPolicyBlueprintImpl;
import weblogic.wsee.security.wss.policy.wssp.SigningPolicyBlueprintImpl;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyBlueprint
extends SecurityPolicyPlanImpl {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyBlueprint.class);
    private static final boolean debug = false;
    private SecurityBuilder sbuilder = null;
    private SecurityValidator sValidator = null;
    private XMLEncryptionFactory xmlEncryptionFactory;
    private XMLSignatureFactory xmlSignatureFactory;
    private SigningReferencesFactory signingReferencesFactory;
    protected List requiredElements;
    protected List<QNameExpr> requiredParts = null;

    public SecurityPolicyBlueprint(SecurityBuilder securityBuilder) {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.sbuilder = securityBuilder;
        this.setBuildingPlan(27);
        this.xmlEncryptionFactory = securityBuilder.getXMLEncryptionFactory();
        this.xmlSignatureFactory = securityBuilder.getXMLSignatureFactory();
        this.signingReferencesFactory = new SigningReferencesFactory(securityBuilder);
        this.signingPolicy = new SigningPolicyBlueprintImpl(this.xmlSignatureFactory, this.signingReferencesFactory);
        this.encryptionPolicy = new EncryptionPolicyBlueprintImpl(this.xmlEncryptionFactory);
        this.endorsingPolicy = new SigningPolicyBlueprintImpl(this.xmlSignatureFactory, this.signingReferencesFactory);
    }

    public SecurityPolicyBlueprint(SecurityValidator securityValidator) {
        if (null == securityValidator) {
            throw new IllegalArgumentException("Null security validator found");
        }
        this.sValidator = securityValidator;
        this.xmlEncryptionFactory = this.sValidator.getXMLEncryptionFactory();
        this.xmlSignatureFactory = this.sValidator.getXMLSignatureFactory();
        this.signingReferencesFactory = new SigningReferencesFactory(this.sValidator);
        this.signingPolicy = new SigningPolicyBlueprintImpl(this.xmlSignatureFactory, this.signingReferencesFactory);
        this.encryptionPolicy = new EncryptionPolicyBlueprintImpl(this.xmlEncryptionFactory);
        this.endorsingPolicy = new SigningPolicyBlueprintImpl(this.xmlSignatureFactory, this.signingReferencesFactory);
    }

    public SecurityBuilder getSecurityBuilder() {
        return this.sbuilder;
    }

    public SecurityValidator getSecurityValidator() {
        return this.sValidator;
    }

    public boolean isForValidator() {
        return this.sValidator != null;
    }

    public XMLEncryptionFactory getXmlEncryptionFactory() {
        return this.xmlEncryptionFactory;
    }

    public XMLSignatureFactory getXmlSignatureFactory() {
        return this.xmlSignatureFactory;
    }

    public SigningReferencesFactory getSigningReferencesFactory() {
        return this.signingReferencesFactory;
    }

    public void addRequiredElement(XPath xPath) {
        if (this.requiredElements == null) {
            this.requiredElements = new ArrayList();
        }
        this.requiredElements.add(xPath);
    }

    public void addRequiredPart(QNameExpr qNameExpr) {
        if (this.requiredParts == null) {
            this.requiredParts = new ArrayList<QNameExpr>();
        }
        this.requiredParts.add(qNameExpr);
    }

    public List<QNameExpr> getRequiredParts() {
        return this.requiredParts;
    }

    public List<XPath> getReqElementList() {
        return this.requiredElements;
    }

    public void verifyPolicy(SOAPMessageContext sOAPMessageContext) throws SecurityPolicyArchitectureException {
        SOAPMessage sOAPMessage;
        Object object;
        if (this.getRequiredParts() != null && this.getRequiredParts().size() > 0) {
            if (verbose) {
                Verbose.log("Checking required parts for " + this.getRequiredParts().size());
            }
            try {
                object = this.getRequiredParts().iterator();
                sOAPMessage = sOAPMessageContext.getMessage();
                while (object.hasNext()) {
                    List list;
                    QNameExpr qNameExpr = (QNameExpr)object.next();
                    QName qName = new QName(qNameExpr.getNamespaceUri(), qNameExpr.getLocalName());
                    if (verbose) {
                        Verbose.log("Checking required parts for QName =" + qName.toString());
                    }
                    if ((list = SOAPSecurityHeaderHelper.getNonSecurityElements(sOAPMessage, qNameExpr)) != null && list.size() != 0) continue;
                    throw new SecurityPolicyArchitectureException("Missing Exception on getting Header Element QName =" + qName.toString());
                }
            }
            catch (WSSecurityException wSSecurityException) {
                throw new SecurityPolicyArchitectureException("Exception on getting Header Elements", wSSecurityException);
            }
        }
        if ((object = this.getReqElementList()) != null) {
            sOAPMessage = XpathNodesHelper.findNode(object, sOAPMessageContext, true);
        }
    }
}

