/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.util.List;
import java.util.Map;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprintPlotter;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenFactory;
import weblogic.wsee.security.wss.plan.helper.SecurityPolicyBlueprintHelper;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wssc.dk.DKClaims;
import weblogic.wsee.security.wssp.AsymmetricBindingInfo;
import weblogic.wsee.security.wssp.InitiatorTokenAssertion;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.ProtectionTokenAssertion;
import weblogic.wsee.security.wssp.RecipientTokenAssertion;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SupportingTokensAssertion;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;
import weblogic.wsee.security.wssp.TransportBindingInfo;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyBlueprintDesigner {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyBlueprintDesigner.class);
    private static final boolean debug = false;
    private static final int ITA = 3;
    private static final int IETA = 2;
    private static final int ISTA = 1;
    private static final int RTA = 12;
    private static final int RETA = 4;
    private static final int RSTA = 8;
    private SecurityPolicyBlueprintPlotter blueprintPlotter;

    public SecurityPolicyBlueprintDesigner(SecurityBuilder securityBuilder) {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.blueprintPlotter = new SecurityPolicyBlueprintPlotter(securityBuilder);
    }

    public SecurityPolicyBlueprintDesigner(SecurityValidator securityValidator) {
        if (null == securityValidator) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.blueprintPlotter = new SecurityPolicyBlueprintPlotter(securityValidator);
    }

    public SecurityPolicyBlueprint getBlueprint() {
        return this.blueprintPlotter.getBlueprint();
    }

    public void designOutboundBlueprint(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == securityPolicyAssertionInfo) {
            throw new IllegalArgumentException("Null SecurityPolicyAssertionInfo found");
        }
        this.blueprintPlotter.drawPolicySelectionPreference((PolicySelectionPreference)map.get("weblogic.wsee.policy.selection.preference"));
        this.blueprintPlotter.drawPolicyCompatibilityPreference((String)map.get("weblogic.wsee.policy.compat.preference"), securityPolicyAssertionInfo.getNamespaceUri());
        this.blueprintPlotter.drawWss10Options(securityPolicyAssertionInfo.getWss10Options());
        this.blueprintPlotter.drawWss11Options(securityPolicyAssertionInfo.getWss11Options(), bl);
        this.blueprintPlotter.drawTrustOptions(securityPolicyAssertionInfo.getWsTrustOptions());
        if (null != securityPolicyAssertionInfo.getTransportBindingInfo()) {
            this.processTransportBindingInfoPolicy(securityPolicyAssertionInfo, securityPolicyAssertionInfo.getTransportBindingInfo(), map);
        }
        if (null != securityPolicyAssertionInfo.getAsymmetricBindingInfo()) {
            this.processAsymmetricBindingPolicy(securityPolicyAssertionInfo, map, bl);
        }
        if (null != securityPolicyAssertionInfo.getSymmetricBindingInfo()) {
            this.processSymmetricBindingPolicy(securityPolicyAssertionInfo, map, bl);
        }
        this.blueprintPlotter.drawIntegrity(securityPolicyAssertionInfo.getIntegrityAssertions());
        this.blueprintPlotter.drawConfidentiality(securityPolicyAssertionInfo.getConfidentialityAssertions());
        if (null != securityPolicyAssertionInfo.getSupportingTokensAssertion()) {
            this.processSupportingTokensAssertionPolicy(securityPolicyAssertionInfo);
        }
        this.blueprintPlotter.drawProtectionAssertion(securityPolicyAssertionInfo.getProtectionAssertions());
        this.verifyPolicy(securityPolicyAssertionInfo, bl);
    }

    private void processAsymmetricBindingPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        AsymmetricBindingInfo asymmetricBindingInfo = securityPolicyAssertionInfo.getAsymmetricBindingInfo();
        if (null == asymmetricBindingInfo) {
            return;
        }
        if (null != asymmetricBindingInfo.getAlgorithm()) {
            this.blueprintPlotter.drawAsymmetricBindingAlgorithm(securityPolicyAssertionInfo.getAlgorithmSuiteInfo());
        }
        if (asymmetricBindingInfo.isTokenProtectionRequired()) {
            if (asymmetricBindingInfo.isTokenProtectionOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("\"The TokenProtection is off  due to it is optional and security is not a preference");
                }
                this.blueprintPlotter.getBlueprint().getSigningPolicy().setTokenProtection(false);
                this.blueprintPlotter.getBlueprint().getEndorsingPolicy().setTokenProtection(false);
            } else {
                this.blueprintPlotter.getBlueprint().getSigningPolicy().setTokenProtection(true);
                this.blueprintPlotter.getBlueprint().getEndorsingPolicy().setTokenProtection(true);
            }
        }
        if (asymmetricBindingInfo.isSignatureProtectionRequired()) {
            this.blueprintPlotter.drawSignatureProtection(asymmetricBindingInfo.isSignatureProtectionOptional());
        }
        if (asymmetricBindingInfo.isEncryptBeforeSigning()) {
            if (asymmetricBindingInfo.isEncryptBeforeSigningOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("The Encrypt Before Signning is off due to it is optional and security is not a preference");
                }
            } else {
                this.blueprintPlotter.drawEncryptBeforeSigning();
            }
        }
        this.blueprintPlotter.drawLayOut((Object)asymmetricBindingInfo.getLayout());
        this.blueprintPlotter.drawTimestamp(asymmetricBindingInfo, map);
        this.blueprintPlotter.setAlgorithmSuiteInfo(securityPolicyAssertionInfo.getAlgorithmSuiteInfo());
        X509TokenAssertion x509TokenAssertion = null;
        SamlTokenAssertion samlTokenAssertion = null;
        X509TokenAssertion x509TokenAssertion2 = null;
        int n = 0;
        if (null != asymmetricBindingInfo.getInitiatorTokenAssertion()) {
            n |= 3;
            x509TokenAssertion = asymmetricBindingInfo.getInitiatorTokenAssertion().getX509TokenAssertion();
            samlTokenAssertion = asymmetricBindingInfo.getInitiatorTokenAssertion().getSamlTokenAssertion();
        }
        if (null != asymmetricBindingInfo.getRecipientTokenAssertion()) {
            n |= 0xC;
            x509TokenAssertion2 = asymmetricBindingInfo.getRecipientTokenAssertion().getX509TokenAssertion();
        }
        if (null != asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion()) {
            n |= 2;
            if (x509TokenAssertion != null) {
                throw new SecurityPolicyArchitectureException("Duplicate X509TokenAssertion in InitiatorTokenAssertion.");
            }
            x509TokenAssertion = asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getX509TokenAssertion();
            if (samlTokenAssertion != null) {
                throw new SecurityPolicyArchitectureException("Duplicate SamlTokenAssertion in InitiatorTokenAssertion.");
            }
            samlTokenAssertion = asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getSamlTokenAssertion();
        }
        if (null != asymmetricBindingInfo.getRecipientEncryptionTokenAssertion()) {
            n |= 4;
            if (x509TokenAssertion2 != null) {
                throw new SecurityPolicyArchitectureException("Duplicate X509TokenAssertion in RecipientTokenAssertion.");
            }
            x509TokenAssertion2 = asymmetricBindingInfo.getRecipientEncryptionTokenAssertion().getX509TokenAssertion();
        }
        if (null != asymmetricBindingInfo.getInitiatorSignatureTokenAssertion()) {
            n |= 1;
            if (x509TokenAssertion != null) {
                throw new SecurityPolicyArchitectureException("Duplicate X509TokenAssertion in InitiatorTokenAssertion.");
            }
            x509TokenAssertion = asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getX509TokenAssertion();
            if (samlTokenAssertion != null) {
                throw new SecurityPolicyArchitectureException("Duplicate SamlTokenAssertion in InitiatorTokenAssertion.");
            }
            samlTokenAssertion = asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getSamlTokenAssertion();
        }
        if (null != asymmetricBindingInfo.getRecipientSignatureTokenAssertion()) {
            n |= 8;
            if (x509TokenAssertion2 != null) {
                throw new SecurityPolicyArchitectureException("Duplicate X509TokenAssertion in RecipientTokenAssertion.");
            }
            x509TokenAssertion2 = asymmetricBindingInfo.getRecipientSignatureTokenAssertion().getX509TokenAssertion();
        }
        this.processInitiatorAndRecipientToken(x509TokenAssertion, samlTokenAssertion, x509TokenAssertion2, n, bl);
        if (asymmetricBindingInfo.isEntireHeaderAndBodySignatureRequired() && this.blueprintPlotter.getBlueprint().getSigningPolicy().hasSignatureToken()) {
            if (asymmetricBindingInfo.isEntireHeaderAndBodySignatureOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("Skip the OnlySignEntrieHeaderAndBody assertion due to it is optional and security is not a preference");
                }
            } else {
                this.blueprintPlotter.drawOneSignatureItem("Body");
                this.blueprintPlotter.drawOneSignatureItem("Header");
            }
        }
        if (bl) {
            // empty if block
        }
    }

    private void processInitiatorAndRecipientToken(X509TokenAssertion x509TokenAssertion, SamlTokenAssertion samlTokenAssertion, X509TokenAssertion x509TokenAssertion2, int n, boolean bl) throws SecurityPolicyArchitectureException {
        if (x509TokenAssertion2 == null) {
            if (verbose) {
                Verbose.say("No X509TokenAssertion in RecipientTokenAssertion.");
            }
            if ((n & 2) == 2 || (n & 8) == 8) {
                throw new SecurityPolicyArchitectureException("Unable to find X509TokenAssertion in RecipientTokenAssertion.");
            }
        }
        if (x509TokenAssertion == null && samlTokenAssertion == null) {
            throw new SecurityPolicyArchitectureException("Unable to find X509TokenAssertion or SamlTokenAssertion in InitiatorTokenAssertion.");
        }
        SecurityToken securityToken = null;
        SecurityToken securityToken2 = null;
        if (bl) {
            if ((n & 1) == 1) {
                securityToken = x509TokenAssertion != null ? SecurityTokenFactory.makeSecurityTokenForSignature(x509TokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy()) : SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(samlTokenAssertion.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy());
            }
            if ((n & 2) == 2) {
                securityToken2 = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion2, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion2.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy());
            }
        } else {
            if ((n & 8) == 8) {
                securityToken = SecurityTokenFactory.makeSecurityTokenForSignatureResponse(x509TokenAssertion2, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion2.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy(), this.getBlueprint().isForValidator());
            }
            if ((n & 4) == 4) {
                securityToken2 = x509TokenAssertion != null ? SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy()) : SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(samlTokenAssertion.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy());
            }
        }
        if (null != securityToken) {
            this.blueprintPlotter.getBlueprint().getSigningPolicy().addSignatureToken(securityToken);
        }
        if (null != securityToken2) {
            this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken(securityToken2);
        }
    }

    private boolean processInitiatorAndRecipientToken(AsymmetricBindingInfo asymmetricBindingInfo, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        SecurityToken securityToken;
        SecurityToken securityToken2;
        InitiatorTokenAssertion initiatorTokenAssertion = asymmetricBindingInfo.getInitiatorTokenAssertion();
        RecipientTokenAssertion recipientTokenAssertion = asymmetricBindingInfo.getRecipientTokenAssertion();
        if (initiatorTokenAssertion == null || recipientTokenAssertion == null) {
            return false;
        }
        X509TokenAssertion x509TokenAssertion = initiatorTokenAssertion.getX509TokenAssertion();
        SamlTokenAssertion samlTokenAssertion = initiatorTokenAssertion.getSamlTokenAssertion();
        X509TokenAssertion x509TokenAssertion2 = recipientTokenAssertion.getX509TokenAssertion();
        if (x509TokenAssertion2 == null) {
            throw new SecurityPolicyArchitectureException("Unable to find X509TokenAssertion in RecipientTokenAssertion.");
        }
        if (bl) {
            if (x509TokenAssertion != null) {
                securityToken2 = SecurityTokenFactory.makeSecurityTokenForSignature(x509TokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy());
            } else if (samlTokenAssertion != null) {
                securityToken2 = SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(samlTokenAssertion.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy());
            } else {
                throw new SecurityPolicyArchitectureException("Unable to find X509TokenAssertion or SamlTokenAssertion in InitiatorTokenAssertion.");
            }
            securityToken = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion2, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion2.getTokenInclusion(), true), this.getBlueprint().getGeneralPolicy());
        } else {
            securityToken2 = SecurityTokenFactory.makeSecurityTokenForSignatureResponse(x509TokenAssertion2, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion2.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy(), this.getBlueprint().isForValidator());
            if (x509TokenAssertion != null) {
                securityToken = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy());
            } else if (samlTokenAssertion != null) {
                securityToken = SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, SecurityPolicyBlueprintHelper.shouldIncludeToken(samlTokenAssertion.getTokenInclusion(), false), this.getBlueprint().getGeneralPolicy());
            } else {
                throw new SecurityPolicyArchitectureException("Unable to find X509TokenAssertion or SamlTokenAssertion in InitiatorTokenAssertion.");
            }
        }
        this.blueprintPlotter.getBlueprint().getSigningPolicy().addSignatureToken(securityToken2);
        this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken(securityToken);
        return true;
    }

    private void processSymmetricBindingPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        SymmetricBindingInfo symmetricBindingInfo = securityPolicyAssertionInfo.getSymmetricBindingInfo();
        if (null == symmetricBindingInfo) {
            return;
        }
        this.getBlueprint().setSymmeticPlan(true);
        this.blueprintPlotter.setAlgorithmSuiteInfo(securityPolicyAssertionInfo.getAlgorithmSuiteInfo());
        if (null != symmetricBindingInfo.getProtectionTokenAssertion()) {
            SamlTokenAssertion samlTokenAssertion;
            boolean bl2;
            Object object;
            ProtectionTokenAssertion protectionTokenAssertion = symmetricBindingInfo.getProtectionTokenAssertion();
            X509TokenAssertion x509TokenAssertion = protectionTokenAssertion.getX509TokenAssertion();
            if (null != x509TokenAssertion) {
                boolean bl3 = SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), bl);
                if (null != x509TokenAssertion.getX509TokenType()) {
                    object = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, bl3, this.getBlueprint().getGeneralPolicy());
                    this.blueprintPlotter.getBlueprint().getSigningPolicy().addSignatureToken((SecurityToken)object);
                    this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken((SecurityToken)object);
                    bl2 = false;
                    if (x509TokenAssertion.requireDerivedKey()) {
                        boolean bl4 = true;
                        if (x509TokenAssertion.isDerivedKeyOptional()) {
                            if (!bl && map.get("DerivedKeysToken") == null) {
                                bl4 = false;
                                if (verbose) {
                                    Verbose.say("Skip the DK assertion due to it is optional with <sp:RequireDerivedKeys wsp:Optional=\"true\" /> and the DK token is not in the request");
                                }
                            } else if (!this.blueprintPlotter.isSecurityFirst()) {
                                bl4 = false;
                                if (verbose) {
                                    Verbose.say("Skip the DK assertion due to it is optional with <sp:RequireDerivedKeys wsp:Optional=\"true\" /> and security is not a preference");
                                }
                            }
                        }
                        if (bl4) {
                            ((SecurityToken)object).setTokenTypeUri(x509TokenAssertion.getDerivedKeyTokenType(this.blueprintPlotter.getBlueprint().getGeneralPolicy().isWssc13())[0]);
                            ((SecurityToken)object).setDerivedFromTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                            ((SecurityToken)object).setClaims(DKClaims.makeDKClaimsNode(this.blueprintPlotter.getBlueprint().getGeneralPolicy(), null, securityPolicyAssertionInfo.getAlgorithmSuiteInfo()));
                            this.blueprintPlotter.addBlueprintAction(512);
                            this.blueprintPlotter.drawSymmetricBindingAlgorithm(securityPolicyAssertionInfo.getAlgorithmSuiteInfo(), true);
                            ((SecurityToken)object).setEncryptionMethod(this.blueprintPlotter.getBlueprint().getEncryptionPolicy().getEncryptionMethod());
                            ((SecurityToken)object).setKeyWrapMethod(this.blueprintPlotter.getBlueprint().getEncryptionPolicy().getKeyWrapMethod());
                            this.blueprintPlotter.getBlueprint().getEncryptionPolicy().setKeyWrapMethod((EncryptionMethod)null);
                            ((SecurityToken)object).setStrTypesForDKBaseToken(((SecurityToken)object).getStrTypes());
                            ((SecurityToken)object).setStrTypes(TokenReferenceTypeHelper.getSTRTypesForDK(((SecurityToken)object).getTokenTypeUri()));
                            ((SecurityToken)object).setIncludeInMessage(true);
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        if (symmetricBindingInfo.isEncryptedKeyRequired()) {
                            this.blueprintPlotter.drawEncyptedKeyAction();
                        }
                        if (null != symmetricBindingInfo.getAlgorithm()) {
                            this.blueprintPlotter.drawSymmetricBindingAlgorithm(securityPolicyAssertionInfo.getAlgorithmSuiteInfo(), true);
                        }
                    }
                } else {
                    throw new SecurityPolicyArchitectureException("Missing TokenType assertion");
                }
            }
            if ((samlTokenAssertion = protectionTokenAssertion.getSamlTokenAssertion()) != null) {
                object = SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, true, this.getBlueprint().getGeneralPolicy());
                this.blueprintPlotter.getBlueprint().getSigningPolicy().addSignatureToken((SecurityToken)object);
                this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken((SecurityToken)object);
                if (null != symmetricBindingInfo.getAlgorithm()) {
                    this.blueprintPlotter.drawSymmetricBindingAlgorithm(securityPolicyAssertionInfo.getAlgorithmSuiteInfo(), true);
                }
            }
            if ((object = protectionTokenAssertion.getSecureConversationTokenAssertion()) != null) {
                bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(object.getTokenInclusion(), bl);
                SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken((SecureConversationTokenAssertion)object, bl2, this.getBlueprint().getGeneralPolicy(), securityPolicyAssertionInfo.getAlgorithmSuiteInfo());
                this.blueprintPlotter.getBlueprint().getSigningPolicy().addSignatureToken(securityToken);
                this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken(securityToken);
                if (null != symmetricBindingInfo.getAlgorithm()) {
                    this.blueprintPlotter.drawSymmetricBindingAlgorithm(securityPolicyAssertionInfo.getAlgorithmSuiteInfo(), false);
                }
            }
        } else {
            SecurityToken securityToken;
            boolean bl5;
            ProtectionTokenAssertion protectionTokenAssertion;
            X509TokenAssertion x509TokenAssertion;
            if (null != symmetricBindingInfo.getEncryptionTokenAssertion() && null != (x509TokenAssertion = (protectionTokenAssertion = symmetricBindingInfo.getEncryptionTokenAssertion()).getX509TokenAssertion())) {
                bl5 = SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), bl);
                if (null != x509TokenAssertion.getX509TokenType()) {
                    securityToken = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, bl5, this.getBlueprint().getGeneralPolicy());
                    this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken(securityToken);
                } else {
                    throw new SecurityPolicyArchitectureException("Missing TokenType assertion");
                }
            }
            if (null != symmetricBindingInfo.getSignatureTokenAssertion() && null != (x509TokenAssertion = (protectionTokenAssertion = symmetricBindingInfo.getSignatureTokenAssertion()).getX509TokenAssertion())) {
                bl5 = SecurityPolicyBlueprintHelper.shouldIncludeToken(x509TokenAssertion.getTokenInclusion(), bl);
                if (null != x509TokenAssertion.getX509TokenType()) {
                    securityToken = SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, bl5, this.getBlueprint().getGeneralPolicy());
                    this.blueprintPlotter.getBlueprint().getEncryptionPolicy().addEncryptionToken(securityToken);
                } else {
                    throw new SecurityPolicyArchitectureException("Missing TokenType assertion");
                }
            }
        }
        if (symmetricBindingInfo.isEntireHeaderAndBodySignatureRequired()) {
            if (symmetricBindingInfo.isEntireHeaderAndBodySignatureOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("Skip the OnlySignEntrieHeaderAndBody assertion due to it is optional and security is not a preference");
                }
            } else {
                this.blueprintPlotter.drawOneSignatureItem("Body");
                this.blueprintPlotter.drawOneSignatureItem("Header");
            }
        }
        if (symmetricBindingInfo.isTokenProtectionRequired()) {
            if (symmetricBindingInfo.isTokenProtectionOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("The TokenProtection is off due to it is optional and security is not a preference");
                }
                this.blueprintPlotter.getBlueprint().getSigningPolicy().setTokenProtection(false);
                this.blueprintPlotter.getBlueprint().getEndorsingPolicy().setTokenProtection(false);
            } else {
                this.blueprintPlotter.getBlueprint().getSigningPolicy().setTokenProtection(true);
                this.blueprintPlotter.getBlueprint().getEndorsingPolicy().setTokenProtection(true);
            }
        }
        if (symmetricBindingInfo.isSignatureProtectionRequired()) {
            if (symmetricBindingInfo.isSignatureProtectionOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("The SignatureProtection is off due to it is optional and security is not a preference");
                }
            } else {
                this.blueprintPlotter.drawSignatureProtection(symmetricBindingInfo.isSignatureProtectionOptional());
                this.blueprintPlotter.addBlueprintAction(8192);
            }
        }
        if (symmetricBindingInfo.isEncryptBeforeSigning()) {
            if (symmetricBindingInfo.isEncryptBeforeSigningOptional() && !this.blueprintPlotter.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("The Encrypt Before Signning is off due to it is optional and security is not a preference");
                }
            } else {
                this.blueprintPlotter.drawEncryptBeforeSigning();
                this.blueprintPlotter.addBlueprintAction(4096);
            }
        }
        this.blueprintPlotter.drawLayOut((Object)symmetricBindingInfo.getLayout());
        this.blueprintPlotter.drawTimestamp(symmetricBindingInfo, map);
    }

    private void processSupportingTokensAssertionPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo) throws WSSecurityException, SecurityPolicyArchitectureException {
        this.blueprintPlotter.setPolicyInfo(securityPolicyAssertionInfo);
        SupportingTokensAssertion supportingTokensAssertion = securityPolicyAssertionInfo.getSupportingTokensAssertion();
        if (supportingTokensAssertion.hasSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfSupportingTokens(), 0);
        }
        if (supportingTokensAssertion.hasEncryptedSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getEncryptedSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfSignedEncryptedSupportingTokens(), 5);
        }
        if (supportingTokensAssertion.hasSignedSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getSignedSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfSignedSupportingTokens(), 1);
        }
        if (supportingTokensAssertion.hasEndorsingSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getEndorsingSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfEndorsingSupportingTokens(), 2);
            this.blueprintPlotter.addBlueprintAction(1024);
        }
        if (supportingTokensAssertion.hasSignedEndorsingSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getSignedEndorsingSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfSignedEndorsingSupportingTokens(), 3);
            this.blueprintPlotter.addBlueprintAction(3072);
        }
        if (supportingTokensAssertion.hasSignedEncryptedSupportingTokens()) {
            this.blueprintPlotter.drawSupportingToken(supportingTokensAssertion.getSignedEncryptedSupportingTokens(), supportingTokensAssertion.getSecurityInfoOfSignedEncryptedSupportingTokens(), 4);
        }
    }

    private void processTransportBindingInfoPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, TransportBindingInfo transportBindingInfo, Map<String, Object> map) throws WSSecurityException, SecurityPolicyArchitectureException {
        this.blueprintPlotter.drawTimestamp(transportBindingInfo, map);
        this.blueprintPlotter.drawLayOut((Object)transportBindingInfo.getLayout());
        this.blueprintPlotter.drawTransportToken(transportBindingInfo.getHttpsTokenAssertion());
        this.blueprintPlotter.setAlgorithmSuiteInfo(securityPolicyAssertionInfo.getAlgorithmSuiteInfo());
    }

    private void verifyPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, boolean bl) throws SecurityPolicyArchitectureException {
        List<IntegrityAssertion> list;
        if (!this.getBlueprint().getEncryptionPolicy().isPolicyValid()) {
            throw new SecurityPolicyArchitectureException("Invalid encryption policy");
        }
        if (!this.getBlueprint().getEndorsingPolicy().isPolicyValid()) {
            throw new SecurityPolicyArchitectureException("Invalid endorsing policy");
        }
        if (!this.getBlueprint().getSigningPolicy().isPolicyValid() && (list = securityPolicyAssertionInfo.getIntegrityAssertions()) != null && list.size() > 0) {
            if (!(null == securityPolicyAssertionInfo.getAsymmetricBindingInfo() || null == securityPolicyAssertionInfo.getAsymmetricBindingInfo().getInitiatorSignatureTokenAssertion() || null != securityPolicyAssertionInfo.getAsymmetricBindingInfo().getRecipientTokenAssertion() && null != securityPolicyAssertionInfo.getAsymmetricBindingInfo().getRecipientSignatureTokenAssertion() || bl)) {
                if (verbose) {
                    Verbose.say("The Signature policy is not verified, due to this is a response on InitiatorSignatureTokenAssertion only");
                }
                return;
            }
            for (IntegrityAssertion integrityAssertion : list) {
                if (integrityAssertion == null || !integrityAssertion.isSignedBodyRequired() && !integrityAssertion.isSignedWsaHeadersRequired() && integrityAssertion.getSigningElements() == null && integrityAssertion.getSigningParts() == null) continue;
                throw new SecurityPolicyArchitectureException("Invalid signing policy");
            }
        }
    }
}

