/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy12.assertions.ContentEncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.IncludeTimestamp;
import weblogic.wsee.security.policy12.assertions.Layout;
import weblogic.wsee.security.policy12.assertions.RequiredParts;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.assertions.XPathElements;
import weblogic.wsee.security.policy12.internal.QNameExprImpl;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenFactory;
import weblogic.wsee.security.wss.plan.helper.SecurityPolicyBlueprintHelper;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SecurityPolicyBuilderConstants;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.TimestampPolicy;
import weblogic.wsee.security.wssp.AlgorithmSuiteInfo;
import weblogic.wsee.security.wssp.AsymmetricBindingInfo;
import weblogic.wsee.security.wssp.ConfidentialityAssertion;
import weblogic.wsee.security.wssp.HttpsTokenAssertion;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.IssuedTokenAssertion;
import weblogic.wsee.security.wssp.KerberosTokenAssertion;
import weblogic.wsee.security.wssp.ProtectionAssertion;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityBindingPropertiesAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SupportingTokensAssertion;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;
import weblogic.wsee.security.wssp.TokenAssertion;
import weblogic.wsee.security.wssp.TransportBindingInfo;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;
import weblogic.wsee.security.wssp.WsTrustOptions;
import weblogic.wsee.security.wssp.Wss10Options;
import weblogic.wsee.security.wssp.Wss11Options;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyBlueprintPlotter {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyBlueprintPlotter.class);
    private static final boolean debug = false;
    private SecurityPolicyAssertionInfo policy = null;
    private SecurityPolicyBlueprint blueprint;
    private AlgorithmSuiteInfo algorithmSuiteInfo = null;
    public static boolean SUPPORT_DK_ENDORSING_WITH_DK = false;
    private boolean isCompatMSFT = false;
    private String policyNamespaceUri = null;
    private static final String SP_NAMESPACE_2005_07 = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";

    public SecurityPolicyBlueprintPlotter(SecurityBuilder securityBuilder) {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.blueprint = new SecurityPolicyBlueprint(securityBuilder);
    }

    public SecurityPolicyBlueprintPlotter(SecurityValidator securityValidator) {
        if (null == securityValidator) {
            throw new IllegalArgumentException("Null security validator found");
        }
        this.blueprint = new SecurityPolicyBlueprint(securityValidator);
        this.blueprint.setBuildingPlan(27);
    }

    protected SecurityPolicyBlueprintPlotter(SecurityPolicyBlueprint securityPolicyBlueprint) {
        this.blueprint = securityPolicyBlueprint;
    }

    public void setPolicyInfo(SecurityPolicyAssertionInfo securityPolicyAssertionInfo) {
        this.policy = securityPolicyAssertionInfo;
    }

    protected SecurityPolicyBlueprint getBlueprint() {
        return this.blueprint;
    }

    protected AlgorithmSuiteInfo getAlgorithmSuiteInfo() {
        return this.algorithmSuiteInfo;
    }

    protected void setAlgorithmSuiteInfo(AlgorithmSuiteInfo algorithmSuiteInfo) {
        this.algorithmSuiteInfo = algorithmSuiteInfo;
    }

    protected void drawPolicySelectionPreference(PolicySelectionPreference policySelectionPreference) {
        if (null == policySelectionPreference) {
            policySelectionPreference = new PolicySelectionPreference();
        }
        this.blueprint.getGeneralPolicy().setPreference(policySelectionPreference);
    }

    protected void drawPolicyCompatibilityPreference(String string, String string2) {
        if (string != null && string.equals("msft")) {
            this.isCompatMSFT = true;
        }
        this.policyNamespaceUri = string2;
        if (verbose) {
            Verbose.log("isCompatMSFT set to " + this.isCompatMSFT);
            Verbose.log("policyNamespaceUri is " + this.policyNamespaceUri);
        }
        this.blueprint.getGeneralPolicy().setCompatMSFT(this.isCompatMSFT);
    }

    protected void drawLayOut(Object object) {
        GeneralPolicy generalPolicy = this.blueprint.getGeneralPolicy();
        if (null == object) {
            if (generalPolicy.getLayout() == null) {
                generalPolicy.setLayoutToLax();
            }
            return;
        }
        if (object instanceof Layout) {
            Layout layout = (Layout)object;
            if (null != layout.getStrict()) {
                generalPolicy.setLayoutToStrict();
            } else if (null != layout.getLaxTsFirst()) {
                generalPolicy.setLayoutToLaxTimestampFirst();
            } else if (null != layout.getLaxTsLast()) {
                generalPolicy.setLayoutToLaxTimestampLast();
            } else {
                generalPolicy.setLayoutToLax();
            }
            return;
        }
        if (object.equals((Object)SecurityBindingPropertiesAssertion.Layout.STRICT)) {
            generalPolicy.setLayoutToStrict();
        } else if (object.equals((Object)SecurityBindingPropertiesAssertion.Layout.LAX_TIMESTAMP_FIRST)) {
            generalPolicy.setLayoutToLaxTimestampFirst();
        } else if (object.equals((Object)SecurityBindingPropertiesAssertion.Layout.LAX_TIMESTAMP_LAST)) {
            generalPolicy.setLayoutToLaxTimestampLast();
        } else {
            generalPolicy.setLayoutToLax();
        }
    }

    protected void drawTimestamp(Object object, Map<String, Object> map) throws SecurityPolicyArchitectureException {
        Object object2;
        TimestampPolicy timestampPolicy = this.blueprint.getTimestampPolicy();
        if (null == object) {
            return;
        }
        if (map != null && (object2 = map.get("weblogic.wsee.security.message_age")) instanceof Integer) {
            timestampPolicy.setMessageAgeSeconds(((Integer)object2).shortValue());
        }
        if ("LaxTimestampFirst".equals(this.blueprint.getGeneralPolicy().getLayout()) || "LaxTimestampFirst".equals(this.blueprint.getGeneralPolicy().getLayout())) {
            timestampPolicy.setIncludeTimestamp(true);
            return;
        }
        if (object instanceof AsymmetricBindingInfo) {
            object2 = (AsymmetricBindingInfo)object;
            if (object2.isTimestampRequired()) {
                if (object2.isTimestampOptional() && !this.isSecurityFirst()) {
                    if (verbose) {
                        Verbose.say("Skip the Timesptamp assertion due to it is optional and security is not a preference");
                    }
                    return;
                }
                timestampPolicy.setIncludeTimestamp(true);
            }
            return;
        }
        if (object instanceof SymmetricBindingInfo) {
            object2 = (SymmetricBindingInfo)object;
            if (object2.isTimestampRequired()) {
                if (object2.isTimestampOptional() && !this.isSecurityFirst()) {
                    if (verbose) {
                        Verbose.say("Skip the Timesptamp assertion due to it is optional and security is not a preference");
                    }
                    return;
                }
                timestampPolicy.setIncludeTimestamp(true);
            }
            return;
        }
        if (object instanceof TransportBindingInfo) {
            object2 = (TransportBindingInfo)object;
            if (object2.isTimestampRequired()) {
                timestampPolicy.setIncludeTimestamp(true);
            }
            return;
        }
        if (object instanceof IncludeTimestamp) {
            timestampPolicy.setIncludeTimestamp(true);
            return;
        }
        throw new SecurityPolicyArchitectureException("unknow object for Timestamp policy ");
    }

    protected void drawTransportToken(HttpsTokenAssertion httpsTokenAssertion) {
        GeneralPolicy generalPolicy = this.blueprint.getGeneralPolicy();
        generalPolicy.setHttpsAssertion(httpsTokenAssertion);
    }

    protected void drawWss11Options(Wss11Options wss11Options, boolean bl) throws SecurityPolicyArchitectureException {
        this.blueprint.setRequest(bl);
        if (null != wss11Options) {
            GeneralPolicy generalPolicy = this.blueprint.getGeneralPolicy();
            generalPolicy.setWss11On();
            generalPolicy.setWss11OptionsAssertion(wss11Options);
            if (!bl && wss11Options.isSignatureConfirmationRequired()) {
                this.addBlueprintAction(128);
            } else {
                generalPolicy.setRequireSignatureConfirmation(false);
            }
        }
    }

    protected void addBlueprintAction(int n) {
        this.blueprint.addActionToBuildingPlan(n);
    }

    protected void drawEncyptedKeyAction() {
        this.blueprint.setEncryptedKeyRequired(true);
        if (this.blueprint.isRequest()) {
            this.addBlueprintAction(288);
        } else {
            this.addBlueprintAction(320);
        }
    }

    protected void drawWss10Options(Wss10Options wss10Options) throws SecurityPolicyArchitectureException {
        if (null != wss10Options) {
            GeneralPolicy generalPolicy = this.blueprint.getGeneralPolicy();
            generalPolicy.setWss10OptionsAssertion(wss10Options);
        }
    }

    protected void drawAsymmetricBindingAlgorithm(AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        SignaturePolicy signaturePolicy = this.blueprint.getSigningPolicy();
        signaturePolicy.setSignatureMethod(algorithmSuiteInfo.getAsymSigUri());
        signaturePolicy.setCanonicalizationMethod(algorithmSuiteInfo.getC14nAlgUri());
        signaturePolicy.setDigestMethod(algorithmSuiteInfo.getDigUri());
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        encryptionPolicy.setEncryptionMethod(algorithmSuiteInfo.getEncUri());
        encryptionPolicy.setKeyWrapMethod(algorithmSuiteInfo.getAsymKwUri());
        encryptionPolicy.setCanonicalizationMethod();
        this.setEndorsingAlgo(algorithmSuiteInfo);
    }

    private void setEndorsingAlgo(AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        SignaturePolicy signaturePolicy = this.blueprint.getEndorsingPolicy();
        signaturePolicy.setSignatureMethod(algorithmSuiteInfo.getAsymSigUri());
        signaturePolicy.setCanonicalizationMethod(algorithmSuiteInfo.getC14nAlgUri());
        signaturePolicy.setDigestMethod(algorithmSuiteInfo.getDigUri());
    }

    public void setSymmetricEndorsingAlgo(AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        if (verbose) {
            Verbose.log("Setting the Endorsing signing algorithm to symmetric signing algorithm ");
        }
        SignaturePolicy signaturePolicy = this.blueprint.getEndorsingPolicy();
        signaturePolicy.setSignatureMethod(algorithmSuiteInfo.getSymSigUri());
        signaturePolicy.setCanonicalizationMethod(algorithmSuiteInfo.getC14nAlgUri());
        signaturePolicy.setDigestMethod(algorithmSuiteInfo.getDigUri());
    }

    protected void drawSymmetricBindingAlgorithm(AlgorithmSuiteInfo algorithmSuiteInfo, boolean bl) throws SecurityPolicyArchitectureException {
        SignaturePolicy signaturePolicy = this.blueprint.getSigningPolicy();
        signaturePolicy.setSignatureMethod(algorithmSuiteInfo.getSymSigUri());
        signaturePolicy.setCanonicalizationMethod(algorithmSuiteInfo.getC14nAlgUri());
        signaturePolicy.setDigestMethod(algorithmSuiteInfo.getDigUri());
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        encryptionPolicy.setEncryptionMethod(algorithmSuiteInfo.getEncUri());
        if (bl) {
            encryptionPolicy.setKeyWrapMethod(algorithmSuiteInfo.getAsymKwUri());
        }
        encryptionPolicy.setCanonicalizationMethod();
        this.setEndorsingAlgo(algorithmSuiteInfo);
        this.algorithmSuiteInfo = algorithmSuiteInfo;
    }

    protected void drawOneSignatureItem(String string) {
        if (!this.blueprint.hasTransportSecuirity()) {
            this.blueprint.getSigningPolicy().addSignatureNode(string, null);
        }
    }

    protected void drawOneEndorseItem(String string) {
        this.blueprint.getEndorsingPolicy().addSignatureNode(string, null);
    }

    protected void drawEncryptBeforeSigning() {
        this.blueprint.getGeneralPolicy().setEncryptBeforeSigning(true);
    }

    protected void drawSignatureProtection(boolean bl) {
        if (bl && !this.isSecurityFirst()) {
            if (verbose) {
                Verbose.say("Skip the TokenProtection assertion due to it is optional and security is not a preference");
            }
        } else {
            this.drawOneEncryptionItem("EncryptSignature");
        }
    }

    protected void drawOneEncryptionItem(String string) {
        if (!this.blueprint.hasTransportSecuirity()) {
            this.blueprint.getEncryptionPolicy().addNode(string, null);
        }
    }

    protected void drawIntegrity(List<IntegrityAssertion> list) throws SecurityPolicyArchitectureException {
        if (this.blueprint.hasTransportSecuirity()) {
            return;
        }
        if (null == list || list.size() == 0) {
            return;
        }
        for (IntegrityAssertion integrityAssertion : list) {
            Collection<Object> collection;
            Object object;
            SignaturePolicy signaturePolicy = this.blueprint.getSigningPolicy();
            if (integrityAssertion.isSignedBodyRequired()) {
                if (integrityAssertion.isSignedBodyOptional() && !this.isSecurityFirst()) {
                    if (verbose) {
                        Verbose.say("Skip the Body Signatre assertion due to it is optional and security is not a preference");
                    }
                } else {
                    this.drawOneSignatureItem("Body");
                }
            }
            if (null != integrityAssertion.getSigningParts() && integrityAssertion.getSigningParts().size() > 0) {
                object = signaturePolicy.getSigningNodeMap();
                if (object.containsKey("Header") && null == object.get("Header")) {
                    if (verbose) {
                        Verbose.log("isEntireHeaderAndBodySignatureRequired() == true, all header elements will be signed");
                    }
                } else {
                    collection = integrityAssertion.getSigningParts();
                    for (Object object2 : collection) {
                        if (object2 == null) continue;
                        signaturePolicy.addQNameExprNode("Header", (QNameExpr)object2);
                    }
                }
            }
            if (integrityAssertion.getSignedElementsPolicy() == null || (collection = ((XPathElements)(object = integrityAssertion.getSignedElementsPolicy())).getXPathExpressions()) == null || collection.size() <= 0) continue;
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(((XPathElements)object).getXPathVersion())) {
                signaturePolicy.addXPathFilter2NodeList("Element", new ArrayList<Object>(collection));
                continue;
            }
            for (Object object2 : collection) {
                signaturePolicy.addXPathNode("Element", (XPath)object2);
            }
        }
    }

    protected void drawConfidentiality(List<ConfidentialityAssertion> list) throws SecurityPolicyArchitectureException {
        if (this.blueprint.hasTransportSecuirity()) {
            return;
        }
        if (null == list || list.size() == 0) {
            return;
        }
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        for (ConfidentialityAssertion confidentialityAssertion : list) {
            if (confidentialityAssertion.isEncryptedBodyRequired()) {
                if (confidentialityAssertion.isEncryptedBodyOptional() && !this.isSecurityFirst()) {
                    if (verbose) {
                        Verbose.say("Skip the Body encryption due to optional and security is not a preference");
                    }
                } else {
                    this.drawOneEncryptionItem("Body");
                }
            }
            if (confidentialityAssertion.isEncryptedHeaderRequired()) {
                boolean bl = false;
                if (null != confidentialityAssertion.getEncryptingParts() && confidentialityAssertion.getEncryptingParts().size() > 0) {
                    Iterator<XPath> iterator = confidentialityAssertion.getEncryptingParts();
                    Iterator iterator2 = iterator.iterator();
                    while (iterator2.hasNext()) {
                        QNameExpr qNameExpr = (QNameExpr)iterator2.next();
                        if (qNameExpr == null) continue;
                        if (qNameExpr.isOptional() && !this.isSecurityFirst()) {
                            if (!verbose) continue;
                            Verbose.say("Skip the Body encryption due to optional and security is not a preference");
                            continue;
                        }
                        bl = true;
                        encryptionPolicy.addQNameExprNode("Header", qNameExpr);
                    }
                }
                if (!bl) {
                    this.drawOneEncryptionItem("Header");
                }
            }
            if (confidentialityAssertion.getEncryptedElementsPolicy() != null) {
                EncryptedElements encryptedElements = confidentialityAssertion.getEncryptedElementsPolicy();
                for (XPath xPath : encryptedElements.getXPathExpressions()) {
                    encryptionPolicy.addXPathNode("Element", xPath);
                }
            }
            if (confidentialityAssertion.getContentEncryptedElementsPolicy() == null) continue;
            ContentEncryptedElements contentEncryptedElements = confidentialityAssertion.getContentEncryptedElementsPolicy();
            for (XPath xPath : contentEncryptedElements.getXPathExpressions()) {
                encryptionPolicy.addXPathNode("Element", xPath);
            }
        }
    }

    protected void drawUsernameToken(UsernameTokenAssertion usernameTokenAssertion, int n, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == usernameTokenAssertion) {
            return;
        }
        TokenAssertion.TokenInclusion tokenInclusion = usernameTokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        if (!bl && !bl2) {
            return;
        }
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(usernameTokenAssertion, bl2);
        if (usernameTokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(usernameTokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(usernameTokenAssertion.getIssuerName());
        }
        boolean bl3 = this.isSignedSupportingToken(n);
        boolean bl4 = this.isEncryptedSupportingToken(n);
        boolean bl5 = this.isEndorsingSupportingToken(n);
        if (!bl4 && bl3 && (this.blueprint.getGeneralPolicy().isCompatMSFT() && SP_NAMESPACE_2005_07.equals(this.policyNamespaceUri) || this.blueprint.getGeneralPolicy().hasTrustOptions() && !usernameTokenAssertion.isHashPasswordRequired() || SP_NAMESPACE_2005_07.equals(this.policyNamespaceUri) && !usernameTokenAssertion.isHashPasswordRequired())) {
            if (verbose) {
                Verbose.log("Forcing encryption for Signed Supporting Username token");
            }
            bl4 = true;
        }
        if (bl4) {
            if (verbose) {
                Verbose.log("Supporting Username token is Encrypted");
            }
            this.drawOneEncryptionItem("UserNameToken");
        }
        if (usernameTokenAssertion.isCreatedRequired() || usernameTokenAssertion.isNonceRequired()) {
            Node node = securityToken.getClaims();
            Element element = null;
            if (null != node) {
                element = weblogic.xml.dom.DOMUtils.getFirstElement(node, SecurityPolicyBuilderConstants.POLICY_USE_PASSWD);
            }
            if (null != element) {
                if (usernameTokenAssertion.isCreatedRequired() && usernameTokenAssertion.isNonceRequired()) {
                    DOMUtils.addAttribute(element, SecurityPolicyBuilderConstants.POLICY_PASSWD_ATTR, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#NonceCreate");
                } else if (usernameTokenAssertion.isCreatedRequired()) {
                    DOMUtils.addAttribute(element, SecurityPolicyBuilderConstants.POLICY_PASSWD_ATTR, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Create");
                } else {
                    DOMUtils.addAttribute(element, SecurityPolicyBuilderConstants.POLICY_PASSWD_ATTR, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Nonce");
                }
            }
        } else if (!(this.blueprint.isForValidator() || usernameTokenAssertion.isHashPasswordRequired() || usernameTokenAssertion.requireDerivedKey() || usernameTokenAssertion.noPasswordRequried() || !this.isSecurityFirst() || bl3 || bl5)) {
            Node node = securityToken.getClaims();
            Element element = null;
            if (null != node) {
                element = weblogic.xml.dom.DOMUtils.getFirstElement(node, SecurityPolicyBuilderConstants.POLICY_USE_PASSWD);
            }
            if (null != element) {
                DOMUtils.addAttribute(element, SecurityPolicyBuilderConstants.POLICY_PASSWD_ATTR, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#NonceCreate");
            }
        }
        if (bl3) {
            if (verbose) {
                Verbose.log("Supporting Username token is Signed");
            }
            this.drawOneSignatureItem("UserNameToken");
        }
        if (bl5) {
            if (verbose) {
                Verbose.log("Supporting Username token is Endorsing");
            }
            throw new SecurityPolicyArchitectureException("Endorsing Supporting Username Token not supported");
        }
        this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
    }

    protected void drawX509Token(X509TokenAssertion x509TokenAssertion, int n, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == x509TokenAssertion) {
            return;
        }
        TokenAssertion.TokenInclusion tokenInclusion = x509TokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        SecurityToken securityToken = n == 2 || n == 3 ? SecurityTokenFactory.makeSecurityTokenForSignature(x509TokenAssertion, bl2, this.blueprint.getGeneralPolicy()) : SecurityTokenFactory.makeSecurityToken(x509TokenAssertion, bl2, this.blueprint.getGeneralPolicy());
        if (x509TokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(x509TokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(x509TokenAssertion.getIssuerName());
        }
        if (x509TokenAssertion.requireDerivedKey() && SUPPORT_DK_ENDORSING_WITH_DK) {
            String[] stringArray = x509TokenAssertion.getDerivedKeyTokenType(this.blueprint.getGeneralPolicy().isWssc13());
            if (stringArray != null) {
                securityToken.setTokenTypeUri(stringArray[0]);
            } else {
                Verbose.say("No token types from DK??");
            }
            securityToken.setDerivedFromTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            securityToken.setEncryptionMethod(this.blueprint.getEncryptionPolicy().getEncryptionMethod());
            EncryptionMethod encryptionMethod = this.blueprint.getEncryptionPolicy().getKeyWrapMethod();
            if (null == encryptionMethod && this.algorithmSuiteInfo != null) {
                try {
                    encryptionMethod = this.blueprint.getXmlEncryptionFactory().newEncryptionMethod(this.algorithmSuiteInfo.getAsymKwUri(), null, null);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
            }
            securityToken.setKeyWrapMethod(encryptionMethod);
            securityToken.setStrTypes(TokenReferenceTypeHelper.getSTRTypesForDK(securityToken.getTokenTypeUri()));
            this.blueprint.getEndorsingPolicy().setSignatureMethod(this.algorithmSuiteInfo.getSymSigUri());
        }
        switch (n) {
            case 3: 
            case 7: {
                this.drawOneSignatureItem("X509Token");
                if (bl2) {
                    this.drawOneEndorseItem("EndoseSignature");
                    this.blueprint.getEndorsingPolicy().addSignatureToken(securityToken);
                }
                return;
            }
            case 2: {
                if (bl2) {
                    this.drawOneEndorseItem("EndoseSignature");
                    this.blueprint.getEndorsingPolicy().addSignatureToken(securityToken);
                }
                return;
            }
            case 1: {
                if (bl2) {
                    this.drawOneSignatureItem("X509Token");
                    this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
                }
                return;
            }
            case 0: 
            case 5: {
                if (bl2) {
                    this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
                }
                return;
            }
        }
    }

    protected void drawSamlToken(SamlTokenAssertion samlTokenAssertion, int n, boolean bl, AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        if (null == samlTokenAssertion) {
            return;
        }
        TokenAssertion.TokenInclusion tokenInclusion = samlTokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        if (!bl && !bl2) {
            return;
        }
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(samlTokenAssertion, bl2, this.getBlueprint().getGeneralPolicy());
        if (samlTokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(samlTokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(samlTokenAssertion.getIssuerName());
        }
        boolean bl3 = false;
        switch (n) {
            case 7: {
                this.drawOneEncryptionItem("SamlToken");
            }
            case 3: {
                this.drawOneSignatureItem("SamlToken");
            }
            case 2: {
                if (this.blueprint.hasTransportSecuirity()) {
                    this.setEndorsingAlgo(algorithmSuiteInfo);
                    this.drawOneEndorseItem("TimeStamp");
                }
                if (bl2 && !this.getBlueprint().hasTransportSecuirity()) {
                    this.drawOneEndorseItem("EndoseSignature");
                }
                this.blueprint.getEndorsingPolicy().addSignatureToken(securityToken);
                break;
            }
            case 4: {
                if (verbose) {
                    Verbose.log("SAML token will be Encrypted");
                }
                this.drawOneEncryptionItem("SamlToken");
            }
            case 1: {
                this.drawOneSignatureItem("SamlToken");
                bl3 = true;
                break;
            }
            case 0: {
                bl3 = true;
            }
        }
        if (bl3) {
            this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
        }
    }

    protected void drawWsscToken(SecureConversationTokenAssertion secureConversationTokenAssertion, int n, boolean bl, AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        if (null == secureConversationTokenAssertion) {
            return;
        }
        TokenAssertion.TokenInclusion tokenInclusion = secureConversationTokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        if (algorithmSuiteInfo == null) {
            algorithmSuiteInfo = this.policy.getAlgorithmSuiteInfo();
        }
        this.setEndorsingAlgo(algorithmSuiteInfo);
        if (this.blueprint.hasTransportSecuirity()) {
            this.blueprint.getEndorsingPolicy().setSignatureMethod(algorithmSuiteInfo.getSymSigUri());
        }
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(secureConversationTokenAssertion, bl2, this.getBlueprint().getGeneralPolicy(), algorithmSuiteInfo);
        if (secureConversationTokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(secureConversationTokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(secureConversationTokenAssertion.getIssuerName());
        }
        switch (n) {
            case 7: {
                if (bl2) {
                    this.drawOneEncryptionItem("SecureConversationTokenToken");
                }
            }
            case 3: {
                if (bl2) {
                    this.drawOneSignatureItem("SecureConversationTokenToken");
                }
            }
            case 2: {
                if (!bl2) break;
                this.blueprint.getEndorsingPolicy().addSignatureToken(securityToken);
                this.drawOneEndorseItem("TimeStamp");
                break;
            }
            case 1: {
                this.drawOneSignatureItem("SecureConversationTokenToken");
                this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
                break;
            }
            case 0: {
                this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
            }
        }
    }

    protected void drawIssuedToken(IssuedTokenAssertion issuedTokenAssertion, int n, boolean bl, AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        if (null == issuedTokenAssertion) {
            return;
        }
        SamlTokenAssertion.ConfirmationMethod confirmationMethod = SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES;
        TokenAssertion.TokenInclusion tokenInclusion = issuedTokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        if (!bl) {
            return;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 7: {
                confirmationMethod = SamlTokenAssertion.ConfirmationMethod.HOLDER_OF_KEY;
                break;
            }
            case 1: {
                confirmationMethod = SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES;
                break;
            }
            default: {
                confirmationMethod = SamlTokenAssertion.ConfirmationMethod.BEARER;
            }
        }
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(issuedTokenAssertion, bl2, this.getBlueprint().getGeneralPolicy(), algorithmSuiteInfo, confirmationMethod);
        if (issuedTokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(issuedTokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(issuedTokenAssertion.getIssuerName());
        }
        switch (n) {
            case 7: {
                this.drawOneEncryptionItem("SamlToken");
            }
            case 3: {
                this.drawOneSignatureItem("SamlToken");
            }
            case 2: {
                if (this.blueprint.hasTransportSecuirity() || securityToken.getDerivedFromTokenType() != null) {
                    this.setSymmetricEndorsingAlgo(algorithmSuiteInfo);
                }
                if (!bl2) break;
                this.drawOneEndorseItem("EndoseSignature");
                this.blueprint.getEndorsingPolicy().addSignatureToken(securityToken);
                break;
            }
            case 4: {
                if (verbose) {
                    Verbose.log("SAML token will be Encrypted");
                }
                this.drawOneEncryptionItem("SamlToken");
            }
            case 1: {
                this.drawOneSignatureItem("SamlToken");
                break;
            }
        }
        this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
    }

    protected void drawKerberosToken(KerberosTokenAssertion kerberosTokenAssertion, int n, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == kerberosTokenAssertion) {
            return;
        }
        TokenAssertion.TokenInclusion tokenInclusion = kerberosTokenAssertion.getTokenInclusion();
        boolean bl2 = SecurityPolicyBlueprintHelper.shouldIncludeToken(tokenInclusion, bl);
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(kerberosTokenAssertion, bl2, this.getBlueprint().getGeneralPolicy());
        if (kerberosTokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(kerberosTokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(kerberosTokenAssertion.getIssuerName());
        }
        switch (n) {
            case 7: {
                this.drawOneEncryptionItem("KerberosToken");
            }
            case 3: {
                this.drawOneSignatureItem("KerberosToken");
                break;
            }
            case 2: {
                this.drawOneEndorseItem("KerberosToken");
                break;
            }
            case 1: {
                this.drawOneSignatureItem("KerberosToken");
                break;
            }
        }
        this.blueprint.getIdentityPolicy().addIdentityToken(securityToken);
    }

    protected void drawSupportingToken(List list, SupportingTokensAssertion.SecurityInfo securityInfo, int n) throws SecurityPolicyArchitectureException {
        Object object;
        boolean bl = false;
        Object object2 = null;
        boolean bl2 = this.blueprint.isRequest();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (!(object instanceof TokenAssertion)) {
                object2 = object;
                Verbose.log("Found Unknown Token Assertion =" + object.toString());
                continue;
            }
            if (((TokenAssertion)object).isOptional() && !this.isSecurityFirst()) {
                Verbose.log("Optional token will not getnerated without security preference set for Token Assertion =" + object.toString());
                bl = true;
                continue;
            }
            if (object instanceof UsernameTokenAssertion) {
                this.drawUsernameToken((UsernameTokenAssertion)object, n, bl2);
                bl = true;
                continue;
            }
            if (object instanceof X509TokenAssertion) {
                this.drawX509Token((X509TokenAssertion)object, n, bl2);
                bl = true;
                continue;
            }
            if (object instanceof SamlTokenAssertion) {
                this.drawSamlToken((SamlTokenAssertion)object, n, bl2, this.algorithmSuiteInfo);
                bl = true;
                continue;
            }
            if (object instanceof SecureConversationTokenAssertion) {
                this.drawWsscToken((SecureConversationTokenAssertion)object, n, bl2, this.algorithmSuiteInfo);
                bl = true;
                continue;
            }
            if (object instanceof IssuedTokenAssertion) {
                this.drawIssuedToken((IssuedTokenAssertion)object, n, bl2, this.algorithmSuiteInfo);
                bl = true;
                continue;
            }
            if (object instanceof KerberosTokenAssertion) {
                this.drawKerberosToken((KerberosTokenAssertion)object, n, bl2);
                bl = true;
                continue;
            }
            object2 = object;
            Verbose.log("Found Unknown Token Assertion" + object.toString());
        }
        if (!bl) {
            throw new SecurityPolicyArchitectureException("Unknown Token found -" + object2.toString());
        }
        object = this.blueprint.getSigningPolicy();
        EncryptionPolicy encryptionPolicy = this.blueprint.getEncryptionPolicy();
        SignaturePolicy signaturePolicy = this.blueprint.getEndorsingPolicy();
        EncryptionPolicy encryptionPolicy2 = this.blueprint.getEncryptionPolicy();
        String string = securityInfo.getSignedXPathVersion();
        String string2 = securityInfo.getEncryptedXPathVersion();
        List<QNameExpr> list2 = securityInfo.getSignedParts();
        List<XPath> list3 = securityInfo.getSignedElements();
        List<QNameExpr> list4 = securityInfo.getEncryptedParts();
        List<XPath> list5 = securityInfo.getEncryptedElements();
        if (securityInfo.isSignedBodyRequired()) {
            if (securityInfo.isSignedBodyOptional() && !this.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("For supporting tokens, skip the Body Signatre assertion due to it is optional and security is not a preference");
                }
            } else if (n == 2 || n == 6) {
                if (signaturePolicy.hasSignatureToken()) {
                    signaturePolicy.addSignatureNode("Body", null);
                }
            } else if (!this.blueprint.hasTransportSecuirity() && object.hasSignatureToken()) {
                object.addSignatureNode("Body", null);
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            Map map = object.getSigningNodeMap();
            if (map.containsKey("Header") && null == map.get("Header")) {
                if (verbose) {
                    Verbose.log("For supporting tokens, isEntireHeaderAndBodySignatureRequired() == true, all header elements will be signed");
                }
            } else {
                for (QNameExpr qNameExpr : list2) {
                    if (qNameExpr == null) continue;
                    if (n == 2 || n == 6) {
                        if (!signaturePolicy.hasSignatureToken()) continue;
                        signaturePolicy.addQNameExprNode("Header", qNameExpr);
                        continue;
                    }
                    if (this.blueprint.hasTransportSecuirity() || !object.hasSignatureToken()) continue;
                    object.addQNameExprNode("Header", qNameExpr);
                }
            }
        }
        if (list3 != null && !list3.isEmpty()) {
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(string)) {
                object.addXPathFilter2NodeList("Element", new ArrayList<XPath>(list3));
            } else {
                for (XPath xPath : list3) {
                    if (n == 2 || n == 6) {
                        if (!signaturePolicy.hasSignatureToken()) continue;
                        signaturePolicy.addXPathNode("Element", xPath);
                        continue;
                    }
                    if (this.blueprint.hasTransportSecuirity() || !object.hasSignatureToken()) continue;
                    object.addXPathNode("Element", xPath);
                }
            }
        }
        if (securityInfo.isEncryptedBodyRequired()) {
            if (securityInfo.isEncryptedBodyOptional() && !this.isSecurityFirst()) {
                if (verbose) {
                    Verbose.say("For supporting tokens, skip the Body encryption due to optional and security is not a preference");
                }
            } else if (n == 2 || n == 6) {
                if (encryptionPolicy2.hasEncryptionToken()) {
                    encryptionPolicy2.addNode("Body", null);
                }
            } else if (!this.blueprint.hasTransportSecuirity() && encryptionPolicy.hasEncryptionToken()) {
                encryptionPolicy.addNode("Body", null);
            }
        }
        if (list4 != null && !list4.isEmpty()) {
            for (QNameExpr qNameExpr : list4) {
                if (qNameExpr == null) continue;
                if (qNameExpr.isOptional() && !this.isSecurityFirst()) {
                    if (!verbose) continue;
                    Verbose.say("For supporting tokens, skip the Body encryption due to optional and security is not a preference");
                    continue;
                }
                if (n == 2 || n == 6) {
                    if (!encryptionPolicy2.hasEncryptionToken()) continue;
                    encryptionPolicy2.addQNameExprNode("Header", qNameExpr);
                    continue;
                }
                if (this.blueprint.hasTransportSecuirity() || !encryptionPolicy.hasEncryptionToken()) continue;
                encryptionPolicy.addQNameExprNode("Header", qNameExpr);
            }
        }
        if (list5 != null && !list5.isEmpty()) {
            for (XPath xPath : list5) {
                if (n == 2 || n == 6) {
                    if (!encryptionPolicy2.hasEncryptionToken()) continue;
                    encryptionPolicy2.addXPathNode("Element", xPath);
                    continue;
                }
                if (this.blueprint.hasTransportSecuirity() || !encryptionPolicy.hasEncryptionToken()) continue;
                encryptionPolicy.addXPathNode("Element", xPath);
            }
        }
    }

    protected void drawTrustOptions(WsTrustOptions wsTrustOptions) {
        this.blueprint.getGeneralPolicy().setTrustOptions(wsTrustOptions);
    }

    protected void drawProtectionAssertion(List<ProtectionAssertion> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (ProtectionAssertion protectionAssertion : list) {
            Object object;
            RequiredParts requiredParts = protectionAssertion.getRequiredPartsPolicy();
            if (requiredParts != null) {
                object = requiredParts.getHeaders().iterator();
                while (object.hasNext()) {
                    Header header = (Header)object.next();
                    this.blueprint.addRequiredPart(new QNameExprImpl(header.getHeaderName(), header.getHeaderNamespaceUri(), header.isOptional() || requiredParts.isOptional()));
                }
            }
            if ((object = protectionAssertion.getRequiredElementsPolicy()) == null) continue;
            for (XPath xPath : ((XPathElements)object).getXPathExpressions()) {
                this.blueprint.addRequiredElement(xPath);
            }
        }
    }

    protected boolean isSecurityFirst() {
        if (null == this.blueprint.getGeneralPolicy().getPreference() || this.blueprint.getGeneralPolicy().getPreference().isDefaut()) {
            return true;
        }
        return this.blueprint.getGeneralPolicy().getPreference().isSecurityFirst();
    }

    private boolean isSignedSupportingToken(int n) {
        return n == 1 || n == 3 || n == 4 || n == 7;
    }

    private boolean isEncryptedSupportingToken(int n) {
        return n == 5 || n == 4 || n == 6 || n == 7;
    }

    private boolean isEndorsingSupportingToken(int n) {
        return n == 2 || n == 3 || n == 6 || n == 7;
    }
}

