/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.security.saml.SAML2TokenHandler;
import weblogic.wsee.security.saml.SAMLTokenHandler;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutlineSketcher;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyOutlineDescriber {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyOutlineDescriber.class);
    private static final boolean debug = false;
    private SecurityPolicyOutlineSketcher outlineSketcher;

    public SecurityPolicyOutlineDescriber(SecurityValidator securityValidator) {
        if (null == securityValidator) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.outlineSketcher = new SecurityPolicyOutlineSketcher();
    }

    public SecurityPolicyPlan getPolicyOutline() {
        return this.outlineSketcher.getOutline();
    }

    public void sketchPolicyOutline(SOAPMessage sOAPMessage, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyInspectionException, MarshalException {
        if (null == sOAPMessage) {
            throw new IllegalArgumentException("Null SOAP MessageContext found");
        }
        this.outlineSketcher.setServiceProvider(bl);
        SOAPSecurityHeaderHelper sOAPSecurityHeaderHelper = new SOAPSecurityHeaderHelper(sOAPMessage);
        Element element = sOAPSecurityHeaderHelper.getSecurityHeaderElement();
        if (null == element) {
            this.outlineSketcher.sketchSecurity(false);
            return;
        }
        this.outlineSketcher.sketchSecurity(true);
        if (null != wSS11Context) {
            wSS11Context.setTokenHandler(new SAMLTokenHandler());
            wSS11Context.setTokenHandler(new SAML2TokenHandler());
        }
        this.outlineSketcher.sketchEncryptedKeyList(sOAPSecurityHeaderHelper.getEncryptionElements(), sOAPSecurityHeaderHelper.getRefListElements());
        List<Element> list = sOAPSecurityHeaderHelper.getSignatrueElements();
        switch (list.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.outlineSketcher.sketchSignatureElelment(list.get(0));
                break;
            }
            case 2: {
                int n = 1;
                if (SecurityPolicyOutlineSketcher.isSignatureElement(list.get(0))) {
                    n = 0;
                }
                this.outlineSketcher.sketchEndorseElement(list.get(1 - n));
                this.outlineSketcher.sketchSignatureElelment(list.get(n));
                break;
            }
            default: {
                throw new SecurityPolicyInspectionException(3909);
            }
        }
        List<Element> list2 = sOAPSecurityHeaderHelper.getOtherElements();
        for (int i = 0; i < list2.size(); ++i) {
            this.outlineSketcher.sketchOuline(list2.get(i));
        }
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                Verbose.log("Error when inspecting SOAP Message: SOAPBody not found");
                throw new WSSecurityException("SOAP Message format error: SOAPBody not found");
            }
            this.outlineSketcher.sketchSoapBody(sOAPBody);
        }
        catch (SOAPException sOAPException) {
            Verbose.log((Object)"Error when inspecting SOAP Body", sOAPException);
            throw new WSSecurityException((Exception)((Object)sOAPException));
        }
    }
}

