/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.saml.SAML2Constants;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutline;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.security.wss.plan.helper.TokenTypeHelper;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.IdentityPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.TimestampPolicy;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.SignedInfoImpl;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.encrypt.ReferenceList;
import weblogic.xml.crypto.encrypt.WLEncryptedKey;
import weblogic.xml.crypto.encrypt.api.DataReference;
import weblogic.xml.crypto.encrypt.api.ReferenceType;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.dom.DOMStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyOutlineSketcher {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyOutlineSketcher.class);
    private static final boolean debug = false;
    private SecurityPolicyPlan outline;
    private int duplicateFlag = 0;
    public static final int ELM_TIMESTAMP = 1;
    public static final int ELM_USERNAME_TOKEN = 2;
    public static final int ELM_SAML_TOKEN = 4;
    public static final int ELM_ENCRYPTED_KEY = 8;
    public static final int ELM_ENCRYPTED_HEADER = 16;
    public static final int ELM_SIGNATURE = 32;
    public static final int ELM_SIGNATURE_CONFRIM = 64;
    public static final int ELM_REFERCE_LIST = 128;
    public static final int ELM_DERIVED_KEY_TOKEN = 256;
    public static final int ELM_DERIVED_KEY_TOKENS = 768;
    public static final int LAYOUT_TS_FIRST = 1024;
    public static final int LAYOUT_TS_LAST = 2048;
    public static final int LAYOUT_STRICT = 4096;
    public static final int ELM_ENCRYPTED_KEYS = 8200;
    public static final int ELM_NONCE = 16384;
    public static final int ELM_CREATED = 32768;
    private boolean isServiceProvider;
    private Map<String, Reference> signatureReference = new HashMap<String, Reference>();
    private Map<String, Reference> endoseSignatureReference = new HashMap<String, Reference>();
    private Map<String, DataReference> encryptionReference = new HashMap<String, DataReference>();
    private Map<String, ReferenceType> encryptionReferenceList = new HashMap<String, ReferenceType>();
    private Map<String, Element> bstReferenceList = new HashMap<String, Element>();

    public boolean isServiceProvider() {
        return this.isServiceProvider;
    }

    public void setServiceProvider(boolean bl) {
        this.isServiceProvider = bl;
    }

    private boolean isDuplicateElement(int n) {
        if ((this.duplicateFlag & n) == n) {
            return true;
        }
        this.duplicateFlag |= n;
        return false;
    }

    public SecurityPolicyOutlineSketcher() {
        this.outline = new SecurityPolicyOutline();
    }

    protected SecurityPolicyOutlineSketcher(SecurityPolicyPlan securityPolicyPlan) {
        this.outline = securityPolicyPlan;
    }

    protected SecurityPolicyPlan getOutline() {
        return this.outline;
    }

    protected void sketchSecurity(boolean bl) {
        if (bl && !this.outline.isRequest()) {
            this.outline.setBuildingPlan(27);
        }
        this.outline.setHasSecurity(bl);
        this.outline.setHasMessageSecurity(bl);
    }

    protected void sketchOuline(Element element) throws SecurityPolicyInspectionException {
        if (null == element) {
            return;
        }
        QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
        if (WSSConstants.UNT_QNAME.equals(qName)) {
            this.sketchUsernameToken(element);
            return;
        }
        if (WSSConstants.TIMESTAMP_QNAME.equals(qName)) {
            this.sketchTimestamp(element);
            return;
        }
        if (WSSConstants.BST_QNAME.equals(qName)) {
            this.sketchBinarySecurityToken(element);
            return;
        }
        if (SAML2Constants.SAML2_ASST_QNAME.equals(qName) || SAMLConstants.SAML_ASST_QNAME.equals(qName)) {
            this.sketchSamlToken(element);
            return;
        }
        if (WSS11Constants.SIG_CONF_QNAME.equals(qName)) {
            this.sketchSignatureConfirmation(element);
            return;
        }
        if (WSS11Constants.ENC_HEADER_QNAME.equals(qName)) {
            this.sketchEncryptedHeader(element);
            return;
        }
        if (SecurityImpl.REFERENCE_LIST_QNAME.equals(qName)) {
            this.sketchReferenceList(element);
            return;
        }
    }

    protected void sketchEncryptedKeyList(List<Element> list, List<Element> list2) throws SecurityPolicyInspectionException, MarshalException {
        int n;
        if (null != list2 && list2.size() > 0) {
            for (n = 0; n < list2.size(); ++n) {
                this.sketchReferenceList(list2.get(n));
            }
        }
        if (null == list || list.size() == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            this.sketchEncryptedKey(list.get(n));
        }
    }

    public static boolean isSignatureElement(Element element) {
        String string = SecurityPolicyOutlineSketcher.getExistingId(element);
        if (null == string || "".equals(string)) {
            return false;
        }
        try {
            List list = SecurityPolicyOutlineSketcher.getKeyInfoList(element);
            if (null == list) {
                return true;
            }
            for (Object e : list) {
                if (!(e instanceof SecurityTokenReference)) continue;
                SecurityTokenReference securityTokenReference = (SecurityTokenReference)e;
                return securityTokenReference.getValueType() == null || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(securityTokenReference.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(securityTokenReference.getValueType()) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(securityTokenReference.getValueType()) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(securityTokenReference.getValueType()) || "http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(securityTokenReference.getValueType()) || "http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(securityTokenReference.getValueType());
            }
        }
        catch (MarshalException marshalException) {
            Verbose.log((Object)"Error on parsing Signature's key info element, while checking it is endorse signature or not", marshalException);
        }
        return true;
    }

    protected void sketchEndorseElement(Element element) throws SecurityPolicyInspectionException, MarshalException {
        SignaturePolicy signaturePolicy = this.outline.getEndorsingPolicy();
        this.sketchOneEndorseItem("EndoseSignature");
        this.sketchSignatureElement(element, signaturePolicy, true);
    }

    protected void sketchSignatureElelment(Element element) throws SecurityPolicyInspectionException, MarshalException {
        SignaturePolicy signaturePolicy = this.outline.getSigningPolicy();
        this.sketchSignatureElement(element, signaturePolicy, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sketchSignatureElement(Element element, SignaturePolicy signaturePolicy, boolean bl) throws SecurityPolicyInspectionException, MarshalException {
        Object object;
        Iterator iterator2;
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(3006);
        }
        if (DOMUtils.is(element2, SecurityImpl.ENCRYPTED_DATA_QNAME)) {
            boolean bl2 = this.isElementInEncryptedDataReferenceList(element2);
            if (!bl2) {
                if (!this.isElementInReferenceList(element2)) throw new SecurityPolicyInspectionException(4206);
                SecurityToken securityToken = new SecurityToken(null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk", true);
                this.outline.getEncryptionPolicy().addEncryptionToken(securityToken);
            }
            this.sketchOneEncryptionItem("EncryptSignature");
            return;
        }
        Element element3 = weblogic.xml.dom.DOMUtils.getFirstElement(element, new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        if (element3 == null) {
            throw new SecurityPolicyInspectionException(3006);
        }
        SignedInfoImpl signedInfoImpl = new SignedInfoImpl();
        ((WLXMLStructure)signedInfoImpl).read(SecurityPolicyOutlineSketcher.getXMLStreamReader(element3));
        signaturePolicy.setSignatureMethod(signedInfoImpl.getSignatureMethod());
        signaturePolicy.setCanonicalizationMethod(signedInfoImpl.getCanonicalizationMethod());
        List list = signedInfoImpl.getReferences();
        for (Iterator iterator2 : list) {
            String string = iterator2.getURI();
            if (null == string || string.length() < 2) continue;
            object = string.substring(1);
            if (bl) {
                this.endoseSignatureReference.put((String)object, (Reference)((Object)iterator2));
                continue;
            }
            this.signatureReference.put((String)object, (Reference)((Object)iterator2));
        }
        List list2 = SecurityPolicyOutlineSketcher.getKeyInfoList(element);
        if (null == list2) {
            return;
        }
        iterator2 = list2.iterator();
        if (!iterator2.hasNext()) return;
        Object e = iterator2.next();
        if (!(e instanceof SecurityTokenReference)) throw new SecurityPolicyInspectionException(3709);
        object = (SecurityTokenReference)e;
        String string = object.getId();
        signaturePolicy.setIncludeSigningTokens(true);
        if (this.signatureReference.get(string) != null) {
            if (bl) {
                this.sketchOneSignatureItem("X509Token");
            } else {
                signaturePolicy.setIncludeSigningTokens(true);
            }
            this.signatureReference.remove(string);
        }
        if (object.getValueType() != null) {
            if (object.getValueType().indexOf("x509") != -1) {
                SecurityToken securityToken = new SecurityToken(null, null, object.getValueType(), true);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(object.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(object.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, object.getValueType(), true);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(object.getValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(object.getValueType())) {
                this.sketchEncyptedKeyAction();
                SecurityToken securityToken = new SecurityToken(null, null, object.getValueType(), true);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(object.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", true);
                List list3 = TokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri(), 1);
                securityToken.setStrTypes(list3);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(object.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk", true);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(object.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct", true);
                signaturePolicy.addSignatureToken(securityToken);
            } else if ("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(object.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk", true);
                signaturePolicy.addSignatureToken(securityToken);
            } else {
                if (!"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(object.getValueType())) throw new SecurityPolicyInspectionException(3609, "Value Type = " + object.getValueType() + " is not supported, ");
                SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct", true);
                signaturePolicy.addSignatureToken(securityToken);
            }
        } else {
            SecurityToken securityToken = new SecurityToken(null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct", true);
            signaturePolicy.addSignatureToken(securityToken);
        }
        signaturePolicy.setSigningNodeMap(this.signatureReference);
    }

    private static List getKeyInfoList(Element element) throws MarshalException {
        Element element2 = weblogic.xml.dom.DOMUtils.getFirstElement(element, new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (element2 == null) {
            return null;
        }
        KeyInfoImpl keyInfoImpl = new KeyInfoImpl();
        keyInfoImpl.read(SecurityPolicyOutlineSketcher.getXMLStreamReader(element2));
        if (null == keyInfoImpl) {
            return null;
        }
        return keyInfoImpl.getContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sketchEncryptedKey(Element element) throws SecurityPolicyInspectionException, MarshalException {
        Iterator iterator;
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(4706);
        }
        Object object = KeyInfoObjectBase.readKeyInfoObject(SecurityPolicyOutlineSketcher.getXMLStreamReader(element));
        WLEncryptedKey wLEncryptedKey = (WLEncryptedKey)object;
        EncryptionPolicy encryptionPolicy = this.outline.getEncryptionPolicy();
        encryptionPolicy.setKeyWrapMethod(wLEncryptedKey.getEncryptionMethod());
        List list = wLEncryptedKey.getReferenceList();
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                iterator = (DataReference)list.get(i);
                String string = iterator.getURI();
                if (null == string || string.length() <= 1) continue;
                this.sketchOneEncryptionItem(string.substring(1));
                this.encryptionReference.put(string.substring(1), (DataReference)((Object)iterator));
            }
        }
        List list2 = SecurityPolicyOutlineSketcher.getKeyInfoList(element);
        if (null == list2) {
            return;
        }
        iterator = list2.iterator();
        if (!iterator.hasNext()) return;
        Object e = iterator.next();
        if (!(e instanceof SecurityTokenReference)) throw new SecurityPolicyInspectionException(4709);
        SecurityTokenReference securityTokenReference = (SecurityTokenReference)e;
        if (securityTokenReference.getValueType() != null) {
            if (securityTokenReference.getValueType().indexOf("x509") != -1) {
                SecurityToken securityToken = new SecurityToken(null, null, securityTokenReference.getValueType(), true);
                encryptionPolicy.addEncryptionToken(securityToken);
                return;
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(securityTokenReference.getValueType())) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", true);
                List list3 = TokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri(), 1);
                securityToken.setStrTypes(list3);
                encryptionPolicy.addEncryptionToken(securityToken);
                return;
            } else {
                if (!TokenTypeHelper.isSamlValueType(securityTokenReference.getValueType())) throw new SecurityPolicyInspectionException(4609);
                SecurityToken securityToken = new SecurityToken(null, null, securityTokenReference.getValueType(), true);
                encryptionPolicy.addEncryptionToken(securityToken);
            }
            return;
        } else {
            if (null == securityTokenReference.getReferenceURI()) return;
            String string = securityTokenReference.getReferenceURI().substring(1);
            if (this.bstReferenceList.get(string) != null) {
                SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", true);
                encryptionPolicy.addEncryptionToken(securityToken);
                return;
            } else {
                this.bstReferenceList.put(string, element);
            }
        }
    }

    protected void sketchUsernameToken(Element element) throws SecurityPolicyInspectionException {
        if (this.isDuplicateElement(2)) {
            throw new SecurityPolicyInspectionException(1025);
        }
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(1026);
        }
        IdentityPolicy identityPolicy = this.outline.getIdentityPolicy();
        SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", true);
        identityPolicy.addIdentityToken(securityToken);
        if ("EncryptedData".equals(element2.getLocalName())) {
            this.sketchOneEncryptionItem("UserNameToken");
        }
        if (this.isElementInSignatureReferenceList(element)) {
            this.sketchOneSignatureItem("UserNameToken");
        }
    }

    protected void sketchSamlToken(Element element) throws SecurityPolicyInspectionException {
        if (this.isDuplicateElement(4)) {
            throw new SecurityPolicyInspectionException(1065);
        }
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(1066);
        }
        IdentityPolicy identityPolicy = this.outline.getIdentityPolicy();
        String string = SAMLUtils.getTokenTypeFromAssertionElement(element);
        SecurityToken securityToken = new SecurityToken(null, null, string, true);
        identityPolicy.addIdentityToken(securityToken);
        if ("EncryptedData".equals(element2.getLocalName())) {
            this.sketchOneEncryptionItem("SamlToken");
        }
        if (this.isElementInSignatureReferenceList(element)) {
            this.sketchOneSignatureItem("SamlToken");
        }
    }

    protected void sketchTimestamp(Element element) throws SecurityPolicyInspectionException {
        if (this.isDuplicateElement(1)) {
            throw new SecurityPolicyInspectionException(6105);
        }
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(6106);
        }
        TimestampPolicy timestampPolicy = this.outline.getTimestampPolicy();
        timestampPolicy.setIncludeTimestamp(true);
    }

    protected void sketchSignatureConfirmation(Element element) throws SecurityPolicyInspectionException {
        Element element2;
        if (this.isDuplicateElement(64) && verbose) {
            Verbose.log("Multiple SignatureConfirmation elements found.");
        }
        if ((element2 = DOMUtils.getFirstElement(element)) != null) {
            throw new SecurityPolicyInspectionException(6306);
        }
        this.outline.getGeneralPolicy().setWss11On();
        this.outline.getGeneralPolicy().setRequireSignatureConfirmation(true);
        this.addBlueprintAction(128);
    }

    protected void sketchEncryptedHeader(Element element) throws SecurityPolicyInspectionException {
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(4306);
        }
        this.outline.getGeneralPolicy().setWss11On();
        this.sketchOneEncryptionItem("Header");
        if (this.isElementInSignatureReferenceList(element)) {
            this.sketchOneSignatureItem("Header");
        }
    }

    protected void sketchSoapBody(SOAPBody sOAPBody) throws SecurityPolicyInspectionException {
        Element element = DOMUtils.getFirstElement((Node)sOAPBody);
        if (null == element) {
            String string = sOAPBody.getAttributeValue(WSSConstants.WSU_ID_QNAME);
            if (string != null && this.signatureReference.get(string) != null) {
                this.outline.getSigningPolicy().addSignatureNode("Body", (Node)sOAPBody);
            }
            ((SecurityPolicyOutline)this.outline).setBodyEmpty(true);
            return;
        }
        if (DOMUtils.is(element, SecurityImpl.ENCRYPTED_DATA_QNAME)) {
            boolean bl = this.isElementInEncryptedDataReferenceList(element);
            if (!bl) {
                if (this.isElementInReferenceList(element)) {
                    SecurityToken securityToken = new SecurityToken(null, null, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk", true);
                    this.outline.getEncryptionPolicy().addEncryptionToken(securityToken);
                } else {
                    throw new SecurityPolicyInspectionException(4206);
                }
            }
            this.sketchOneEncryptionItem("Body");
        }
        if (this.isElementInSignatureReferenceList((Element)element.getParentNode())) {
            this.outline.getSigningPolicy().addSignatureNode("Body", (Element)element.getParentNode());
        }
    }

    protected void sketchReferenceList(Element element) throws SecurityPolicyInspectionException {
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new SecurityPolicyInspectionException(4806);
        }
        Node node = element.getParentNode();
        if (!DOMUtils.is(node, SecurityImpl.ENCRYPTED_KEY_QNAME)) {
            try {
                List list = this.unmarshalReferenceList(element);
                if (null != list && list.size() != 0) {
                    this.outline.getGeneralPolicy().setWss11On();
                    if (this.isServiceProvider) {
                        this.addBlueprintAction(288);
                    } else {
                        this.addBlueprintAction(320);
                    }
                    for (ReferenceType referenceType : list) {
                        String string = referenceType.getURI();
                        if (string == null || string.length() <= 1) continue;
                        this.sketchOneEncryptionItem(string.substring(1));
                        this.encryptionReferenceList.put(string.substring(1), referenceType);
                    }
                } else {
                    Verbose.log("Empyty refernce list found in the header");
                }
            }
            catch (MarshalException marshalException) {
                Verbose.log("Unknow refernce list found in the header");
            }
        }
    }

    private List unmarshalReferenceList(Node node) throws MarshalException {
        try {
            DOMStreamReader dOMStreamReader = new DOMStreamReader(node);
            return ReferenceList.read(dOMStreamReader, false);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    protected void sketchBinarySecurityToken(Element element) throws SecurityPolicyInspectionException {
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 != null) {
            throw new SecurityPolicyInspectionException(2546);
        }
        String string = DOMUtils.getExistingId(element, WSSConstants.BUILTIN_ID_QNAMES);
        if (this.bstReferenceList.get(string) != null) {
            SecurityToken securityToken = new SecurityToken(null, null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", true);
            this.outline.getEncryptionPolicy().addEncryptionToken(securityToken);
        }
        this.bstReferenceList.put(string, element);
        if (this.isElementInSignatureReferenceList(element)) {
            this.sketchOneSignatureItem("X509Token");
        }
    }

    private boolean isElementInSignatureReferenceList(Element element) {
        String string = DOMUtils.getExistingId(element, WSSConstants.BUILTIN_ID_QNAMES);
        return this.signatureReference.get(string) != null;
    }

    private boolean isElementInEncryptedDataReferenceList(Element element) {
        String string = SecurityPolicyOutlineSketcher.getExistingId(element);
        return this.encryptionReference.get(string) != null;
    }

    private boolean isElementInReferenceList(Element element) {
        String string = SecurityPolicyOutlineSketcher.getExistingId(element);
        return this.encryptionReferenceList.get(string) != null;
    }

    private static String getExistingId(Element element) {
        String string = element.getAttribute("Id");
        if (string != null && string.length() > 0) {
            return string;
        }
        return DOMUtils.getExistingId(element, WSSConstants.BUILTIN_ID_QNAMES);
    }

    protected void addBlueprintAction(int n) {
        this.outline.addActionToBuildingPlan(n);
    }

    protected void sketchEncyptedKeyAction() {
        this.outline.setEncryptedKeyRequired(true);
        if (this.outline.isRequest()) {
            this.addBlueprintAction(288);
        } else {
            this.addBlueprintAction(320);
        }
    }

    protected void sketchOneSignatureItem(String string) {
        this.outline.getSigningPolicy().addSignatureNode(string, null);
    }

    protected void sketchOneEndorseItem(String string) {
        this.outline.getEndorsingPolicy().addSignatureNode(string, null);
    }

    protected void sketchSignatureProtection() {
        this.sketchOneEncryptionItem("EncryptSignature");
    }

    protected void sketchOneEncryptionItem(String string) {
        this.outline.getEncryptionPolicy().addNode(string, null);
    }

    private static XMLStreamReader getXMLStreamReader(Node node) throws MarshalException {
        if (null == node) {
            return null;
        }
        DOMStreamReader dOMStreamReader = null;
        try {
            dOMStreamReader = new DOMStreamReader(node);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to create XMLStreamReader from " + node.getNodeName(), xMLStreamException);
        }
        return dOMStreamReader;
    }
}

