/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan;

import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wss.policy.IdentityPolicy;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.TimestampPolicy;
import weblogic.wsee.security.wss.policy.wssp.GeneralPolicyImpl;
import weblogic.wsee.security.wss.policy.wssp.IdentityPolicyImpl;
import weblogic.wsee.security.wss.policy.wssp.TimestampPolicyImpl;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.BSTUtils;

public class SecurityPolicyPlanImpl
implements SecurityPolicyPlan {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyPlanImpl.class);
    private static final boolean debug = false;
    private boolean isRequest;
    private boolean isSymmeticPlan = false;
    private boolean isEncryptedKeyRequired = false;
    private boolean hasSecurity = true;
    private boolean hasMessageSecurity;
    protected boolean isBodyEmpty = false;
    private int buildingPlan = 0;
    protected PolicyAlternative policyAlternative;
    protected EncryptionPolicy encryptionPolicy;
    protected SignaturePolicy signingPolicy;
    protected IdentityPolicy identityPolicy;
    protected TimestampPolicy timestampPolicy;
    protected GeneralPolicy generalPolicy = new GeneralPolicyImpl();
    protected SignaturePolicy endorsingPolicy;
    private SecurityToken policyIdToken;

    public SecurityPolicyPlanImpl() {
        this.timestampPolicy = new TimestampPolicyImpl();
        this.identityPolicy = new IdentityPolicyImpl();
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public void setRequest(boolean bl) {
        this.isRequest = bl;
    }

    public boolean isHasSecurity() {
        return this.hasSecurity;
    }

    public void setHasSecurity(boolean bl) {
        this.hasSecurity = bl;
    }

    public boolean isHasMessageSecurity() {
        return this.hasMessageSecurity;
    }

    public void setHasMessageSecurity(boolean bl) {
        this.hasMessageSecurity = bl;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public SignaturePolicy getSigningPolicy() {
        return this.signingPolicy;
    }

    public void setSigningPolicy(SignaturePolicy signaturePolicy) {
        this.signingPolicy = signaturePolicy;
    }

    public SignaturePolicy getEndorsingPolicy() {
        return this.endorsingPolicy;
    }

    public void setEndorsingPolicy(SignaturePolicy signaturePolicy) {
        this.endorsingPolicy = signaturePolicy;
    }

    public int getBuildingPlan() {
        return this.buildingPlan;
    }

    public void setBuildingPlan(int n) {
        this.buildingPlan = n;
    }

    public void addActionToBuildingPlan(int n) {
        this.buildingPlan |= n;
    }

    public IdentityPolicy getIdentityPolicy() {
        return this.identityPolicy;
    }

    public void setIdentityPolicy(IdentityPolicy identityPolicy) {
        this.identityPolicy = identityPolicy;
    }

    public GeneralPolicy getGeneralPolicy() {
        return this.generalPolicy;
    }

    public void setGeneralPolicy(GeneralPolicy generalPolicy) {
        this.generalPolicy = generalPolicy;
    }

    public TimestampPolicy getTimestampPolicy() {
        return this.timestampPolicy;
    }

    public SecurityToken getPolicyIdToken() {
        return this.policyIdToken;
    }

    public void setPolicyIdToken(SecurityToken securityToken) {
        this.policyIdToken = securityToken;
    }

    public GeneralPolicy getGenrealPolicy() {
        return this.generalPolicy;
    }

    public void setGenrealPolicy(GeneralPolicy generalPolicy) {
        this.generalPolicy = generalPolicy;
    }

    public boolean isX509AuthConditional() {
        if (!this.signingPolicy.isX509AuthConditional()) {
            return false;
        }
        return this.policyIdToken == null || !BSTUtils.isX509Type(this.policyIdToken.getTokenTypeUri());
    }

    public boolean isSymmeticPlan() {
        return this.isSymmeticPlan;
    }

    public void setSymmeticPlan(boolean bl) {
        this.isSymmeticPlan = bl;
    }

    public boolean isEncryptedKeyRequired() {
        return this.isEncryptedKeyRequired;
    }

    public void setEncryptedKeyRequired(boolean bl) {
        this.isEncryptedKeyRequired = bl;
    }

    public boolean isBodyEmpty() {
        return false;
    }

    public PolicyAlternative getPolicyAlternative() {
        return this.policyAlternative;
    }

    public void setPolicyAlternative(PolicyAlternative policyAlternative) {
        this.policyAlternative = policyAlternative;
    }

    public boolean hasTransportSecuirity() {
        return this.generalPolicy.isHTTPsRequired();
    }
}

