/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.fact;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.XBeanUtils;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.saml.SAMLIssuedTokenHelper;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenTypeFactory;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.security.wss.plan.helper.TokenTypeHelper;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wssc.dk.DKClaims;
import weblogic.wsee.security.wssp.AlgorithmSuiteInfo;
import weblogic.wsee.security.wssp.IssuedTokenAssertion;
import weblogic.wsee.security.wssp.KerberosTokenAssertion;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.TokenAssertion;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;

public class SecurityTokenFactory {
    private static final boolean verbose = Verbose.isVerbose(SecurityTokenFactory.class);
    private static final boolean debug = false;
    public static final String KERBEROS_TOKEN_PROFILE_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1";
    public static final String KERBEROS_TOKEN_PROFILE_V5_AP_REQ_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ";
    public static final String KERBEROS_TOKEN_PROFILE_GSS_V5_AP_REQ_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";

    public static SecurityToken makeSecurityToken(SecurityTokenType securityTokenType) {
        if (null == securityTokenType) {
            return null;
        }
        SecurityToken securityToken = new SecurityToken(XBeanUtils.getElement(securityTokenType), null, securityTokenType.getTokenType(), securityTokenType.getIncludeInMessage());
        securityToken.setDerivedFromTokenType(securityTokenType.getDerivedFromTokenType());
        return securityToken;
    }

    private static void setIssuerAndOptional(SecurityToken securityToken, TokenAssertion tokenAssertion) {
        if (tokenAssertion.getIssuer() != null) {
            securityToken.setTokenIssuer(tokenAssertion.getIssuer());
        } else {
            securityToken.setIssuerName(tokenAssertion.getIssuerName());
        }
        securityToken.setOptional(tokenAssertion.isOptional());
    }

    public static SecurityToken makeSecurityTokenForSignature(X509TokenAssertion x509TokenAssertion, boolean bl, GeneralPolicy generalPolicy) throws SecurityPolicyArchitectureException {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityTokenInternal(x509TokenAssertion, bl, generalPolicy);
        TokenReferenceTypeHelper tokenReferenceTypeHelper = new TokenReferenceTypeHelper(generalPolicy, x509TokenAssertion);
        if (bl) {
            securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeListForSignature(securityToken.getTokenTypeUri()));
        } else {
            securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri()));
        }
        return securityToken;
    }

    public static SecurityToken makeSecurityTokenInternal(X509TokenAssertion x509TokenAssertion, boolean bl, GeneralPolicy generalPolicy) throws SecurityPolicyArchitectureException {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(SecurityTokenTypeFactory.makeSecurityTokenType(x509TokenAssertion.getX509TokenType(), bl));
        SecurityTokenFactory.setIssuerAndOptional(securityToken, x509TokenAssertion);
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(X509TokenAssertion x509TokenAssertion, boolean bl, GeneralPolicy generalPolicy) throws SecurityPolicyArchitectureException {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityTokenInternal(x509TokenAssertion, bl, generalPolicy);
        TokenReferenceTypeHelper tokenReferenceTypeHelper = new TokenReferenceTypeHelper(generalPolicy, x509TokenAssertion);
        securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri()));
        return securityToken;
    }

    public static SecurityToken makeSecurityTokenForSignatureResponse(X509TokenAssertion x509TokenAssertion, boolean bl, GeneralPolicy generalPolicy, boolean bl2) throws SecurityPolicyArchitectureException {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityTokenInternal(x509TokenAssertion, bl, generalPolicy);
        TokenReferenceTypeHelper tokenReferenceTypeHelper = new TokenReferenceTypeHelper(generalPolicy, x509TokenAssertion);
        if (bl2) {
            securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeListForValidation(securityToken.getTokenTypeUri()));
        } else if (bl) {
            securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeListForSignature(securityToken.getTokenTypeUri()));
        } else {
            securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri()));
        }
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(UsernameTokenAssertion usernameTokenAssertion, boolean bl) throws SecurityPolicyArchitectureException {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(SecurityTokenTypeFactory.makeSecurityTokenType(usernameTokenAssertion, bl));
        SecurityTokenFactory.setIssuerAndOptional(securityToken, usernameTokenAssertion);
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(SamlTokenAssertion samlTokenAssertion, boolean bl, GeneralPolicy generalPolicy) throws SecurityPolicyArchitectureException {
        String string = TokenTypeHelper.getSamlConfirmationMethod(samlTokenAssertion);
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(SecurityTokenTypeFactory.makeSecurityTokenType(samlTokenAssertion.getSamlTokenType(), bl, string));
        securityToken.setStrTypes(TokenReferenceTypeHelper.getSTRTypesForSAML(samlTokenAssertion.getSamlTokenType()));
        SecurityTokenFactory.setIssuerAndOptional(securityToken, samlTokenAssertion);
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(KerberosTokenAssertion kerberosTokenAssertion, boolean bl, GeneralPolicy generalPolicy) throws SecurityPolicyArchitectureException {
        String string = null;
        if (kerberosTokenAssertion.requireDerivedKey()) {
            string = kerberosTokenAssertion.requireExplicitDerivedKey() ? "Explicit" : "Implicit";
        }
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(SecurityTokenTypeFactory.makeSecurityTokenType(KERBEROS_TOKEN_PROFILE_VALUE_TYPE, string, bl));
        TokenReferenceTypeHelper tokenReferenceTypeHelper = new TokenReferenceTypeHelper(generalPolicy, kerberosTokenAssertion);
        securityToken.setStrTypes(tokenReferenceTypeHelper.getSTRTypeList(securityToken.getTokenTypeUri()));
        SecurityTokenFactory.setIssuerAndOptional(securityToken, kerberosTokenAssertion);
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(SecureConversationTokenAssertion secureConversationTokenAssertion, boolean bl, GeneralPolicy generalPolicy, AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        Object object;
        SecurityToken securityToken = new SecurityToken();
        securityToken.setBootstrapPolicy(secureConversationTokenAssertion.getNormalizedBootstrapPolicy());
        if (secureConversationTokenAssertion.requireDerivedKey()) {
            securityToken.setTokenTypeUri(secureConversationTokenAssertion.getDkTokenType());
            securityToken.setDerivedFromTokenType(secureConversationTokenAssertion.getSctTokenType());
            securityToken.setIncludeInMessage(true);
            securityToken.setIncludeDerivedFromInMessage(bl);
            object = DKClaims.makeDKClaimsNode(generalPolicy, null, algorithmSuiteInfo);
            securityToken.setClaims((Node)object);
        } else {
            securityToken.setTokenTypeUri(secureConversationTokenAssertion.getSctTokenType());
            securityToken.setIncludeInMessage(bl);
        }
        object = new TokenReferenceTypeHelper(generalPolicy, secureConversationTokenAssertion);
        securityToken.setStrTypes(((TokenReferenceTypeHelper)object).getSTRTypeList(securityToken.getTokenTypeUri()));
        SecurityTokenFactory.setIssuerAndOptional(securityToken, secureConversationTokenAssertion);
        return securityToken;
    }

    public static SecurityToken makeSecurityToken(IssuedTokenAssertion issuedTokenAssertion, boolean bl, GeneralPolicy generalPolicy, AlgorithmSuiteInfo algorithmSuiteInfo, SamlTokenAssertion.ConfirmationMethod confirmationMethod) throws SecurityPolicyArchitectureException {
        Node node;
        SecurityToken securityToken = new SecurityToken();
        String string = SAMLIssuedTokenHelper.getTrustVersionFromPolicy(generalPolicy);
        String string2 = confirmationMethod.toString();
        boolean bl2 = issuedTokenAssertion.requireDerivedKey();
        if (bl2) {
            if (verbose) {
                Verbose.log("The IssuedToken requireDerivedKey() = " + bl2 + " setting DerivedFromTokenType = " + issuedTokenAssertion.getIssuedTokenType());
            }
            securityToken.setTokenTypeUri(issuedTokenAssertion.getDkTokenType());
            securityToken.setDerivedFromTokenType(issuedTokenAssertion.getIssuedTokenType());
            securityToken.setIncludeInMessage(true);
            securityToken.setIncludeDerivedFromInMessage(bl);
            node = DKClaims.makeDKClaimsNode(generalPolicy, null, algorithmSuiteInfo);
            securityToken.setStrTypesForDKBaseToken(securityToken.getStrTypes());
            securityToken.setStrTypes(TokenReferenceTypeHelper.getSTRTypesForDK(securityToken.getTokenTypeUri()));
        } else {
            securityToken.setStrTypes(TokenReferenceTypeHelper.getSTRTypesForSAMLIssuedToken(issuedTokenAssertion.getIssuedTokenType()));
            securityToken.setTokenTypeUri(issuedTokenAssertion.getIssuedTokenType());
            securityToken.setIncludeInMessage(bl);
            node = DKClaims.makeClaimsNode();
        }
        Element element = SAMLIssuedTokenHelper.makeIssuedTokenClaimElement(issuedTokenAssertion, node, string);
        node.appendChild(element);
        securityToken.setClaims(node);
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer".equals(SAMLIssuedTokenHelper.getTrustKeyTypeFromIssuedTokenClaims(node)) && !SamlTokenAssertion.ConfirmationMethod.BEARER.toString().equals(string2)) {
            if (verbose) {
                Verbose.log("Changed the subject confirmation method from " + string2 + " to " + SamlTokenAssertion.ConfirmationMethod.BEARER.toString());
            }
            string2 = SamlTokenAssertion.ConfirmationMethod.BEARER.toString();
        }
        Element element2 = DOMUtils.createAndAddElement((Element)node, SAMLConstants.CONFIRMATION_METHOD_QNAME, node.getPrefix());
        DOMUtils.addText(element2, string2);
        SecurityTokenFactory.setIssuerAndOptional(securityToken, issuedTokenAssertion);
        return securityToken;
    }
}

