/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.fact;

import java.io.StringReader;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.wss.plan.helper.TokenTypeHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SecurityPolicyBuilderConstants;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;

public class SecurityTokenTypeFactory {
    private static final boolean verbose = Verbose.isVerbose(SecurityTokenTypeFactory.class);
    private static final boolean debug = false;
    private static Stack<DocumentBuilder> pool = new Stack();
    public static final String DK_VALUE_TYPE_V2005 = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
    public static final String SCT_VALUE_TYPE_V2005 = "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
    public static final String DK_VALUE_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk";
    public static final String SCT_VALUE_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";

    public static SecurityTokenType makeSecurityTokenType() {
        return SecurityTokenType.Factory.newInstance();
    }

    public static SecurityTokenType makeSecurityTokenType(X509TokenAssertion.TokenType tokenType, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == tokenType) {
            return null;
        }
        SecurityTokenType securityTokenType = SecurityTokenTypeFactory.makeSecurityTokenType();
        securityTokenType.setIncludeInMessage(bl);
        if (tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_V3_TOKEN_10) || tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_V3_TOKEN_11)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        } else if (tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_V1_TOKEN_11)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1");
        } else if (tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_PKIPATH_V1_TOKEN_10) || tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_PKIPATH_V1_TOKEN_11)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1");
        } else if (tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_PKCS7_TOKEN_10) || tokenType.equals((Object)X509TokenAssertion.TokenType.WSS_X509_PKCS7_TOKEN_11)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7");
        } else {
            throw new SecurityPolicyArchitectureException("Unsuported X509 Token Type found.");
        }
        return securityTokenType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityTokenType makeSecurityTokenType(UsernameTokenAssertion usernameTokenAssertion, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == usernameTokenAssertion) {
            return null;
        }
        UsernameTokenAssertion.TokenType tokenType = usernameTokenAssertion.getUsernameTokenType();
        SecurityTokenType securityTokenType = SecurityTokenTypeFactory.makeSecurityTokenType(tokenType, bl);
        DocumentBuilder documentBuilder = null;
        try {
            try {
                documentBuilder = SecurityTokenTypeFactory.getParser();
                Document document = documentBuilder.parse(new InputSource(new StringReader(securityTokenType.toString())));
                Element element = document.getDocumentElement();
                if (!usernameTokenAssertion.noPasswordRequried()) {
                    Element element2 = DOMUtils.createAndAddElement(element, SecurityPolicyBuilderConstants.POLICY_USE_PASSWD, SecurityPolicyBuilderConstants.POLICY_PASSWD_TYPE.getPrefix());
                    if (usernameTokenAssertion.isHashPasswordRequired()) {
                        DOMUtils.addAttribute(element2, SecurityPolicyBuilderConstants.POLICY_PASSWD_TYPE, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                    } else {
                        DOMUtils.addAttribute(element2, SecurityPolicyBuilderConstants.POLICY_PASSWD_TYPE, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                    }
                    securityTokenType = SecurityTokenType.Factory.parse(element);
                }
                if (usernameTokenAssertion.requireDerivedKey()) {
                    if (usernameTokenAssertion.requireExplicitDerivedKey()) {
                        securityTokenType.setDerivedFromTokenType("????");
                    }
                    if (!usernameTokenAssertion.requireExplicitDerivedKey()) throw new SecurityPolicyArchitectureException("Username Token DerivedKey is not supported");
                    securityTokenType.setDerivedFromTokenType("????");
                    throw new SecurityPolicyArchitectureException("Username Token DerivedKey is not supported");
                }
                Object var9_9 = null;
                if (documentBuilder == null) return securityTokenType;
            }
            catch (Exception exception) {
                throw new SecurityPolicyArchitectureException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (documentBuilder == null) throw throwable;
            SecurityTokenTypeFactory.returnParser(documentBuilder);
            throw throwable;
        }
        SecurityTokenTypeFactory.returnParser(documentBuilder);
        return securityTokenType;
    }

    private static SecurityTokenType makeSecurityTokenType(UsernameTokenAssertion.TokenType tokenType, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == tokenType) {
            return null;
        }
        SecurityTokenType securityTokenType = SecurityTokenTypeFactory.makeSecurityTokenType();
        securityTokenType.setIncludeInMessage(bl);
        if (tokenType.equals((Object)UsernameTokenAssertion.TokenType.WSS_UT_10)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        } else if (tokenType.equals((Object)UsernameTokenAssertion.TokenType.WSS_UT_11)) {
            securityTokenType.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        } else {
            throw new SecurityPolicyArchitectureException("Unsuported Username Token Type found.");
        }
        return securityTokenType;
    }

    public static SecurityTokenType makeSecurityTokenType(SamlTokenAssertion.TokenType tokenType, boolean bl, String string) throws SecurityPolicyArchitectureException {
        SecurityTokenType securityTokenType;
        block5: {
            if (null == tokenType) {
                return null;
            }
            SecurityTokenType securityTokenType2 = SecurityTokenTypeFactory.makeSecurityTokenType();
            securityTokenType2.setIncludeInMessage(bl);
            securityTokenType2.setTokenType(TokenTypeHelper.getSamlValueTokenType(tokenType));
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = SecurityTokenTypeFactory.getParser();
                Document document = documentBuilder.parse(new InputSource(new StringReader(securityTokenType2.toString())));
                Element element = document.getDocumentElement();
                Element element2 = DOMUtils.createAndAddElement(element, new QName("http://www.bea.com/wls90/security/policy", "Claims"), "wssp");
                Element element3 = DOMUtils.createAndAddElement(element2, SAMLConstants.CONFIRMATION_METHOD_QNAME, element2.getPrefix());
                DOMUtils.addText(element3, string);
                securityTokenType = securityTokenType2 = SecurityTokenType.Factory.parse(element);
                Object var11_11 = null;
                if (documentBuilder == null) break block5;
            }
            catch (Exception exception) {
                try {
                    throw new SecurityPolicyArchitectureException(exception);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var11_12 = null;
                        if (documentBuilder == null) break block6;
                        SecurityTokenTypeFactory.returnParser(documentBuilder);
                    }
                    throw throwable;
                }
            }
            SecurityTokenTypeFactory.returnParser(documentBuilder);
        }
        return securityTokenType;
    }

    public static SecurityTokenType makeDerivedFromSecurityTokenType(boolean bl, int n) throws SecurityPolicyArchitectureException {
        SecurityTokenType securityTokenType;
        block4: {
            SecurityTokenType securityTokenType2 = SecurityTokenTypeFactory.makeSecurityTokenType();
            securityTokenType2.setTokenType(DK_VALUE_TYPE_V2005);
            securityTokenType2.setIncludeInMessage(bl);
            securityTokenType2.setDerivedFromTokenType(SCT_VALUE_TYPE_V2005);
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = SecurityTokenTypeFactory.getParser();
                Document document = documentBuilder.parse(new InputSource(new StringReader(securityTokenType2.toString())));
                Element element = document.getDocumentElement();
                Element element2 = DOMUtils.createAndAddElement(element, new QName("http://www.bea.com/wls90/security/policy", "Claims"), "wssp");
                Element element3 = DOMUtils.createAndAddElement(element2, new QName("http://www.bea.com/wls90/security/policy", "Label"), element2.getPrefix());
                DOMUtils.addText(element3, "WS-SecureConversationWS-SecureConversation");
                Element element4 = DOMUtils.createAndAddElement(element2, new QName("http://www.bea.com/wls90/security/policy", "Length"), element2.getPrefix());
                DOMUtils.addText(element4, "" + n);
                securityTokenType = securityTokenType2 = SecurityTokenType.Factory.parse(element);
                Object var11_11 = null;
                if (documentBuilder == null) break block4;
            }
            catch (Exception exception) {
                try {
                    throw new SecurityPolicyArchitectureException(exception);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var11_12 = null;
                        if (documentBuilder == null) break block5;
                        SecurityTokenTypeFactory.returnParser(documentBuilder);
                    }
                    throw throwable;
                }
            }
            SecurityTokenTypeFactory.returnParser(documentBuilder);
        }
        return securityTokenType;
    }

    public static SecurityTokenType makeSecurityTokenType(String string, String string2, boolean bl) {
        if (null == string) {
            return null;
        }
        SecurityTokenType securityTokenType = SecurityTokenTypeFactory.makeSecurityTokenType();
        securityTokenType.setIncludeInMessage(bl);
        securityTokenType.setTokenType(string);
        if (null != string2) {
            securityTokenType.setDerivedFromTokenType(string2);
        }
        return securityTokenType;
    }

    private static DocumentBuilder createNewParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException(factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getParser() {
        DocumentBuilder documentBuilder = null;
        Stack<DocumentBuilder> stack = pool;
        synchronized (stack) {
            documentBuilder = pool.empty() ? SecurityTokenTypeFactory.createNewParser() : pool.pop();
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void returnParser(DocumentBuilder documentBuilder) {
        Stack<DocumentBuilder> stack = pool;
        synchronized (stack) {
            pool.push(documentBuilder);
        }
    }
}

