/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.helper;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.security.saml.SAML2Constants;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.wssc.v200502.WSCConstants;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.dom.DOMProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPSecurityHeaderHelper {
    private static final boolean verbose = Verbose.isVerbose(SOAPSecurityHeaderHelper.class);
    private static final boolean debug = false;
    private boolean hasSorted = false;
    private List<Element> signatureElements = null;
    private List<Element> encryptionElements = null;
    private List<Element> refListElements = null;
    private List<Element> otherElements = null;
    private List<Element> allElements = null;
    private Element securityHeader = null;
    private SOAPMessage soap;

    public SOAPSecurityHeaderHelper(SOAPMessage sOAPMessage) throws WSSecurityException {
        this.soap = sOAPMessage;
        this.securityHeader = SOAPSecurityHeaderHelper.getSecurityElement(sOAPMessage);
    }

    public SOAPSecurityHeaderHelper(SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        this.soap = sOAPMessageContext.getMessage();
        this.securityHeader = SOAPSecurityHeaderHelper.getSecurityElement(sOAPMessageContext);
    }

    public static Element getSecurityElement(SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        Element element = null;
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        if (wSSecurityContext != null) {
            element = wSSecurityContext.getSecurityElement();
        }
        if (element == null) {
            return SOAPSecurityHeaderHelper.getSecurityElement(sOAPMessageContext.getMessage());
        }
        return element;
    }

    public static Element getSecurityElement(SOAPMessage sOAPMessage) throws WSSecurityException {
        try {
            if (null == sOAPMessage.getSOAPHeader()) {
                return null;
            }
            NodeList nodeList = sOAPMessage.getSOAPHeader().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            if (nodeList.getLength() > 0) {
                return (Element)nodeList.item(0);
            }
        }
        catch (SOAPException sOAPException) {
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
        return null;
    }

    public static List getNonSecurityElements(SOAPMessage sOAPMessage, QNameExpr qNameExpr) throws WSSecurityException {
        return SOAPSecurityHeaderHelper.getNonSecurityElements(sOAPMessage, qNameExpr, false);
    }

    public static List getNonSecurityElements(SOAPMessage sOAPMessage, QNameExpr qNameExpr, boolean bl) throws WSSecurityException {
        try {
            NodeList nodeList;
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (null == sOAPHeader) {
                return null;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            String string = null;
            QName qName = null;
            if (null != qNameExpr) {
                if (qNameExpr.getLocalName() != null && qNameExpr.getLocalName().length() > 0) {
                    qName = new QName(qNameExpr.getNamespaceUri(), qNameExpr.getLocalName());
                } else {
                    string = qNameExpr.getNamespaceUri();
                }
            }
            if (null == (nodeList = sOAPHeader.getChildNodes()) || nodeList.getLength() == 0) {
                return null;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1 || DOMUtils.is(node, WSSConstants.SECURITY_QNAME)) continue;
                if (bl && DOMUtils.is(node, WSS11Constants.ENC_HEADER_QNAME)) {
                    node = DOMUtils.getFirstElement(node);
                }
                if (qName != null) {
                    if (!DOMUtils.is(node, qName)) continue;
                    arrayList.add(node);
                    continue;
                }
                if (string != null) {
                    if (!string.equals(node.getNamespaceURI())) continue;
                    arrayList.add(node);
                    continue;
                }
                arrayList.add(node);
            }
            return arrayList;
        }
        catch (SOAPException sOAPException) {
            throw new WSSecurityException(sOAPException.getMessage(), (Exception)((Object)sOAPException));
        }
    }

    public Element getSecurityHeaderElement() {
        return this.securityHeader;
    }

    public Element getScToken13Element() {
        return this.getSecurityElement(weblogic.wsee.security.wssc.v13.WSCConstants.SCT_QNAME);
    }

    public Element getScTokenElement() {
        return this.getSecurityElement(WSCConstants.SCT_QNAME);
    }

    public Element getSamlTokenElement() {
        return this.getSecurityElement(SAMLConstants.SAML_ASST_QNAME);
    }

    public Element getSaml2TokenElement() {
        return this.getSecurityElement(SAML2Constants.SAML2_ASST_QNAME);
    }

    public Element getSaml11Or20TokenElement() {
        if (null != this.getSamlTokenElement()) {
            return this.getSamlTokenElement();
        }
        return this.getSaml2TokenElement();
    }

    public Element getUsernameTokenElement() {
        return this.getSecurityElement(WSSConstants.UNT_QNAME);
    }

    public Element getTimestampElement() {
        return this.getSecurityElement(WSSConstants.TIMESTAMP_QNAME);
    }

    public Element getSignatrueElement() {
        if (null == this.securityHeader) {
            return null;
        }
        return SOAPSecurityHeaderHelper.getFirstChildElement(this.securityHeader.getFirstChild(), DsigConstants.SIGNATURE_QNAME);
    }

    public List getSignatrueConfirmationElements() {
        if (null == this.securityHeader) {
            return null;
        }
        Element element = DOMUtils.getFirstElement(this.securityHeader);
        ArrayList<Element> arrayList = new ArrayList<Element>(1);
        while (element != null) {
            if (DOMUtils.is(element, WSS11Constants.SIG_CONF_QNAME)) {
                arrayList.add(element);
            }
            element = DOMUtils.getNextElement(element);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public Element getReferenceListElement() {
        return this.getSecurityElement(SecurityImpl.REFERENCE_LIST_QNAME);
    }

    public List getDerivedKeyTokenElements() {
        if (null == this.securityHeader) {
            return null;
        }
        Element element = DOMUtils.getFirstElement(this.securityHeader);
        ArrayList<Element> arrayList = new ArrayList<Element>(1);
        while (element != null) {
            if ("DerivedKeyToken".equals(element.getLocalName())) {
                arrayList.add(element);
            }
            element = DOMUtils.getNextElement(element);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public List<Element> getAllElements() {
        this.sortItOut();
        return this.allElements;
    }

    public List<Element> getSignatrueElements() {
        this.sortItOut();
        return this.signatureElements;
    }

    public List<Element> getEncryptionElements() {
        this.sortItOut();
        return this.encryptionElements;
    }

    public List<Element> getRefListElements() {
        this.sortItOut();
        return this.refListElements;
    }

    public List<Element> getOtherElements() {
        this.sortItOut();
        return this.otherElements;
    }

    private void sortItOut() {
        if (this.hasSorted) {
            return;
        }
        this.hasSorted = true;
        if (null == this.securityHeader) {
            return;
        }
        this.signatureElements = new ArrayList<Element>();
        this.encryptionElements = new ArrayList<Element>();
        this.refListElements = new ArrayList<Element>();
        this.otherElements = new ArrayList<Element>();
        this.allElements = new ArrayList<Element>();
        Element element = DOMUtils.getFirstElement(this.securityHeader);
        while (element != null) {
            this.allElements.add(element);
            if (DOMUtils.is(element, DsigConstants.SIGNATURE_QNAME)) {
                this.signatureElements.add(element);
            } else if (DOMUtils.is(element, SecurityImpl.ENCRYPTED_KEY_QNAME)) {
                this.encryptionElements.add(element);
            } else if (DOMUtils.is(element, SecurityImpl.REFERENCE_LIST_QNAME)) {
                this.refListElements.add(element);
            } else {
                this.otherElements.add(element);
            }
            element = DOMUtils.getNextElement(element);
        }
    }

    public Element getSecurityElement(QName qName) {
        if (null == this.securityHeader) {
            return null;
        }
        return weblogic.xml.dom.DOMUtils.getFirstElement(this.securityHeader, qName);
    }

    public static Element getFirstChildElement(Node node, QName qName) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1 && weblogic.xml.dom.DOMUtils.equalsQName(node, qName)) {
            return (Element)node;
        }
        for (Node node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !weblogic.xml.dom.DOMUtils.equalsQName(node2, qName)) continue;
            return (Element)node2;
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            Element element = SOAPSecurityHeaderHelper.getFirstChildElement(node3, qName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public Element getDummyElement(String string) throws DOMProcessingException {
        weblogic.xml.dom.DOMUtils.addEmptyElement(this.securityHeader, string);
        return weblogic.xml.dom.DOMUtils.getElementByTagName(this.securityHeader, string);
    }

    public void removeDummyElement(Node node) throws DOMProcessingException {
        this.securityHeader.removeChild(node);
    }

    public void dumpSoapMessage(String string) {
        SOAPSecurityHeaderHelper.dumpSoapMessage(this.soap, string, false);
    }

    public static void dumpSoapMessage(SOAPMessageContext sOAPMessageContext, String string) {
        SOAPSecurityHeaderHelper.dumpSoapMessage(sOAPMessageContext.getMessage(), string, false);
    }

    public static void dumpSoapMessage(SOAPMessage sOAPMessage, String string) {
        SOAPSecurityHeaderHelper.dumpSoapMessage(sOAPMessage, string, false);
    }

    public static void dumpSoapMessage(SOAPMessageContext sOAPMessageContext, String string, boolean bl) {
        SOAPSecurityHeaderHelper.dumpSoapMessage(sOAPMessageContext.getMessage(), string, bl);
    }

    public static void dumpSoapMessage(SOAPMessage sOAPMessage, String string, boolean bl) {
        if (null == string) {
            string = "SoapMessageDump";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            if (bl) {
                System.out.println(string + " MSG: " + byteArrayOutputStream);
            }
            if (null != string) {
                File file = File.createTempFile(string, ".xml");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                sOAPMessage.writeTo((OutputStream)bufferedOutputStream);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

