/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.helper;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wssp.IssuedTokenAssertion;
import weblogic.wsee.security.wssp.KerberosTokenAssertion;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss11.internal.STRType;

public class TokenReferenceTypeHelper {
    private static final boolean verbose = Verbose.isVerbose(TokenReferenceTypeHelper.class);
    private static final boolean debug = false;
    private static final STRType[] STR_TYPE_MAP = new STRType[]{new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1"), new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier"), new STRType(DsigConstants.X509ISSUER_SERIAL_QNAME), new STRType(WSSConstants.EMBEDDED_QNAME), new STRType(WSSConstants.REFERENCE_QNAME, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk"), new STRType(WSSConstants.REFERENCE_QNAME), new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ"), new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ"), new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk")};
    private int requiredType = 0;
    private int mustSupportedType = 0;
    static int flag = 0;

    public TokenReferenceTypeHelper(GeneralPolicy generalPolicy, X509TokenAssertion x509TokenAssertion) {
        this.mustSupportedType = generalPolicy.getMustSupportedTypeCode() & 0xFFFFFFEF;
        this.setRequiredType(x509TokenAssertion);
    }

    public TokenReferenceTypeHelper(GeneralPolicy generalPolicy, SamlTokenAssertion samlTokenAssertion) {
        this.mustSupportedType = generalPolicy.getMustSupportedTypeCode() & 0xFFFFFFEF;
        this.setRequiredType(samlTokenAssertion);
    }

    public TokenReferenceTypeHelper(GeneralPolicy generalPolicy, IssuedTokenAssertion issuedTokenAssertion) {
        this.mustSupportedType = generalPolicy.getMustSupportedTypeCode() & 0xFFFFFFEF;
        this.setRequiredType(issuedTokenAssertion);
    }

    public TokenReferenceTypeHelper(GeneralPolicy generalPolicy, KerberosTokenAssertion kerberosTokenAssertion) {
        this.mustSupportedType = generalPolicy.getMustSupportedTypeCode();
        if (kerberosTokenAssertion.isKeyIdentifierReferenceRequired()) {
            if (kerberosTokenAssertion.isWssKerberosV5ApReqToken11()) {
                this.setRequired(64);
            } else {
                this.setRequired(128);
            }
        }
    }

    public TokenReferenceTypeHelper(GeneralPolicy generalPolicy, SecureConversationTokenAssertion secureConversationTokenAssertion) {
        this.mustSupportedType = generalPolicy.getMustSupportedTypeCode();
        this.setRequiredType(secureConversationTokenAssertion);
    }

    public static List getSTRTypeList(String string, int n) {
        if (n == 0) {
            return null;
        }
        return TokenReferenceTypeHelper.buildSTRTypeList(n, string, false);
    }

    public static List getSTRTypesForDK(String string) {
        ArrayList<STRType> arrayList = new ArrayList<STRType>();
        if ("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(string)) {
            arrayList.add(new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk"));
        } else {
            arrayList.add(new STRType(WSSConstants.REFERENCE_QNAME, "http://schemas.xmlsoap.org/ws/2005/02/sc/dk"));
        }
        return arrayList;
    }

    public static List getSTRTypesForSAML(SamlTokenAssertion.TokenType tokenType) {
        ArrayList<STRType> arrayList = new ArrayList<STRType>();
        if (SamlTokenAssertion.TokenType.WSS_SAML_V20_TOKEN_11 == tokenType) {
            arrayList.add(new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        } else if (SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_11 == tokenType) {
            arrayList.add(new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        } else if (SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_10 == tokenType) {
            arrayList.add(new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    public static List getSTRTypesForSAMLIssuedToken(String string) {
        ArrayList<STRType> arrayList = new ArrayList<STRType>();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(string)) {
            arrayList.add(new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(string)) {
            arrayList.add(new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(string)) {
            arrayList.add(new STRType(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID"));
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    public static boolean isThrumbprintSTRType(STRType sTRType) {
        if (null == sTRType) {
            return false;
        }
        return "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(sTRType.getValueType());
    }

    public List getSTRTypeList(String string) {
        if (this.mustSupportedType == 0 && this.requiredType == 0) {
            return null;
        }
        if (this.requiredType != 0) {
            return TokenReferenceTypeHelper.buildSTRTypeList(this.requiredType, string, false);
        }
        return TokenReferenceTypeHelper.buildSTRTypeList(this.mustSupportedType | 0x20, string, false);
    }

    public List getSTRTypeListForValidation(String string) {
        return TokenReferenceTypeHelper.buildSTRTypeList(this.requiredType | this.mustSupportedType | 0x20, string, false);
    }

    public List getSTRTypeListForSignature(String string) {
        if (this.mustSupportedType == 0 && this.requiredType == 0) {
            return null;
        }
        if (this.requiredType != 0) {
            return TokenReferenceTypeHelper.buildSTRTypeList(this.requiredType, string, true);
        }
        return TokenReferenceTypeHelper.buildSTRTypeList(this.mustSupportedType | 0x20, string, true);
    }

    public static String getStrTypeInfo(List list) {
        StringBuffer stringBuffer = new StringBuffer("Actual KeyInfo:");
        stringBuffer.append(" StrTypes size=" + list.size() + " :");
        for (STRType sTRType : list) {
            stringBuffer.append(sTRType.getTopLevelElement().toString() + "|");
            stringBuffer.append("|" + sTRType.getValueType() + ", ");
        }
        return stringBuffer.toString();
    }

    private static List buildSTRTypeList(int n, String string, boolean bl) {
        ArrayList<STRType> arrayList = new ArrayList<STRType>();
        if (bl && (n & 0x20) == 32) {
            arrayList.add(STR_TYPE_MAP[5]);
            n &= 0xFFFFFFDF;
        }
        for (int i = 0; i < STR_TYPE_MAP.length; ++i) {
            if ((n & 1) == 1) {
                STRType sTRType = STR_TYPE_MAP[i];
                sTRType.setTokenType(string);
                arrayList.add(STR_TYPE_MAP[i]);
            }
            n >>= 1;
        }
        return arrayList;
    }

    public void setRequiredType(X509TokenAssertion x509TokenAssertion) {
        if (x509TokenAssertion == null) {
            return;
        }
        if (x509TokenAssertion.isThumbprintReferenceRequired()) {
            this.setRequired(1);
        }
        if (x509TokenAssertion.isKeyIdentifierReferenceRequired()) {
            this.setRequired(2);
        }
        if (x509TokenAssertion.isIssuerSerialReferenceRequired()) {
            this.setRequired(4);
        }
        if (x509TokenAssertion.isEmbeddedTokenReferenceRequired()) {
            this.setRequired(8);
        }
    }

    public void setRequiredType(IssuedTokenAssertion issuedTokenAssertion) {
        if (issuedTokenAssertion == null) {
            return;
        }
        if (issuedTokenAssertion.isRequireExternalReference()) {
            this.setRequired(16);
        }
    }

    public void setRequiredType(SamlTokenAssertion samlTokenAssertion) {
        if (samlTokenAssertion == null) {
            return;
        }
        if (samlTokenAssertion.isKeyIdentifierReferenceRequired()) {
            this.setRequired(2);
        }
    }

    public void setRequiredType(SecureConversationTokenAssertion secureConversationTokenAssertion) {
        if (secureConversationTokenAssertion != null) {
            if (secureConversationTokenAssertion.isSC200502SecurityContextToken()) {
                this.setRequired(32);
            } else if (secureConversationTokenAssertion.isWSSC13SecurityContextToken()) {
                this.setRequired(32);
            } else {
                throw new IllegalArgumentException(" Unknown SecureConversation version, it's neither 200502 nor 1.3");
            }
            if (secureConversationTokenAssertion.isSC200502SecurityContextToken()) {
                this.setRequired(16);
            } else if (secureConversationTokenAssertion.isWSSC13SecurityContextToken()) {
                this.setRequired(16);
            }
        }
    }

    public void setRequired(int n) {
        this.requiredType |= n;
    }

    public void setRequiredType(int n) {
        this.requiredType = n;
    }

    public int getMustSupportedType() {
        return this.mustSupportedType;
    }

    public void setMustSupportedType(int n) {
        this.mustSupportedType = n;
    }

    public boolean isMustSupportRefThumbprint() {
        return (this.mustSupportedType & 1) == 1;
    }

    public boolean isMustSupportRefKeyIdentifier() {
        return (this.mustSupportedType & 2) == 2;
    }

    public boolean isMustSupportRefIssuerSerial() {
        return (this.mustSupportedType & 4) == 4;
    }

    public boolean isMustSupportRefExternalURI() {
        return (this.mustSupportedType & 0x10) == 16;
    }

    public boolean isMustSupportRefEmbeddedToken() {
        return (this.mustSupportedType & 8) == 8;
    }
}

