/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;
import weblogic.wsee.util.Verbose;

public class TokenTypeHelper {
    private static final boolean verbose = Verbose.isVerbose(TokenTypeHelper.class);
    private static final boolean debug = false;
    private static final Map samlTokenMap = new HashMap();
    private static final Map samlConfirmationMethodMap;

    public static String getUsernameTokenType(UsernameTokenAssertion usernameTokenAssertion) {
        if (usernameTokenAssertion.getUsernameTokenType() == UsernameTokenAssertion.TokenType.WSS_UT_10) {
            return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
        }
        if (usernameTokenAssertion.getUsernameTokenType() == UsernameTokenAssertion.TokenType.WSS_UT_11) {
            return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
        }
        throw new UnsupportedOperationException("Unkown Username Token Type found.");
    }

    public static String getSamlValueTokenType(SamlTokenAssertion samlTokenAssertion) {
        SamlTokenAssertion.TokenType tokenType = samlTokenAssertion.getSamlTokenType();
        return TokenTypeHelper.getSamlValueTokenType(tokenType);
    }

    public static String getSamlValueTokenType(SamlTokenAssertion.TokenType tokenType) {
        return (String)samlTokenMap.get((Object)tokenType);
    }

    public static String getSamlConfirmationMethod(SamlTokenAssertion samlTokenAssertion) {
        SamlTokenAssertion.ConfirmationMethod confirmationMethod = samlTokenAssertion.getSubjectConfirmationMethod();
        return (String)samlConfirmationMethodMap.get((Object)confirmationMethod);
    }

    public static boolean isSamlValueType(String string) {
        HashSet hashSet = new HashSet(samlTokenMap.values());
        return hashSet.contains(string);
    }

    static {
        samlTokenMap.put(SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_10, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        samlTokenMap.put(SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_11, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        samlTokenMap.put(SamlTokenAssertion.TokenType.WSS_SAML_V20_TOKEN_11, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        samlConfirmationMethodMap = new HashMap();
        samlConfirmationMethodMap.put(SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES, "sender-vouches");
        samlConfirmationMethodMap.put(SamlTokenAssertion.ConfirmationMethod.HOLDER_OF_KEY, "holder-of-key");
        samlConfirmationMethodMap.put(SamlTokenAssertion.ConfirmationMethod.BEARER, "bearer");
    }
}

