/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.plan.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.MessagePartsEvaluator;
import weblogic.wsee.security.policy.assertions.xbeans.MessagePartsType;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.stax.util.NamespaceContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathNodesHelper {
    private static final boolean verbose = Verbose.isVerbose(XpathNodesHelper.class);
    private static final boolean debug = false;

    public static List<Node> findNode(MessagePartsType messagePartsType, SOAPMessageContext sOAPMessageContext, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == messagePartsType) {
            if (verbose) {
                Verbose.log("Null MessagePartsType found.");
            }
            return null;
        }
        weblogic.wsee.security.policy12.assertions.XPath xPath = new weblogic.wsee.security.policy12.assertions.XPath();
        xPath.setAssertion(messagePartsType.getDialect(), messagePartsType.getStringValue(), "");
        return XpathNodesHelper.findNode(xPath, sOAPMessageContext, bl);
    }

    public static List<Node> findNode(weblogic.wsee.security.policy12.assertions.XPath xPath, SOAPMessageContext sOAPMessageContext, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == xPath) {
            if (verbose) {
                Verbose.log("Null XPath object found.");
            }
            return null;
        }
        ArrayList<weblogic.wsee.security.policy12.assertions.XPath> arrayList = new ArrayList<weblogic.wsee.security.policy12.assertions.XPath>(1);
        arrayList.add(xPath);
        return XpathNodesHelper.findNode(arrayList, sOAPMessageContext, bl);
    }

    public static List<Node> findNode(List<weblogic.wsee.security.policy12.assertions.XPath> list, SOAPMessageContext sOAPMessageContext, boolean bl) throws SecurityPolicyArchitectureException {
        if (null == list || list.size() == 0) {
            if (verbose) {
                Verbose.log("No XPath objects found.");
            }
            return null;
        }
        if (null == sOAPMessageContext || null == sOAPMessageContext.getMessage()) {
            throw new IllegalArgumentException("Null Soap Message found");
        }
        Node node = null;
        try {
            if (sOAPMessageContext.getMessage().getSOAPBody() == null) {
                throw new SecurityPolicyArchitectureException("missing Soap Body");
            }
            node = sOAPMessageContext.getMessage().getSOAPBody().getParentNode();
        }
        catch (Exception exception) {
            throw new SecurityPolicyArchitectureException("missing Soap Body", exception);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Map map = DOMUtils.getNamespaceMap(node);
        for (weblogic.wsee.security.policy12.assertions.XPath xPath : list) {
            MessagePartsEvaluator messagePartsEvaluator = new MessagePartsEvaluator(xPath, sOAPMessageContext, map);
            try {
                List list2 = messagePartsEvaluator.getNodes();
                if (null == list2 || list2.size() == 0) {
                    if (bl) {
                        throw new SecurityPolicyArchitectureException("Missing required element with xpath=" + xPath.getXPathExpr());
                    }
                    Verbose.log("Element in xpath not found in SOAP message (but not required)=" + xPath.getXPathExpr());
                    continue;
                }
                arrayList.addAll(list2);
            }
            catch (PolicyException policyException) {
                if (bl) {
                    throw new SecurityPolicyArchitectureException("Missing required element with xpath=" + xPath.getXPathExpr(), policyException);
                }
                Verbose.log("Element in xpath not found in SOAP message (but not required)=" + xPath.getXPathExpr());
            }
        }
        return arrayList;
    }

    public static XPath buildXPath(List list) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        xPath.setNamespaceContext((NamespaceContext)namespaceContextImpl);
        return xPath;
    }

    public static String getElementPath(Node node) {
        if (node == null) {
            return null;
        }
        String string = "";
        Node node2 = node;
        while (node.getNodeType() == 1) {
            string = "/" + node.getNamespaceURI() + ":" + node.getLocalName() + string;
            if ((node = node.getParentNode()) != null) continue;
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }
}

