/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.MessagePartsEvaluator;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityTargetType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenFactory;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.plan.helper.XpathNodesHelper;
import weblogic.wsee.security.wss.policy.EncryptionPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.wssp.EncryptionPolicyImpl;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.wss.WSSecurityException;

public class EncryptionPolicyBlueprintImpl
extends EncryptionPolicyImpl
implements EncryptionPolicy {
    public static final boolean verbose = Verbose.isVerbose(EncryptionPolicyBlueprintImpl.class);
    static int sequnce = 0;
    private XMLEncryptionFactory encryptionFactory;

    public EncryptionPolicyBlueprintImpl() {
    }

    public EncryptionPolicyBlueprintImpl(XMLEncryptionFactory xMLEncryptionFactory) {
        this.encryptionFactory = xMLEncryptionFactory;
    }

    public EncryptionPolicyBlueprintImpl(XMLEncryptionFactory xMLEncryptionFactory, SOAPMessageContext sOAPMessageContext, ConfidentialityAssertion confidentialityAssertion, boolean bl) throws PolicyException, WSSecurityException {
        Map map = confidentialityAssertion.getNamespaceMap();
        ConfidentialityDocument.Confidentiality confidentiality = confidentialityAssertion.getXbean().getConfidentiality();
        String string = "http://www.w3.org/2001/10/xml-exc-c14n#";
        try {
            this.setCanonicalizationMethod(string);
            if (confidentiality.getKeyWrappingAlgorithm() != null) {
                this.setKeyWrapMethod(confidentiality.getKeyWrappingAlgorithm().getURI());
            }
        }
        catch (SecurityPolicyArchitectureException securityPolicyArchitectureException) {
            throw new WSSecurityException(securityPolicyArchitectureException.getMessage(), securityPolicyArchitectureException);
        }
        ConfidentialityTargetType[] confidentialityTargetTypeArray = confidentiality.getTargetArray();
        for (int i = 0; i < confidentialityTargetTypeArray.length; ++i) {
            ConfidentialityTargetType confidentialityTargetType = confidentialityTargetTypeArray[i];
            try {
                this.setEncryptionMethod(confidentialityTargetType.getEncryptionAlgorithm().getURI());
            }
            catch (SecurityPolicyArchitectureException securityPolicyArchitectureException) {
                throw new WSSecurityException(securityPolicyArchitectureException.getMessage(), securityPolicyArchitectureException);
            }
            if (!bl) continue;
            List list = null;
            MessagePartsEvaluator messagePartsEvaluator = new MessagePartsEvaluator(confidentialityTargetType.getMessageParts(), sOAPMessageContext, map);
            list = confidentialityTargetType.getEncryptContentOnly() ? messagePartsEvaluator.getNodesContent() : messagePartsEvaluator.getNodes();
            if (list == null || list.size() == 0) {
                if (!verbose) continue;
                Verbose.log("MessageParts expression '" + confidentialityTargetType.getMessageParts() + "' did not evaluate to any nodes in the message; target will be skipped");
                continue;
            }
            this.addEncryptionTarget(this.encryptionMethod, list, confidentialityTargetType.getEncryptContentOnly());
        }
        SecurityTokenType[] securityTokenTypeArray = confidentiality.getKeyInfo().getSecurityTokenArray();
        this.addEncryptionTokens(securityTokenTypeArray);
    }

    public void addEncryptionTarget(List list, boolean bl) throws WSSecurityException {
        this.addEncryptionTarget(this.getEncryptionMethod(), list, bl);
    }

    public void addEncryptionTarget(EncryptionMethod encryptionMethod, List list, boolean bl) {
        if (list == null || list.size() == 0) {
            if (verbose) {
                Verbose.log("empty list found");
            }
            return;
        }
        this.doAddEncryptionTarget(encryptionMethod, list, bl);
    }

    public void doAddEncryptionTarget(EncryptionMethod encryptionMethod, List list, boolean bl) {
        Object object22;
        ArrayList<DOMTBEXML> arrayList = new ArrayList<DOMTBEXML>();
        if (bl) {
            for (Iterator iterator : list) {
                object22 = new DOMTBEXML((NodeList)((Object)iterator), this.canonicalizationMethod);
                arrayList.add((DOMTBEXML)object22);
            }
        } else {
            for (Iterator iterator : list) {
                object22 = new DOMTBEXML((Element)((Object)iterator), this.canonicalizationMethod);
                arrayList.add((DOMTBEXML)object22);
            }
        }
        boolean bl2 = true;
        for (Object object22 : this.encryptionTargets) {
            if (!((EncryptionTarget)object22).getEncryptionMethod().equals(encryptionMethod)) continue;
            List list2 = ((EncryptionTarget)object22).getTBEs();
            for (TBE tBE : arrayList) {
                list2.add(tBE);
            }
            bl2 = false;
            break;
        }
        if (bl2) {
            this.encryptionTargets.add(new EncryptionTarget(encryptionMethod, arrayList));
        }
    }

    public void addEncryptionToken(SecurityTokenType securityTokenType) {
        this.addEncryptionToken(SecurityTokenFactory.makeSecurityToken(securityTokenType));
    }

    public boolean hasEncryptionToken() {
        return this.validEncryptionTokens != null && !this.validEncryptionTokens.isEmpty();
    }

    public void setEncryptionMethod(String string) throws SecurityPolicyArchitectureException {
        EncryptionMethod encryptionMethod = null;
        try {
            encryptionMethod = this.encryptionFactory.newEncryptionMethod(string, null, null);
            if (encryptionMethod == null) {
                throw new SecurityPolicyArchitectureException(this.encryptionFactory.toString() + " is not a supported encryption algorithm.");
            }
            this.encryptionMethod = encryptionMethod;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    public void setKeyWrapMethod(String string) throws SecurityPolicyArchitectureException {
        if (null == string) {
            this.keyWrapMethod = null;
            return;
        }
        try {
            this.keyWrapMethod = this.encryptionFactory.newEncryptionMethod(string, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    public void setCanonicalizationMethod(String string) throws SecurityPolicyArchitectureException {
        try {
            this.canonicalizationMethod = this.encryptionFactory.newCanonicalizationMethod(string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityPolicyArchitectureException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public void setValidEncryptionTokens(List list) {
        this.validEncryptionTokens = list;
    }

    public void addQNameExprNode(String string, QNameExpr qNameExpr) {
        if (qNameExpr == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.nodeMap.containsKey(string)) {
            this.nodeMap.put(string, qNameExpr);
        } else {
            this.nodeMap.put(string + sequnce++, qNameExpr);
        }
    }

    public void addEncryptionNodeList(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (this.nodeMap.isEmpty()) {
            return;
        }
        this.doAddEncryptionNodeList(sOAPMessageContext);
    }

    private void doAddEncryptionNodeList(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SecurityPolicyArchitectureException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.nodeMap.values());
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Object object2;
            Object e = arrayList.get(i);
            if (e == null) continue;
            if (e instanceof QNameExpr) {
                object2 = sOAPMessageContext.getMessage();
                object = SOAPSecurityHeaderHelper.getNonSecurityElements((SOAPMessage)object2, (QNameExpr)e);
                this.addEncryptionTarget(this.encryptionMethod, (List)object, false);
                continue;
            }
            if (e instanceof Node) {
                object2 = new ArrayList();
                object2.add(e);
                object = this.nodeMap.get("Body");
                if (e.equals(object)) {
                    this.addEncryptionTarget(this.encryptionMethod, (List)object2, true);
                    continue;
                }
                this.addEncryptionTarget(this.encryptionMethod, (List)object2, false);
                continue;
            }
            if (e instanceof List) {
                object2 = XpathNodesHelper.findNode((List)e, sOAPMessageContext, false);
                if (null == object2 || object2.size() <= 0) continue;
                object = (XPath)((List)e).get(0);
                EncryptedElements.isValidElement((List<Node>)object2, ((XPath)object).getEncryptContentOnly());
                this.addEncryptionTarget(this.encryptionMethod, (List)object2, ((XPath)object).getEncryptContentOnly());
                continue;
            }
            if (e instanceof XPath) {
                object2 = XpathNodesHelper.findNode((XPath)e, sOAPMessageContext, false);
                if (null == object2 || object2.size() <= 0) continue;
                EncryptedElements.isValidElement((List<Node>)object2, ((XPath)e).getEncryptContentOnly());
                this.addEncryptionTarget(this.encryptionMethod, (List)object2, ((XPath)e).getEncryptContentOnly());
                continue;
            }
            throw new SecurityPolicyArchitectureException("Unknown object type found in encryption node list");
        }
        this.nodeMap = new HashMap();
    }
}

