/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.assertions.xbeans.MessagePartsType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EncryptionPolicyImpl {
    private static final boolean verbose = Verbose.isVerbose(EncryptionPolicyImpl.class);
    private static final boolean debug = false;
    protected EncryptionMethod keyWrapMethod = null;
    protected EncryptionMethod encryptionMethod = null;
    protected CanonicalizationMethod canonicalizationMethod;
    protected List<SecurityToken> validEncryptionTokens = new ArrayList<SecurityToken>();
    protected List<EncryptionTarget> encryptionTargets = new ArrayList<EncryptionTarget>();
    protected Map nodeMap = new HashMap();

    public List<EncryptionTarget> getEncryptionTargets() {
        return this.encryptionTargets;
    }

    public void addEncryptionToken(SecurityToken securityToken) {
        this.validEncryptionTokens.add(securityToken);
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public abstract void setEncryptionMethod(String var1) throws SecurityPolicyArchitectureException;

    public abstract void setKeyWrapMethod(String var1) throws SecurityPolicyArchitectureException;

    public void setKeyWrapMethod(EncryptionMethod encryptionMethod) {
        this.keyWrapMethod = encryptionMethod;
    }

    public EncryptionMethod getKeyWrapMethod() {
        return this.keyWrapMethod;
    }

    public abstract void setCanonicalizationMethod(String var1) throws SecurityPolicyArchitectureException;

    public void setCanonicalizationMethod(CanonicalizationMethod canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public List getValidEncryptionTokens() {
        return this.validEncryptionTokens;
    }

    public void addXPathNode(String string, MessagePartsType messagePartsType) {
        if (messagePartsType == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.nodeMap.containsKey(string)) {
            this.nodeMap.put(string, messagePartsType);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object v = this.nodeMap.get(string);
            if (v instanceof List) {
                arrayList.addAll((List)v);
            } else {
                arrayList.add(v);
            }
            arrayList.add(messagePartsType);
            this.nodeMap.put(string, arrayList);
        }
    }

    public void addXPathNode(String string, XPath xPath) {
        if (xPath == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.nodeMap.containsKey(string)) {
            this.nodeMap.put(string, xPath);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object v = this.nodeMap.get(string);
            if (v instanceof List) {
                arrayList.addAll((List)v);
            } else {
                arrayList.add(v);
            }
            arrayList.add(xPath);
            this.nodeMap.put(string, arrayList);
        }
    }

    public void addNode(String string, Node node) {
        if (this.nodeMap.containsKey(string)) {
            Object v = this.nodeMap.get(string);
            if (null == node && null != v) {
                return;
            }
        }
        this.nodeMap.put(string, node);
    }

    public Map getNodeMap() {
        return this.nodeMap;
    }

    public boolean isEncryptionRequired() {
        return this.validEncryptionTokens.size() > 0 && 0 != this.nodeMap.size() + this.encryptionTargets.size();
    }

    public boolean isPolicyValid() {
        if (0 == this.nodeMap.size() + this.encryptionTargets.size()) {
            return true;
        }
        return this.validEncryptionTokens.size() > 0;
    }

    public void addEncryptionTokens(SecurityTokenType[] securityTokenTypeArray) {
        for (int i = 0; i < securityTokenTypeArray.length; ++i) {
            this.addEncryptionToken(securityTokenTypeArray[i]);
        }
    }

    public abstract void addEncryptionToken(SecurityTokenType var1);

    public void setCanonicalizationMethod() throws SecurityPolicyArchitectureException {
        this.setCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void setNodeMap(Map map) {
        this.nodeMap = map;
    }
}

