/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wssp.HttpsTokenAssertion;
import weblogic.wsee.security.wssp.WsTrustOptions;
import weblogic.wsee.security.wssp.Wss10Options;
import weblogic.wsee.security.wssp.Wss11Options;
import weblogic.wsee.util.Verbose;

public class GeneralPolicyImpl
implements GeneralPolicy {
    private static final boolean verbose = Verbose.isVerbose(GeneralPolicyImpl.class);
    private static final boolean debug = false;
    private String layout = null;
    private boolean isWss11 = false;
    private boolean isCompatMSFT = false;
    private Wss11Options wss11OptionsAssertion = null;
    private Wss10Options wss10OptionsAssertion = null;
    private WsTrustOptions trustOptions = null;
    private boolean encryptBeforeSigning = false;
    private String[] signatureValues;
    private boolean requireSignatureConfirmation = false;
    private int mustSupportedTypeCode = 0;
    private PolicySelectionPreference preference;
    private boolean optionalSignatureConfirmation = false;
    private HttpsTokenAssertion httpsAssertion = null;

    public int getMustSupportedTypeCode() {
        return this.mustSupportedTypeCode;
    }

    public String getLayout() {
        if (null == this.layout) {
            return "Lax";
        }
        return this.layout;
    }

    public void setLayout(String string) {
        this.layout = string;
    }

    public void setLayoutToStrict() {
        this.layout = "Strict";
    }

    public void setLayoutToLaxTimestampFirst() {
        this.layout = "LaxTimestampFirst";
    }

    public void setLayoutToLaxTimestampLast() {
        this.layout = "LaxTimestampLast";
    }

    public void setLayoutToLax() {
        this.layout = "Lax";
    }

    public boolean isWss11() {
        return this.isWss11;
    }

    public void setWss11On() {
        this.isWss11 = true;
    }

    public void setWss11OptionsAssertion(Wss11Options wss11Options) {
        this.wss11OptionsAssertion = wss11Options;
        this.setMustSupportWS10Options(wss11Options);
        if (wss11Options.isMustSupportThumbprintReference()) {
            if (wss11Options.isMustSupportThumbprintReferenceOptional() && !this.preference.isInteropFirst()) {
                if (verbose) {
                    Verbose.say("Skip the MustSupportThumbprintReference assertion due to it is optional and interop is not a preference");
                }
            } else {
                this.setMustSupportRefThumbprint();
            }
        }
        if (wss11Options.isSignatureConfirmationRequired()) {
            this.setRequireSignatureConfirmation(true);
            if (wss11Options.isSignatureConfirmationRequiredOptional()) {
                this.setOptionalSignatureConfirmation(true);
            }
        } else {
            this.setRequireSignatureConfirmation(false);
        }
    }

    private void setMustSupportWS10Options(Wss10Options wss10Options) {
        if (wss10Options.isMustSupportEmbeddedTokenReference()) {
            this.setMustSupportRefEmbeddedToken();
        }
        if (wss10Options.isMustSupportExternalUriReference()) {
            this.setMustSupportRefExternalURI();
        }
        if (wss10Options.isMustSupportIssuerSerialReference()) {
            this.setMustSupportRefIssuerSerial();
        }
        if (wss10Options.isMustSupportKeyIdentiferReference()) {
            this.setMustSupportRefKeyIdentifier();
        }
    }

    public void setWss10OptionsAssertion(Wss10Options wss10Options) {
        this.wss10OptionsAssertion = wss10Options;
        this.setMustSupportWS10Options(wss10Options);
    }

    public boolean isRequireSignatureConfirmation() {
        return this.requireSignatureConfirmation;
    }

    public void setRequireSignatureConfirmation(boolean bl) {
        this.requireSignatureConfirmation = bl;
    }

    public String[] getSignatureValues() {
        if (null == this.signatureValues && this.isRequireSignatureConfirmation()) {
            this.signatureValues = new String[0];
        }
        return this.signatureValues;
    }

    public void setSignatureValues(String[] stringArray) {
        this.signatureValues = stringArray;
    }

    public void setMustSupportRefThumbprint() {
        this.mustSupportedTypeCode |= 1;
    }

    public void setMustSupportRefKeyIdentifier() {
        this.mustSupportedTypeCode |= 2;
    }

    public void setMustSupportRefIssuerSerial() {
        this.mustSupportedTypeCode |= 4;
    }

    public void setMustSupportRefExternalURI() {
        this.mustSupportedTypeCode |= 0x10;
    }

    public void setMustSupportRefEmbeddedToken() {
        this.mustSupportedTypeCode |= 8;
    }

    public boolean isEncryptBeforeSigning() {
        return this.encryptBeforeSigning;
    }

    public void setEncryptBeforeSigning(boolean bl) {
        this.encryptBeforeSigning = bl;
    }

    public WsTrustOptions getTrustOptions() {
        return this.trustOptions;
    }

    public void setTrustOptions(WsTrustOptions wsTrustOptions) {
        this.trustOptions = wsTrustOptions;
    }

    public boolean hasTrustOptions() {
        return this.trustOptions != null;
    }

    public boolean isWssc13() {
        if (!this.hasTrustOptions()) {
            return false;
        }
        return this.trustOptions.isWst13();
    }

    public boolean isCompatMSFT() {
        return this.isCompatMSFT;
    }

    public void setCompatMSFT(boolean bl) {
        this.isCompatMSFT = bl;
    }

    public PolicySelectionPreference getPreference() {
        return this.preference;
    }

    public void setPreference(PolicySelectionPreference policySelectionPreference) {
        this.preference = policySelectionPreference;
    }

    public boolean isOptionalSignatureConfirmation() {
        return this.optionalSignatureConfirmation;
    }

    public void setOptionalSignatureConfirmation(boolean bl) {
        this.optionalSignatureConfirmation = bl;
    }

    public void setHttpsAssertion(HttpsTokenAssertion httpsTokenAssertion) {
        this.httpsAssertion = httpsTokenAssertion;
    }

    public boolean isHTTPsRequired() {
        return this.httpsAssertion != null;
    }

    public boolean isClientCertificateRequired() {
        if (!this.isHTTPsRequired()) {
            return false;
        }
        return this.httpsAssertion.isClientCertificateRequired();
    }

    public boolean isHttpBasicAuthenticationRequired() {
        if (!this.isHTTPsRequired()) {
            return false;
        }
        return this.httpsAssertion.isHttpBasicAuthenticationRequired();
    }
}

