/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.XBeanUtils;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenFactory;
import weblogic.wsee.security.wss.policy.IdentityPolicy;

public class IdentityPolicyImpl
implements IdentityPolicy {
    private List validIdentityTokens = new ArrayList();

    public IdentityPolicyImpl() {
    }

    public IdentityPolicyImpl(IdentityAssertion identityAssertion) {
        SecurityTokenType[] securityTokenTypeArray = identityAssertion.getXbean().getIdentity().getSupportedTokens().getSecurityTokenArray();
        for (int i = 0; i < securityTokenTypeArray.length; ++i) {
            SecurityTokenType securityTokenType = securityTokenTypeArray[i];
            this.validIdentityTokens.add(new SecurityToken(XBeanUtils.getElement(securityTokenType), null, securityTokenType.getTokenType(), securityTokenType.getIncludeInMessage()));
        }
    }

    public void addIdentityToken(SecurityTokenType securityTokenType) {
        this.addIdentityToken(SecurityTokenFactory.makeSecurityToken(securityTokenType));
    }

    public void addIdentityToken(SecurityToken securityToken) {
        if (null != securityToken) {
            this.doAddIdentityToken(securityToken);
        }
    }

    private void doAddIdentityToken(SecurityToken securityToken) {
        this.validIdentityTokens.add(securityToken);
    }

    public List getValidIdentityTokens() {
        return this.validIdentityTokens;
    }

    public boolean isAuthenticationRequired() {
        return 0 != this.validIdentityTokens.size();
    }
}

