/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.SigningReferencesFactory;
import weblogic.wsee.security.policy.XBeanUtils;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityTargetType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy.assertions.xbeans.TransformType;
import weblogic.wsee.security.policy12.assertions.SignedElements;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.assertions.XPath2;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wss.plan.helper.XpathNodesHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SignaturePolicy;
import weblogic.wsee.security.wss.policy.wssp.SigningPolicyImpl;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.xml.crypto.dsig.XPathFilter2Transform;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.XPathFilter2ParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.XPathFilterParameterSpec;
import weblogic.xml.crypto.wss.WSSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningPolicyBlueprintImpl
extends SigningPolicyImpl
implements SignaturePolicy {
    static int sequnce = 0;
    private XMLSignatureFactory signatureFactory;
    private SigningReferencesFactory signingReferencesFactory;
    public static final String XPATH_TXFORM_URI = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final QName XPATH_FILTER_ELEMENT = new QName("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath");

    public SigningPolicyBlueprintImpl(XMLSignatureFactory xMLSignatureFactory, SigningReferencesFactory signingReferencesFactory) {
        this.signatureFactory = xMLSignatureFactory;
        this.signingReferencesFactory = signingReferencesFactory;
    }

    public SigningPolicyBlueprintImpl(XMLSignatureFactory xMLSignatureFactory, SigningReferencesFactory signingReferencesFactory, SOAPMessageContext sOAPMessageContext, Set set) throws PolicyException, SecurityPolicyException, WSSecurityException {
        this.signatureFactory = xMLSignatureFactory;
        this.signingReferencesFactory = signingReferencesFactory;
        for (IntegrityAssertion integrityAssertion : set) {
            Object object;
            Map map = integrityAssertion.getNamespaceMap();
            IntegrityDocument.Integrity integrity = integrityAssertion.getXbean().getIntegrity();
            this.includeSigningTokens |= integrity.getSignToken();
            this.X509AuthConditional |= integrity.getX509AuthConditional();
            if (!integrity.isSetSupportedTokens()) {
                throw new PolicyException("Supportedtokens element is missing from Integrity assertion");
            }
            SecurityTokenType[] securityTokenTypeArray = integrity.getSupportedTokens().getSecurityTokenArray();
            this.addSignatureTokens(securityTokenTypeArray);
            IntegrityTargetType[] integrityTargetTypeArray = integrity.getTargetArray();
            for (int i = 0; i < integrityTargetTypeArray.length; ++i) {
                Object object2;
                object = integrityTargetTypeArray[i];
                List list = null;
                DigestMethod digestMethod = null;
                try {
                    list = SigningPolicyBlueprintImpl.processSigningTransforms(xMLSignatureFactory, (IntegrityTargetType)object);
                    object2 = object.getDigestAlgorithm().getURI();
                    digestMethod = xMLSignatureFactory.newDigestMethod((String)object2, null);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SecurityPolicyException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new SecurityPolicyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                object2 = signingReferencesFactory.getSigningReferences(xMLSignatureFactory, object.getMessageParts(), digestMethod, list, sOAPMessageContext, map);
                this.references.addAll(object2);
            }
            String string = integrity.getCanonicalizationAlgorithm().getURI();
            this.setCanonicalizationMethod(string);
            object = integrity.getSignatureAlgorithm().getURI();
            this.setSignatureMethod((String)object);
        }
    }

    @Override
    public void setSignatureMethod(String string) throws SecurityPolicyArchitectureException {
        SignatureMethod signatureMethod = null;
        try {
            this.signatureMethod = signatureMethod = this.signatureFactory.newSignatureMethod(string, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityPolicyArchitectureException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    public void setCanonicalizationMethod(String string) throws SecurityPolicyArchitectureException {
        CanonicalizationMethod canonicalizationMethod = null;
        try {
            this.canonicalizationMethod = canonicalizationMethod = this.signatureFactory.newCanonicalizationMethod(string, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityPolicyArchitectureException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    public void setDigestMethod(String string) throws SecurityPolicyArchitectureException {
        try {
            this.digestMethod = this.signatureFactory.newDigestMethod(string, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityPolicyArchitectureException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    public SignedInfo newSignedInfo(Reference reference) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>(this.references);
        arrayList.add(reference);
        return this.signatureFactory.newSignedInfo(this.canonicalizationMethod, this.signatureMethod, arrayList);
    }

    @Override
    public SignedInfo getSignedInfo() {
        this.removeDuplicatedReference();
        return this.signatureFactory.newSignedInfo(this.canonicalizationMethod, this.signatureMethod, this.references);
    }

    private void removeDuplicatedReference() {
        if (null == this.references || this.references.size() < 2) {
            return;
        }
        HashMap hashMap = new HashMap(this.references.size());
        for (int i = 0; i < this.references.size(); ++i) {
            hashMap.put(((Reference)this.references.get(i)).getURI(), this.references.get(i));
        }
        if (hashMap.size() == this.references.size()) {
            return;
        }
        Collection collection = hashMap.values();
        this.references = new ArrayList(collection);
    }

    @Override
    public void addSignatureNodeListToReference(SOAPMessageContext sOAPMessageContext) throws SecurityPolicyArchitectureException, WSSecurityException {
        if (this.signingNodeMap.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        Collection collection = this.signingNodeMap.values();
        collection.remove(null);
        arrayList.addAll(collection);
        for (int i = 0; i < arrayList.size(); ++i) {
            List<Node> list;
            Object object;
            Object e = arrayList.get(i);
            if (e == null) continue;
            if (e instanceof QNameExpr) {
                object = sOAPMessageContext.getMessage();
                list = SOAPSecurityHeaderHelper.getNonSecurityElements(object, (QNameExpr)e);
                this.addSignatureNodeListToReference(list);
                continue;
            }
            if (e instanceof Node) {
                arrayList2.add((Node)e);
                continue;
            }
            if (e instanceof List) {
                object = ((List)e).get(0);
                if (object instanceof XPath2) {
                    this.addXPathFilter2Reference((List)e, sOAPMessageContext);
                    continue;
                }
                if (!(object instanceof XPath) || null == (list = XpathNodesHelper.findNode((List)e, sOAPMessageContext, false)) || list.size() <= 0) continue;
                this.addSignatureNodeListToReference(list);
                continue;
            }
            if (e instanceof XPath2) {
                this.addXPathFilter2Reference((XPath2)e, sOAPMessageContext);
                continue;
            }
            if (e instanceof XPath) {
                object = XpathNodesHelper.findNode((XPath)e, sOAPMessageContext, false);
                if (null == object || object.size() <= 0) continue;
                this.addSignatureNodeListToReference((List)object);
                continue;
            }
            if (e instanceof Reference) {
                this.addReferences(Arrays.asList((Reference)e));
                continue;
            }
            throw new SecurityPolicyArchitectureException("Unknown object type found in signature node list");
        }
        SignedElements.isValidElement(arrayList2);
        this.addSignatureNodeListToReference(arrayList2);
    }

    private void addXPathFilter2Reference(List<XPath2> list, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyArchitectureException {
        ArrayList<Element> noSuchAlgorithmException;
        ArrayList<weblogic.xml.crypto.dsig.api.spec.XPath> arrayList2 = new ArrayList<weblogic.xml.crypto.dsig.api.spec.XPath>();
        for (XPath2 serializable2 : list) {
            assert ("http://www.w3.org/2002/06/xmldsig-filter2".equals(serializable2.getXPathVersion()));
            noSuchAlgorithmException = SigningPolicyBlueprintImpl.convertToSpecXPath(serializable2);
            arrayList2.add((weblogic.xml.crypto.dsig.api.spec.XPath)((Object)noSuchAlgorithmException));
        }
        XPathFilter2ParameterSpec xPathFilter2ParameterSpec = new XPathFilter2ParameterSpec(arrayList2);
        ArrayList arrayList = new ArrayList();
        try {
            noSuchAlgorithmException = this.signatureFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xPathFilter2ParameterSpec);
            arrayList.add(noSuchAlgorithmException);
        }
        catch (NoSuchAlgorithmException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        noSuchAlgorithmException = new ArrayList<Element>();
        noSuchAlgorithmException.add(sOAPMessageContext.getMessage().getSOAPPart().getDocumentElement());
        try {
            List wSSecurityException = this.signingReferencesFactory.getSigningReferences(this.signatureFactory, noSuchAlgorithmException, this.digestMethod, arrayList);
            this.addReferences(wSSecurityException);
        }
        catch (WSSecurityException policyException) {
            throw new SecurityPolicyArchitectureException(policyException.getMessage(), policyException);
        }
        catch (PolicyException policyException) {
            throw new SecurityPolicyArchitectureException(policyException.getMessage(), policyException);
        }
    }

    private static weblogic.xml.crypto.dsig.api.spec.XPath convertToSpecXPath(XPath2 xPath2) {
        return new weblogic.xml.crypto.dsig.api.spec.XPath(xPath2.getXPathExpr(), XPathFilter2Transform.getFilter(xPath2.getFilter()), xPath2.getXPathNamespaces());
    }

    private void addXPathFilter2Reference(XPath2 xPath2, SOAPMessageContext sOAPMessageContext) throws SecurityPolicyArchitectureException {
        ArrayList<XPath2> arrayList = new ArrayList<XPath2>();
        arrayList.add(xPath2);
        this.addXPathFilter2Reference(arrayList, sOAPMessageContext);
    }

    @Override
    public void addSignatureNodeListToReference() throws SecurityPolicyArchitectureException, WSSecurityException {
        if (this.signingNodeMap.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = this.signingNodeMap.values();
        collection.remove(null);
        arrayList.addAll(collection);
        this.addSignatureNodeListToReference(arrayList);
    }

    @Override
    public void addSignatureNodeListToReference(List list) throws SecurityPolicyArchitectureException, WSSecurityException {
        if (null == list || list.size() == 0) {
            return;
        }
        try {
            List list2 = this.signingReferencesFactory.getSigningReferences(this.signatureFactory, list, this.digestMethod, this.getSigningTransforms());
            this.addReferences(list2);
        }
        catch (PolicyException policyException) {
            throw new SecurityPolicyArchitectureException(policyException.getMessage(), policyException);
        }
    }

    @Override
    public void setNewSignatureNodeListToReference(List list) throws SecurityPolicyArchitectureException, WSSecurityException {
        try {
            this.references = this.signingReferencesFactory.getSigningReferences(this.signatureFactory, list, this.digestMethod, this.getSigningTransforms());
        }
        catch (PolicyException policyException) {
            throw new SecurityPolicyArchitectureException(policyException.getMessage(), policyException);
        }
    }

    @Override
    public List getReferences() throws SecurityPolicyArchitectureException, WSSecurityException {
        this.addSignatureNodeListToReference();
        return this.references;
    }

    private List getSigningTransforms() throws SecurityPolicyArchitectureException {
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        try {
            arrayList.add(this.signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", null));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityPolicyArchitectureException(noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SecurityPolicyArchitectureException(invalidAlgorithmParameterException);
        }
        return arrayList;
    }

    private static List processSigningTransforms(XMLSignatureFactory xMLSignatureFactory, IntegrityTargetType integrityTargetType) throws SecurityPolicyException {
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        TransformType[] transformTypeArray = integrityTargetType.getTransformArray();
        for (int i = 0; i < transformTypeArray.length; ++i) {
            TransformType transformType = transformTypeArray[i];
            String string = DOMUtils.getAttributeValueAsString(XBeanUtils.getElement(transformType), new QName("URI"));
            if (string == null) {
                throw new SecurityPolicyException("Could not read Transform URI from Transform element");
            }
            TransformParameterSpec transformParameterSpec = null;
            DocumentFragment documentFragment = XBeanUtils.getXMLBeanChildren(transformType);
            if (XPATH_TXFORM_URI.equals(string)) {
                transformParameterSpec = SigningPolicyBlueprintImpl.createXPathFilterSpec(documentFragment);
                if (transformParameterSpec == null) {
                    throw new SecurityPolicyException("No XPath transform parameter.");
                }
            } else {
                transformParameterSpec = new DOMParameterSpec(documentFragment);
            }
            try {
                arrayList.add(xMLSignatureFactory.newTransform(string, transformParameterSpec));
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityPolicyException(noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new SecurityPolicyException(invalidAlgorithmParameterException);
            }
        }
        if (arrayList.size() == 0) {
            try {
                arrayList.add(xMLSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", null));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static XPathFilterParameterSpec createXPathFilterSpec(DocumentFragment documentFragment) {
        NodeList nodeList = documentFragment.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        Element element = (Element)nodeList.item(0);
        String string = DOMUtils.getTextContent(element, true);
        return new XPathFilterParameterSpec(string);
    }

    private static class DOMParameterSpec
    implements TransformParameterSpec {
        private DocumentFragment fragment;

        public DOMParameterSpec(DocumentFragment documentFragment) {
            this.fragment = documentFragment;
        }

        public DocumentFragment getDocumentFragment() {
            return this.fragment;
        }
    }
}

