/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.assertions.xbeans.MessagePartsType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.wss.plan.fact.SecurityTokenFactory;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.wssp.SigningPolicyBlueprintImpl;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.wss.WSSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SigningPolicyImpl {
    private static final boolean verbose = Verbose.isVerbose(SigningPolicyImpl.class);
    private static final boolean debug = false;
    protected List validSignatureTokens = new ArrayList();
    protected boolean isTokenProtection = false;
    protected boolean includeSigningTokens = false;
    protected boolean X509AuthConditional = false;
    protected List references = new ArrayList();
    protected SignatureMethod signatureMethod = null;
    protected CanonicalizationMethod canonicalizationMethod = null;
    protected DigestMethod digestMethod = null;
    protected Map signingNodeMap = new HashMap();

    public void addSignatureTokens(SecurityTokenType[] securityTokenTypeArray) {
        for (int i = 0; i < securityTokenTypeArray.length; ++i) {
            this.addSignatureToken(securityTokenTypeArray[i]);
        }
    }

    public void addSignatureToken(SecurityTokenType securityTokenType) {
        SecurityToken securityToken = SecurityTokenFactory.makeSecurityToken(securityTokenType);
        this.addSignatureToken(securityToken);
    }

    public void addSignatureToken(SecurityToken securityToken) {
        this.validSignatureTokens.add(securityToken);
    }

    public void setValidSignatureTokens(List list) {
        this.validSignatureTokens = list;
    }

    public List getValidSignatureTokens() {
        return this.validSignatureTokens;
    }

    public abstract void setSignatureMethod(String var1) throws SecurityPolicyArchitectureException;

    public void setSignatureMethod(SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public abstract void setCanonicalizationMethod(String var1) throws SecurityPolicyArchitectureException;

    public void setCanonicalizationMethod(CanonicalizationMethod canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public abstract void setDigestMethod(String var1) throws SecurityPolicyArchitectureException;

    public void setDigestMethod(DigestMethod digestMethod) {
        this.digestMethod = digestMethod;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public void setTokenProtection(boolean bl) {
        this.isTokenProtection = bl;
    }

    public boolean signedSecurityTokens() {
        return this.isTokenProtection;
    }

    public void setIncludeSigningTokens(boolean bl) {
        this.includeSigningTokens = bl;
    }

    public boolean isIncludeSigningTokens() {
        return this.includeSigningTokens;
    }

    public void addSignatureNode(String string, Node node) {
        if (this.signingNodeMap.containsKey(string)) {
            Object v = this.signingNodeMap.get(string);
            if (null == node && null != v) {
                return;
            }
        }
        this.signingNodeMap.put(string, node);
    }

    public void addSignatureReference(String string, Reference reference) {
        if (this.signingNodeMap.containsKey(string)) {
            Object v = this.signingNodeMap.get(string);
            if (null == reference && null != v) {
                return;
            }
        }
        this.signingNodeMap.put(string, reference);
    }

    public Map getSigningNodeMap() {
        return this.signingNodeMap;
    }

    public void setSigningNodeMap(Map map) {
        this.signingNodeMap = map;
    }

    public void addQNameExprNode(String string, QNameExpr qNameExpr) {
        if (qNameExpr == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.signingNodeMap.containsKey(string)) {
            this.signingNodeMap.put(string, qNameExpr);
        } else {
            this.signingNodeMap.put(string + SigningPolicyBlueprintImpl.sequnce++, qNameExpr);
        }
    }

    public void addXPathFilter2NodeList(String string, List<XPath> list) {
        assert (string != null && list != null);
        this.signingNodeMap.put(string + SigningPolicyBlueprintImpl.sequnce++, list);
    }

    public void addXPathNode(String string, MessagePartsType messagePartsType) {
        if (messagePartsType == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.signingNodeMap.containsKey(string)) {
            this.signingNodeMap.put(string, messagePartsType);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object v = this.signingNodeMap.get(string);
            if (v instanceof List) {
                arrayList.addAll((List)v);
            } else {
                arrayList.add(v);
            }
            arrayList.add(messagePartsType);
            this.signingNodeMap.put(string, arrayList);
        }
    }

    public void addXPathNode(String string, XPath xPath) {
        if (xPath == null || string == null) {
            throw new IllegalArgumentException("null arg received");
        }
        if (!this.signingNodeMap.containsKey(string)) {
            this.signingNodeMap.put(string, xPath);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object v = this.signingNodeMap.get(string);
            if (v instanceof List) {
                arrayList.addAll((List)v);
            } else {
                arrayList.add(v);
            }
            arrayList.add(xPath);
            this.signingNodeMap.put(string, arrayList);
        }
    }

    public void addReferences(List list) {
        this.references.addAll(list);
    }

    public abstract List getReferences() throws SecurityPolicyArchitectureException, WSSecurityException;

    public void setX509AuthConditional(boolean bl) {
        this.X509AuthConditional = bl;
    }

    public boolean isX509AuthConditional() {
        return this.X509AuthConditional;
    }

    public boolean hasSignatureToken() {
        return this.validSignatureTokens != null && !this.validSignatureTokens.isEmpty();
    }

    public boolean isSignatureRequired() {
        return this.hasSignatureToken() && 0 != this.signingNodeMap.size() + this.references.size();
    }

    public String getDerivedFromTokenType() {
        if (this.validSignatureTokens.size() == 0) {
            return null;
        }
        List list = this.getValidSignatureTokens();
        for (SecurityToken securityToken : list) {
            if (securityToken.getDerivedFromTokenType() == null) continue;
            return securityToken.getDerivedFromTokenType();
        }
        return null;
    }

    public boolean isPolicyValid() {
        if (0 == this.signingNodeMap.size() + this.references.size()) {
            return true;
        }
        return this.validSignatureTokens.size() > 0;
    }

    public SignedInfo newSignedInfo(XMLSignatureFactory xMLSignatureFactory, Reference reference) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>(this.references);
        arrayList.add(reference);
        return xMLSignatureFactory.newSignedInfo(this.canonicalizationMethod, this.signatureMethod, arrayList);
    }
}

