/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.policy.wssp;

import java.math.BigInteger;
import weblogic.wsee.security.policy.assertions.MessageAgeAssertion;
import weblogic.wsee.security.wss.policy.TimestampPolicy;

public class TimestampPolicyImpl
implements TimestampPolicy {
    private short messageAgeSeconds = (short)-1;
    private boolean includeTimestamp = false;
    private boolean signTimestampRequired = false;

    public TimestampPolicyImpl() {
    }

    public TimestampPolicyImpl(MessageAgeAssertion messageAgeAssertion) {
        BigInteger bigInteger = messageAgeAssertion.getXbean().getMessageAge().getAge();
        if (bigInteger != null) {
            this.messageAgeSeconds = (short)bigInteger.intValue();
        }
    }

    public short getMessageAgeSeconds() {
        if (this.isIncludeTimestamp() && this.messageAgeSeconds == -1) {
            return 0;
        }
        return this.messageAgeSeconds;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean bl) {
        this.includeTimestamp = bl;
    }

    public void setMessageAgeSeconds(short s) {
        this.messageAgeSeconds = s;
    }

    public boolean isSignTimestampRequired() {
        return this.signTimestampRequired;
    }

    public void setSignTimestampRequired(boolean bl) {
        this.signTimestampRequired = bl;
    }

    public void setSignTimestampRequired() {
        this.signTimestampRequired = true;
    }
}

