/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.sps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.wsee.policy.factory.DefaultPolicyAssertion;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.policy.SecurityPolicyAssertionHelper;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprintDesigner;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutline;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.security.wss.sps.SmartSecurityPolicyBlueprint;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartPolicySelector {
    private static final boolean verbose = Verbose.isVerbose(SmartPolicySelector.class);
    private static final boolean debug = false;
    private int[] policyPriorityIndex = null;
    private NormalizedExpression normalizedPolicy;
    private NormalizedExpression normalizedReferencePolicy;
    private List securityAssertionList;
    private SecurityBuilder sbuilder = null;
    private SecurityValidator securityValidator = null;
    private WSS11Context securityContex = null;
    private PolicySelectionPreference preference = null;
    private PolicyAlternative[] policyAlternatives = null;
    private int reasonCode = 0;
    private String reasons;

    public SmartPolicySelector(SecurityBuilder securityBuilder, NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.sbuilder = securityBuilder;
        this.securityContex = wSS11Context;
        this.init(normalizedExpression, normalizedExpression2, map, bl);
    }

    public SmartPolicySelector(SecurityValidator securityValidator, SecurityBuilder securityBuilder, NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == securityValidator || null == securityBuilder) {
            throw new IllegalArgumentException("Null security builder found");
        }
        this.securityValidator = securityValidator;
        this.securityContex = wSS11Context;
        this.sbuilder = securityBuilder;
        this.init(normalizedExpression, normalizedExpression2, map, bl);
    }

    public SmartPolicySelector(NormalizedExpression normalizedExpression, Map<String, Object> map, boolean bl, WSS11Context wSS11Context) throws WSSecurityException, SecurityPolicyArchitectureException {
        this.securityValidator = null;
        this.securityContex = wSS11Context;
        this.sbuilder = new SecurityBuilderImpl(wSS11Context);
        this.init(normalizedExpression, null, map, bl);
    }

    private void init(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        this.normalizedPolicy = normalizedExpression;
        if (map != null) {
            this.preference = (PolicySelectionPreference)map.get("weblogic.wsee.policy.selection.preference");
        }
        if (null == this.preference) {
            this.preference = new PolicySelectionPreference();
        }
        this.normalizedReferencePolicy = normalizedExpression2;
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        if (normalizedExpression != null) {
            this.loadPolicyList(normalizedExpression, map, bl);
        } else {
            this.loadPolicyList(normalizedExpression2, map, bl);
        }
    }

    public String tellMeWhy() {
        if (null == this.reasons) {
            return "Unable to find a good policy";
        }
        return this.reasons;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public boolean hasSecurityPolicyAlternative() {
        if (this.normalizedPolicy == null || this.policyAlternatives == null || this.policyAlternatives.length == 0) {
            return false;
        }
        return this.securityAssertionList != null && 0 != this.getPolicyAlternativeCount();
    }

    private void loadPolicyList(NormalizedExpression normalizedExpression, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        if (null == normalizedExpression || !SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression)) {
            this.securityAssertionList = null;
            return;
        }
        ArrayList<SecurityPolicyAssertionInfo> arrayList = new ArrayList<SecurityPolicyAssertionInfo>();
        this.policyAlternatives = new PolicyAlternative[normalizedExpression.getPolicyAlternatives().size()];
        Iterator iterator = normalizedExpression.getPolicyAlternatives().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PolicyAlternative policyAlternative = (PolicyAlternative)iterator.next();
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            arrayList.add(securityPolicyAssertionInfo);
            this.policyAlternatives[n++] = policyAlternative;
        }
        this.securityAssertionList = arrayList.size() > 0 ? this.buildSmartPolicyList(arrayList, map, bl) : null;
    }

    private List buildSmartPolicyList(List list, Map<String, Object> map, boolean bl) throws WSSecurityException, SecurityPolicyArchitectureException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = -1;
        Object object2 = null;
        int n2 = -1;
        SecurityPolicyArchitectureException securityPolicyArchitectureException = null;
        Iterator iterator = list.iterator();
        String string = "";
        if (list.size() > 1) {
            string = "Unable to find a matched policy alternative due to: ";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        while (iterator.hasNext() || !linkedList.isEmpty()) {
            Serializable serializable;
            object = null;
            if (iterator.hasNext()) {
                object = (SecurityPolicyAssertionInfo)iterator.next();
                ++n;
                if (null == object) continue;
                int n3 = SecurityPolicyAssertionHelper.policyLogicalErrorDetectorRuntime(this.policyAlternatives[n]);
                if (n3 != 0) {
                    stringBuffer.append("-- Found policy logic errors, error code =" + n3 + ";  ");
                    continue;
                }
                serializable = SecurityPolicyAssertionHelper.getPolicyAlternativeWithoutOption(this.policyAlternatives[n]);
                if (null != serializable) {
                    linkedList.add(serializable);
                }
            } else {
                PolicyAlternative policyAlternative = (PolicyAlternative)linkedList.pollLast();
                object = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            }
            if (object.hasUnidentifiedAssertion()) {
                List list2 = object.getUnidentifiedAssertions();
                serializable = new StringBuffer();
                for (int i = 0; i < list2.size(); ++i) {
                    PolicyAssertion policyAssertion = (PolicyAssertion)list2.get(i);
                    String string2 = policyAssertion instanceof DefaultPolicyAssertion ? " unidentified assertion =" + ((DefaultPolicyAssertion)policyAssertion).toString() : " unidentified assertion " + policyAssertion + " Name =" + policyAssertion.getName() + " Subject " + policyAssertion.getPolicySubject().name();
                    ((StringBuffer)serializable).append(string2);
                    if (!verbose) continue;
                    Verbose.log("Found an" + string2);
                }
                stringBuffer.append(((StringBuffer)serializable).toString());
                if (null == object2) {
                    object2 = object;
                    n2 = n;
                    continue;
                }
                if (!verbose) continue;
                Verbose.log("Multiple ufo found, msg =" + ((StringBuffer)serializable).toString());
                continue;
            }
            try {
                SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = this.buildSmartPolicy((SecurityPolicyAssertionInfo)object, map, bl, n);
                if (!smartSecurityPolicyBlueprint.hasUnsupportedFeature(524288L)) {
                    String[] stringArray;
                    boolean bl2 = false;
                    if (null != this.securityContex && this.securityContex.getCredentialProviders().size() > 0 && null != (stringArray = smartSecurityPolicyBlueprint.getTokenTypes())) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (this.securityContex.getCredentialProvider(stringArray[i]) != null) continue;
                            stringBuffer.append("-- No credential provider found for token type = [" + stringArray[i] + "];  ");
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    arrayList.add(smartSecurityPolicyBlueprint);
                    continue;
                }
                stringBuffer.append("-- " + smartSecurityPolicyBlueprint.tellMeWhyNotSupported(524288L) + ";  ");
            }
            catch (SecurityPolicyArchitectureException securityPolicyArchitectureException2) {
                securityPolicyArchitectureException = securityPolicyArchitectureException2;
            }
        }
        if (arrayList.size() == 0) {
            if (null != object2) {
                object = this.buildSmartPolicy((SecurityPolicyAssertionInfo)object2, map, bl, n2);
                arrayList.add(object);
                return arrayList;
            }
            if (securityPolicyArchitectureException == null) {
                securityPolicyArchitectureException = new SecurityPolicyArchitectureException(stringBuffer.toString());
            }
            throw securityPolicyArchitectureException;
        }
        return arrayList;
    }

    private SmartSecurityPolicyBlueprint buildSmartPolicy(SecurityPolicyAssertionInfo securityPolicyAssertionInfo, Map<String, Object> map, boolean bl, int n) throws WSSecurityException, SecurityPolicyArchitectureException {
        SecurityPolicyBlueprintDesigner securityPolicyBlueprintDesigner = this.securityValidator != null ? new SecurityPolicyBlueprintDesigner(this.securityValidator) : new SecurityPolicyBlueprintDesigner(this.sbuilder);
        securityPolicyBlueprintDesigner.designOutboundBlueprint(securityPolicyAssertionInfo, map, bl);
        return new SmartSecurityPolicyBlueprint(securityPolicyBlueprintDesigner.getBlueprint(), n, this.policyAlternatives[n], this.securityContex);
    }

    private boolean isGoodSecuritySecurityPolicyAssertion(SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint) {
        if (smartSecurityPolicyBlueprint.isCertRequired()) {
            return true;
        }
        return true;
    }

    public int getPolicyAlternativeCount() {
        if (null == this.securityAssertionList) {
            return 0;
        }
        return this.securityAssertionList.size();
    }

    public SmartSecurityPolicyBlueprint[] getSmartPolicyBlueprint(SecurityPolicyOutline securityPolicyOutline) throws SecurityPolicyInspectionException {
        Object object;
        Object object22;
        if (this.securityAssertionList == null || 0 == this.getPolicyAlternativeCount()) {
            return null;
        }
        if (null == securityPolicyOutline || null == securityPolicyOutline.getGeneralPolicy()) {
            Verbose.log("There is no information on the incoming SOAP message.");
            Iterator iterator = this.securityAssertionList.iterator();
            SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = new SmartSecurityPolicyBlueprint[this.securityAssertionList.size()];
            int n = 0;
            while (iterator.hasNext()) {
                SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = (SmartSecurityPolicyBlueprint)iterator.next();
                smartSecurityPolicyBlueprintArray[n++] = smartSecurityPolicyBlueprint;
            }
            return smartSecurityPolicyBlueprintArray;
        }
        SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = new SmartSecurityPolicyBlueprint(securityPolicyOutline);
        if (this.securityAssertionList.size() == 1) {
            SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = new SmartSecurityPolicyBlueprint[]{(SmartSecurityPolicyBlueprint)this.securityAssertionList.get(0)};
            if (!smartSecurityPolicyBlueprint.hasDescribed()) {
                return smartSecurityPolicyBlueprintArray;
            }
            if (smartSecurityPolicyBlueprintArray[0].getMessageOutlook() == smartSecurityPolicyBlueprint.getMessageOutlook()) {
                return smartSecurityPolicyBlueprintArray;
            }
            if (smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() == smartSecurityPolicyBlueprint.getMessageOutlook()) {
                return smartSecurityPolicyBlueprintArray;
            }
            if ((smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() || (smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == smartSecurityPolicyBlueprintArray[0].getPolicyOutlookWithMask(smartSecurityPolicyBlueprint.getMessageOutlookMask()) || (smartSecurityPolicyBlueprintArray[0].getMessageOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == smartSecurityPolicyBlueprintArray[0].getMessageOutlook()) {
                return smartSecurityPolicyBlueprintArray;
            }
            if (verbose) {
                Verbose.log("NO match on only one!\nBlueprint Outlook =" + smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() + " Msg outlook =" + smartSecurityPolicyBlueprintArray[0].getMessageOutlook() + " getActualPolicyOutlook() & samrtOutline.getMessageOutlook()" + (smartSecurityPolicyBlueprintArray[0].getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) + " getPolicyOutlookWithMask(samrtOutline.getMessageOutlookMask() " + smartSecurityPolicyBlueprintArray[0].getPolicyOutlookWithMask(smartSecurityPolicyBlueprint.getMessageOutlookMask()) + " getMessageOutlook() & samrtOutline.getMessageOutlook()" + (smartSecurityPolicyBlueprintArray[0].getMessageOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()));
            }
            String string = smartSecurityPolicyBlueprintArray[0].tellMeWhy(smartSecurityPolicyBlueprint.getMessageOutlook());
            int n = smartSecurityPolicyBlueprintArray[0].getErrorCode(smartSecurityPolicyBlueprint.getMessageOutlook());
            throw new SecurityPolicyInspectionException(n, string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : this.securityAssertionList) {
            if (((SmartSecurityPolicyBlueprint)object22).getMessageOutlook() != smartSecurityPolicyBlueprint.getMessageOutlook()) continue;
            arrayList.add(object22);
        }
        for (Object object22 : this.securityAssertionList) {
            if (((SmartSecurityPolicyBlueprint)object22).getMessageOutlook() == smartSecurityPolicyBlueprint.getMessageOutlook() || ((SmartSecurityPolicyBlueprint)object22).getActualPolicyOutlook() != smartSecurityPolicyBlueprint.getMessageOutlook()) continue;
            arrayList.add(object22);
        }
        object22 = new StringBuffer();
        for (Object[] objectArray : this.securityAssertionList) {
            if (objectArray.getMessageOutlook() == smartSecurityPolicyBlueprint.getMessageOutlook() || objectArray.getActualPolicyOutlook() == smartSecurityPolicyBlueprint.getMessageOutlook()) continue;
            if ((objectArray.getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == objectArray.getActualPolicyOutlook() || (objectArray.getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == objectArray.getPolicyOutlookWithMask(smartSecurityPolicyBlueprint.getMessageOutlookMask()) || (objectArray.getMessageOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) == objectArray.getMessageOutlook()) {
                arrayList.add(objectArray);
                continue;
            }
            object = objectArray.tellMeWhy(smartSecurityPolicyBlueprint.getMessageOutlook());
            if (verbose) {
                Verbose.log("Not a possible match policy reason " + (String)object + "\nBlueprint Outlook =" + objectArray.getActualPolicyOutlook() + " Msg outlook =" + objectArray.getMessageOutlook() + " getActualPolicyOutlook() & samrtOutline.getMessageOutlook()" + (objectArray.getActualPolicyOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()) + " getPolicyOutlookWithMask(samrtOutline.getMessageOutlookMask() " + objectArray.getPolicyOutlookWithMask(smartSecurityPolicyBlueprint.getMessageOutlookMask()) + " getMessageOutlook() & samrtOutline.getMessageOutlook()" + (objectArray.getMessageOutlook() & smartSecurityPolicyBlueprint.getMessageOutlook()));
            }
            ((StringBuffer)object22).append((String)object);
        }
        if (arrayList.size() > 0) {
            Object[] objectArray;
            objectArray = arrayList.toArray();
            object = new SmartSecurityPolicyBlueprint[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object[i] = (SmartSecurityPolicyBlueprint)objectArray[i];
            }
            return object;
        }
        throw new SecurityPolicyInspectionException(((StringBuffer)object22).toString());
    }

    public SmartSecurityPolicyBlueprint[] getSmartPolicyBlueprint() {
        if (this.securityAssertionList == null || 0 == this.getPolicyAlternativeCount()) {
            return null;
        }
        Object[] objectArray = this.securityAssertionList.toArray();
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = new SmartSecurityPolicyBlueprint[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            smartSecurityPolicyBlueprintArray[i] = (SmartSecurityPolicyBlueprint)objectArray[i];
        }
        return smartSecurityPolicyBlueprintArray;
    }

    public SecurityPolicyBlueprint[] getPolicyBlueprint() {
        if (this.securityAssertionList == null || 0 == this.getPolicyAlternativeCount()) {
            return null;
        }
        this.setPolicyPriorityIndex(this.preference);
        return SmartPolicySelector.getSecurityPolicyBlueprintArray(this.securityAssertionList);
    }

    public PolicyAlternative getFirstPolicyAlternative(PolicySelectionPreference policySelectionPreference) {
        if (this.securityAssertionList == null || 0 == this.getPolicyAlternativeCount()) {
            return null;
        }
        if (null == policySelectionPreference) {
            policySelectionPreference = new PolicySelectionPreference();
        }
        this.setPolicyPriorityIndex(policySelectionPreference);
        SmartSecurityPolicyBlueprint[] smartSecurityPolicyBlueprintArray = this.getSmartPolicyBlueprint();
        SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = smartSecurityPolicyBlueprintArray[this.policyPriorityIndex[0]];
        return smartSecurityPolicyBlueprint.getPolicyAlternative();
    }

    protected void setPolicyPriorityIndex(PolicySelectionPreference policySelectionPreference) {
        if (null == policySelectionPreference) {
            policySelectionPreference = new PolicySelectionPreference();
        }
        this.preference = policySelectionPreference;
        if (1 == this.getPolicyAlternativeCount()) {
            this.policyPriorityIndex = new int[1];
            this.policyPriorityIndex[0] = 0;
        } else {
            this.policyPriorityIndex = this.sortPolicies(this.securityAssertionList, policySelectionPreference);
        }
    }

    public int[] getPolicyPriorityIndex(PolicySelectionPreference policySelectionPreference) {
        if (null == policySelectionPreference || policySelectionPreference.isDefaut() || 1 == this.getPolicyAlternativeCount()) {
            int[] nArray = new int[this.getPolicyAlternativeCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        return this.sortPolicies(this.securityAssertionList, policySelectionPreference);
    }

    public int[] getPolicyPriorityIndex() {
        if (null == this.policyPriorityIndex) {
            this.setPolicyPriorityIndex(this.preference);
        }
        return this.policyPriorityIndex;
    }

    private SecurityPolicyAssertionInfo getResponsePolicy() {
        if (null == this.normalizedReferencePolicy) {
            return null;
        }
        return null;
    }

    private boolean checkMixPolicyOfWSS() {
        int n = 0;
        for (int i = 0; i < this.getPolicyAlternativeCount(); ++i) {
            SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = (SmartSecurityPolicyBlueprint)this.securityAssertionList.get(i);
            if (!smartSecurityPolicyBlueprint.isWss11()) continue;
            ++n;
        }
        return n != 0 && n != this.getPolicyAlternativeCount();
    }

    private int[] sortPolicies(List list, PolicySelectionPreference policySelectionPreference) {
        if (null == list) {
            return null;
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            SmartSecurityPolicyBlueprint smartSecurityPolicyBlueprint = (SmartSecurityPolicyBlueprint)list.get(i);
            nArray[i] = smartSecurityPolicyBlueprint.getScore(policySelectionPreference);
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        int[] nArray2 = new int[list.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == n) {
                    nArray2[n2++] = i;
                    continue;
                }
                if (nArray[i] >= n || nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
            n = n3;
        }
        return nArray2;
    }

    private static SecurityPolicyBlueprint[] getSecurityPolicyBlueprintArray(List list) {
        if (null == list) {
            return null;
        }
        SecurityPolicyBlueprint[] securityPolicyBlueprintArray = new SecurityPolicyBlueprint[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            securityPolicyBlueprintArray[i] = SmartPolicySelector.getSecurityPolicyBlueprint(list, i);
        }
        return securityPolicyBlueprintArray;
    }

    private static SecurityPolicyBlueprint getSecurityPolicyBlueprint(List list, int n) {
        if (null == list) {
            return null;
        }
        Object e = list.get(n);
        return ((SmartSecurityPolicyBlueprint)e).getSecurityPolicyBlueprint();
    }

    private SecurityPolicyBlueprint getSecurityPolicyBlueprint(int n) {
        return SmartPolicySelector.getSecurityPolicyBlueprint(this.securityAssertionList, n);
    }
}

