/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wss.sps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.wss.plan.SecurityPolicyBlueprint;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutline;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class SmartSecurityPolicyBlueprint {
    private static final boolean verbose = Verbose.isVerbose(SmartSecurityPolicyBlueprint.class);
    private static final boolean debug = true;
    private SecurityPolicyPlan blueprint;
    private static final int SC_TRANS_SECURITY = 100;
    private static final int SC_USER_NAME_TOKEN = 200;
    private long outlook;
    private long outlookMask;
    private long optionalOutlookMask;
    private boolean isFromActualMessage = false;
    private List tokenList;
    private Map signatureMap;
    private Map encryptionMap;
    public static final long SIGNATURE = 1L;
    public static final long ENCRYPTION = 2L;
    public static final long SIGNATURE_CONFIRMATION = 4L;
    public static final long ENCRYTED_KEY = 8L;
    public static final long REQUIRED_ELEMENT = 16L;
    public static final long ENDORSE_TOKEN = 32L;
    public static final long AUTHENTICATION = 64L;
    public static final long USERNAME_TOKEN = 192L;
    public static final long SAML_TOKEN = 256L;
    public static final long X509_TOKEN_AUTH = 576L;
    public static final long TIME_STAMP = 1024L;
    public static final long BODY_SIGNATURE = 2049L;
    public static final long BODY_ENCRYPTION = 4098L;
    public static final long THUMBPRINT = 8192L;
    public static final long ENCRYPTED_HEADER = 16386L;
    public static final long ENCRYPTED_USERNAME_TOKEN = 32962L;
    public static final long ENCRYPTED_SIGNATURE = 65539L;
    public static final long SAML11_TOKEN = 131072L;
    public static final long SAML20_TOKEN = 262144L;
    public static final long KERBEROS_TOKEN = 524288L;
    public static final long ELEMENT_SIGN_ENCRPT = 0x100000L;
    public static final long WSS11 = 0x200000L;
    public static final long OPTIONAL = 0x400000L;
    public static final long BODY_SIGNATURE_OPTIONAL = 4196353L;
    public static final long BODY_ENCRYPTION_OPTIONAL = 4198402L;
    public static final long SECURE_CONVERSATION = 0x800000L;
    public static final long WSSC13 = 0x1000000L;
    public static final long TRUST13 = 0x2000000L;
    public static final long ISSUED_TOKEN = 0x4000000L;
    private static final int[][] POSITIVE_SCORING = new int[][]{{3, 1, 0}, {3, 1, 0}, {2, 0, 0}, {4, 0, 2}, {4, 0, 0}, {2, 0, 0}, {5, 0, 0}, {3, 2, 1}, {4, 0, 0}, {2, 1, 2}, {1, 4, 0}, {3, 1, 0}, {3, 1, 0}, {1, 2, 0}, {4, 0, 1}, {1, 0, 0}, {1, 0, 0}, {1, 4, 2}, {2, 3, 3}, {1, 0, 0}, {4, 1, 4}, {2, 0, 0}, {0, 0, 5}, {4, 1, 4}, {5, 0, 5}, {5, 0, 4}};
    private static final int[][] NEGATIVE_SCORING = new int[][]{{0, 2, 5}, {0, 2, 5}, {0, 4, 3}, {0, 1, 0}, {0, 3, 1}, {0, 3, 3}, {0, 3, 3}, {0, 0, 1}, {0, 3, 3}, {0, 0, 1}, {0, 0, 1}, {0, 1, 2}, {0, 0, 3}, {0, 0, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 2}, {0, 2, 2}, {0, 3, 2}, {0, 5, 2}, {0, 3, 1}, {0, 4, 3}, {2, 1, 0}, {0, 5, 1}, {0, 5, 0}, {0, 5, 0}};
    private static final int[] MISSING_CODE = new int[]{3001, 4001, 6301, 4701, 2501, 7001, 1001, 1021, 1061, 1041, 6101, 3201, 4201, 2741, 4301, 4621, 4331, 2661, 2761, 1071, 3501, 6401};
    private static final int[] NOT_REQUIRED_CODE = new int[]{3008, 4008, 6308, 4702, 3508, 7008, 1008, 1028, 1068, 1048, 6108, 3208, 4208, 2748, 4308, 4028, 4338, 2668, 2768, 1078, 4508, 6408};
    private static final String[] FEATURES = new String[]{"Signature", "Encryption", "Signature confirmation", "Encryted key", "Required element", "Endorse token", "Authentication", "Username token", "Saml token SV", "X509 token auth", "Time stamp", "Body signature", "Body encryption", "Thumbprint", "Encrypted header", "Encrypted username token", "Encrypted signature", "Saml11 token", "Saml20 token", "Kerberos token", "Element sign encrpt", "Wss11", "Optional", "Secure conversation", "Wssc13", "Trust13"};
    private boolean usernameTokenAuth = false;
    private boolean x509TokenAuth = false;
    private boolean kerberosAuth = false;
    private boolean saml11TokenAuth = false;
    private boolean saml20TokenAuth = false;
    private boolean spnegoToken = false;
    private boolean relToken = false;
    private boolean issuedToken = false;
    WSS11Context securityContext = null;
    private int policyLocationIdx = 0;

    public SmartSecurityPolicyBlueprint(SecurityPolicyBlueprint securityPolicyBlueprint, int n, PolicyAlternative policyAlternative, WSS11Context wSS11Context) {
        this.blueprint = securityPolicyBlueprint;
        this.policyLocationIdx = n;
        this.isFromActualMessage = false;
        this.securityContext = wSS11Context;
        this.setPolicyAlternative(policyAlternative);
        this.init();
    }

    public SmartSecurityPolicyBlueprint(SecurityPolicyOutline securityPolicyOutline) {
        this.blueprint = securityPolicyOutline;
        this.isFromActualMessage = true;
        this.init();
    }

    public PolicyAlternative getPolicyAlternative() {
        return this.blueprint.getPolicyAlternative();
    }

    public void setPolicyAlternative(PolicyAlternative policyAlternative) {
        this.blueprint.setPolicyAlternative(policyAlternative);
    }

    public int getPolicyLocationIdx() {
        return this.policyLocationIdx;
    }

    public long getMessageOutlook() {
        return this.outlook;
    }

    public long getActualPolicyOutlook() {
        return this.outlook & (this.outlookMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long getPolicyOutlookWithMask(long l) {
        return this.outlook & (this.outlookMask ^ 0xFFFFFFFFFFFFFFFFL) & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long getMessageOutlookMask() {
        return this.outlookMask;
    }

    public boolean hasUnsupportedFeature(long l) {
        return (this.outlook & l) != 0L;
    }

    private void addOutlook(long l) {
        if (this.blueprint.hasTransportSecuirity() && !this.isFromActualMessage) {
            if (l == 1L || l == 2L || l == 2049L || l == 4098L || l == 16386L || l == 32962L || l == 65539L || l == 0x100000L || l == 4196353L || l == 4198402L) {
                l = 0L;
            } else if (l == 32L) {
                l = 1L;
            }
        }
        this.outlook |= l;
    }

    private void addPolicyOutlookMask(long l) {
        this.outlookMask |= l;
    }

    private void init() {
        this.outlook = 0L;
        this.tokenList = new ArrayList();
        if (this.isAuthenticationRequired()) {
            this.tokenList.addAll(this.blueprint.getIdentityPolicy().getValidIdentityTokens());
            this.addOutlook(64L);
            this.setAuthToken();
        }
        if (this.isEncryptionRequired()) {
            this.tokenList.addAll(this.blueprint.getEncryptionPolicy().getValidEncryptionTokens());
            this.encryptionMap = this.blueprint.getEncryptionPolicy().getNodeMap();
            this.setSamlToken(this.blueprint.getEncryptionPolicy().getValidEncryptionTokens());
            if (!this.isFromActualMessage) {
                this.addOutlook(2L);
                if (this.isElementEncryption()) {
                    this.addOutlook(0x100000L);
                    this.addPolicyOutlookMask(0x100000L);
                    if (this.getActualSize(this.encryptionMap) == 1) {
                        this.addPolicyOutlookMask(2L);
                    }
                }
            } else if (this.blueprint.isBodyEmpty()) {
                this.addPolicyOutlookMask(4098L);
            } else {
                this.addOutlook(2L);
            }
        } else if (this.isFromActualMessage && this.blueprint.isBodyEmpty()) {
            this.addPolicyOutlookMask(4098L);
            this.addPolicyOutlookMask(2L);
            this.addPolicyOutlookMask(0x200000L);
        }
        if (this.isSignatureRequired()) {
            if (!this.isSignatureEncryptionRequired()) {
                this.tokenList.addAll(this.blueprint.getSigningPolicy().getValidSignatureTokens());
                this.addOutlook(1L);
                this.signatureMap = this.blueprint.getSigningPolicy().getSigningNodeMap();
            }
            this.setSamlToken(this.blueprint.getSigningPolicy().getValidSignatureTokens());
        }
        if (this.isEndorsingRequired()) {
            this.tokenList.addAll(this.blueprint.getEndorsingPolicy().getValidSignatureTokens());
            this.addOutlook(32L);
        }
        if (this.isWss11()) {
            this.addOutlook(0x200000L);
            if (!this.isFromActualMessage) {
                this.addPolicyOutlookMask(0x200000L);
            }
        }
        if (this.isSignatureConfirmationRequired()) {
            this.addOutlook(4L);
        }
        if (this.isTimestampRequired()) {
            this.addOutlook(1024L);
        }
        if (this.isBodyEncrypted()) {
            this.addOutlook(4098L);
        }
        if (this.isBodySigned()) {
            this.addOutlook(2049L);
        }
        if (this.isSignatureEncryptionRequired()) {
            this.addOutlook(65539L);
            if (!this.isFromActualMessage) {
                Map map;
                this.addPolicyOutlookMask(65539L);
                this.addPolicyOutlookMask(1L);
                if (this.isSignatureConfirmationRequired()) {
                    this.addPolicyOutlookMask(4L);
                }
                if (this.isWss11()) {
                    this.addPolicyOutlookMask(0x200000L);
                }
                if ((map = this.blueprint.getSigningPolicy().getSigningNodeMap()).containsKey("Body")) {
                    this.addPolicyOutlookMask(2049L);
                }
                if (this.isElementSignature()) {
                    this.addOutlook(0x100000L);
                    this.addPolicyOutlookMask(0x100000L);
                    if (this.getActualSize(map) == 1) {
                        this.addPolicyOutlookMask(1L);
                    }
                }
                if (this.isEndorsedTokenRequired()) {
                    this.addPolicyOutlookMask(32L);
                }
            }
        }
        if (!this.isFromActualMessage && this.isUsernameTokenEncryptionRequired()) {
            this.addPolicyOutlookMask(192L);
        }
        if (!this.isFromActualMessage && this.isX509TokenAuth() && this.isSignatureRequired()) {
            this.addPolicyOutlookMask(576L);
        }
        if (this.isSecureConversation()) {
            this.addOutlook(0x800000L);
            this.addPolicyOutlookMask(0x800000L);
        }
        if (this.isWssc13()) {
            this.addOutlook(0x1000000L);
            this.addPolicyOutlookMask(0x1000000L);
        }
        if (!this.isFromActualMessage && this.isSamlTokenEncryptionRequired()) {
            this.addPolicyOutlookMask(256L);
            this.addPolicyOutlookMask(64L);
            if (this.isSaml11TokenAuth()) {
                this.addPolicyOutlookMask(131072L);
            }
            if (this.isSaml20TokenAuth()) {
                this.addPolicyOutlookMask(262144L);
            }
            if (this.isWss11()) {
                this.addPolicyOutlookMask(0x200000L);
            }
        }
    }

    private int getActualSize(Map map) {
        ArrayList arrayList = new ArrayList(map.values());
        arrayList.remove(null);
        return arrayList.size();
    }

    public int getErrorCode(long l) {
        if (this.getActualPolicyOutlook() == l) {
            return 0;
        }
        long l2 = this.getActualPolicyOutlook() & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (l2 != 0L) {
            return SmartSecurityPolicyBlueprint.getMissingRc(l2);
        }
        long l3 = (this.outlook ^ 0xFFFFFFFFFFFFFFFFL) & l;
        if (l3 != 0L) {
            return SmartSecurityPolicyBlueprint.getNotRequiredRc(l3);
        }
        return 9999;
    }

    public String tellMeWhy(long l) {
        long l2;
        if (this.getActualPolicyOutlook() == l) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(" Error codes:");
        long l3 = this.getActualPolicyOutlook() & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (l3 != 0L) {
            StringBuffer stringBuffer2 = SmartSecurityPolicyBlueprint.findMissingCodes(l3);
            if (verbose) {
                Verbose.log("Incoming message missing code =" + stringBuffer2);
            }
            stringBuffer.append(stringBuffer2);
        }
        if ((l2 = (this.getActualPolicyOutlook() ^ 0xFFFFFFFFFFFFFFFFL) & l) != 0L) {
            StringBuffer stringBuffer3 = SmartSecurityPolicyBlueprint.findNotRequiredCodes(l2);
            if (verbose) {
                Verbose.log("Incoming message error code =" + stringBuffer3);
            }
            stringBuffer.append(stringBuffer3);
        }
        return stringBuffer.toString();
    }

    public String tellMeWhyNotSupported(long l) {
        StringBuffer stringBuffer = new StringBuffer("Unsupported codes:");
        long l2 = this.outlook & l;
        if (l2 != 0L) {
            StringBuffer stringBuffer2 = SmartSecurityPolicyBlueprint.findNotRequiredCodes(l2);
            if (verbose) {
                Verbose.log("Incoming message error code =" + stringBuffer2);
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private static int getMissingRc(long l) {
        for (int i = 0; i < MISSING_CODE.length; ++i) {
            if ((l & 1L) == 1L) {
                return MISSING_CODE[i];
            }
            l >>= 1;
        }
        return 9999;
    }

    private static int getNotRequiredRc(long l) {
        for (int i = 0; i < NOT_REQUIRED_CODE.length; ++i) {
            if ((l & 1L) == 1L) {
                return NOT_REQUIRED_CODE[i];
            }
            l >>= 1;
        }
        return 9999;
    }

    private static StringBuffer findMissingCodes(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < MISSING_CODE.length; ++i) {
            if ((l & 1L) == 1L) {
                stringBuffer.append(" " + MISSING_CODE[i]);
            }
            l >>= 1;
        }
        return stringBuffer;
    }

    private static StringBuffer findNotRequiredCodes(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < NOT_REQUIRED_CODE.length; ++i) {
            if ((l & 1L) == 1L) {
                stringBuffer.append(" " + NOT_REQUIRED_CODE[i]);
            }
            l >>= 1;
        }
        return stringBuffer;
    }

    public int getScore(PolicySelectionPreference policySelectionPreference) {
        if (null == policySelectionPreference || policySelectionPreference.isDefaut()) {
            return 1;
        }
        int[] nArray = this.securityInteropPerformanceScoring();
        return policySelectionPreference.calculateScore(nArray);
    }

    public SecurityPolicyBlueprint getSecurityPolicyBlueprint() {
        if (this.blueprint instanceof SecurityPolicyBlueprint) {
            return (SecurityPolicyBlueprint)this.blueprint;
        }
        throw new UnsupportedOperationException("Unable to get blueprint from outline");
    }

    public boolean hasDescribed() {
        if (this.blueprint == null || this.blueprint.getGeneralPolicy() == null) {
            return false;
        }
        return this.blueprint.getBuildingPlan() != 0;
    }

    public boolean isSignatureRequired() {
        return this.blueprint.getSigningPolicy().isSignatureRequired();
    }

    public boolean isEncryptionRequired() {
        return this.blueprint.getEncryptionPolicy().isEncryptionRequired();
    }

    public boolean isAuthenticationRequired() {
        return this.blueprint.getIdentityPolicy().isAuthenticationRequired();
    }

    private void setAuthToken() {
        List list = this.blueprint.getIdentityPolicy().getValidIdentityTokens();
        for (int i = 0; i < list.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)list.get(i);
            String string = securityToken.getTokenTypeUri();
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(string)) {
                this.usernameTokenAuth = true;
                this.addOutlook(192L);
                continue;
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7".equals(string) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(string)) {
                this.x509TokenAuth = true;
                this.addOutlook(576L);
                continue;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(string)) {
                this.saml11TokenAuth = true;
                this.addOutlook(256L);
                this.addOutlook(131072L);
                continue;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(string)) {
                this.saml20TokenAuth = true;
                this.addOutlook(256L);
                this.addOutlook(262144L);
                continue;
            }
            if (!"http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1".equals(string)) continue;
            this.kerberosAuth = true;
            this.addOutlook(524288L);
        }
    }

    private void setSamlToken(List list) {
        for (int i = 0; i < list.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)list.get(i);
            String string = securityToken.getTokenTypeUri();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(string)) {
                this.saml11TokenAuth = true;
                this.addOutlook(131072L);
                continue;
            }
            if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(string)) continue;
            this.saml20TokenAuth = true;
            this.addOutlook(262144L);
        }
    }

    public boolean isSaml11TokenAuth() {
        return this.saml11TokenAuth;
    }

    public boolean isSaml20TokenAuth() {
        return this.saml20TokenAuth;
    }

    public boolean isSamlTokenAuth() {
        return this.saml11TokenAuth || this.saml20TokenAuth;
    }

    public boolean isIssuedToken() {
        return this.issuedToken;
    }

    public boolean isRelToken() {
        return this.relToken;
    }

    public boolean isSpnegoToken() {
        return this.spnegoToken;
    }

    public boolean isKerberosAuth() {
        return this.kerberosAuth;
    }

    public boolean isUsernameTokenAuth() {
        return this.usernameTokenAuth;
    }

    public boolean isX509TokenAuth() {
        return this.x509TokenAuth;
    }

    public boolean isEndorsingRequired() {
        return this.blueprint.getEndorsingPolicy().isSignatureRequired();
    }

    public boolean isSignatureConfirmationRequired() {
        return this.blueprint.getGeneralPolicy().isRequireSignatureConfirmation();
    }

    public boolean isTimestampRequired() {
        return this.blueprint.getTimestampPolicy().isSignTimestampRequired();
    }

    public boolean isEndorsedTokenRequired() {
        return this.blueprint.getEndorsingPolicy().isSignatureRequired();
    }

    public boolean isBodySigned() {
        if (!this.isSignatureRequired() || null == this.signatureMap) {
            return false;
        }
        return this.signatureMap.containsKey("Body");
    }

    public boolean isBodyEncrypted() {
        if (!this.isEncryptionRequired() || null == this.encryptionMap) {
            return false;
        }
        return this.encryptionMap.containsKey("Body");
    }

    public boolean isElementEncryption() {
        if (!this.isEncryptionRequired() || null == this.encryptionMap) {
            return false;
        }
        return this.encryptionMap.containsKey("Element");
    }

    public boolean isWssc13() {
        return this.blueprint.getGeneralPolicy().isWssc13();
    }

    public boolean isElementSignature() {
        if (!this.isSignatureRequired() || null == this.signatureMap) {
            return false;
        }
        return this.signatureMap.containsKey("Element");
    }

    public String[] getTokenTypes() {
        if (this.tokenList == null || this.tokenList.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tokenList.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)this.tokenList.get(i);
            if (securityToken.isOptional()) continue;
            arrayList.add(securityToken.getTokenTypeUri());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    protected boolean isThumbprintRequired() {
        if (this.tokenList == null || this.tokenList.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.tokenList.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)this.tokenList.get(i);
            List list = securityToken.getStrTypes();
            if (null == list || list.isEmpty()) continue;
            for (STRType sTRType : list) {
                if (!TokenReferenceTypeHelper.isThrumbprintSTRType(sTRType)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUsernameTokenEncryptionRequired() {
        if (!this.isEncryptionRequired() || null == this.encryptionMap) {
            return false;
        }
        return this.encryptionMap.containsKey("UserNameToken");
    }

    protected boolean isSamlTokenEncryptionRequired() {
        if (!this.isEncryptionRequired() || null == this.encryptionMap) {
            return false;
        }
        return this.encryptionMap.containsKey("SamlToken");
    }

    protected boolean isSignatureEncryptionRequired() {
        if (!this.isEncryptionRequired() || null == this.encryptionMap) {
            return false;
        }
        return this.encryptionMap.containsKey("EncryptSignature");
    }

    public boolean isCertRequired() {
        if (this.tokenList == null || this.tokenList.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.tokenList.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)this.tokenList.get(i);
            String string = securityToken.getTokenTypeUri();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(string) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(string) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(string) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7".equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecureConversation() {
        if (this.tokenList == null || this.tokenList.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.tokenList.size(); ++i) {
            SecurityToken securityToken = (SecurityToken)this.tokenList.get(i);
            String string = securityToken.getTokenTypeUri();
            if (!"http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(string) && !"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk".equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isWss11() {
        return this.blueprint.getGeneralPolicy().isWss11();
    }

    private int[] securityInteropPerformanceScoring() {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        long l = this.outlook;
        for (int i = 0; i < POSITIVE_SCORING.length; ++i) {
            int n;
            if ((l & 1L) == 1L) {
                for (n = 0; n < nArray.length; ++n) {
                    int n2 = n;
                    nArray[n2] = nArray[n2] + POSITIVE_SCORING[i][n];
                }
                if (!verbose) {
                    // empty if block
                }
                stringBuffer.append(FEATURES[i] + " ");
            } else {
                for (n = 0; n < nArray.length; ++n) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + NEGATIVE_SCORING[i][n];
                }
            }
            l >>= 1;
        }
        if (verbose) {
            Verbose.say(stringBuffer.toString() + " are considered for scoring");
        }
        System.out.println("Policy Key =" + this.outlook + " Counted --" + stringBuffer.toString());
        return nArray;
    }

    private void checkTransportSecurity() {
    }

    private void checkAuthentication() {
    }

    public String getPolicyScoringKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policy Key =" + this.outlook + " --");
        long l = this.outlook;
        for (int i = 0; i < POSITIVE_SCORING.length; ++i) {
            if ((l & 1L) == 1L) {
                stringBuffer.append(FEATURES[i] + " ");
            }
            l >>= 1;
        }
        return stringBuffer.toString();
    }
}

