/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.dom.marshal.MarshalException;

public abstract class SecurityTokenBase
implements SecurityToken {
    private String id;

    protected abstract Element marshalInternal(Element var1, Node var2, Map var3) throws MarshalException;

    protected abstract Element unmarshalInternal(Node var1) throws MarshalException;

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        Element element2 = this.marshalInternal(element, node, map);
        if (element2 != null && this.getId() != null && map != null) {
            String string = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            if (string == null) {
                string = "wsu";
                map.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", string);
            }
            DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string, this.getId());
        }
    }

    public void unmarshal(Node node) throws MarshalException {
        Element element = this.unmarshalInternal(node);
        if (element != null) {
            this.setId(DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME));
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = DOMUtils.generateId();
        }
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public PrivateKey getPrivateKey() {
        return null;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        Class<?> clazz = this.getClass();
        if (!clazz.isInstance(object)) {
            return false;
        }
        SecurityTokenBase securityTokenBase = (SecurityTokenBase)object;
        return this.getId().equals(securityTokenBase.getId());
    }
}

