/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc;

import java.util.HashMap;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

public class WSSCCredentialProviderFactory {
    private HashMap<String, CredentialProvider> credProviders = new HashMap();
    private static final WSSCCredentialProviderFactory INSTANCE = new WSSCCredentialProviderFactory();
    private static final String SCT_VALUE_TYPE_V2005 = "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
    private static final String CLIENT_SCT_PROVIDER_V2005 = "weblogic.wsee.security.wssc.v200502.sct.ClientSCCredentialProvider";
    private static final String DK_VALUE_TYPE_V2005 = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
    private static final String CLIENT_DK_PROVIDER_V2005 = "weblogic.wsee.security.wssc.v200502.dk.DKCredentialProvider";
    private static final String SCT_VALUE_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";
    private static final String CLIENT_SCT_PROVIDER_V13 = "weblogic.wsee.security.wssc.v13.sct.ClientSCCredentialProvider";
    private static final String DK_VALUE_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk";
    private static final String CLIENT_DK_PROVIDER_V13 = "weblogic.wsee.security.wssc.v13.dk.DKCredentialProvider";

    private WSSCCredentialProviderFactory() {
        this.credProviders.put(SCT_VALUE_TYPE_V2005, WSSCCredentialProviderFactory.newInstance(CLIENT_SCT_PROVIDER_V2005));
        this.credProviders.put(DK_VALUE_TYPE_V2005, WSSCCredentialProviderFactory.newInstance(CLIENT_DK_PROVIDER_V2005));
        this.credProviders.put(SCT_VALUE_TYPE_V13, WSSCCredentialProviderFactory.newInstance(CLIENT_SCT_PROVIDER_V13));
        this.credProviders.put(DK_VALUE_TYPE_V13, WSSCCredentialProviderFactory.newInstance(CLIENT_DK_PROVIDER_V13));
    }

    public static final WSSCCredentialProviderFactory getInstance() {
        return INSTANCE;
    }

    public CredentialProvider getCredentialProvider(String string) {
        return this.credProviders.get(string);
    }

    private static final CredentialProvider newInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (CredentialProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return null;
    }
}

