/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.dk;

import javax.xml.namespace.QName;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wss.plan.helper.TokenReferenceTypeHelper;
import weblogic.wsee.security.wssc.base.faults.WSCFaultException;
import weblogic.wsee.security.wssc.dk.DKClaims;
import weblogic.wsee.security.wssc.dk.DKCredential;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.STRType;

public abstract class DKCredentialProviderBase
implements CredentialProvider {
    public static final boolean verbose = Verbose.isVerbose(DKCredentialProviderBase.class);

    protected DKCredentialProviderBase() {
    }

    public abstract String[] getValueTypes();

    protected abstract String getURI_P_SHA1();

    protected abstract WSCFaultException newUnknownDerivationSourceException(String var1);

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (purpose == null || purpose.equals(Purpose.IDENTITY) || purpose.equals(Purpose.ENCRYPT_RESPONSE)) {
            return null;
        }
        return this.createNewDK(contextHandler, purpose);
    }

    protected Object createNewDK(ContextHandler contextHandler, Purpose purpose) {
        try {
            Object object;
            SecurityToken securityToken = (SecurityToken)contextHandler.getValue("weblogic.wsee.wsc.derived_from_token");
            if (securityToken == null) {
                return null;
            }
            WSSecurityContext wSSecurityContext = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
            String string = securityToken.getValueType();
            SecurityTokenHandler securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(string);
            QName qName = (QName)contextHandler.getValue("weblogic.wsee.dk.referece_type");
            if (SAMLUtils.isSamlTokenType(string) && (object = TokenReferenceTypeHelper.getSTRTypesForSAMLIssuedToken(string)) != null && object.size() > 0) {
                qName = ((STRType)object.get(0)).getTopLevelElement();
            }
            if (qName == null) {
                qName = WSSConstants.REFERENCE_QNAME;
            }
            object = securityTokenHandler.getSTR(qName, string, securityToken);
            DKCredential dKCredential = new DKCredential();
            dKCredential.setSecurityToken(securityToken);
            dKCredential.setTokenReference((SecurityTokenReference)object);
            dKCredential.setAlgorithm(this.getURI_P_SHA1());
            dKCredential.setLabel(DKClaims.getLabelFromContextHandler(contextHandler));
            dKCredential.setLength(DKClaims.getLengthFromContextHandler(contextHandler));
            dKCredential.setGeneration(0);
            dKCredential.setNonce(KeyUtils.createNonce());
            if (verbose) {
                Verbose.banner("Returning DK Credential");
                Verbose.log("DKLabel: " + dKCredential.getLabel());
                Verbose.log("DKLength: " + dKCredential.getLength());
            }
            if (SAMLUtils.isSamlTokenType(string)) {
                dKCredential.setSecretKey(securityToken.getSecretKey());
            }
            return dKCredential;
        }
        catch (WSSecurityException wSSecurityException) {
            WSTFaultUtil.raiseFault(this.newUnknownDerivationSourceException("Can not create DerivedKey Token"));
            return null;
        }
    }
}

