/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.dk;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.security.wssc.SecurityTokenBase;
import weblogic.wsee.security.wssc.base.WSCConstantsBase;
import weblogic.wsee.security.wssc.base.faults.WSCFaultException;
import weblogic.wsee.security.wssc.dk.DKCredential;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.marshal.MarshalException;

public abstract class DKTokenBase
extends SecurityTokenBase {
    private static final boolean verbose = Verbose.isVerbose(DKTokenBase.class);
    private static final boolean DEBUG = false;
    private DKCredential credential;

    public DKTokenBase() {
    }

    public DKTokenBase(DKCredential dKCredential) {
        this.credential = dKCredential;
    }

    protected abstract QName getDK_ALGORITHM_QNAME();

    protected abstract QName getDK_QNAME();

    protected abstract QName getDK_OFFSET_QNAME();

    protected abstract QName getDK_LENGTH_QNAME();

    protected abstract QName getDK_LABEL_QNAME();

    protected abstract QName getDK_NONCE_QNAME();

    protected abstract QName getDK_GENERATION_QNAME();

    protected abstract String getDK_VALUE_TYPE();

    protected abstract String getURI_P_SHA1();

    protected abstract String getXMLNS_WSS();

    protected abstract String getXMLNS_WSC();

    protected abstract WSCFaultException newBadContextTokenException(String var1);

    protected abstract WSCFaultException newUnknownDerivationSourceException(String var1);

    protected abstract WSCFaultException newUnsupportedContextTokenException(String var1);

    protected Element marshalInternal(Element element, Node node, Map map) throws MarshalException {
        Element element2;
        Element element3 = DOMUtils.createElement(element, this.getDK_QNAME(), "wsc");
        if (this.credential.getAlgorithm() != null) {
            DOMUtils.addAttribute(element3, WSCConstantsBase.DK_ALGORITHM_QNAME, this.credential.getAlgorithm());
        }
        if (this.credential.getTokenReference() != null) {
            this.credential.getTokenReference().marshal(element3, null, map);
        }
        if (this.credential.getGeneration() != -1) {
            element2 = DOMUtils.createAndAddElement(element3, this.getDK_GENERATION_QNAME(), "wsc");
            DOMUtils.addText(element2, Integer.toString(this.credential.getGeneration()));
        }
        if (this.credential.getOffset() != -1) {
            element2 = DOMUtils.createAndAddElement(element3, this.getDK_OFFSET_QNAME(), "wsc");
            DOMUtils.addText(element2, Integer.toString(this.credential.getOffset()));
        }
        if (verbose) {
            Verbose.log("Marshall DK Credential: Length is: " + this.credential.getLength());
        }
        if (this.credential.getLength() != -1) {
            element2 = DOMUtils.createAndAddElement(element3, this.getDK_LENGTH_QNAME(), "wsc");
            DOMUtils.addText(element2, Integer.toString(this.credential.getLength()));
        }
        if (this.credential.getLabel() != null) {
            element2 = DOMUtils.createAndAddElement(element3, this.getDK_LABEL_QNAME(), "wsc");
            DOMUtils.addText(element2, this.credential.getLabel());
        }
        if (this.credential.getNonce() != null) {
            element2 = DOMUtils.createAndAddElement(element3, this.getDK_NONCE_QNAME(), "wsc");
            DOMUtils.addText(element2, new Base64Encoding().encode(this.credential.getNonce()));
        }
        if (node == null) {
            element.appendChild(element3);
        } else {
            element.insertBefore(element3, node);
        }
        return element3;
    }

    protected Element unmarshalInternal(Node node) throws MarshalException {
        Object object;
        Element element = (Element)node;
        this.credential = new DKCredential();
        this.credential.setAlgorithm(DOMUtils.getAttributeValue(element, this.getDK_ALGORITHM_QNAME()));
        Element element2 = DKTokenBase.getElement(element, this.getXMLNS_WSS(), "SecurityTokenReference");
        if (element2 != null) {
            object = SecurityTokenReferenceImpl.createAndUnmarshal(element2);
            this.credential.setTokenReference((SecurityTokenReference)object);
        }
        this.credential.setGeneration(DKTokenBase.getElementAsInt(element, this.getXMLNS_WSC(), "Generation"));
        this.credential.setOffset(DKTokenBase.getElementAsInt(element, this.getXMLNS_WSC(), "Offset"));
        this.credential.setLength(DKTokenBase.getElementAsInt(element, this.getXMLNS_WSC(), "Length"));
        this.credential.setLabel(DKTokenBase.getElementAsString(element, this.getXMLNS_WSC(), "Label"));
        if (this.credential.getLabel() == null) {
            this.credential.setLabel("WS-SecureConversationWS-SecureConversation");
        }
        if ((object = DKTokenBase.getElementAsString(element, this.getXMLNS_WSC(), "Nonce")) != null) {
            this.credential.setNonce(new Base64Encoding().decode((String)object));
        }
        return element;
    }

    public Key getSecretKey() {
        return this.credential.getSecretKey();
    }

    public String getValueType() {
        return this.getDK_VALUE_TYPE();
    }

    public Object getCredential() {
        return this.credential;
    }

    public Key getSecretKey(MessageContext messageContext) {
        Object object;
        if (this.credential == null) {
            return null;
        }
        Key key = this.credential.getSecretKey();
        if (key != null) {
            return key;
        }
        if (this.credential.getAlgorithm() != null && !this.getURI_P_SHA1().equals(this.credential.getAlgorithm())) {
            return null;
        }
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        if (wSSecurityContext == null) {
            return null;
        }
        SecurityTokenReference securityTokenReference = this.credential.getTokenReference();
        if (securityTokenReference == null) {
            return null;
        }
        SecurityToken securityToken = this.credential.getSecurityToken();
        if (securityToken == null) {
            try {
                object = wSSecurityContext.getRequiredTokenHandler(securityTokenReference.getValueType());
                securityToken = object.getSecurityToken(securityTokenReference, messageContext);
                this.credential.setSecurityToken(securityToken);
            }
            catch (WSSecurityException wSSecurityException) {
                Verbose.log((Object)"Could not resolve Referenced Token in Derived Key Token", wSSecurityException);
                WSTFaultUtil.raiseFault(this.newBadContextTokenException("Could not resolve Referenced Token in Derived Key Token"));
            }
        }
        if (securityToken == null) {
            Verbose.log("Could not resolve Referenced Token in Derived Key Token");
            WSTFaultUtil.raiseFault(this.newBadContextTokenException("Could not resolve Referenced Token in Derived Key Token"));
        }
        if ((object = securityToken.getSecretKey()) == null) {
            Verbose.log("Context token does not have a shared secret that is required for deriving secret keys");
            WSTFaultUtil.raiseFault(this.newUnknownDerivationSourceException("Context token does not have a shared secret that is required for deriving secret keys"));
        }
        EncryptedKeyInfoBuilder.debugKey((Key)object, "DK Token got sharedSecret from Referenced Token");
        if (securityToken instanceof SAMLToken) {
            if (verbose) {
                Verbose.log("Return with Symetric Key from SAML Token ");
            }
            return object;
        }
        int n = this.credential.getLength() != -1 ? this.credential.getLength() : 32;
        String string = this.credential.getLabel();
        if (string == null && (string = (String)messageContext.getProperty("weblogic.wsee.wssc.dk.label")) == null) {
            string = "WS-SecureConversation";
        }
        try {
            byte[] byArray = DKTokenBase.concatenate(string.getBytes("UTF-8"), this.credential.getNonce());
            byte[] byArray2 = KeyUtils.P_SHA1((Key)object, byArray, n);
            key = new SecretKeySpec(byArray2, "AES");
            this.credential.setSecretKey(key);
            if (verbose) {
                // empty if block
            }
            EncryptedKeyInfoBuilder.debugKey(key, "DK Token set symetric Key onto new credential");
            return key;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WSTFaultUtil.raiseFault(this.newUnsupportedContextTokenException(noSuchAlgorithmException.getMessage()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WSTFaultUtil.raiseFault(this.newUnsupportedContextTokenException(unsupportedEncodingException.getMessage()));
        }
        catch (InvalidKeyException invalidKeyException) {
            WSTFaultUtil.raiseFault(this.newUnsupportedContextTokenException(invalidKeyException.getMessage()));
        }
        return null;
    }

    private static Element getElement(Element element, String string, String string2) {
        try {
            return weblogic.xml.dom.DOMUtils.getOptionalElementByTagNameNS(element, string, string2);
        }
        catch (DOMProcessingException dOMProcessingException) {
            return null;
        }
    }

    private static int getElementAsInt(Element element, String string, String string2) {
        Element element2 = DKTokenBase.getElement(element, string, string2);
        if (element2 != null) {
            return Integer.parseInt(weblogic.xml.dom.DOMUtils.getTextContent(element2, true));
        }
        return -1;
    }

    private static String getElementAsString(Element element, String string, String string2) {
        Element element2 = DKTokenBase.getElement(element, string, string2);
        if (element2 != null) {
            return weblogic.xml.dom.DOMUtils.getTextContent(element2, true);
        }
        return null;
    }

    private static final byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null && byArray2 != null) {
            return byArray2;
        }
        if (byArray != null && byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

