/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.dk;

import java.security.Key;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.wssc.base.dk.DKTokenBase;
import weblogic.wsee.security.wssc.dk.DKClaims;
import weblogic.wsee.security.wssc.dk.DKCredential;
import weblogic.wsee.security.wssc.dk.DKTokenReference;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.SecretKeyProvider;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.MarshalException;

public abstract class DKTokenHandlerBase
implements SecurityTokenHandler {
    protected abstract QName[] getDK_QNAMES();

    protected abstract String[] getDK_VALUE_TYPES();

    protected abstract DKTokenBase newDKToken();

    protected abstract DKTokenBase newDKToken(DKCredential var1);

    protected abstract String getDK_VALUE_TYPE();

    protected abstract String getSCT_RST_ACTION();

    protected abstract String getXMLNS_WSC();

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        if (object instanceof DKCredential) {
            DKCredential dKCredential = (DKCredential)object;
            if (dKCredential.getLabel() == null) {
                dKCredential.setLabel(DKClaims.getLabelFromContextHandler(contextHandler));
            }
            if (dKCredential.getLength() == -1) {
                dKCredential.setLength(DKClaims.getLengthFromContextHandler(contextHandler));
            }
            return this.newDKToken(dKCredential);
        }
        return null;
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        return SecurityTokenHelper.findSecurityTokenInContext(contextHandler, string);
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (securityToken instanceof DKTokenBase && qName.equals(WSSConstants.REFERENCE_QNAME)) {
            return new DKTokenReference((DKTokenBase)securityToken);
        }
        return null;
    }

    public QName[] getQNames() {
        return this.getDK_QNAMES();
    }

    public String[] getValueTypes() {
        return this.getDK_VALUE_TYPES();
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        DKTokenBase dKTokenBase = this.newDKToken();
        try {
            dKTokenBase.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to unmarshal DerivedKeyToken.", marshalException);
        }
        return dKTokenBase;
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) throws MarshalException {
        DKTokenReference dKTokenReference = new DKTokenReference();
        dKTokenReference.unmarshal(node);
        return dKTokenReference;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        Key key;
        SecretKeyProvider secretKeyProvider = null;
        if (securityToken instanceof DKTokenBase && (key = ((DKTokenBase)securityToken).getSecretKey(messageContext)) != null) {
            byte[] byArray = securityToken.getId() != null ? securityToken.getId().getBytes() : null;
            secretKeyProvider = new SecretKeyProvider(key, null, byArray, SecurityTokenHelper.getURI(securityToken), securityToken);
            EncryptedKeyInfoBuilder.debugKey(key, "secretKey returned from DK TokenHandler of KeyProvider");
        }
        return secretKeyProvider;
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        if (WSSConstants.REFERENCE_QNAME.equals(securityTokenReference.getSTRType())) {
            return SecurityTokenHelper.findSecurityTokenByIdInContext(wSSecurityContext, securityTokenReference.getValueType(), SecurityTokenHelper.getIdFromURI(securityTokenReference.getReferenceURI()));
        }
        if (WSSConstants.KEY_IDENTIFIER_QNAME.equals(securityTokenReference.getSTRType())) {
            KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
            return SecurityTokenHelper.findSecurityTokenByIdInContext(wSSecurityContext, securityTokenReference.getValueType(), new String(keyIdentifier.getIdentifier()));
        }
        throw new WSSecurityException("Failed to retrieve token for reference " + securityTokenReference, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        return new SecurityTokenValidateResult(true);
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        return new SecurityTokenValidateResult(true);
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        return securityToken instanceof DKTokenBase && string.equals(this.getDK_VALUE_TYPE());
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        return null;
    }
}

