/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.CreateSequencePostSecurityTokenCallback;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProactiveRequestor;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProviderBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenHandlerBase;
import weblogic.wsee.security.wssc.faults.FaultVersionHelper;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.sct.SCTClaims;
import weblogic.wsee.security.wssc.sct.SCTStore;
import weblogic.wsee.security.wssc.sct.SCTVersionHelper;
import weblogic.wsee.security.wst.binding.AppliesTo;
import weblogic.wsee.security.wst.binding.ComputedKey;
import weblogic.wsee.security.wst.binding.KeySize;
import weblogic.wsee.security.wst.binding.Lifetime;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponseCollection;
import weblogic.wsee.security.wst.binding.RequestedAttachedReference;
import weblogic.wsee.security.wst.binding.RequestedProofToken;
import weblogic.wsee.security.wst.binding.RequestedSecurityToken;
import weblogic.wsee.security.wst.binding.TokenReferenceBase;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.InvalidScopeException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustSoapClient;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.framework.WSTCredentialProviderHelper;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.WLDOMStructure;

public abstract class ClientSCCredentialProviderBase
extends SCCredentialProviderBase {
    protected static final boolean verbose = Verbose.isVerbose(ClientSCCredentialProviderBase.class);

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose, SCTokenHandlerBase sCTokenHandlerBase) {
        if (purpose == null || purpose.equals(Purpose.ENCRYPT_RESPONSE)) {
            return null;
        }
        SCCredential sCCredential = null;
        SecurityTokenContextHandler securityTokenContextHandler = ClientSCCredentialProviderBase.getSecurityCtxHandler(contextHandler);
        if (securityTokenContextHandler == null) {
            return null;
        }
        MessageContext messageContext = ClientSCCredentialProviderBase.getMessageContext(securityTokenContextHandler);
        if (messageContext == null) {
            return null;
        }
        if (purpose.equals(Purpose.IDENTITY)) {
            sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
            if (sCCredential != null && sCCredential.getSecret() == null) {
                String string3 = ClientSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
                sCCredential = SCTStore.getFromClient(sCCredential.getIdentifier(), string3);
            }
            return sCCredential;
        }
        WSTContext wSTContext = WSTContext.getWSTContext(messageContext);
        this.initWSTContext(wSTContext, messageContext, securityTokenContextHandler, sCTokenHandlerBase, string);
        sCCredential = this.isProactive(messageContext) ? this.requestCredentialWithProactive(messageContext, wSTContext, sCTokenHandlerBase) : this.requestCredential(messageContext, wSTContext, sCTokenHandlerBase);
        try {
            CreateSequencePostSecurityTokenCallback.processCallback(messageContext);
        }
        catch (WsrmException wsrmException) {
            throw new RuntimeException(wsrmException.getMessage());
        }
        return sCCredential;
    }

    private boolean isProactive(MessageContext messageContext) {
        return "true".equalsIgnoreCase((String)messageContext.getProperty("weblogic.wsee.security.wssc.sct.enableSCCredentialProactiveRequestor"));
    }

    private SCCredential requestCredential(MessageContext messageContext, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        SCCredential sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
        String string = ClientSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        if (sCCredential == null) {
            sCCredential = ClientSCCredentialProviderBase.createSCCredential(wSTContext, sCTokenHandlerBase);
            ClientSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
            SCTStore.addToClient(sCCredential, !wSTContext.isSessionPersisted(), string);
        } else if (TrustTokenHelper.isExpired(messageContext, sCCredential.getCreated(), sCCredential.getExpires())) {
            ClientSCCredentialProviderBase.renewCredential(sCCredential, wSTContext, sCTokenHandlerBase);
            ClientSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
            SCTStore.addToClient(sCCredential, !wSTContext.isSessionPersisted(), string);
        }
        return sCCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCCredential requestCredentialWithProactive(MessageContext messageContext, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        SCCredential sCCredential;
        SCCredentialProactiveRequestor sCCredentialProactiveRequestor = SCCredentialProactiveRequestor.getProactiveRequestor(messageContext);
        String string = ClientSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        sCCredentialProactiveRequestor.lock();
        try {
            sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
            if (sCCredential == null) {
                if (verbose) {
                    Verbose.log("SC credential not found in context, needs a new SC credential.");
                }
                sCCredential = ClientSCCredentialProviderBase._createSCCredential(sCCredentialProactiveRequestor, wSTContext, sCTokenHandlerBase);
                ClientSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
                SCTStore.addToClient(sCCredential, !wSTContext.isSessionPersisted(), string);
                sCCredentialProactiveRequestor.asyncRenewNext(sCCredential);
            } else if (TrustTokenHelper.isExpired(messageContext, sCCredential.getCreated(), sCCredential.getExpires())) {
                if (verbose) {
                    Verbose.log("SC credential expires, needs renewal on it.");
                }
                sCCredentialProactiveRequestor.waitOutProactiveRenewal();
                if (TrustTokenHelper.isExpired(messageContext, sCCredential.getCreated(), sCCredential.getExpires())) {
                    ClientSCCredentialProviderBase._renewCredential(sCCredentialProactiveRequestor, sCCredential, wSTContext, sCTokenHandlerBase);
                    if (verbose) {
                        Verbose.log("Renew SC credential without using proactive requestor");
                    }
                    SCCredentialProactiveRequestor sCCredentialProactiveRequestor2 = sCCredentialProactiveRequestor;
                    synchronized (sCCredentialProactiveRequestor2) {
                        ClientSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
                        SCTStore.addToClient(sCCredential, !wSTContext.isSessionPersisted(), string);
                    }
                }
            }
            Object var10_9 = null;
            sCCredentialProactiveRequestor.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            sCCredentialProactiveRequestor.unlock();
            throw throwable;
        }
        return sCCredential;
    }

    public static void cancelSCToken(Stub stub) {
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        boolean bl = false;
        WSTContext wSTContext = null;
        if (map != null && (wSTContext = (WSTContext)map.get("weblogic.wsee.security.wst.framework.WSTContext")) != null) {
            bl = ((SoapMessageContext)wSTContext.getMessageContext()).isSoap12();
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                soapMessageContext.setProperty((String)entry.getKey(), entry.getValue());
            }
            soapMessageContext.setProperty("weblogic.wsee.invoke_properties", map);
        }
        ClientSCCredentialProviderBase.cancelSCToken(soapMessageContext);
    }

    public static void cancelSCToken(BindingProvider bindingProvider) {
        Map map = bindingProvider.getRequestContext();
        boolean bl = false;
        WSTContext wSTContext = null;
        if (map != null && (wSTContext = (WSTContext)map.get("weblogic.wsee.security.wst.framework.WSTContext")) != null) {
            bl = ((SoapMessageContext)wSTContext.getMessageContext()).isSoap12();
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                soapMessageContext.setProperty((String)entry.getKey(), entry.getValue());
            }
            soapMessageContext.setProperty("weblogic.wsee.invoke_properties", map);
        }
        ClientSCCredentialProviderBase.cancelSCToken(soapMessageContext);
    }

    public static void cancelSCToken(MessageContext messageContext) {
        SCCredential sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
        if (sCCredential == null) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("No SCCredential to cancelSCToken"));
        }
        String string = sCCredential.getScNamespace();
        assert (string != null) : "Warning ! SCNamespace in SCCredential is NULL, we require it in cancelSCToken(messageContext) to know which version of SCToken to load for cancel !";
        ClientSCCredentialProviderBase.cancelSCToken(messageContext, string);
    }

    private static void cancelSCToken(MessageContext messageContext, String string) {
        ClientSCCredentialProviderBase.cancelSCToken(messageContext, SCTVersionHelper.newSCTokenHandler(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelSCToken(MessageContext messageContext, SCTokenHandlerBase sCTokenHandlerBase) {
        SCCredential sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
        String string = sCTokenHandlerBase.getSCT_RST_CANCEL_ACTION();
        WSTContext wSTContext = (WSTContext)messageContext.getProperty("weblogic.wsee.security.wst.framework.WSTContext");
        if (wSTContext != null) {
            wSTContext.setAction(string);
        }
        try {
            WSTCredentialProviderHelper.cancelCredential(messageContext, sCCredential, sCTokenHandlerBase, sCTokenHandlerBase.getSCT_VALUE_TYPE(), sCTokenHandlerBase.getCANNED_POLICY_INCLUDE_SCT_FOR_IDENTITY(), sCTokenHandlerBase.getSCT_RST_CANCEL_ACTION());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SCCredentialProactiveRequestor.dispose(messageContext);
            throw throwable;
        }
        SCCredentialProactiveRequestor.dispose(messageContext);
        ClientSCCredentialProviderBase.removeSCFromContext(messageContext);
        String string2 = ClientSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        SCTStore.removeFromClient(sCCredential.getIdentifier(), string2);
    }

    public static void renewSCToken(Stub stub) {
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        boolean bl = false;
        WSTContext wSTContext = null;
        if (map != null && (wSTContext = (WSTContext)map.get("weblogic.wsee.security.wst.framework.WSTContext")) != null) {
            bl = ((SoapMessageContext)wSTContext.getMessageContext()).isSoap12();
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                soapMessageContext.setProperty((String)entry.getKey(), entry.getValue());
            }
            soapMessageContext.setProperty("weblogic.wsee.invoke_properties", map);
        }
        ClientSCCredentialProviderBase.renewSCToken(soapMessageContext);
    }

    public static void renewSCToken(BindingProvider bindingProvider) {
        Map map = bindingProvider.getRequestContext();
        boolean bl = false;
        WSTContext wSTContext = null;
        if (map != null && (wSTContext = (WSTContext)map.get("weblogic.wsee.security.wst.framework.WSTContext")) != null) {
            bl = ((SoapMessageContext)wSTContext.getMessageContext()).isSoap12();
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                soapMessageContext.setProperty((String)entry.getKey(), entry.getValue());
            }
            soapMessageContext.setProperty("weblogic.wsee.invoke_properties", map);
        }
        ClientSCCredentialProviderBase.renewSCToken(soapMessageContext);
    }

    public static void renewSCToken(MessageContext messageContext) {
        SCCredential sCCredential = ClientSCCredentialProviderBase.getSCFromContext(messageContext);
        if (sCCredential == null) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("No SCCredential to renewSCToken"));
        }
        String string = sCCredential.getScNamespace();
        assert (string != null) : "Warning ! SCNamespace in SCCredential is NULL, we require it in renewSCToken(messageContext) to know which version of SCToken to load for renewal !";
        WSTContext wSTContext = (WSTContext)messageContext.getProperty("weblogic.wsee.security.wst.framework.WSTContext");
        ClientSCCredentialProviderBase.renewCredential(sCCredential, wSTContext, SCTVersionHelper.newSCTokenHandler(string));
        ClientSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
        String string2 = ClientSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        SCTStore.addToClient(sCCredential, !wSTContext.isSessionPersisted(), string2);
    }

    static void _renewCredential(SCCredentialProactiveRequestor sCCredentialProactiveRequestor, SCCredential sCCredential, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        SCCredentialProactiveRequestor.Measure measure = sCCredentialProactiveRequestor.createAndStartMeasure();
        ClientSCCredentialProviderBase.renewCredential(sCCredential, wSTContext, sCTokenHandlerBase);
        measure.terminate();
    }

    static void renewCredential(SCCredential sCCredential, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        Lifetime lifetime;
        RequestSecurityTokenResponse requestSecurityTokenResponse = WSTCredentialProviderHelper.renewCredential(wSTContext, sCCredential, sCTokenHandlerBase, sCTokenHandlerBase.getSCT_VALUE_TYPE(), sCTokenHandlerBase.getCANNED_POLICY_INCLUDE_SCT_FOR_IDENTITY(), sCTokenHandlerBase.getSCT_RST_RENEW_ACTION());
        RequestedSecurityToken requestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken();
        if (requestedSecurityToken == null) {
            WSTFaultUtil.raiseFault(FaultVersionHelper.newUnableToRenewException(sCTokenHandlerBase.getXMLNS_WSC(), "No RequestedSecurityToken found in renew RSTR"));
        }
        if ((lifetime = requestSecurityTokenResponse.getLifetime()) == null) {
            WSTFaultUtil.raiseFault(FaultVersionHelper.newUnableToRenewException(sCTokenHandlerBase.getXMLNS_WSC(), "Lifetime is missing in renewal RSTR."));
        }
        sCCredential.setCreated(lifetime.getCreated());
        sCCredential.setExpires(lifetime.getExpires());
    }

    public static SCCredential createSCCredential(TrustSoapClient trustSoapClient, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) throws WSTFaultException {
        ClientSCCredentialProviderBase.initPolicy(null, wSTContext);
        SOAPMessage sOAPMessage = trustSoapClient.requestTrustToken();
        Node node = SOAPHelper.getRSTBaseNode(sOAPMessage);
        if (sCTokenHandlerBase.getXMLNS_WSC().equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection = BindingHelper.unmarshalRSTRCNode(node, sCTokenHandlerBase);
            return ClientSCCredentialProviderBase.getSCCredentialFromRSTRC(wSTContext, requestSecurityTokenResponseCollection, sCTokenHandlerBase);
        }
        if (sCTokenHandlerBase.getXMLNS_WSC().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            RequestSecurityTokenResponse requestSecurityTokenResponse = BindingHelper.unmarshalRSTRNode(node, sCTokenHandlerBase);
            return ClientSCCredentialProviderBase.getSCCredentialFromRSTR(wSTContext, requestSecurityTokenResponse, sCTokenHandlerBase);
        }
        throw new WSTFaultException(" unable to create SCCredential for WS-SC namespace='" + sCTokenHandlerBase.getXMLNS_WSC() + "'.  Namespace not understood.");
    }

    private static SCCredential _createSCCredential(SCCredentialProactiveRequestor sCCredentialProactiveRequestor, WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        SCCredentialProactiveRequestor.Measure measure = sCCredentialProactiveRequestor.createAndStartMeasure();
        SCCredential sCCredential = ClientSCCredentialProviderBase.createSCCredential(wSTContext, sCTokenHandlerBase);
        measure.terminate();
        return sCCredential;
    }

    private static SCCredential createSCCredential(WSTContext wSTContext, SCTokenHandlerBase sCTokenHandlerBase) {
        try {
            RequestSecurityTokenResponse requestSecurityTokenResponse = WSTCredentialProviderHelper.createCredential(wSTContext, (SecurityTokenHandler)sCTokenHandlerBase);
            return ClientSCCredentialProviderBase.getSCCredentialFromRSTR(wSTContext, requestSecurityTokenResponse, sCTokenHandlerBase);
        }
        catch (WSTFaultException wSTFaultException) {
            WSTFaultUtil.raiseFault(wSTFaultException);
            return null;
        }
    }

    private static SCCredential getSCCredentialFromRSTRC(WSTContext wSTContext, RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection, SCTokenHandlerBase sCTokenHandlerBase) throws WSTFaultException {
        List<RequestSecurityTokenResponse> list = requestSecurityTokenResponseCollection.getRequestSecurityTokenResponseCollection();
        if (list.size() <= 0) {
            throw new WSTFaultException(" SecureTokenService did not return a WS-SecureConversation token in the returned RequestSecurityTokenResponseCollection ");
        }
        RequestSecurityTokenResponse requestSecurityTokenResponse = list.get(0);
        return ClientSCCredentialProviderBase.getSCCredentialFromRSTR(wSTContext, requestSecurityTokenResponse, sCTokenHandlerBase);
    }

    private static SCCredential getSCCredentialFromRSTR(WSTContext wSTContext, RequestSecurityTokenResponse requestSecurityTokenResponse, SCTokenHandlerBase sCTokenHandlerBase) throws WSTFaultException {
        Object object;
        WLDOMStructure wLDOMStructure;
        SCCredential sCCredential = sCTokenHandlerBase.newSCCredential();
        TokenType tokenType = requestSecurityTokenResponse.getTokenType();
        if (tokenType != null && !tokenType.getTokenType().equals(sCTokenHandlerBase.getSCT_VALUE_TYPE())) {
            throw new RequestFailedException("Unexpected token type in RSTR: " + tokenType.getTokenType());
        }
        RequestedSecurityToken requestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken();
        if (requestedSecurityToken == null) {
            throw new RequestFailedException("RequestedSecurityToken must be specified");
        }
        SecurityToken securityToken = requestedSecurityToken.getSecurityToken();
        if (!(securityToken instanceof SCTokenBase)) {
            throw new RequestFailedException(securityToken.getValueType() + " is not a SCT");
        }
        SCTokenBase sCTokenBase = (SCTokenBase)securityToken;
        SCCredential sCCredential2 = sCTokenBase.getCredential();
        SCCredential.copy(sCCredential2, sCCredential);
        RequestedProofToken requestedProofToken = requestSecurityTokenResponse.getRequestedProofToken();
        if (requestedProofToken == null) {
            throw new RequestFailedException("RequestedProofToken must be specified");
        }
        ComputedKey computedKey = requestedProofToken.getComputedKey();
        if (computedKey == null) {
            throw new RequestFailedException("ComputedKey is expected in RequestedProofToken");
        }
        String string = computedKey.getUri();
        if (string != null && !string.endsWith("/CK/PSHA1")) {
            throw new InvalidScopeException(string + " of ComputedKey is not supported");
        }
        int n = 256;
        KeySize keySize = requestSecurityTokenResponse.getKeySize();
        if (keySize != null) {
            n = keySize.getSize();
        }
        Key key = null;
        try {
            key = KeyUtils.generateKey(wSTContext.getRstNonce(), requestSecurityTokenResponse.getEntropy().getBinarySecret().getValue(), "AES", n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidScopeException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidScopeException(invalidKeyException.getMessage());
        }
        sCCredential.setSecret(key);
        Lifetime lifetime = requestSecurityTokenResponse.getLifetime();
        sCCredential.setCreated(lifetime.getCreated());
        sCCredential.setExpires(lifetime.getExpires());
        AppliesTo appliesTo = requestSecurityTokenResponse.getAppliesTo();
        if (appliesTo != null) {
            sCCredential.setAppliesTo(appliesTo.getEndpointReference());
            sCCredential.setAppliesToElement(appliesTo.getElement());
        } else {
            sCCredential.setAppliesTo(wSTContext.getAppliesTo());
            sCCredential.setAppliesToElement(wSTContext.getAppliesToElement());
        }
        RequestedAttachedReference requestedAttachedReference = requestSecurityTokenResponse.getRequestedAttachedReference();
        if (requestedAttachedReference != null) {
            wLDOMStructure = requestedAttachedReference.getSecurityTokenReference();
            object = sCCredential.newAttachedSecurityTokenReferenceInfo();
            SCCredential.copyFromSTRToInfo((SecurityTokenReference)wLDOMStructure, (SCCredential.SecurityTokenReferenceInfo)object);
        }
        if ((wLDOMStructure = requestSecurityTokenResponse.getRequestedUnattachedReference()) != null) {
            object = ((TokenReferenceBase)wLDOMStructure).getSecurityTokenReference();
            SCCredential.SecurityTokenReferenceInfo securityTokenReferenceInfo = sCCredential.newUnattachedSecurityTokenReferenceInfo();
            SCCredential.copyFromSTRToInfo((SecurityTokenReference)object, securityTokenReferenceInfo);
        }
        return sCCredential;
    }

    void initWSTContext(WSTContext wSTContext, MessageContext messageContext, SecurityTokenContextHandler securityTokenContextHandler, SCTokenHandlerBase sCTokenHandlerBase, String string) {
        SCTClaims sCTClaims = SCTClaims.newInstance(securityTokenContextHandler);
        long l = sCTClaims.getTokenLifetime();
        if (verbose) {
            Verbose.log("SCT Lifetime from SCTClaims is " + l);
        }
        if (l > 0L) {
            wSTContext.setLifetimePeriod(l);
        }
        wSTContext.setAction(sCTokenHandlerBase.getSCT_RST_ACTION());
        wSTContext.setTokenType(sCTokenHandlerBase.getSCT_VALUE_TYPE());
        String string2 = (String)securityTokenContextHandler.getValue("weblogic.wsee.security.trust_version");
        if (string2 == null) {
            if (string != null) {
                if (string.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
                    string2 = "http://schemas.xmlsoap.org/ws/2005/02/trust";
                } else if (string.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
                    string2 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
                } else {
                    if (verbose) {
                        Verbose.log("WARNING !  could not determine WS-Trust namespace URI from tokenType='" + string + "', forcing value to '" + "http://docs.oasis-open.org/ws-sx/ws-trust/200512" + "'");
                    }
                    string2 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
                }
            } else {
                if (verbose) {
                    Verbose.log("WARNING !  could not determine WS-Trust namespace URI from null tokenType.  Forcing value to 'http://docs.oasis-open.org/ws-sx/ws-trust/200512'");
                }
                string2 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            }
        }
        wSTContext.setTrustVersion(string2);
        String string3 = (String)messageContext.getProperty("weblogic.wsee.security.trust_soap_version");
        if (string3 != null) {
            wSTContext.setSoapVersion(string3);
        }
        wSTContext.initEndpoints(messageContext);
        String string4 = wSTContext.getStsUri();
        if (string4 == null || string4.equals(wSTContext.getEndpointUri())) {
            String string5 = (String)messageContext.getProperty("weblogic.wsee.wst.sts_endpoint_uri");
            string4 = string5 == null || "".equals(string5) ? WSTCredentialProviderHelper.getSTSURIFromConfig(securityTokenContextHandler, messageContext, this.getClass().getName()) : string5;
            if (string4 == null) {
                string4 = wSTContext.getEndpointUri();
            }
            if (verbose) {
                Verbose.log("Settng the STS endpoint URI to [" + string4 + "]");
            }
            wSTContext.setStsUri(string4);
        }
        ClientSCCredentialProviderBase.initPolicy(securityTokenContextHandler, wSTContext);
    }

    private static void initPolicy(SecurityTokenContextHandler securityTokenContextHandler, WSTContext wSTContext) {
        if (wSTContext.getBootstrapPolicy() != null) {
            return;
        }
        NormalizedExpression normalizedExpression = null;
        if (securityTokenContextHandler != null) {
            normalizedExpression = (NormalizedExpression)securityTokenContextHandler.getValue("weblogic.wsee.security.wst_bootstrap_policy");
        }
        if (normalizedExpression == null) {
            normalizedExpression = ClientSCCredentialProviderBase.getTrustBootStrapPolicy(wSTContext.getStsUri().toLowerCase(Locale.ENGLISH).startsWith("https"));
            wSTContext.setWssp(false);
        } else {
            try {
                NormalizedExpression normalizedExpression2 = PolicyContext.getEndpointPolicy(wSTContext.getMessageContext());
                wSTContext.setOuterPolicy(normalizedExpression2);
                wSTContext.setWssp(true);
            }
            catch (PolicyException policyException) {
                throw new RuntimeException(policyException.getMessage());
            }
        }
        if (null == normalizedExpression) {
            throw new IllegalArgumentException("Unable to find the security policy for WS-Trust");
        }
        wSTContext.setBootstrapPolicy(normalizedExpression);
    }

    private static NormalizedExpression getTrustBootStrapPolicy(boolean bl) {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (!bl) {
            try {
                PolicyServer policyServer = new PolicyServer();
                normalizedExpression = policyServer.getPolicy("SecurityTokenService.xml").normalize();
            }
            catch (PolicyException policyException) {
                // empty catch block
            }
        }
        return normalizedExpression;
    }

    static void p(String string) {
        Verbose.log(" [ClientSCCredentialProviderBase THORICK] " + string);
    }
}

