/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.xml.rpc.handler.MessageContext;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.security.wssc.base.sct.ClientSCCredentialProviderBase;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProviderBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.sct.SCTStore;
import weblogic.wsee.security.wssc.v200502.sct.SCTokenHandler;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.util.Verbose;

public class SCCredentialProactiveRequestor {
    private static final boolean verbose = Verbose.isVerbose(SCCredentialProactiveRequestor.class);
    public static final String ENABLE_SC_CREDENTIAL_PROACTIVE_REQUESTOR = "weblogic.wsee.security.wssc.sct.enableSCCredentialProactiveRequestor";
    public static final String SC_CREDENTIAL_PROACTIVE_REQUESTOR = "weblogic.wsee.security.wssc.sct.scCredentialProactiveRequestor";
    private MessageContext context = null;
    private Semaphore lock = new Semaphore(1);
    private Semaphore proactiveRenewalSignal = new Semaphore(1);
    private long avgTimePeriod = -1L;
    private TimerManager tm = null;

    private SCCredentialProactiveRequestor(MessageContext messageContext) {
        this.context = messageContext;
    }

    public static SCCredentialProactiveRequestor getProactiveRequestor(MessageContext messageContext) {
        SCCredentialProactiveRequestor sCCredentialProactiveRequestor = (SCCredentialProactiveRequestor)messageContext.getProperty(SC_CREDENTIAL_PROACTIVE_REQUESTOR);
        if (sCCredentialProactiveRequestor == null) {
            sCCredentialProactiveRequestor = new SCCredentialProactiveRequestor(messageContext);
            messageContext.setProperty(SC_CREDENTIAL_PROACTIVE_REQUESTOR, (Object)sCCredentialProactiveRequestor);
            ConcurrentHashMap<String, SCCredentialProactiveRequestor> concurrentHashMap = (ConcurrentHashMap<String, SCCredentialProactiveRequestor>)messageContext.getProperty("weblogic.wsee.invoke_properties");
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap<String, SCCredentialProactiveRequestor>();
                messageContext.setProperty("weblogic.wsee.invoke_properties", concurrentHashMap);
            }
            concurrentHashMap.put(SC_CREDENTIAL_PROACTIVE_REQUESTOR, sCCredentialProactiveRequestor);
        }
        return sCCredentialProactiveRequestor;
    }

    public boolean verify(MessageContext messageContext) {
        return this.context == messageContext;
    }

    public void lock() {
        try {
            this.lock.acquire();
            if (verbose) {
                Verbose.log("Lock to exchange SC credential");
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void unlock() {
        this.lock.release();
        if (verbose) {
            Verbose.log("Unlock after exchanging SC credential");
        }
    }

    public Measure createAndStartMeasure() {
        return new Measure();
    }

    public void asyncRenewNext(SCCredential sCCredential) {
        this.asyncRenewNext(sCCredential, new RenewTimerListener(sCCredential));
    }

    private void asyncRenewNext(SCCredential sCCredential, TimerListener timerListener) {
        if (this.tm == null) {
            this.tm = TimerManagerFactory.getTimerManagerFactory().getTimerManager("sc_credential_proactive_requestor-" + sCCredential.getIdentifier(), WorkManagerFactory.getInstance().getSystem());
        }
        Calendar calendar = (Calendar)sCCredential.getExpires().clone();
        calendar.add(14, (int)this.avgTimePeriod * -2);
        this.tm.schedule(timerListener, calendar.getTime());
        if (verbose) {
            Verbose.log("Schedules to async renew SC credential at " + calendar.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOutProactiveRenewal() {
        boolean bl = false;
        try {
            WSTContext wSTContext = WSTContext.getWSTContext(this.context);
            long l = this.avgTimePeriod == -1L ? wSTContext.getLifetimePeriod() : this.avgTimePeriod * 5L;
            bl = this.proactiveRenewalSignal.tryAcquire(l, TimeUnit.MILLISECONDS);
            if (verbose) {
                if (bl) {
                    Verbose.log("Waits out proactive async renewal");
                } else {
                    Verbose.log("Proactive nenewal not return in " + l / 1000L + " seconds, don't continue to wait it out");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        finally {
            if (bl) {
                this.proactiveRenewalSignal.release();
            }
        }
    }

    public static void dispose(MessageContext messageContext) {
        SCCredentialProactiveRequestor sCCredentialProactiveRequestor = (SCCredentialProactiveRequestor)messageContext.getProperty(SC_CREDENTIAL_PROACTIVE_REQUESTOR);
        if (sCCredentialProactiveRequestor == null) {
            return;
        }
        sCCredentialProactiveRequestor.dispose();
    }

    public void dispose() {
        block4: {
            if (this.tm == null) {
                return;
            }
            try {
                this.tm.stop();
                this.tm = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!verbose) break block4;
                Verbose.log("Fails to stop the thread for proactive async renewal");
                Verbose.logException(throwable);
            }
        }
        if (verbose) {
            Verbose.log("SC credential proactive requestor is disposed");
        }
    }

    public class Measure {
        private long startTime = System.currentTimeMillis();

        private Measure() {
        }

        public void terminate() {
            long l = System.currentTimeMillis() - this.startTime;
            SCCredentialProactiveRequestor.this.avgTimePeriod = SCCredentialProactiveRequestor.this.avgTimePeriod == -1L ? l : (SCCredentialProactiveRequestor.this.avgTimePeriod + l) / 2L;
            if (verbose) {
                Verbose.log("Proactive requestor calculates the average time period of exchanging SC: " + SCCredentialProactiveRequestor.this.avgTimePeriod / 1000L + " seconds, the current time period is: " + l / 1000L + " seconds.");
            }
        }
    }

    private class RenewTimerListener
    implements TimerListener {
        private SCCredential sc = null;

        public RenewTimerListener(SCCredential sCCredential) {
            this.sc = sCCredential;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            boolean bl = false;
            try {
                SCCredentialProactiveRequestor.this.proactiveRenewalSignal.acquire();
                bl = true;
                WSTContext wSTContext = WSTContext.getWSTContext(SCCredentialProactiveRequestor.this.context);
                SCTokenHandler sCTokenHandler = new SCTokenHandler();
                ClientSCCredentialProviderBase._renewCredential(SCCredentialProactiveRequestor.this, this.sc, wSTContext, sCTokenHandler);
                SCCredentialProactiveRequestor sCCredentialProactiveRequestor = SCCredentialProactiveRequestor.this;
                synchronized (sCCredentialProactiveRequestor) {
                    SCCredentialProviderBase.setSCToContext(SCCredentialProactiveRequestor.this.context, this.sc);
                    String string = SCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(wSTContext.getMessageContext());
                    SCTStore.addToClient(this.sc, !wSTContext.isSessionPersisted(), string);
                }
                if (verbose) {
                    Verbose.log("Proactive async renewal has completed this once");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                if (bl) {
                    SCCredentialProactiveRequestor.this.proactiveRenewalSignal.release();
                }
                SCCredentialProactiveRequestor.this.asyncRenewNext(this.sc, this);
            }
        }
    }
}

