/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.handler.MessageContext;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.security.service.ContextHandler;
import weblogic.store.PersistentStoreManager;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.spi.WLSServiceDelegate;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.runtime.WebServicesRuntime;
import weblogic.wsee.security.wssc.faults.FaultVersionHelper;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.ws.WsPort;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

public abstract class SCCredentialProviderBase
implements CredentialProvider {
    private static final Logger LOGGER = Logger.getLogger(SCCredentialProviderBase.class.getName());

    protected abstract String[] getSCT_VALUE_TYPES();

    public String[] getValueTypes() {
        return this.getSCT_VALUE_TYPES();
    }

    protected static SecurityTokenContextHandler getSecurityCtxHandler(ContextHandler contextHandler) {
        if (!(contextHandler instanceof SecurityTokenContextHandler)) {
            return null;
        }
        return (SecurityTokenContextHandler)contextHandler;
    }

    protected static MessageContext getMessageContext(SecurityTokenContextHandler securityTokenContextHandler) {
        WSSecurityContext wSSecurityContext = (WSSecurityContext)securityTokenContextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        if (wSSecurityContext == null) {
            return null;
        }
        MessageContext messageContext = wSSecurityContext.getMessageContext();
        return messageContext;
    }

    static SCCredential checkExpiration(MessageContext messageContext, SCCredential sCCredential, String string) {
        if ("true".equals(messageContext.getProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration")) && sCCredential != null && TrustTokenHelper.isExpired(messageContext, sCCredential.getCreated(), sCCredential.getExpires())) {
            WSTFaultUtil.raiseFault(FaultVersionHelper.newRenewNeededException(string, "SCToken expired: " + sCCredential.getIdentifier()));
        }
        return sCCredential;
    }

    static SCCredential getSCFromContext(MessageContext messageContext) {
        SCCredential sCCredential;
        if (messageContext == null) {
            return null;
        }
        Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
        if (map != null && (sCCredential = (SCCredential)map.get("weblogic.wsee.wssc.sct")) != null) {
            return sCCredential;
        }
        return (SCCredential)messageContext.getProperty("weblogic.wsee.wssc.sct");
    }

    static void setSCToContext(MessageContext messageContext, SCCredential sCCredential) {
        if (messageContext != null) {
            messageContext.setProperty("weblogic.wsee.wssc.sct", (Object)sCCredential);
            Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            if (map != null) {
                map.put("weblogic.wsee.wssc.sct", sCCredential);
            }
        }
    }

    static void removeSCFromContext(MessageContext messageContext) {
        messageContext.removeProperty("weblogic.wsee.wssc.sct");
        Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
        if (map != null) {
            map.remove("weblogic.wsee.wssc.sct");
        }
    }

    static String getAppliesToEndpoint(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("weblogic.wsee.connection.end_point_address");
        if (string == null) {
            string = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        }
        return string;
    }

    protected String getPhysicalStoreNameFromWSTContext(WSTContext wSTContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(wSTContext.getMessageContext());
        return SCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(wlMessageContext);
    }

    protected static String getPhysicalStoreNameFromMessageContext(MessageContext messageContext) {
        PersistenceConfig.Common common;
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        String string = null;
        boolean bl = SCCredentialProviderBase.isJaxwsRuntime(wlMessageContext);
        if (bl && (common = SCCredentialProviderBase.getPersistenceConfigFromMessageContext(wlMessageContext)) != null) {
            string = SCCredentialProviderBase.getPhysicalStoreName(common);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Calculated physical store for current message context as: " + string);
        }
        return string;
    }

    protected static PersistenceConfig.Common getPersistenceConfigFromMessageContext(WlMessageContext wlMessageContext) {
        PersistenceConfig.Common common = null;
        if (wlMessageContext instanceof SOAPMessageContext) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)wlMessageContext;
            if (sOAPMessageContext.isClient()) {
                PortInfoBean portInfoBean = ConfigUtil.getPortInfoBeanForPort((WLSServiceDelegate)sOAPMessageContext.getWSService(), wlMessageContext.getDispatcher().getPortName().getLocalPart());
                common = PersistenceConfig.getClientConfig(portInfoBean);
            } else {
                WsPort wsPort = null;
                if (wlMessageContext.getDispatcher() != null) {
                    wsPort = wlMessageContext.getDispatcher().getWsPort();
                }
                common = PersistenceConfig.getServiceConfig(wsPort);
            }
        } else if (wlMessageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE") instanceof WLSServiceDelegate) {
            WLSServiceDelegate wLSServiceDelegate = (WLSServiceDelegate)((Object)wlMessageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE"));
            PortInfoBean portInfoBean = ConfigUtil.getPortInfoBeanForPort(wLSServiceDelegate, wlMessageContext.getDispatcher().getPortName().getLocalPart());
            common = PersistenceConfig.getClientConfig(portInfoBean);
        } else if (wlMessageContext.getDispatcher() != null && wlMessageContext.getDispatcher().getWsPort() != null) {
            WsPort wsPort = wlMessageContext.getDispatcher().getWsPort();
            common = PersistenceConfig.getServiceConfig(wsPort);
        } else {
            common = PersistenceConfig.getServiceConfig((WsPort)null);
        }
        return common;
    }

    public static boolean isJaxwsRuntime(MessageContext messageContext) {
        return Boolean.parseBoolean((String)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME")) || messageContext.getProperty("weblogic.wsee.jaxws.async.PersistentContext") != null;
    }

    protected static String getPhysicalStoreName(PersistenceConfig.Common common) {
        String string = common.getLogicalStoreName();
        return SCCredentialProviderBase.getPhysicalStoreFromLogicalStore(string);
    }

    protected static String getPhysicalStoreFromLogicalStore(String string) {
        List<String> list = WebServicesRuntime.getInstance().getLocalPhysicalStoresForLogicalStore(string);
        if (list.size() < 1) {
            String string2 = PersistentStoreManager.getManager().getDefaultStore().getName();
            return string2;
        }
        String string3 = list.get(0);
        return string3;
    }
}

