/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.security.Key;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenHandlerBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wst.binding.AppliesTo;
import weblogic.wsee.security.wst.binding.Lifetime;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestedAttachedReference;
import weblogic.wsee.security.wst.binding.RequestedSecurityToken;
import weblogic.wsee.security.wst.binding.TokenReferenceBase;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.WLDOMStructure;

public class SCTHelper {
    public static SCCredential getSCCredentialFromRSTR(WSTContext wSTContext, Key key, RequestSecurityTokenResponse requestSecurityTokenResponse, SCTokenHandlerBase sCTokenHandlerBase) throws WSTFaultException {
        Object object;
        WLDOMStructure wLDOMStructure;
        SCCredential sCCredential = sCTokenHandlerBase.newSCCredential();
        TokenType tokenType = requestSecurityTokenResponse.getTokenType();
        if (tokenType != null && !tokenType.getTokenType().equals(sCTokenHandlerBase.getSCT_VALUE_TYPE())) {
            throw new RequestFailedException("Unexpected token type in RSTR: " + tokenType.getTokenType());
        }
        RequestedSecurityToken requestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken();
        if (requestedSecurityToken == null) {
            throw new RequestFailedException("RequestedSecurityToken must be specified");
        }
        SecurityToken securityToken = requestedSecurityToken.getSecurityToken();
        if (!(securityToken instanceof SCTokenBase)) {
            throw new RequestFailedException(securityToken.getValueType() + " is not a SCT");
        }
        SCTokenBase sCTokenBase = (SCTokenBase)securityToken;
        SCCredential sCCredential2 = sCTokenBase.getCredential();
        SCCredential.copy(sCCredential2, sCCredential);
        sCCredential.setSecret(key);
        Lifetime lifetime = requestSecurityTokenResponse.getLifetime();
        sCCredential.setCreated(lifetime.getCreated());
        sCCredential.setExpires(lifetime.getExpires());
        AppliesTo appliesTo = requestSecurityTokenResponse.getAppliesTo();
        if (appliesTo != null) {
            sCCredential.setAppliesTo(appliesTo.getEndpointReference());
            sCCredential.setAppliesToElement(appliesTo.getElement());
        } else {
            sCCredential.setAppliesTo(wSTContext.getAppliesTo());
            sCCredential.setAppliesToElement(wSTContext.getAppliesToElement());
        }
        RequestedAttachedReference requestedAttachedReference = requestSecurityTokenResponse.getRequestedAttachedReference();
        if (requestedAttachedReference != null) {
            wLDOMStructure = requestedAttachedReference.getSecurityTokenReference();
            object = sCCredential.newAttachedSecurityTokenReferenceInfo();
            SCCredential.copyFromSTRToInfo((SecurityTokenReference)wLDOMStructure, (SCCredential.SecurityTokenReferenceInfo)object);
        }
        if ((wLDOMStructure = requestSecurityTokenResponse.getRequestedUnattachedReference()) != null) {
            object = ((TokenReferenceBase)wLDOMStructure).getSecurityTokenReference();
            SCCredential.SecurityTokenReferenceInfo securityTokenReferenceInfo = sCCredential.newUnattachedSecurityTokenReferenceInfo();
            SCCredential.copyFromSTRToInfo((SecurityTokenReference)object, securityTokenReferenceInfo);
        }
        return sCCredential;
    }
}

