/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.io.Serializable;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.wssc.SecurityTokenBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wst.framework.TrustCredential;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.Util;
import weblogic.xml.dom.marshal.MarshalException;

public abstract class SCTokenBase
extends SecurityTokenBase
implements TrustToken,
Serializable {
    private SCCredential credential;
    private static final boolean verbose = Verbose.isVerbose(SCTokenBase.class);
    private String netCV;
    private QName netCNS;

    public SCTokenBase() {
    }

    public SCTokenBase(SCCredential sCCredential) {
        this.credential = sCCredential;
        this.setId(sCCredential.getTokenId());
        if (sCCredential.getScNamespace() == null) {
            sCCredential.setScNamespace(this.getXMLNS_WSC());
        } else if (sCCredential.getScNamespace().length() <= 0) {
            sCCredential.setScNamespace(this.getXMLNS_WSC());
        } else assert (sCCredential.getScNamespace().equals(this.getXMLNS_WSC())) : "Error ! input SCCredential.getSCNamespace()='" + sCCredential.getScNamespace() + "', but the SCToken is being created in the namespace '" + this.getXMLNS_WSC() + "'.  The 2 SC version namespaces are supposed to be equal !";
    }

    protected abstract QName getSCT_IDENTIFIER_QNAME();

    protected abstract QName getSCT_QNAME();

    protected abstract String getSCT_VALUE_TYPE();

    protected abstract String getXMLNS_WSC();

    public Element marshalInternal(Element element, Node node, Map map) throws MarshalException {
        Element element2 = DOMUtils.createElement(element, this.getSCT_QNAME(), "wsc");
        String string = this.credential.getSecurityContextTokenIDAttribute();
        if (string != null) {
            element2.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", string);
        }
        weblogic.xml.dom.DOMUtils.addNamespaceDeclaration(element2, "wsc", this.getXMLNS_WSC());
        Element element3 = DOMUtils.createAndAddElement(element2, this.getSCT_IDENTIFIER_QNAME(), "wsc");
        DOMUtils.addText(element3, this.credential.getIdentifier());
        String string2 = this.credential.getNETCookieValue();
        if (string2 != null && string2.length() > 0) {
            Element element4 = DOMUtils.createAndAddElement(element2, this.credential.getNETCookieQName(), "wlsNetCookie");
            DOMUtils.addText(element4, string2);
            if (verbose) {
                Verbose.log("detected and marshalled .NET SCT Cookie.  XML value: \n" + Util.printNode(element4) + "\n");
            }
        }
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        return element2;
    }

    public Element unmarshalInternal(Node node) throws MarshalException {
        Element element = (Element)node;
        String string = null;
        QName qName = null;
        String string2 = null;
        String string3 = null;
        try {
            Element element2;
            block7: {
                Element element3 = weblogic.xml.dom.DOMUtils.getElementByTagNameNS(element, this.getXMLNS_WSC(), "Identifier");
                string = weblogic.xml.dom.DOMUtils.getTextContent(element3, true);
                element2 = null;
                try {
                    element2 = weblogic.xml.dom.DOMUtils.getOptionalElementByLocalName(element, "Cookie");
                }
                catch (DOMProcessingException dOMProcessingException) {
                    if (!verbose) break block7;
                    Verbose.log(" ignoring exception obtained while looking for optional .NET SCT Cookie 'Cookie'");
                }
            }
            if (element2 != null) {
                Attr attr;
                string2 = weblogic.xml.dom.DOMUtils.getTextContent(element2, false);
                qName = new QName(element2.getNamespaceURI(), element2.getLocalName());
                if (verbose) {
                    Verbose.log("\n SCT unmarshalled NET SCT Cookie. Name='" + qName.toString() + "', Value='" + string2 + "'\n");
                }
                if ((attr = element.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) != null) {
                    string3 = attr.getValue();
                }
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MarshalException("Token '" + this.getValueType() + "' missing element - " + "Identifier");
        }
        this.credential = new SCCredential();
        this.credential.setIdentifier(string);
        this.credential.setScNamespace(this.getXMLNS_WSC());
        this.credential.setTokenId(DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME));
        this.credential.setNETCookieValue(string2);
        this.credential.setNETCookieQName(qName);
        this.credential.setSecurityContextTokenIDAttribute(string3);
        return element;
    }

    public String getValueType() {
        return this.getSCT_VALUE_TYPE();
    }

    public Key getSecretKey() {
        return this.credential.getSecret();
    }

    public SCCredential getCredential() {
        return this.credential;
    }

    void setCredential(SCCredential sCCredential) {
        this.credential = sCCredential;
    }

    public TrustCredential getTrustCredential() {
        return this.credential;
    }

    public int hashCode() {
        if (this.credential != null) {
            return this.credential.getIdentifier().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SCTokenBase) {
            SCTokenBase sCTokenBase = (SCTokenBase)object;
            if (this.getCredential() != null && sCTokenBase.getCredential() != null) {
                return this.getCredential().equals(sCTokenBase.getCredential());
            }
        }
        return false;
    }
}

